/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.util.Date;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.InFlightCorrector;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InFlightCorrectorImpl
implements InFlightCorrector {
    TreeConnection tree;
    private static final Log logger = LogFactory.getLog(InFlightCorrectorImpl.class);

    public InFlightCorrectorImpl(TreeConnection tree) {
        this.tree = tree;
    }

    @Override
    public void correct(FileInfo info, String folderPath) {
        FileStateCache cache;
        FileState fstate;
        ContentContext tctx = (ContentContext)this.tree.getContext();
        String path = String.valueOf(folderPath) + info.getFileName();
        if (tctx.hasStateCache() && (fstate = (cache = tctx.getStateCache()).findFileState(path, true)) != null) {
            logger.debug((Object)("correct " + path));
            if (fstate.hasFileSize()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replace file size " + info.getSize() + " with " + fstate.getFileSize()));
                }
                info.setFileSize(fstate.getFileSize());
            }
            if (fstate.hasAccessDateTime()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replace access date " + new Date(info.getAccessDateTime()) + " with " + new Date(fstate.getAccessDateTime())));
                }
                info.setAccessDateTime(fstate.getAccessDateTime());
            }
            if (fstate.hasChangeDateTime()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replace change date " + new Date(info.getChangeDateTime()) + " with " + new Date(fstate.getChangeDateTime())));
                }
                info.setChangeDateTime(fstate.getChangeDateTime());
            }
            if (fstate.hasModifyDateTime()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replace modified date " + new Date(info.getModifyDateTime()) + " with " + new Date(fstate.getModifyDateTime())));
                }
                info.setModifyDateTime(fstate.getModifyDateTime());
            }
            if (fstate.hasAllocationSize()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replace allocation size" + info.getAllocationSize() + " with " + fstate.getAllocationSize()));
                }
                info.setAllocationSize(fstate.getAllocationSize());
            }
        }
    }
}

