/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityBridgeDAO;
import org.alfresco.repo.security.authority.AuthorityBridgeLink;
import org.alfresco.repo.security.authority.AuthorityBridgeTableAsynchronouslyRefreshedCache;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class AuthorityBridgeTableAsynchronouslyRefreshedCacheTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthorityService authorityService;
    private TenantAdminService tenantAdminService;
    private TransactionService transactionService;
    private PersonService personService;
    private TenantService tenantService;
    private AuthorityBridgeTableAsynchronouslyRefreshedCache authorityBridgeTableCache;
    private static final String TENANT_DOMAIN = String.valueOf(GUID.generate()) + ".com";
    private static final String TENANT_ADMIN_USER = String.valueOf(AuthenticationUtil.getAdminUserName()) + "@" + TENANT_DOMAIN;

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.authorityService = (AuthorityService)ctx.getBean(ServiceRegistry.AUTHORITY_SERVICE.getLocalName());
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService", TenantAdminService.class);
        this.personService = (PersonService)ctx.getBean(ServiceRegistry.PERSON_SERVICE.getLocalName());
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.authorityBridgeTableCache = (AuthorityBridgeTableAsynchronouslyRefreshedCache)ctx.getBean("authorityBridgeTableCache");
    }

    protected void tearDown() {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testAuthorityBridgeTableCacheForTenants() throws Exception {
        final String tenantPersonName = String.valueOf(GUID.generate()) + "@" + TENANT_DOMAIN;
        final String childGroupName = "tenantChildGroup" + GUID.generate();
        final String parentGroupName = "tenantParentGroup" + GUID.generate();
        this.createTenant(TENANT_DOMAIN);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TENANT_ADMIN_USER);
        AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertEquals((String)TENANT_DOMAIN, (String)this.tenantService.getCurrentUserDomain());
        final String tenantChildGroup = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.personService.getPerson(tenantPersonName, true);
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertTrue((boolean)AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.personService.personExists(tenantPersonName));
                String tenantChildGroup = AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityService.createAuthority(AuthorityType.GROUP, childGroupName);
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertNotNull((Object)AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityService.getAuthorityNodeRef(tenantChildGroup));
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityService.addAuthority(tenantChildGroup, tenantPersonName);
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityBridgeTableCache.forceInChangesForThisUncommittedTransaction();
                return tenantChildGroup;
            }
        }, false, true);
        String tenantParentGroup = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                String tenantParentGroup = AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityService.createAuthority(AuthorityType.GROUP, parentGroupName);
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertNotNull((Object)AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityService.getAuthorityNodeRef(tenantParentGroup));
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityService.addAuthority(tenantParentGroup, tenantChildGroup);
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.authorityBridgeTableCache.forceInChangesForThisUncommittedTransaction();
                return tenantParentGroup;
            }
        }, false, true);
        Set authorities = this.authorityService.getContainingAuthorities(null, tenantPersonName, false);
        AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertEquals((int)2, (int)authorities.size());
        AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertTrue((boolean)authorities.contains(tenantParentGroup));
        AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertTrue((boolean)authorities.contains(tenantChildGroup));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    private void createTenant(final String tenantDomain) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.tenantAdminService.existsTenant(tenantDomain)) {
                    throw new IllegalStateException("Tenant exists!");
                }
                AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.this.tenantAdminService.createTenant(tenantDomain, "password".toCharArray());
                return null;
            }
        }, false, true);
    }

    public void testCyclicGroups() {
        LinkedList<AuthorityBridgeLink> cyclicLinks = new LinkedList<AuthorityBridgeLink>();
        cyclicLinks.add(this.createAuthorityBridgeLink("a1", "a2"));
        cyclicLinks.add(this.createAuthorityBridgeLink("g1", "g2"));
        cyclicLinks.add(this.createAuthorityBridgeLink("g2", "g3"));
        cyclicLinks.add(this.createAuthorityBridgeLink("g3", "g4"));
        cyclicLinks.add(this.createAuthorityBridgeLink("g4", "g1"));
        cyclicLinks.add(this.createAuthorityBridgeLink("b1", "b2"));
        cyclicLinks.add(this.createAuthorityBridgeLink("b2", "a1"));
        cyclicLinks.add(this.createAuthorityBridgeLink("b2", "b3"));
        cyclicLinks.add(this.createAuthorityBridgeLink("b3", "b1"));
        cyclicLinks.add(this.createAuthorityBridgeLink("d1", "d2"));
        cyclicLinks.add(this.createAuthorityBridgeLink("d2", "d3"));
        cyclicLinks.add(this.createAuthorityBridgeLink("d3", "d1"));
        cyclicLinks.add(this.createAuthorityBridgeLink("d2", "d4"));
        cyclicLinks.add(this.createAuthorityBridgeLink("d4", "d1"));
        cyclicLinks.add(this.createAuthorityBridgeLink("d3", "d5"));
        cyclicLinks.add(this.createAuthorityBridgeLink("d5", "d1"));
        AuthorityBridgeDAO authorityBridgeDAOMock = (AuthorityBridgeDAO)Mockito.mock(AuthorityBridgeDAO.class);
        Mockito.when((Object)authorityBridgeDAOMock.getAuthorityBridgeLinks()).thenReturn(cyclicLinks);
        AuthorityDAO authorityDAOMock = (AuthorityDAO)Mockito.mock(AuthorityDAO.class);
        class Counter {
            private int removed = 0;

            Counter() {
            }

            public int getRemoved() {
                return this.removed;
            }

            public void increase() {
                ++this.removed;
            }
        }
        final Counter cycles = new Counter();
        ((AuthorityDAO)Mockito.doAnswer((Answer)new Answer<Object>(){
            {
            }

            public Object answer(InvocationOnMock invocation) {
                cycles.increase();
                return null;
            }
        }).when((Object)authorityDAOMock)).removeAuthority(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        AuthorityBridgeTableAsynchronouslyRefreshedCache cache = new AuthorityBridgeTableAsynchronouslyRefreshedCache();
        cache.setAuthorityBridgeDAO(authorityBridgeDAOMock);
        cache.setAuthorityDAO(authorityDAOMock);
        cache.setTenantAdminService(this.tenantAdminService);
        cache.setRetryingTransactionHelper(this.transactionService.getRetryingTransactionHelper());
        try {
            cache.buildCache(this.tenantAdminService.getCurrentUserDomain());
        }
        catch (AlfrescoRuntimeException e1) {
            AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertTrue((boolean)e1.getMessage().contains("Cyclic links were detected"));
            AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.assertEquals((int)5, (int)cycles.getRemoved());
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            AuthorityBridgeTableAsynchronouslyRefreshedCacheTest.fail((String)"Cyclic links were NOT detected and processed");
        }
    }

    private AuthorityBridgeLink createAuthorityBridgeLink(String parentName, String childName) {
        AuthorityBridgeLink link = new AuthorityBridgeLink();
        link.setParentName(parentName);
        link.setChildName(childName);
        return link;
    }
}

