/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.GetChildByIdMethod;
import org.alfresco.repo.virtual.ref.GetTemplatePathMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.junit.Test;

public class GetChildByIdMethodTest
extends TestCase {
    private String toChildPath(String parentPath, String childName) throws ProtocolMethodException {
        StringParameter path = new StringParameter(parentPath);
        Reference ref = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/a/class/path.js"), Arrays.asList(path));
        GetChildByIdMethod method = new GetChildByIdMethod(childName);
        Reference childRef = (Reference)ref.execute((ProtocolMethod)method);
        GetChildByIdMethodTest.assertEquals((Object)ref.getResource(), (Object)childRef.getResource());
        GetChildByIdMethodTest.assertEquals((Object)ref.getProtocol(), (Object)childRef.getProtocol());
        return (String)childRef.execute((ProtocolMethod)new GetTemplatePathMethod());
    }

    @Test
    public void testExecute() throws Exception {
        String childPath = this.toChildPath("/root", "aChid");
        GetChildByIdMethodTest.assertEquals((String)"/root/aChid", (String)childPath);
    }

    @Test
    public void testTrailingPath() throws Exception {
        String childPath = this.toChildPath("  /root/   ", "child");
        GetChildByIdMethodTest.assertEquals((String)"/root/child", (String)childPath);
    }
}

