/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.content.metadata.AsynchronousExtractor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rendition.RenditionPreventionRegistry;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.RenditionService2;
import org.alfresco.repo.rendition2.RenditionService2Exception;
import org.alfresco.repo.rendition2.RenditionService2PreventedException;
import org.alfresco.repo.rendition2.TransformClient;
import org.alfresco.repo.rendition2.TransformDefinition;
import org.alfresco.repo.rendition2.TransformReplyProvider;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.util.PostTxnCallbackScheduler;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class RenditionService2Impl
implements RenditionService2,
InitializingBean,
ContentServicePolicies.OnContentUpdatePolicy {
    public static final String TRANSFORMING_ERROR_MESSAGE = "Some error occurred during document transforming. Error message: ";
    public static final QName DEFAULT_RENDITION_CONTENT_PROP = ContentModel.PROP_CONTENT;
    public static final String DEFAULT_MIMETYPE = "text/plain";
    public static final String MIMETYPE_METADATA_EXTRACT = "alfresco-metadata-extract";
    public static final String MIMETYPE_METADATA_EMBED = "alfresco-metadata-embed";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int SOURCE_HAS_NO_CONTENT = -1;
    public static final int RENDITION2_DOES_NOT_EXIST = -2;
    private static final Set<String> ALLOWED_MIMETYPES = Set.of("text/plain", "alfresco-metadata-extract", "alfresco-metadata-embed");
    private static Log logger = LogFactory.getLog(RenditionService2Impl.class);
    private TransactionService transactionService;
    private NodeService nodeService;
    private ContentService contentService;
    private RenditionPreventionRegistry renditionPreventionRegistry;
    private RenditionDefinitionRegistry2 renditionDefinitionRegistry2;
    private TransformClient transformClient;
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private RuleService ruleService;
    private PostTxnCallbackScheduler renditionRequestSheduler;
    private TransformReplyProvider transformReplyProvider;
    private AsynchronousExtractor asynchronousExtractor;
    private boolean enabled;
    private boolean thumbnailsEnabled;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setRenditionPreventionRegistry(RenditionPreventionRegistry renditionPreventionRegistry) {
        this.renditionPreventionRegistry = renditionPreventionRegistry;
    }

    public void setRenditionDefinitionRegistry2(RenditionDefinitionRegistry2 renditionDefinitionRegistry2) {
        this.renditionDefinitionRegistry2 = renditionDefinitionRegistry2;
    }

    @Override
    public RenditionDefinitionRegistry2 getRenditionDefinitionRegistry2() {
        return this.renditionDefinitionRegistry2;
    }

    public void setTransformClient(TransformClient transformClient) {
        this.transformClient = transformClient;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setRenditionRequestSheduler(PostTxnCallbackScheduler renditionRequestSheduler) {
        this.renditionRequestSheduler = renditionRequestSheduler;
    }

    public void setTransformReplyProvider(TransformReplyProvider transformReplyProvider) {
        this.transformReplyProvider = transformReplyProvider;
    }

    public void setAsynchronousExtractor(AsynchronousExtractor asynchronousExtractor) {
        this.asynchronousExtractor = asynchronousExtractor;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setThumbnailsEnabled(boolean thumbnailsEnabled) {
        this.thumbnailsEnabled = thumbnailsEnabled;
    }

    public boolean isThumbnailsEnabled() {
        return this.thumbnailsEnabled;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"renditionPreventionRegistry", (Object)this.renditionPreventionRegistry);
        PropertyCheck.mandatory((Object)this, (String)"renditionDefinitionRegistry2", (Object)this.renditionDefinitionRegistry2);
        PropertyCheck.mandatory((Object)this, (String)"transformClient", (Object)this.transformClient);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"ruleService", (Object)this.ruleService);
        PropertyCheck.mandatory((Object)this, (String)"asynchronousExtractor", (Object)this.asynchronousExtractor);
    }

    @Override
    public void transform(NodeRef sourceNodeRef, final TransformDefinition transformDefinition) {
        this.requestAsyncTransformOrRendition(sourceNodeRef, new RenderOrTransformCallBack(){

            @Override
            public String getName() {
                String transformName = transformDefinition.getTransformName();
                return "Transform" + (transformName == null ? "" : " " + transformName);
            }

            @Override
            public RenditionDefinition2 getRenditionDefinition() {
                return transformDefinition;
            }
        });
    }

    @Override
    public void render(final NodeRef sourceNodeRef, final String renditionName) {
        this.requestAsyncTransformOrRendition(sourceNodeRef, new RenderOrTransformCallBack(){

            @Override
            public String getName() {
                return "Rendition " + renditionName;
            }

            @Override
            public RenditionDefinition2 getRenditionDefinition() {
                RenditionService2Impl.this.checkSourceNodeForPreventionClass(sourceNodeRef);
                RenditionDefinition2 renditionDefinition = RenditionService2Impl.this.renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
                if (renditionDefinition == null) {
                    throw new IllegalArgumentException(String.valueOf(this.getName()) + " has not been registered.");
                }
                return renditionDefinition;
            }

            @Override
            public void handleUnsupported(UnsupportedOperationException e) {
                NodeRef renditionNode = RenditionService2Impl.this.getRenditionNode(sourceNodeRef, renditionName);
                if (renditionNode == null) {
                    throw e;
                }
            }

            @Override
            public void throwIllegalStateExceptionIfAlreadyDone(int sourceContentHashCode) {
                NodeRef renditionNode = RenditionService2Impl.this.getRenditionNode(sourceNodeRef, renditionName);
                int renditionContentHashCode = RenditionService2Impl.this.getRenditionContentHashCode(renditionNode);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(String.valueOf(this.getName()) + ": Source " + sourceContentHashCode + " rendition " + renditionContentHashCode + " hashCodes"));
                }
                if (renditionContentHashCode == sourceContentHashCode) {
                    throw new IllegalStateException(String.valueOf(this.getName()) + " has already been created.");
                }
            }
        });
    }

    private void requestAsyncTransformOrRendition(NodeRef sourceNodeRef, RenderOrTransformCallBack renderOrTransform) {
        try {
            if (!this.isAsyncAllowed(renderOrTransform)) {
                throw new RenditionService2Exception("Async transforms and renditions are disabled (system.thumbnail.generate=false or renditionService2.enabled=false).");
            }
            if (!this.nodeService.exists(sourceNodeRef)) {
                throw new IllegalArgumentException(String.valueOf(renderOrTransform.getName()) + ": The supplied sourceNodeRef " + sourceNodeRef + " does not exist.");
            }
            RenditionDefinition2 renditionDefinition = renderOrTransform.getRenditionDefinition();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(String.valueOf(renderOrTransform.getName()) + ": transform " + sourceNodeRef));
            }
            AtomicBoolean supported = new AtomicBoolean(true);
            ContentData contentData = (ContentData)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_CONTENT);
            if (contentData != null && contentData.getContentUrl() != null) {
                String contentUrl = contentData.getContentUrl();
                String sourceMimetype = contentData.getMimetype();
                long size = contentData.getSize();
                try {
                    this.transformClient.checkSupported(sourceNodeRef, renditionDefinition, sourceMimetype, size, contentUrl);
                }
                catch (UnsupportedOperationException e) {
                    renderOrTransform.handleUnsupported(e);
                    supported.set(false);
                }
            }
            String user = AuthenticationUtil.getRunAsUser();
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = () -> {
                int sourceContentHashCode = this.getSourceContentHashCode(sourceNodeRef);
                if (!supported.get()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(String.valueOf(renderOrTransform.getName()) + " is not supported. " + "The content might be too big or the source mimetype cannot be converted."));
                    }
                    this.failure(sourceNodeRef, renditionDefinition, sourceContentHashCode);
                } else {
                    renderOrTransform.throwIllegalStateExceptionIfAlreadyDone(sourceContentHashCode);
                    if (sourceContentHashCode != -1) {
                        this.transformClient.transform(sourceNodeRef, renditionDefinition, user, sourceContentHashCode);
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(String.valueOf(renderOrTransform.getName()) + ": Source had no content."));
                        }
                        this.failure(sourceNodeRef, renditionDefinition, sourceContentHashCode);
                    }
                }
                return null;
            };
            String renditionName = renditionDefinition.getRenditionName();
            this.renditionRequestSheduler.scheduleRendition(callback, sourceNodeRef + renditionName);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
            throw e;
        }
    }

    public void failure(NodeRef sourceNodeRef, RenditionDefinition2 renditionDefinition, int transformContentHashCode) {
        AuthenticationUtil.runAsSystem(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.consume(sourceNodeRef, null, renditionDefinition, transformContentHashCode);
            return null;
        }, false, true));
    }

    public void consume(NodeRef sourceNodeRef, InputStream transformInputStream, RenditionDefinition2 renditionDefinition, int transformContentHashCode) {
        int sourceContentHashCode = this.getSourceContentHashCode(sourceNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Consume: Source " + sourceContentHashCode + " and transform's source " + transformContentHashCode + " hashcodes"));
        }
        if (renditionDefinition instanceof TransformDefinition) {
            TransformDefinition transformDefinition = (TransformDefinition)renditionDefinition;
            String targetMimetype = transformDefinition.getTargetMimetype();
            if (AsynchronousExtractor.isMetadataExtractMimetype(targetMimetype)) {
                this.consumeExtractedMetadata(sourceNodeRef, sourceContentHashCode, transformInputStream, transformDefinition, transformContentHashCode);
            } else if (AsynchronousExtractor.isMetadataEmbedMimetype(targetMimetype)) {
                this.consumeEmbeddedMetadata(sourceNodeRef, sourceContentHashCode, transformInputStream, transformDefinition, transformContentHashCode);
            } else {
                this.consumeTransformReply(sourceNodeRef, transformInputStream, transformDefinition, transformContentHashCode);
            }
        } else {
            this.consumeRendition(sourceNodeRef, sourceContentHashCode, transformInputStream, renditionDefinition, transformContentHashCode);
        }
    }

    private void consumeExtractedMetadata(NodeRef nodeRef, int sourceContentHashCode, InputStream transformInputStream, TransformDefinition transformDefinition, int transformContentHashCode) {
        if (transformInputStream == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignore transform for metadata extraction on " + nodeRef + " as it failed"));
            }
        } else if (transformContentHashCode != sourceContentHashCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignore transform for metadata extraction on " + nodeRef + " as it is no longer needed"));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set the metadata extraction on " + nodeRef));
            }
            this.asynchronousExtractor.setMetadata(nodeRef, transformInputStream);
        }
    }

    private void consumeEmbeddedMetadata(NodeRef nodeRef, int sourceContentHashCode, InputStream transformInputStream, TransformDefinition transformDefinition, int transformContentHashCode) {
        if (transformInputStream == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignore transform for metadata embed on " + nodeRef + " as it failed"));
            }
        } else if (transformContentHashCode != sourceContentHashCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignore transform for metadata embed on " + nodeRef + " as it is no longer needed"));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set the content with embedded metadata on " + nodeRef));
            }
            this.asynchronousExtractor.setEmbeddedMetadata(nodeRef, transformInputStream);
        }
    }

    private void consumeTransformReply(NodeRef sourceNodeRef, InputStream transformInputStream, TransformDefinition transformDefinition, int transformContentHashCode) {
        if (logger.isDebugEnabled()) {
            String transformName = transformDefinition.getTransformName();
            String replyQueue = transformDefinition.getReplyQueue();
            String clientData = transformDefinition.getClientData();
            boolean success = transformInputStream != null;
            logger.info((Object)("Reply to " + replyQueue + " that the transform " + transformName + " with the client data " + clientData + " " + (success ? "was successful" : "failed.")));
        }
        this.transformReplyProvider.produceTransformEvent(sourceNodeRef, transformInputStream, transformDefinition, transformContentHashCode);
    }

    private void consumeRendition(NodeRef sourceNodeRef, int sourceContentHashCode, InputStream transformInputStream, RenditionDefinition2 renditionDefinition, int transformContentHashCode) {
        String renditionName = renditionDefinition.getRenditionName();
        if (transformContentHashCode != sourceContentHashCode) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignore transform for rendition " + renditionName + " on " + sourceNodeRef + " as it is no longer needed"));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set the content of rendition " + renditionName + " on " + sourceNodeRef + (transformInputStream == null ? " to null as the transform failed" : " to the transform result")));
            }
            AuthenticationUtil.runAsSystem(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                NodeRef renditionNode = this.getRenditionNode(sourceNodeRef, renditionName);
                boolean createRenditionNode = renditionNode == null;
                boolean sourceHasAspectRenditioned = this.nodeService.hasAspect(sourceNodeRef, RenditionModel.ASPECT_RENDITIONED);
                try {
                    try {
                        this.ruleService.disableRuleType("update");
                        this.behaviourFilter.disableBehaviour(sourceNodeRef, ContentModel.ASPECT_AUDITABLE);
                        this.behaviourFilter.disableBehaviour(sourceNodeRef, ContentModel.ASPECT_VERSIONABLE);
                        if (createRenditionNode) {
                            renditionNode = this.createRenditionNode(sourceNodeRef, renditionDefinition);
                        } else if (!this.nodeService.hasAspect(renditionNode, RenditionModel.ASPECT_RENDITION2)) {
                            this.nodeService.addAspect(renditionNode, RenditionModel.ASPECT_RENDITION2, null);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Added rendition2 aspect to rendition " + renditionName + " on " + sourceNodeRef));
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Set ThumbnailLastModified for " + renditionName));
                        }
                        this.setThumbnailLastModified(sourceNodeRef, renditionName);
                        if (transformInputStream != null) {
                            try {
                                ContentWriter contentWriter = this.contentService.getWriter(renditionNode, DEFAULT_RENDITION_CONTENT_PROP, true);
                                String targetMimetype = renditionDefinition.getTargetMimetype();
                                contentWriter.setMimetype(targetMimetype);
                                contentWriter.setEncoding(DEFAULT_ENCODING);
                                ContentWriter renditionWriter = contentWriter;
                                renditionWriter.putContent(transformInputStream);
                                ContentReader contentReader = renditionWriter.getReader();
                                long sizeOfRendition = contentReader.getSize();
                                if (sizeOfRendition > 0L) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Set rendition hashcode for " + renditionName));
                                    }
                                    this.nodeService.setProperty(renditionNode, RenditionModel.PROP_RENDITION_CONTENT_HASH_CODE, (Serializable)Integer.valueOf(transformContentHashCode));
                                }
                                logger.error((Object)("Transform was zero bytes for " + renditionName + " on " + sourceNodeRef));
                                this.clearRenditionContentData(renditionNode);
                            }
                            catch (Exception e) {
                                logger.error((Object)("Failed to copy transform InputStream into rendition " + renditionName + " on " + sourceNodeRef));
                                throw e;
                            }
                        } else {
                            this.clearRenditionContentData(renditionNode);
                        }
                        if (!sourceHasAspectRenditioned) {
                            this.nodeService.addAspect(sourceNodeRef, RenditionModel.ASPECT_RENDITIONED, null);
                        }
                    }
                    catch (Exception e) {
                        throw new RenditionService2Exception(TRANSFORMING_ERROR_MESSAGE + e.getMessage(), e);
                    }
                }
                finally {
                    this.behaviourFilter.enableBehaviour(sourceNodeRef, ContentModel.ASPECT_AUDITABLE);
                    this.behaviourFilter.enableBehaviour(sourceNodeRef, ContentModel.ASPECT_VERSIONABLE);
                    this.ruleService.enableRuleType("update");
                }
                return null;
            }, false, true));
        }
    }

    private NodeRef createRenditionNode(NodeRef sourceNode, RenditionDefinition2 renditionDefinition) {
        String renditionName = renditionDefinition.getRenditionName();
        HashMap<QName, Object> nodeProps = new HashMap<QName, Object>();
        nodeProps.put(ContentModel.PROP_NAME, renditionName);
        nodeProps.put(ContentModel.PROP_THUMBNAIL_NAME, renditionName);
        nodeProps.put(ContentModel.PROP_CONTENT_PROPERTY_NAME, ContentModel.PROP_CONTENT);
        nodeProps.put(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)renditionName);
        QName assocType = RenditionModel.ASSOC_RENDITION;
        QName nodeType = ContentModel.TYPE_THUMBNAIL;
        ChildAssociationRef childAssoc = this.nodeService.createNode(sourceNode, assocType, assocName, nodeType, nodeProps);
        NodeRef renditionNode = childAssoc.getChildRef();
        this.nodeService.addAspect(renditionNode, RenditionModel.ASPECT_RENDITION2, null);
        this.nodeService.addAspect(renditionNode, RenditionModel.ASPECT_HIDDEN_RENDITION, null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + renditionName + " rendition node " + childAssoc.getChildRef() + " as a child of " + sourceNode));
        }
        return renditionNode;
    }

    private void setThumbnailLastModified(NodeRef sourceNodeRef, String renditionName) {
        String prefix = String.valueOf(renditionName) + ':';
        String lastModifiedValue = String.valueOf(prefix) + System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Setting thumbnail last modified date to " + lastModifiedValue + " on source node: " + sourceNodeRef));
        }
        if (this.nodeService.hasAspect(sourceNodeRef, ContentModel.ASPECT_THUMBNAIL_MODIFICATION)) {
            List thumbnailMods = (List)((Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
            String target = null;
            for (String currThumbnailMod : thumbnailMods) {
                if (!currThumbnailMod.startsWith(prefix)) continue;
                target = currThumbnailMod;
            }
            if (target != null) {
                thumbnailMods.remove(target);
            }
            thumbnailMods.add(lastModifiedValue);
            this.nodeService.setProperty(sourceNodeRef, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA, (Serializable)((Object)thumbnailMods));
        } else {
            List<String> thumbnailMods = Collections.singletonList(lastModifiedValue);
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA, (Serializable)((Object)thumbnailMods));
            this.nodeService.addAspect(sourceNodeRef, ContentModel.ASPECT_THUMBNAIL_MODIFICATION, properties);
        }
    }

    private int getSourceContentHashCode(NodeRef sourceNodeRef) {
        String contentString;
        int hashCode = -1;
        ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_CONTENT));
        if (contentData != null && (contentString = String.valueOf(contentData.getContentUrl()) + contentData.getMimetype()) != null) {
            hashCode = contentString.hashCode();
        }
        return hashCode;
    }

    private int getRenditionContentHashCode(NodeRef renditionNode) {
        if (renditionNode == null || !this.nodeService.hasAspect(renditionNode, RenditionModel.ASPECT_RENDITION2)) {
            return -2;
        }
        Serializable hashCode = this.nodeService.getProperty(renditionNode, RenditionModel.PROP_RENDITION_CONTENT_HASH_CODE);
        return hashCode == null ? -1 : (Integer)hashCode;
    }

    private NodeRef getRenditionNode(NodeRef sourceNodeRef, String renditionName) {
        QName renditionQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)renditionName);
        List renditionAssocs = this.nodeService.getChildAssocs(sourceNodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, (QNamePattern)renditionQName);
        return renditionAssocs.isEmpty() ? null : ((ChildAssociationRef)renditionAssocs.get(0)).getChildRef();
    }

    public boolean isCreatedByRenditionService2(NodeRef sourceNodeRef, String renditionName) {
        boolean result = false;
        NodeRef renditionNode = this.getRenditionNode(sourceNodeRef, renditionName);
        if (renditionNode != null) {
            result = this.nodeService.hasAspect(renditionNode, RenditionModel.ASPECT_RENDITION2);
        }
        return result;
    }

    public void deleteRendition(NodeRef sourceNodeRef, String renditionName) {
        NodeRef renditionNode = this.getRenditionNode(sourceNodeRef, renditionName);
        if (renditionNode != null && this.nodeService.hasAspect(renditionNode, RenditionModel.ASPECT_RENDITION2)) {
            this.nodeService.deleteNode(renditionNode);
        }
    }

    public void clearRenditionContentData(NodeRef sourceNodeRef, String renditionName) {
        this.clearRenditionContentData(this.getRenditionNode(sourceNodeRef, renditionName));
    }

    private void clearRenditionContentData(NodeRef renditionNode) {
        if (renditionNode != null) {
            Serializable content = this.nodeService.getProperty(renditionNode, ContentModel.PROP_CONTENT);
            if (content != null) {
                this.nodeService.removeProperty(renditionNode, ContentModel.PROP_CONTENT);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Cleared rendition content");
                }
            }
            this.nodeService.removeProperty(renditionNode, RenditionModel.PROP_RENDITION_CONTENT_HASH_CODE);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cleared rendition hashcode");
            }
        }
    }

    private void checkSourceNodeForPreventionClass(NodeRef sourceNode) {
        if (sourceNode != null && this.nodeService.exists(sourceNode)) {
            Set nodeContentClasses = this.nodeService.getAspects(sourceNode);
            nodeContentClasses.add(this.nodeService.getType(sourceNode));
            for (QName contentClass : nodeContentClasses) {
                if (!this.renditionPreventionRegistry.isContentClassRegistered(contentClass)) continue;
                String msg = "Node " + sourceNode + " cannot be renditioned as it is of class " + contentClass;
                logger.debug((Object)msg);
                throw new RenditionService2PreventedException(msg);
            }
        }
    }

    private List<ChildAssociationRef> getRenditionChildAssociations(NodeRef sourceNodeRef) {
        List result = Collections.emptyList();
        if (this.nodeService.hasAspect(sourceNodeRef, RenditionModel.ASPECT_RENDITIONED)) {
            result = this.nodeService.getChildAssocs(sourceNodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
        }
        return result;
    }

    @Override
    public List<ChildAssociationRef> getRenditions(NodeRef sourceNodeRef) {
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        List<ChildAssociationRef> childAsocs = this.getRenditionChildAssociations(sourceNodeRef);
        for (ChildAssociationRef childAssoc : childAsocs) {
            NodeRef renditionNode = childAssoc.getChildRef();
            if (!this.isRenditionAvailable(sourceNodeRef, renditionNode)) continue;
            result.add(childAssoc);
        }
        return result;
    }

    public boolean isRenditionAvailable(NodeRef sourceNodeRef, NodeRef renditionNode) {
        boolean available = true;
        if (this.nodeService.hasAspect(renditionNode, RenditionModel.ASPECT_RENDITION2)) {
            Serializable contentUrl = this.nodeService.getProperty(renditionNode, ContentModel.PROP_CONTENT);
            if (contentUrl == null) {
                available = false;
            } else {
                int sourceContentHashCode = this.getSourceContentHashCode(sourceNodeRef);
                int renditionContentHashCode = this.getRenditionContentHashCode(renditionNode);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("isRenditionAvailable source " + sourceContentHashCode + " and rendition " + renditionContentHashCode + " hashcodes"));
                }
                if (sourceContentHashCode != renditionContentHashCode) {
                    available = false;
                }
            }
        }
        return available;
    }

    @Override
    public ChildAssociationRef getRenditionByName(NodeRef sourceNodeRef, String renditionName) {
        ChildAssociationRef childAssoc;
        NodeRef renditionNode;
        List renditions = Collections.emptyList();
        QName renditionQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)renditionName);
        if (this.nodeService.hasAspect(sourceNodeRef, RenditionModel.ASPECT_RENDITIONED)) {
            renditions = this.nodeService.getChildAssocs(sourceNodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, (QNamePattern)renditionQName);
        }
        if (renditions.isEmpty()) {
            return null;
        }
        if (renditions.size() > 1 && logger.isDebugEnabled()) {
            logger.debug((Object)("Unexpectedly found " + renditions.size() + " renditions of name " + renditionQName + " on node " + sourceNodeRef));
        }
        return !this.isRenditionAvailable(sourceNodeRef, renditionNode = (childAssoc = (ChildAssociationRef)renditions.get(0)).getChildRef()) ? null : childAssoc;
    }

    @Override
    public void clearRenditionContentDataInTransaction(NodeRef renditionNode) {
        AuthenticationUtil.runAsSystem(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.clearRenditionContentData(renditionNode);
            return null;
        }, false, true));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.thumbnailsEnabled;
    }

    @Override
    public void onContentUpdate(NodeRef sourceNodeRef, boolean newContent) {
        if (this.isEnabled()) {
            if (this.nodeService.exists(sourceNodeRef)) {
                logger.debug((Object)("onContentUpdate on " + sourceNodeRef));
                List<ChildAssociationRef> childAssocs = this.getRenditionChildAssociations(sourceNodeRef);
                for (ChildAssociationRef childAssoc : childAssocs) {
                    NodeRef renditionNodeRef = childAssoc.getChildRef();
                    if (!this.nodeService.hasAspect(renditionNodeRef, RenditionModel.ASPECT_RENDITION2)) continue;
                    QName childAssocQName = childAssoc.getQName();
                    String renditionName = childAssocQName.getLocalName();
                    RenditionDefinition2 renditionDefinition = this.renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
                    if (renditionDefinition != null) {
                        this.clearRenditionContentData(sourceNodeRef, renditionName);
                        this.render(sourceNodeRef, renditionName);
                        continue;
                    }
                    logger.debug((Object)("onContentUpdate rendition " + renditionName + " only exists in the original rendition service."));
                }
            } else {
                logger.debug((Object)("onContentUpdate rendition " + sourceNodeRef + " does not exist."));
            }
        }
    }

    @Override
    public void forceRenditionsContentHashCode(NodeRef sourceNodeRef) {
        List<ChildAssociationRef> renditions;
        if (sourceNodeRef != null && this.nodeService.exists(sourceNodeRef) && (renditions = this.getRenditionChildAssociations(sourceNodeRef)) != null) {
            int sourceContentHashCode = this.getSourceContentHashCode(sourceNodeRef);
            for (ChildAssociationRef rendition : renditions) {
                NodeRef renditionNode = rendition.getChildRef();
                if (!this.nodeService.hasAspect(renditionNode, RenditionModel.ASPECT_RENDITION2)) continue;
                int renditionContentHashCode = this.getRenditionContentHashCode(renditionNode);
                String renditionName = rendition.getQName().getLocalName();
                if (sourceContentHashCode == renditionContentHashCode) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Update content hash code for rendition " + renditionName + " of node " + sourceNodeRef));
                }
                this.nodeService.setProperty(renditionNode, RenditionModel.PROP_RENDITION_CONTENT_HASH_CODE, (Serializable)Integer.valueOf(sourceContentHashCode));
            }
        }
    }

    private boolean isTextOrMetadataExtractTransform(RenderOrTransformCallBack renderOrTransform) {
        RenditionDefinition2 renditionDefinition = renderOrTransform.getRenditionDefinition();
        return renditionDefinition != null && ALLOWED_MIMETYPES.contains(renditionDefinition.getTargetMimetype());
    }

    private boolean isAsyncAllowed(RenderOrTransformCallBack renderOrTransform) {
        if (!this.enabled) {
            return false;
        }
        return this.thumbnailsEnabled || this.isTextOrMetadataExtractTransform(renderOrTransform);
    }

    private static abstract class RenderOrTransformCallBack {
        private RenderOrTransformCallBack() {
        }

        abstract String getName();

        abstract RenditionDefinition2 getRenditionDefinition();

        void handleUnsupported(UnsupportedOperationException e) {
        }

        void throwIllegalStateExceptionIfAlreadyDone(int sourceContentHashCode) {
        }
    }
}

