/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.authentication;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.repo.admin.SysAdminParams;

public class AdminAuthenticationCookiesService {
    private final SysAdminParams sysAdminParams;
    private final int cookieLifetime;

    public AdminAuthenticationCookiesService(SysAdminParams sysAdminParams, int cookieLifetime) {
        this.sysAdminParams = sysAdminParams;
        this.cookieLifetime = cookieLifetime;
    }

    public String getCookie(String name, HttpServletRequest request) {
        String result = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(name)) {
                    result = cookie.getValue();
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public void addCookie(String name, String value, HttpServletResponse servletResponse) {
        this.internalAddCookie(name, value, this.cookieLifetime, servletResponse);
    }

    public void resetCookie(String name, HttpServletResponse servletResponse) {
        this.internalAddCookie(name, "", 0, servletResponse);
    }

    private void internalAddCookie(String name, String value, int maxAge, HttpServletResponse servletResponse) {
        Cookie authCookie = new Cookie(name, value);
        authCookie.setPath("/");
        authCookie.setMaxAge(maxAge);
        authCookie.setSecure(this.sysAdminParams.getAlfrescoProtocol().equalsIgnoreCase("https"));
        authCookie.setHttpOnly(true);
        servletResponse.addCookie(authCookie);
    }
}

