/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rendition.RenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionLocation;
import org.alfresco.repo.rendition.RenditionLocationImpl;
import org.alfresco.repo.rendition.RenditionNodeManager;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Deprecated
public class RenditionNodeManagerTest
extends TestCase {
    private final NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
    private final RenditionService renditionService = (RenditionService)Mockito.mock(RenditionService.class);
    private final BehaviourFilter behaviourFilter = (BehaviourFilter)Mockito.mock(BehaviourFilter.class);
    private final NodeRef source = new NodeRef("http://test/sourceId");
    private final NodeRef destination = new NodeRef("http://test/destinationId");
    private final NodeRef oldRendition = new NodeRef("http://test/oldRenditionId");
    private final QName renditionName = QName.createQName((String)"http://www.alfresco.org/model/rendition/1.0", (String)"renditionName");
    private final RenditionDefinition definition = new RenditionDefinitionImpl("definitionId", this.renditionName, "engineName");

    public void testNoOldRenditionAndDestinationSpecified() {
        ChildAssociationRef parentAssoc = this.makeAssoc(this.source, this.destination, true);
        Mockito.when((Object)this.nodeService.getPrimaryParent((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn((Object)parentAssoc);
        RenditionLocationImpl location = new RenditionLocationImpl(this.source, this.destination, "destinationName");
        RenditionNodeManager manager = new RenditionNodeManager(this.source, null, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)parentAssoc, (Object)result);
    }

    public void testNoOldRenditionAndNoDestinationSpecifiedAndParentIsSource() {
        Map<QName, Boolean> indexProps = Collections.singletonMap(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
        ChildAssociationRef parentAssoc = this.makeAssoc(this.source, this.destination, true);
        Mockito.when((Object)this.nodeService.createNode(this.source, RenditionModel.ASSOC_RENDITION, this.renditionName, ContentModel.TYPE_CONTENT, indexProps)).thenReturn((Object)parentAssoc);
        RenditionLocationImpl location = new RenditionLocationImpl(this.source, null, this.renditionName.getLocalName());
        RenditionNodeManager manager = new RenditionNodeManager(this.source, null, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)parentAssoc, (Object)result);
    }

    public void testNoOldRenditionAndNoDestinationSpecifiedAndParentIsNotSource() {
        String localName = "Foo";
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)localName);
        NodeRef parent = new NodeRef("http://test/parentId");
        ChildAssociationRef parentAssoc = this.makeAssoc(parent, this.destination, assocName, false);
        Map<QName, Boolean> indexProps = Collections.singletonMap(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
        Mockito.when((Object)this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, assocName, ContentModel.TYPE_CONTENT, indexProps)).thenReturn((Object)parentAssoc);
        RenditionLocationImpl location = new RenditionLocationImpl(parent, null, localName);
        RenditionNodeManager manager = new RenditionNodeManager(this.source, null, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)parentAssoc, (Object)result);
        ((NodeService)Mockito.verify((Object)this.nodeService)).addChild(this.source, this.destination, RenditionModel.ASSOC_RENDITION, this.renditionName);
    }

    public void testHasOldRenditionMatchesSpecifiedDestinationNode() {
        ChildAssociationRef renditionAssoc = this.makeAssoc(this.source, this.oldRendition, true);
        Mockito.when((Object)this.renditionService.getRenditionByName(this.source, this.renditionName)).thenReturn((Object)renditionAssoc);
        RenditionLocationImpl location = new RenditionLocationImpl(this.source, this.oldRendition, this.renditionName.getLocalName());
        Mockito.when((Object)this.nodeService.getPrimaryParent(this.oldRendition)).thenReturn((Object)renditionAssoc);
        RenditionNodeManager manager = new RenditionNodeManager(this.source, this.oldRendition, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)renditionAssoc, (Object)result);
    }

    public void testHasOldRenditionCorrectParentNoNameSpecified() {
        NodeRef parent = new NodeRef("http://test/parentId");
        ChildAssociationRef renditionAssoc = this.makeAssoc(this.source, this.oldRendition, true);
        Mockito.when((Object)this.renditionService.getRenditionByName(this.source, this.renditionName)).thenReturn((Object)renditionAssoc);
        ChildAssociationRef parentAssoc = this.makeAssoc(parent, this.oldRendition, false);
        Mockito.when((Object)this.nodeService.getPrimaryParent(this.oldRendition)).thenReturn((Object)parentAssoc);
        RenditionLocationImpl location = new RenditionLocationImpl(parent, null, null);
        RenditionNodeManager manager = new RenditionNodeManager(this.source, this.oldRendition, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)parentAssoc, (Object)result);
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)2))).getPrimaryParent(this.oldRendition);
    }

    public void testHasOldRenditionCorrectParentCorrectNameSpecified() {
        String rendName = "Rendition Name";
        NodeRef parent = new NodeRef("http://test/parentId");
        ChildAssociationRef renditionAssoc = this.makeAssoc(this.source, this.oldRendition, true);
        Mockito.when((Object)this.renditionService.getRenditionByName(this.source, this.renditionName)).thenReturn((Object)renditionAssoc);
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)rendName);
        ChildAssociationRef parentAssoc = this.makeAssoc(parent, this.oldRendition, assocName, false);
        Mockito.when((Object)this.nodeService.getPrimaryParent(this.oldRendition)).thenReturn((Object)parentAssoc);
        Mockito.when((Object)this.nodeService.getProperty(this.oldRendition, ContentModel.PROP_NAME)).thenReturn((Object)rendName);
        RenditionLocationImpl location = new RenditionLocationImpl(parent, null, rendName);
        RenditionNodeManager manager = new RenditionNodeManager(this.source, this.oldRendition, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)parentAssoc, (Object)result);
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)2))).getPrimaryParent(this.oldRendition);
    }

    public void testHasOldRenditionWrongParentSpecified() {
        NodeRef parent = new NodeRef("http://test/parentId");
        ChildAssociationRef parentAssoc = this.makeAssoc(parent, this.oldRendition, false);
        ChildAssociationRef sourceAssoc = this.makeAssoc(this.source, this.oldRendition, true);
        Mockito.when((Object)this.renditionService.getRenditionByName(this.source, this.renditionName)).thenReturn((Object)sourceAssoc);
        Mockito.when((Object)this.nodeService.getPrimaryParent(this.oldRendition)).thenReturn((Object)sourceAssoc);
        Mockito.when((Object)this.nodeService.moveNode(this.oldRendition, parent, ContentModel.ASSOC_CONTAINS, this.renditionName)).thenReturn((Object)parentAssoc);
        RenditionLocationImpl location = new RenditionLocationImpl(parent, null, null);
        RenditionNodeManager manager = new RenditionNodeManager(this.source, this.oldRendition, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)parentAssoc, (Object)result);
        ((NodeService)Mockito.verify((Object)this.nodeService)).moveNode(this.oldRendition, parent, ContentModel.ASSOC_CONTAINS, this.renditionName);
        Mockito.when((Object)this.nodeService.getPrimaryParent(this.oldRendition)).thenReturn((Object)parentAssoc);
        Mockito.when((Object)this.nodeService.moveNode(this.oldRendition, this.source, RenditionModel.ASSOC_RENDITION, this.renditionName)).thenReturn((Object)sourceAssoc);
        location = new RenditionLocationImpl(this.source, null, null);
        manager = new RenditionNodeManager(this.source, this.oldRendition, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)sourceAssoc, (Object)result);
        ((NodeService)Mockito.verify((Object)this.nodeService)).moveNode(this.oldRendition, this.source, RenditionModel.ASSOC_RENDITION, this.renditionName);
        NodeRef newParent = new NodeRef("http://test/newParentId");
        ChildAssociationRef newParentAssoc = this.makeAssoc(newParent, this.oldRendition, false);
        Mockito.when((Object)this.nodeService.getPrimaryParent(this.oldRendition)).thenReturn((Object)parentAssoc);
        Mockito.when((Object)this.nodeService.moveNode(this.oldRendition, newParent, ContentModel.ASSOC_CONTAINS, this.renditionName)).thenReturn((Object)newParentAssoc);
        location = new RenditionLocationImpl(newParent, null, null);
        manager = new RenditionNodeManager(this.source, this.oldRendition, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)newParentAssoc, (Object)result);
        ((NodeService)Mockito.verify((Object)this.nodeService)).moveNode(this.oldRendition, newParent, ContentModel.ASSOC_CONTAINS, this.renditionName);
    }

    public void testHasOldRenditionCorrectParentWrongNameSpecified() {
        NodeRef parent = new NodeRef("http://test/parentId");
        ChildAssociationRef parentAssoc = this.makeAssoc(parent, this.oldRendition, false);
        ChildAssociationRef renditionAssoc = this.makeAssoc(this.source, this.oldRendition, true);
        String newName = "newName";
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)newName);
        Mockito.when((Object)this.renditionService.getRenditionByName(this.source, this.renditionName)).thenReturn((Object)renditionAssoc);
        Mockito.when((Object)this.nodeService.getPrimaryParent(this.oldRendition)).thenReturn((Object)parentAssoc);
        Mockito.when((Object)this.nodeService.moveNode(this.oldRendition, parent, ContentModel.ASSOC_CONTAINS, assocName)).thenReturn((Object)parentAssoc);
        Mockito.when((Object)this.nodeService.getProperty(this.oldRendition, ContentModel.PROP_NAME)).thenReturn((Object)"oldName");
        RenditionLocationImpl location = new RenditionLocationImpl(parent, null, newName);
        RenditionNodeManager manager = new RenditionNodeManager(this.source, this.oldRendition, (RenditionLocation)location, this.definition, this.nodeService, this.renditionService, this.behaviourFilter);
        ChildAssociationRef result = manager.findOrCreateRenditionNode();
        RenditionNodeManagerTest.assertEquals((Object)parentAssoc, (Object)result);
        ((NodeService)Mockito.verify((Object)this.nodeService)).moveNode(this.oldRendition, parent, ContentModel.ASSOC_CONTAINS, assocName);
    }

    private ChildAssociationRef makeAssoc(NodeRef parent, NodeRef child, boolean isRenditionAssoc) {
        return this.makeAssoc(parent, child, this.renditionName, isRenditionAssoc);
    }

    private ChildAssociationRef makeAssoc(NodeRef parent, NodeRef child, QName assocName, boolean isRenditionAssoc) {
        QName assocType = isRenditionAssoc ? RenditionModel.ASSOC_RENDITION : ContentModel.ASSOC_CONTAINS;
        return new ChildAssociationRef(assocType, parent, assocName, child);
    }
}

