/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeVersionKey;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.node.TransactionEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.security.permissions.PermissionCheckValue;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class NodeEntity
implements Node,
PermissionCheckValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private boolean locked;
    private Long id;
    private Long version;
    private StoreEntity store;
    private String uuid;
    private Long typeQNameId;
    private Long localeId;
    private Long aclId;
    private TransactionEntity transaction;
    private AuditablePropertiesEntity auditableProperties;
    private String shardKey;
    private Integer explicitShardId;

    public NodeEntity() {
        this.locked = false;
    }

    NodeEntity(NodeRef nodeRef) {
        this();
        this.store = new StoreEntity();
        this.store.setProtocol(nodeRef.getStoreRef().getProtocol());
        this.store.setIdentifier(nodeRef.getStoreRef().getIdentifier());
        this.uuid = nodeRef.getId();
    }

    NodeEntity(Node node) {
        this.id = node.getId();
        this.version = node.getVersion();
        this.store = node.getStore();
        this.uuid = node.getUuid();
        this.typeQNameId = node.getTypeQNameId();
        this.localeId = node.getLocaleId();
        this.aclId = node.getAclId();
        this.transaction = node.getTransaction();
        this.auditableProperties = node.getAuditableProperties();
        this.shardKey = node.getShardKey();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeEntity)) {
            return false;
        }
        NodeEntity that = (NodeEntity)obj;
        return this.id.equals(that.id) && this.version.equals(that.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("NodeEntity").append("[ ID=").append(this.id).append(", version=").append(this.version);
        if (this.store != null) {
            sb.append(", store=").append(this.store.getProtocol()).append("://").append(this.store.getIdentifier());
        } else {
            sb.append(", store=").append("null");
        }
        sb.append(", uuid=").append(this.uuid).append(", typeQNameId=").append(this.typeQNameId).append(", localeId=").append(this.localeId).append(", aclId=").append(this.aclId).append(", transaction=").append(this.transaction).append(", auditProps=").append(this.auditableProperties).append(", shardKey=").append(this.shardKey).append("]");
        return sb.toString();
    }

    @Override
    public NodeVersionKey getNodeVersionKey() {
        if (this.id == null || this.version == null) {
            throw new IllegalStateException("The NodeEntity has not be filled: " + this);
        }
        return new NodeVersionKey(this.id, this.version);
    }

    @Override
    public synchronized void lock() {
        this.locked = true;
        if (this.auditableProperties != null) {
            this.auditableProperties.lock();
        }
        if (this.id == null || this.version == null) {
            throw new IllegalStateException("The NodeEntity has not be filled: " + this);
        }
    }

    private final synchronized void checkLock() {
        if (this.locked) {
            throw new IllegalStateException("The entity is locked against updates: " + this);
        }
    }

    public synchronized void incrementVersion() {
        this.checkLock();
        this.version = this.version >= 32767L ? Long.valueOf(0L) : Long.valueOf(this.version + 1L);
    }

    @Override
    public NodeRef getNodeRef() {
        return new NodeRef(this.store.getStoreRef(), this.uuid);
    }

    @Override
    public NodeRef.Status getNodeStatus(QNameDAO qnameDAO) {
        NodeRef nodeRef = new NodeRef(this.store.getStoreRef(), this.uuid);
        boolean deleted = this.getDeleted(qnameDAO);
        return new NodeRef.Status(this.id, nodeRef, this.transaction.getChangeTxnId(), this.transaction.getId(), deleted);
    }

    @Override
    public Pair<Long, NodeRef> getNodePair() {
        return new Pair((Object)this.id, (Object)this.getNodeRef());
    }

    @Override
    public boolean getDeleted(QNameDAO qnameDAO) {
        if (this.store.getProtocol().equals("deleted")) {
            return true;
        }
        Pair<Long, QName> deletedTypeQNamePair = qnameDAO.getQName(ContentModel.TYPE_DELETED);
        return deletedTypeQNamePair != null && ((Long)deletedTypeQNamePair.getFirst()).equals(this.typeQNameId);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public synchronized void setId(Long id) {
        this.checkLock();
        this.id = id;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    public synchronized void setVersion(Long version) {
        this.checkLock();
        this.version = version;
    }

    @Override
    public StoreEntity getStore() {
        return this.store;
    }

    public synchronized void setStore(StoreEntity store) {
        this.checkLock();
        this.store = store;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public synchronized void setUuid(String uuid) {
        this.checkLock();
        this.uuid = uuid;
    }

    @Override
    public Long getTypeQNameId() {
        return this.typeQNameId;
    }

    public synchronized void setTypeQNameId(Long typeQNameId) {
        this.checkLock();
        this.typeQNameId = typeQNameId;
    }

    @Override
    public Long getLocaleId() {
        return this.localeId;
    }

    public synchronized void setLocaleId(Long localeId) {
        this.localeId = localeId;
    }

    @Override
    public Long getAclId() {
        return this.aclId;
    }

    public synchronized void setAclId(Long aclId) {
        this.checkLock();
        this.aclId = aclId;
    }

    @Override
    public TransactionEntity getTransaction() {
        return this.transaction;
    }

    public synchronized void setTransaction(TransactionEntity transaction) {
        this.checkLock();
        this.transaction = transaction;
    }

    @Override
    public AuditablePropertiesEntity getAuditableProperties() {
        return this.auditableProperties;
    }

    public synchronized void setAuditableProperties(AuditablePropertiesEntity auditableProperties) {
        this.checkLock();
        this.auditableProperties = auditableProperties;
    }

    @Override
    public String getShardKey() {
        return this.shardKey;
    }

    @Override
    public Integer getExplicitShardId() {
        return this.explicitShardId;
    }

    public synchronized void setShardKey(String shardKey) {
        this.shardKey = shardKey;
    }

    public synchronized void setExplicitShardId(Integer explicitShardId) {
        this.explicitShardId = explicitShardId;
    }
}

