/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={NeverRunsTests.class})
public class ActionParameterConstraintTest
extends BaseSpringTest {
    private static final String COMPARE_OP = "ac-compare-operations";
    private ActionService actionService;

    @Before
    public void before() throws Exception {
        this.actionService = (ActionService)this.applicationContext.getBean("ActionService");
    }

    public void testGetConstraints() {
        List constraints = this.actionService.getParameterConstraints();
        ActionParameterConstraintTest.assertNotNull((Object)constraints);
        ActionParameterConstraintTest.assertFalse((boolean)constraints.isEmpty());
    }

    public void testGetConstraint() {
        ParameterConstraint constraint = this.actionService.getParameterConstraint("junk");
        ActionParameterConstraintTest.assertNull((Object)constraint);
        constraint = this.actionService.getParameterConstraint(COMPARE_OP);
        ActionParameterConstraintTest.assertNotNull((Object)constraint);
    }

    public void testCompareOperationsConstraint() {
        ParameterConstraint constraint = this.actionService.getParameterConstraint(COMPARE_OP);
        ActionParameterConstraintTest.assertNotNull((Object)constraint);
        ActionParameterConstraintTest.assertEquals((String)COMPARE_OP, (String)constraint.getName());
        ActionParameterConstraintTest.assertEquals((String)"Ends With", (String)constraint.getValueDisplayLabel(ComparePropertyValueOperation.ENDS.toString()));
        Map values = constraint.getAllowableValues();
        for (Map.Entry entry : values.entrySet()) {
            System.out.println(String.valueOf((String)entry.getKey()) + " - " + (String)entry.getValue());
        }
    }

    public void testConstraints() {
        this.testConstraint("ac-aspects");
        this.testConstraint("ac-types");
        this.testConstraint("ac-properties");
        this.testConstraint("ac-mimetypes");
        this.testConstraint("ac-email-templates");
        this.testConstraint("ac-scripts");
        this.testConstraint("ac-content-properties");
    }

    private void testConstraint(String name) {
        ParameterConstraint constraint = this.actionService.getParameterConstraint(name);
        ActionParameterConstraintTest.assertNotNull((Object)constraint);
        ActionParameterConstraintTest.assertEquals((String)name, (String)constraint.getName());
        Map values = constraint.getAllowableValues();
        ActionParameterConstraintTest.assertTrue((values.size() > 0 ? 1 : 0) != 0);
        System.out.println("== " + name + " ==\n");
        for (Map.Entry entry : values.entrySet()) {
            System.out.println(String.valueOf((String)entry.getKey()) + " - " + (String)entry.getValue());
        }
    }
}

