/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.alfresco.util.test.junitrules.TemporarySitesTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.springframework.extensions.webscripts.GUID;

@Category(value={OwnJVMTestsCategory.class})
public class SiteServiceImplMoreTest {
    protected static Log log = LogFactory.getLog(SiteServiceImplMoreTest.class);
    public static ApplicationContextInit APP_CONTEXT_INIT = ApplicationContextInit.createStandardContextWithOverrides("classpath:sites/test-" + TemporarySitesTest.class.getSimpleName() + "-context.xml");
    public static TemporarySites STATIC_TEST_SITES = new TemporarySites(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain staticRuleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)STATIC_TEST_SITES);
    public RunAsFullyAuthenticatedRule runAllTestsAsAdmin = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    public TemporarySites perMethodTestSites = new TemporarySites(APP_CONTEXT_INIT);
    public AlfrescoPerson testUser = new AlfrescoPerson(APP_CONTEXT_INIT);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.runAllTestsAsAdmin).around((TestRule)this.perMethodTestSites).around((TestRule)this.testUser);
    @Rule
    public TestName testName = new TestName();
    private static AuthorityService AUTHORITY_SERVICE;
    private static NamespaceService NAMESPACE_SERVICE;
    private static NodeService NODE_SERVICE;
    private static NodeArchiveService NODE_ARCHIVE_SERVICE;
    private static SiteService SITE_SERVICE;
    private static CheckOutCheckInService COCI_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static PermissionService PERMISSION_SERVICE;
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static FileFolderService FILE_FOLDER_SERVICE;
    private static AuthenticationComponent AUTHENTICATION_COMPONENT;
    private static LockService LOCK_SERVICE;
    private static String TEST_SITE_NAME;
    private static String TEST_SUB_SITE_NAME;
    private static TemporarySites.TestSiteAndMemberInfo TEST_SITE_WITH_MEMBERS;

    @BeforeClass
    public static void initStaticData() throws Exception {
        AUTHORITY_SERVICE = (AuthorityService)APP_CONTEXT_INIT.getApplicationContext().getBean("AuthorityService", AuthorityService.class);
        NAMESPACE_SERVICE = (NamespaceService)APP_CONTEXT_INIT.getApplicationContext().getBean("namespaceService", NamespaceService.class);
        NODE_SERVICE = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("NodeService", NodeService.class);
        NODE_ARCHIVE_SERVICE = (NodeArchiveService)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeArchiveService", NodeArchiveService.class);
        SITE_SERVICE = (SiteService)APP_CONTEXT_INIT.getApplicationContext().getBean("siteService", SiteService.class);
        COCI_SERVICE = (CheckOutCheckInService)APP_CONTEXT_INIT.getApplicationContext().getBean("checkOutCheckInService", CheckOutCheckInService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        PERMISSION_SERVICE = (PermissionService)APP_CONTEXT_INIT.getApplicationContext().getBean("permissionServiceImpl", PermissionService.class);
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)APP_CONTEXT_INIT.getApplicationContext().getBean("authenticationService", MutableAuthenticationService.class);
        PERSON_SERVICE = (PersonService)APP_CONTEXT_INIT.getApplicationContext().getBean("PersonService", PersonService.class);
        FILE_FOLDER_SERVICE = (FileFolderService)APP_CONTEXT_INIT.getApplicationContext().getBean("FileFolderService", FileFolderService.class);
        AUTHENTICATION_COMPONENT = (AuthenticationComponent)APP_CONTEXT_INIT.getApplicationContext().getBean("authenticationComponent", AuthenticationComponent.class);
        LOCK_SERVICE = (LockService)APP_CONTEXT_INIT.getApplicationContext().getBean("lockService", LockService.class);
        String admin = AuthenticationUtil.getAdminUserName();
        TEST_SITE_NAME = GUID.generate();
        TEST_SUB_SITE_NAME = GUID.generate();
        QName subSiteType = QName.createQName((String)"testsite", (String)"testSubsite", (NamespacePrefixResolver)NAMESPACE_SERVICE);
        STATIC_TEST_SITES.createSite("sitePreset", TEST_SITE_NAME, "siteTitle", "siteDescription", SiteVisibility.PUBLIC, admin);
        STATIC_TEST_SITES.createSite("sitePreset", TEST_SUB_SITE_NAME, "siteTitle", "siteDescription", SiteVisibility.PUBLIC, subSiteType, admin);
        TEST_SITE_WITH_MEMBERS = STATIC_TEST_SITES.createTestSiteWithUserPerRole(SiteServiceImplMoreTest.class.getSimpleName(), "sitePreset", SiteVisibility.PUBLIC, admin);
    }

    @Test
    public void listSitesIncludingSubTypesOfSite() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PagingResults sites = SITE_SERVICE.listSites(null, null, new PagingRequest(0, 1024));
                HashMap<String, SiteInfo> sitesByName = new HashMap<String, SiteInfo>();
                for (SiteInfo site : sites.getPage()) {
                    sitesByName.put(site.getShortName(), site);
                }
                Assert.assertNotNull((String)"st:site missing.", sitesByName.get(TEST_SITE_NAME));
                Assert.assertNotNull((String)"subtype of st:site missing.", sitesByName.get(TEST_SUB_SITE_NAME));
                return null;
            }
        });
    }

    @Test
    public void anySiteManagerShouldBeAbleToDeleteASite() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SITE_SERVICE.setMembership(TEST_SITE_WITH_MEMBERS.siteInfo.getShortName(), SiteServiceImplMoreTest.this.testUser.getUsername(), "SiteManager");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        SITE_SERVICE.deleteSite(TEST_SITE_WITH_MEMBERS.siteInfo.getShortName());
                        return null;
                    }
                }, (String)SiteServiceImplMoreTest.this.testUser.getUsername());
                return null;
            }
        });
    }

    @Test
    public void deleteSiteDeleteAuthoritiesAndRestoreEnsuringSiteGroupsWasRecreated() throws Exception {
        final String siteShortName = "testsite-" + System.currentTimeMillis();
        final SiteServiceImpl siteServiceImpl = (SiteServiceImpl)SITE_SERVICE;
        log.debug((Object)("Creating test site called: " + siteShortName));
        final TemporarySites.TestSiteAndMemberInfo testSiteAndMemberInfo = this.perMethodTestSites.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName());
        final Map membersBefore = (Map)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, String>>(){

            public Map<String, String> execute() throws Throwable {
                NodeRef siteNodeRef = testSiteAndMemberInfo.siteInfo.getNodeRef();
                Map membersBefore = SITE_SERVICE.listMembers(siteShortName, null, null, 0, true);
                log.debug((Object)(String.valueOf(membersBefore.size()) + " members..."));
                for (Map.Entry entry : membersBefore.entrySet()) {
                    log.debug(entry);
                }
                HashMap<String, Set> groupsMemberships = new HashMap<String, Set>();
                log.debug((Object)"About to delete site-related groups.");
                Set permissions = PERMISSION_SERVICE.getSettablePermissions(SiteModel.TYPE_SITE);
                for (String permission : permissions) {
                    String prefixSiteRoleGroup = siteServiceImpl.getSiteRoleGroup(siteShortName, permission, true);
                    Set groupUsers = AUTHORITY_SERVICE.getContainedAuthorities(null, prefixSiteRoleGroup, true);
                    groupsMemberships.put(prefixSiteRoleGroup, groupUsers);
                    AUTHORITY_SERVICE.deleteAuthority(prefixSiteRoleGroup);
                }
                NODE_SERVICE.setProperty(siteNodeRef, QName.createQName(null, (String)"memberships"), (Serializable)groupsMemberships);
                log.debug((Object)"Site-related groups deleted.");
                log.debug((Object)"About to delete site.");
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"Site deleted.");
                return membersBefore;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.assertThatArchivedNodeExists(testSiteAndMemberInfo.siteInfo.getNodeRef(), "Site node not found in archive.");
                Set permissions = PERMISSION_SERVICE.getSettablePermissions(SiteModel.TYPE_SITE);
                for (String permission : permissions) {
                    String permissionGroupShortName = siteServiceImpl.getSiteRoleGroup(siteShortName, permission, false);
                    String authorityName = AUTHORITY_SERVICE.getName(AuthorityType.GROUP, permissionGroupShortName);
                    Assert.assertTrue((String)("Authotiry should not exist : " + authorityName), (!AUTHORITY_SERVICE.authorityExists(authorityName) ? 1 : 0) != 0);
                }
                log.debug((Object)"About to restore site node from archive");
                NodeRef archivedSiteNode = NODE_ARCHIVE_SERVICE.getArchivedNode(testSiteAndMemberInfo.siteInfo.getNodeRef());
                RestoreNodeReport report = NODE_ARCHIVE_SERVICE.restoreArchivedNode(archivedSiteNode);
                Assert.assertEquals((String)"Failed to restore site from archive", (Object)RestoreNodeReport.RestoreStatus.SUCCESS, (Object)report.getStatus());
                log.debug((Object)"Successfully restored site from arhive.");
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, String>>(){

            public Map<String, String> execute() throws Throwable {
                Assert.assertTrue((String)"The site noderef was not restored as expected", (boolean)NODE_SERVICE.exists(testSiteAndMemberInfo.siteInfo.getNodeRef()));
                Map members = SITE_SERVICE.listMembers(siteShortName, null, null, 0, true);
                Assert.assertEquals((String)"Not all member have been restored", (long)membersBefore.size(), (long)members.size());
                log.debug((Object)(String.valueOf(members.size()) + " members..."));
                for (Map.Entry entry : SITE_SERVICE.listMembers(siteShortName, null, null, 0, true).entrySet()) {
                    log.debug(entry);
                }
                for (String role : SITE_SERVICE.getSiteRoles()) {
                    String siteGroup = SITE_SERVICE.getSiteRoleGroup(siteShortName, role);
                    Assert.assertTrue((String)("Site group for role " + role + " did not exist after site restoration"), (boolean)AUTHORITY_SERVICE.authorityExists(siteGroup));
                }
                Set currentManagers = AUTHORITY_SERVICE.getContainedAuthorities(AuthorityType.USER, siteServiceImpl.getSiteRoleGroup(siteShortName, "SiteManager", true), false);
                log.debug((Object)("Current Managers " + currentManagers));
                Assert.assertTrue((String)"There should be at least one site manager", (!currentManagers.isEmpty() ? 1 : 0) != 0);
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"About to delete site completely.");
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"About to purge site from trashcan.");
                String storePath = "archive://SpacesStore";
                StoreRef storeRef = new StoreRef(storePath);
                NodeRef archivedNodeRef = new NodeRef(storeRef, testSiteAndMemberInfo.siteInfo.getNodeRef().getId());
                NODE_ARCHIVE_SERVICE.purgeArchivedNode(archivedNodeRef);
                return null;
            }
        });
    }

    private void createUser(String userName, String nameSuffix) {
        if (AUTHENTICATION_SERVICE.authenticationExists(userName)) {
            return;
        }
        AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
        PropertyMap ppOne = new PropertyMap(4);
        ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)("firstName" + nameSuffix));
        ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)("lastName" + nameSuffix));
        ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)("email" + nameSuffix + "@email.com"));
        ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
        PERSON_SERVICE.createPerson((Map)ppOne);
    }

    @Test
    public void deleteSiteDeleteAuthoritiesAndRestoreEnsuringLocksAreRestored() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.createUser("UserOwner", "dart");
                SiteServiceImplMoreTest.this.createUser("UserColaborator", "dart");
                return null;
            }
        });
        final String siteShortName = "testsite-" + System.currentTimeMillis();
        log.debug((Object)("Creating test site called: " + siteShortName));
        final TemporarySites.TestSiteAndMemberInfo testSiteAndMemberInfo = this.perMethodTestSites.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, "UserOwner");
        AUTHENTICATION_COMPONENT.setCurrentUser("UserOwner");
        String fileFolderPrefix = "TESTLOCK_";
        String componentId = "doclib";
        NodeRef siteContainer = SITE_SERVICE.createContainer(siteShortName, componentId, ContentModel.TYPE_FOLDER, null);
        final FileInfo fileInfo = FILE_FOLDER_SERVICE.create(siteContainer, String.valueOf(fileFolderPrefix) + "file.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer = FILE_FOLDER_SERVICE.getWriter(fileInfo.getNodeRef());
        writer.putContent("Just some old content that doesn't mean anything");
        FileInfo folder1Info = FILE_FOLDER_SERVICE.create(siteContainer, String.valueOf(fileFolderPrefix) + "folder", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo2 = FILE_FOLDER_SERVICE.create(folder1Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "fileInFolder.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer2 = FILE_FOLDER_SERVICE.getWriter(fileInfo2.getNodeRef());
        writer2.putContent("Just some old content that doesn't mean anything");
        FileInfo folder2Info = FILE_FOLDER_SERVICE.create(folder1Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "subfolder", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo3 = FILE_FOLDER_SERVICE.create(folder2Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "fileInSubfolder.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer3 = FILE_FOLDER_SERVICE.getWriter(fileInfo3.getNodeRef());
        writer3.putContent("Just some old content that doesn't mean anything");
        Assert.assertEquals((Object)LockStatus.NO_LOCK, (Object)LOCK_SERVICE.getLockStatus(fileInfo.getNodeRef()));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LOCK_SERVICE.lock(fileInfo.getNodeRef(), LockType.WRITE_LOCK);
                return null;
            }
        });
        Assert.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)LOCK_SERVICE.getLockStatus(fileInfo.getNodeRef()));
        this.checkThatNonMembersCanNotCreateFiles("UserColaborator", fileFolderPrefix, folder2Info);
        AUTHENTICATION_COMPONENT.setCurrentUser("UserOwner");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                SITE_SERVICE.setMembership(siteShortName, "UserColaborator", "SiteCollaborator");
                return null;
            }
        });
        AUTHENTICATION_COMPONENT.setCurrentUser("UserColaborator");
        final FileInfo fileInfoForCollaboratorUser = FILE_FOLDER_SERVICE.create(folder2Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "userCollaborator.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer4 = FILE_FOLDER_SERVICE.getWriter(fileInfoForCollaboratorUser.getNodeRef());
        writer4.putContent("Just some old content that doesn't mean anything");
        Assert.assertEquals((Object)LockStatus.NO_LOCK, (Object)LOCK_SERVICE.getLockStatus(fileInfoForCollaboratorUser.getNodeRef()));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LOCK_SERVICE.lock(fileInfoForCollaboratorUser.getNodeRef(), LockType.WRITE_LOCK);
                return null;
            }
        });
        Assert.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)LOCK_SERVICE.getLockStatus(fileInfoForCollaboratorUser.getNodeRef()));
        final FileInfo fileEditOffline = FILE_FOLDER_SERVICE.create(siteContainer, String.valueOf(fileFolderPrefix) + "fileEditOfline.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writerEO = FILE_FOLDER_SERVICE.getWriter(fileEditOffline.getNodeRef());
        writerEO.putContent("Just some old content that doesn't mean anything");
        Assert.assertEquals((Object)LockStatus.NO_LOCK, (Object)LOCK_SERVICE.getLockStatus(fileEditOffline.getNodeRef()));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef workingCopy = COCI_SERVICE.checkout(fileEditOffline.getNodeRef());
                Assert.assertNotNull((Object)workingCopy);
                return null;
            }
        });
        Assert.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)LOCK_SERVICE.getLockStatus(fileEditOffline.getNodeRef()));
        AUTHENTICATION_COMPONENT.setCurrentUser("UserOwner");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"About to delete site.");
                AUTHENTICATION_COMPONENT.getCurrentUserName();
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"Site deleted.");
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.assertThatArchivedNodeExists(testSiteAndMemberInfo.siteInfo.getNodeRef(), "Site node not found in archive.");
                log.debug((Object)"About to restore site node from archive");
                NodeRef archivedSiteNode = NODE_ARCHIVE_SERVICE.getArchivedNode(testSiteAndMemberInfo.siteInfo.getNodeRef());
                RestoreNodeReport report = NODE_ARCHIVE_SERVICE.restoreArchivedNode(archivedSiteNode);
                Assert.assertEquals((String)"Failed to restore site from archive", (Object)RestoreNodeReport.RestoreStatus.SUCCESS, (Object)report.getStatus());
                log.debug((Object)"Successfully restored site from arhive.");
                return null;
            }
        });
        AUTHENTICATION_COMPONENT.setCurrentUser("UserColaborator");
        Assert.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)LOCK_SERVICE.getLockStatus(fileInfoForCollaboratorUser.getNodeRef()));
        Assert.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)LOCK_SERVICE.getLockStatus(fileEditOffline.getNodeRef()));
        AUTHENTICATION_COMPONENT.setCurrentUser("UserOwner");
        Assert.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)LOCK_SERVICE.getLockStatus(fileInfo.getNodeRef()));
        Assert.assertEquals((Object)LockStatus.LOCKED, (Object)LOCK_SERVICE.getLockStatus(fileEditOffline.getNodeRef()));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NODE_SERVICE.addAspect(testSiteAndMemberInfo.siteInfo.getNodeRef(), ContentModel.ASPECT_TEMPORARY, null);
                log.debug((Object)"About to delete site completely.");
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"About to purge site from trashcan.");
                String storePath = "archive://SpacesStore";
                StoreRef storeRef = new StoreRef(storePath);
                NodeRef archivedNodeRef = new NodeRef(storeRef, testSiteAndMemberInfo.siteInfo.getNodeRef().getId());
                NODE_ARCHIVE_SERVICE.purgeArchivedNode(archivedNodeRef);
                return null;
            }
        });
    }

    private void checkThatNonMembersCanNotCreateFiles(String userCollaborator, String fileFolderPrefix, FileInfo folder2Info) {
        AUTHENTICATION_COMPONENT.setCurrentUser(userCollaborator);
        try {
            FileInfo fileInfoForTestNewFileAsAnotherUser = FILE_FOLDER_SERVICE.create(folder2Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "user2.txt", ContentModel.TYPE_CONTENT);
            ContentWriter writer3_user2 = FILE_FOLDER_SERVICE.getWriter(fileInfoForTestNewFileAsAnotherUser.getNodeRef());
            writer3_user2.putContent("Just some old content that doesn't mean anything");
            Assert.fail((String)"We should not reach this point. the user that tries to run this code, add the file, is not yet a member of the site");
        }
        catch (AccessDeniedException accessDeniedException) {}
    }

    @Test
    public void deleteSiteAndRestoreEnsuringSiteGroupsAreRecovered() throws Exception {
        final String siteShortName = this.testName.getMethodName();
        log.debug((Object)("Creating test site called: " + siteShortName));
        final TemporarySites.TestSiteAndMemberInfo testSiteAndMemberInfo = this.perMethodTestSites.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName());
        final TestData testData = (TestData)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<TestData>(){

            public TestData execute() throws Throwable {
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(ContentModel.PROP_NAME, "testcontent");
                properties.put(ContentModel.PROP_DESCRIPTION, "content - test doc for test");
                ChildAssociationRef testDoc = NODE_SERVICE.createNode(testSiteAndMemberInfo.doclib, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testcontent"), ContentModel.TYPE_CONTENT, properties);
                NodeRef testDocNodeRef = testDoc.getChildRef();
                PERMISSION_SERVICE.deletePermissions(testDocNodeRef);
                PERMISSION_SERVICE.setInheritParentPermissions(testDocNodeRef, false);
                Assert.assertTrue((String)"Permissions should be cleared", (boolean)PERMISSION_SERVICE.getAllSetPermissions(testDocNodeRef).isEmpty());
                Set permissions = PERMISSION_SERVICE.getSettablePermissions(SiteModel.TYPE_SITE);
                for (String permission : permissions) {
                    String siteRoleGroup = SITE_SERVICE.getSiteRoleGroup(siteShortName, permission);
                    PERMISSION_SERVICE.setPermission(testDocNodeRef, siteRoleGroup, "SiteContributor", true);
                }
                HashMap<String, String> userNameToRoleMap = new HashMap<String, String>();
                for (String role : SITE_SERVICE.getSiteRoles()) {
                    userNameToRoleMap.putAll(SITE_SERVICE.listMembers(siteShortName, null, role, 0, true));
                }
                String siteContributorGroup = SITE_SERVICE.getSiteRoleGroup(siteShortName, "SiteContributor");
                Assert.assertTrue((String)"Site contributor user was not in site contributors group", (boolean)AUTHORITY_SERVICE.getContainedAuthorities(AuthorityType.USER, siteContributorGroup, true).contains(testSiteAndMemberInfo.siteContributor));
                Assert.assertEquals((String)"Site contributor user did not have expected Contributor role", (Object)"SiteContributor", userNameToRoleMap.get(testSiteAndMemberInfo.siteContributor));
                log.debug((Object)"About to delete site.");
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"Site deleted.");
                return new TestData(userNameToRoleMap, testDocNodeRef);
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.assertThatArchivedNodeExists(testSiteAndMemberInfo.siteInfo.getNodeRef(), "Site node not found in archive.");
                log.debug((Object)"About to restore site node from archive");
                NodeRef archivedSiteNode = NODE_ARCHIVE_SERVICE.getArchivedNode(testSiteAndMemberInfo.siteInfo.getNodeRef());
                RestoreNodeReport report = NODE_ARCHIVE_SERVICE.restoreArchivedNode(archivedSiteNode);
                Assert.assertEquals((String)"Failed to restore site from archive", (Object)RestoreNodeReport.RestoreStatus.SUCCESS, (Object)report.getStatus());
                log.debug((Object)"Successfully restored site from arhive.");
                return null;
            }
        });
        final Map associatedGroups = (Map)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, String>>(){

            public Map<String, String> execute() throws Throwable {
                Assert.assertTrue((String)"The site noderef was not restored as expected", (boolean)NODE_SERVICE.exists(testSiteAndMemberInfo.siteInfo.getNodeRef()));
                for (String string : SITE_SERVICE.getSiteRoles()) {
                    String siteGroup = SITE_SERVICE.getSiteRoleGroup(siteShortName, string);
                    Assert.assertTrue((String)("Site group for role " + string + " did not exist after site restoration"), (boolean)AUTHORITY_SERVICE.authorityExists(siteGroup));
                }
                log.debug((Object)(String.valueOf(SITE_SERVICE.listMembers(siteShortName, null, null, 0, true).size()) + " members..."));
                for (Map.Entry entry : SITE_SERVICE.listMembers(siteShortName, null, null, 0, true).entrySet()) {
                    log.debug((Object)entry);
                }
                for (Map.Entry entry : testData.userNameToRoleMap.entrySet()) {
                    Assert.assertEquals((String)("Unexpected role for site user: " + (String)entry.getKey()), entry.getValue(), (Object)SITE_SERVICE.getMembersRole(siteShortName, (String)entry.getKey()));
                }
                Set set = PERMISSION_SERVICE.getAllSetPermissions(testData.testDocNodeRef);
                HashMap<String, String> associatedGroups = new HashMap<String, String>();
                for (AccessPermission access : set) {
                    associatedGroups.put(access.getAuthority(), access.getPermission());
                }
                Set permissions = PERMISSION_SERVICE.getSettablePermissions(SiteModel.TYPE_SITE);
                for (String permission : permissions) {
                    String siteRoleGroup = SITE_SERVICE.getSiteRoleGroup(siteShortName, permission);
                    Assert.assertTrue((String)"all groups should have the permissions from a contributor on test content", (boolean)"SiteContributor".equals(associatedGroups.get(siteRoleGroup)));
                }
                return associatedGroups;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"About to delete site completely.");
                SITE_SERVICE.deleteSite(siteShortName);
                for (String authority : associatedGroups.keySet()) {
                    Assert.assertTrue((String)"Associated groups should remain after site delete", (boolean)AUTHORITY_SERVICE.authorityExists(authority));
                }
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"About to purge site from trashcan.");
                String storePath = "archive://SpacesStore";
                StoreRef storeRef = new StoreRef(storePath);
                NodeRef archivedNodeRef = new NodeRef(storeRef, testSiteAndMemberInfo.siteInfo.getNodeRef().getId());
                NODE_ARCHIVE_SERVICE.purgeArchivedNode(archivedNodeRef);
                for (String authority : associatedGroups.keySet()) {
                    Assert.assertTrue((String)"Associated groups should be deleted on site purge", (!AUTHORITY_SERVICE.authorityExists(authority) ? 1 : 0) != 0);
                }
                return null;
            }
        });
    }

    @Test
    public void testSiteMembersPaged() {
        final String siteShortName = this.testName.getMethodName();
        log.debug((Object)("Creating test site called: " + siteShortName));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.perMethodTestSites.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName());
                ArrayList<Pair> sortProps = new ArrayList<Pair>(1);
                sortProps.add(new Pair((Object)SiteService.SortFields.FirstName, (Object)true));
                PagingResults pagedMembers = SITE_SERVICE.listMembersPaged(siteShortName, true, sortProps, new PagingRequest(100));
                Assert.assertNotNull((Object)pagedMembers);
                Assert.assertNotNull((Object)pagedMembers.getPage());
                Assert.assertNotNull((Object)pagedMembers.getQueryExecutionId());
                Assert.assertFalse((boolean)pagedMembers.hasMoreItems());
                log.debug((Object)"About to delete site completely.");
                SITE_SERVICE.deleteSite(siteShortName);
                return null;
            }
        });
    }

    @Test
    public void testSiteGroupsPaged() {
        String siteShortName = this.testName.getMethodName();
        log.debug((Object)("Creating test site called: " + siteShortName));
        TRANSACTION_HELPER.doInTransaction(() -> {
            this.perMethodTestSites.createTestSiteWithGroups(siteShortName, "sitePreset", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName(), 10);
            ArrayList<Pair> sortProps = new ArrayList<Pair>(1);
            sortProps.add(new Pair((Object)SiteService.SortFields.DisplayName, (Object)true));
            PagingResults pagedMembers = SITE_SERVICE.listGroupMembersPaged(siteShortName, sortProps, new PagingRequest(5));
            Assert.assertNotNull((Object)pagedMembers);
            Assert.assertNotNull((Object)pagedMembers.getQueryExecutionId());
            Assert.assertTrue((boolean)pagedMembers.hasMoreItems());
            Assert.assertEquals((long)pagedMembers.getPage().size(), (long)5L);
            log.debug((Object)"About to delete site completely.");
            SITE_SERVICE.deleteSite(siteShortName);
            return null;
        });
    }

    @Test
    public void testSiteMembersPagedV2() {
        String siteShortName = this.testName.getMethodName();
        log.debug((Object)("Creating test site called: " + siteShortName));
        TRANSACTION_HELPER.doInTransaction(() -> {
            this.perMethodTestSites.createTestSiteWithGroups(siteShortName, "sitePreset", SiteVisibility.PUBLIC, AuthenticationUtil.getAdminUserName(), 10);
            ArrayList<Pair> sortProps = new ArrayList<Pair>(1);
            sortProps.add(new Pair((Object)SiteService.SortFields.FirstName, (Object)true));
            PagingResults pagedMembers = SITE_SERVICE.listMembersPaged(siteShortName, true, sortProps, new PagingRequest(25));
            Assert.assertNotNull((Object)pagedMembers);
            Assert.assertNotNull((Object)pagedMembers.getQueryExecutionId());
            Assert.assertFalse((boolean)pagedMembers.hasMoreItems());
            Assert.assertEquals((long)pagedMembers.getPage().size(), (long)11L);
            List users = pagedMembers.getPage().stream().filter(member -> !member.isMemberOfGroup()).collect(Collectors.toList());
            List groupsUsers = pagedMembers.getPage().stream().filter(SiteMembership::isMemberOfGroup).collect(Collectors.toList());
            Assert.assertEquals((long)users.size(), (long)1L);
            Assert.assertEquals((long)groupsUsers.size(), (long)10L);
            pagedMembers = SITE_SERVICE.listMembersPaged(siteShortName, false, sortProps, new PagingRequest(100));
            Assert.assertNotNull((Object)pagedMembers);
            Assert.assertNotNull((Object)pagedMembers.getQueryExecutionId());
            Assert.assertFalse((boolean)pagedMembers.hasMoreItems());
            Assert.assertEquals((long)pagedMembers.getPage().size(), (long)1L);
            users = pagedMembers.getPage().stream().filter(member -> !member.isMemberOfGroup()).collect(Collectors.toList());
            groupsUsers = pagedMembers.getPage().stream().filter(SiteMembership::isMemberOfGroup).collect(Collectors.toList());
            Assert.assertEquals((long)users.size(), (long)1L);
            Assert.assertEquals((long)groupsUsers.size(), (long)0L);
            log.debug((Object)"About to delete site completely.");
            SITE_SERVICE.deleteSite(siteShortName);
            return null;
        });
    }

    @Test
    public void testTokenizer() {
        String[] res = SiteServiceImpl.tokenizeFilterLowercase((String)"Fred");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)1L, (long)res.length);
        Assert.assertEquals((Object)"fred", (Object)res[0]);
        res = SiteServiceImpl.tokenizeFilterLowercase((String)"king kong lives");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"king", (Object)res[0]);
        Assert.assertEquals((Object)"kong", (Object)res[1]);
        Assert.assertEquals((Object)"lives", (Object)res[2]);
        res = SiteServiceImpl.tokenizeFilterLowercase((String)"KING Kong livES");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)3L, (long)res.length);
        Assert.assertEquals((Object)"king", (Object)res[0]);
        Assert.assertEquals((Object)"kong", (Object)res[1]);
        Assert.assertEquals((Object)"lives", (Object)res[2]);
        res = SiteServiceImpl.tokenizeFilterLowercase(null);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)0L, (long)res.length);
    }

    @Test
    public void testSiteRolesPermissionsToDeleteWorkingCopy() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.createUser("UserSiteOwner", "delete-working-copy-file");
                SiteServiceImplMoreTest.this.createUser("UserSiteManager", "delete-working-copy-file");
                SiteServiceImplMoreTest.this.createUser("UserSiteCollaborator", "delete-working-copy-file");
                return null;
            }
        });
        final String siteShortName = "delete-working-copy-fileSite" + System.currentTimeMillis();
        this.perMethodTestSites.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, "UserSiteOwner");
        AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteOwner");
        NodeRef siteContainer = SITE_SERVICE.createContainer(siteShortName, "doclib", ContentModel.TYPE_FOLDER, null);
        final FileInfo fileInfo1 = FILE_FOLDER_SERVICE.create(siteContainer, "fileInfo1.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer1 = FILE_FOLDER_SERVICE.getWriter(fileInfo1.getNodeRef());
        writer1.putContent("Just some old content that doesn't mean anything");
        final FileInfo fileInfo2 = FILE_FOLDER_SERVICE.create(siteContainer, "fileInfo2.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer2 = FILE_FOLDER_SERVICE.getWriter(fileInfo2.getNodeRef());
        writer2.putContent("Just some old content that doesn't mean anything");
        final FileInfo fileInfo3 = FILE_FOLDER_SERVICE.create(siteContainer, "fileInfo3.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer3 = FILE_FOLDER_SERVICE.getWriter(fileInfo2.getNodeRef());
        writer3.putContent("Just some old content that doesn't mean anything");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteOwner");
                NodeRef workingCopy = COCI_SERVICE.checkout(fileInfo3.getNodeRef());
                Assert.assertNotNull((Object)workingCopy);
                SITE_SERVICE.setMembership(siteShortName, "UserSiteCollaborator", "SiteCollaborator");
                AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteCollaborator");
                try {
                    NODE_SERVICE.deleteNode(workingCopy);
                    Assert.fail((String)"You do not have the appropriate permissions to perform this operation");
                }
                catch (AccessDeniedException accessDeniedException) {}
                try {
                    NODE_SERVICE.deleteNode(fileInfo3.getNodeRef());
                    Assert.fail((String)"You do not have the appropriate permissions to perform this operation");
                }
                catch (AccessDeniedException accessDeniedException) {}
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteOwner");
                NodeRef workingCopy = COCI_SERVICE.checkout(fileInfo2.getNodeRef());
                Assert.assertNotNull((Object)workingCopy);
                NODE_SERVICE.deleteNode(workingCopy);
                workingCopy = COCI_SERVICE.checkout(fileInfo2.getNodeRef());
                Assert.assertNotNull((Object)workingCopy);
                NODE_SERVICE.deleteNode(fileInfo2.getNodeRef());
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteOwner");
                NodeRef workingCopy = COCI_SERVICE.checkout(fileInfo1.getNodeRef());
                Assert.assertNotNull((Object)workingCopy);
                SITE_SERVICE.setMembership(siteShortName, "UserSiteManager", "SiteManager");
                AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteManager");
                NODE_SERVICE.deleteNode(workingCopy);
                AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteOwner");
                workingCopy = COCI_SERVICE.checkout(fileInfo1.getNodeRef());
                Assert.assertNotNull((Object)workingCopy);
                AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteManager");
                NODE_SERVICE.deleteNode(fileInfo1.getNodeRef());
                return null;
            }
        });
        AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteOwner");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AUTHENTICATION_COMPONENT.getCurrentUserName();
                SITE_SERVICE.deleteSite(siteShortName);
                return null;
            }
        });
    }

    @Test
    public void deleteSiteRestoreSiteWithLocks() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.createUser("UserSiteOwner", "restore-with-lock");
                SiteServiceImplMoreTest.this.createUser("UserSiteManager", "restore-with-lock");
                SiteServiceImplMoreTest.this.createUser("UserSiteCollaborator", "restore-with-lock");
                return null;
            }
        });
        final String siteShortName = "testsite-" + System.currentTimeMillis();
        SiteServiceImpl cfr_ignored_0 = (SiteServiceImpl)SITE_SERVICE;
        log.debug((Object)("Creating test site called: " + siteShortName));
        final TemporarySites.TestSiteAndMemberInfo testSiteAndMemberInfo = this.perMethodTestSites.createTestSiteWithUserPerRole(siteShortName, "sitePreset", SiteVisibility.PUBLIC, "UserSiteOwner");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SITE_SERVICE.setMembership(siteShortName, "UserSiteCollaborator", "SiteCollaborator");
                return null;
            }
        });
        AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteCollaborator");
        String fileFolderPrefix = "TESTLOCK_";
        String componentId = "doclib";
        NodeRef siteContainer = SITE_SERVICE.createContainer(siteShortName, componentId, ContentModel.TYPE_FOLDER, null);
        final FileInfo fileInfo = FILE_FOLDER_SERVICE.create(siteContainer, String.valueOf(fileFolderPrefix) + "file.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer = FILE_FOLDER_SERVICE.getWriter(fileInfo.getNodeRef());
        writer.putContent("Just some old content that doesn't mean anything");
        Assert.assertEquals((Object)LockStatus.NO_LOCK, (Object)LOCK_SERVICE.getLockStatus(fileInfo.getNodeRef()));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LOCK_SERVICE.lock(fileInfo.getNodeRef(), LockType.READ_ONLY_LOCK);
                return null;
            }
        });
        Assert.assertEquals((Object)LockStatus.LOCK_OWNER, (Object)LOCK_SERVICE.getLockStatus(fileInfo.getNodeRef()));
        AUTHENTICATION_COMPONENT.setCurrentUser("UserSiteOwner");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, String>>(){

            public Map<String, String> execute() throws Throwable {
                log.debug((Object)"About to delete site.");
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"Site deleted.");
                return null;
            }
        });
        PolicyComponent policyComponent = (PolicyComponent)APP_CONTEXT_INIT.getApplicationContext().getBean("policyComponent");
        policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour((Object)this, "onCreateNodeSetTitle"));
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.assertThatArchivedNodeExists(testSiteAndMemberInfo.siteInfo.getNodeRef(), "Site node not found in archive.");
                log.debug((Object)"About to restore site node from archive");
                NodeRef archivedSiteNode = NODE_ARCHIVE_SERVICE.getArchivedNode(testSiteAndMemberInfo.siteInfo.getNodeRef());
                RestoreNodeReport report = NODE_ARCHIVE_SERVICE.restoreArchivedNode(archivedSiteNode);
                Assert.assertEquals((String)"Failed to restore site from archive", (Object)RestoreNodeReport.RestoreStatus.SUCCESS, (Object)report.getStatus());
                log.debug((Object)"Successfully restored site from arhive.");
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, String>>(){

            public Map<String, String> execute() throws Throwable {
                Assert.assertTrue((String)"The site noderef was not restored as expected", (boolean)NODE_SERVICE.exists(testSiteAndMemberInfo.siteInfo.getNodeRef()));
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"About to delete site completely.");
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"About to purge site from trashcan.");
                String storePath = "archive://SpacesStore";
                StoreRef storeRef = new StoreRef(storePath);
                NodeRef archivedNodeRef = new NodeRef(storeRef, testSiteAndMemberInfo.siteInfo.getNodeRef().getId());
                NODE_ARCHIVE_SERVICE.purgeArchivedNode(archivedNodeRef);
                return null;
            }
        });
    }

    public void onCreateNodeSetTitle(ChildAssociationRef childAssocRef) {
        NodeRef newRef = childAssocRef.getChildRef();
        NODE_SERVICE.setProperty(newRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Testing REPO-1688"));
    }

    private void assertThatArchivedNodeExists(NodeRef originalNodeRef, String failureMsg) {
        NodeRef archivedNodeRef = NODE_ARCHIVE_SERVICE.getArchivedNode(originalNodeRef);
        Assert.assertTrue((String)failureMsg, (boolean)NODE_SERVICE.exists(archivedNodeRef));
    }

    @Test
    public void testListMembershipOnSitesDifferentCase() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteServiceImplMoreTest.this.createUser("UserSiteOwner", "test");
                SiteServiceImplMoreTest.this.createUser("UserSiteCollaborator", "test");
                return null;
            }
        });
        String id = Long.toString(System.currentTimeMillis());
        final String siteShortName = "testsite-" + id;
        final String secondSiteShortName = "testsite2-" + System.currentTimeMillis();
        log.debug((Object)("Creating test sites called: " + siteShortName + " " + secondSiteShortName));
        this.perMethodTestSites.createSite("sitePreset", siteShortName, null, null, SiteVisibility.PUBLIC, "UserSiteOwner");
        this.perMethodTestSites.createSite("sitePreset", secondSiteShortName, null, null, SiteVisibility.PUBLIC, "UserSiteOwner");
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SITE_SERVICE.setMembership(siteShortName, "UserSiteCollaborator", "SiteCollaborator");
                SITE_SERVICE.setMembership(secondSiteShortName, "UserSiteCollaborator", "SiteCollaborator");
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, String>>(){

            public Map<String, String> execute() throws Throwable {
                log.debug((Object)"About to delete site.");
                SITE_SERVICE.deleteSite(siteShortName);
                log.debug((Object)"Site deleted.");
                return null;
            }
        });
        String siteShortName1 = "TesTsite-" + id;
        log.debug((Object)("Creating test site called: " + siteShortName1));
        this.perMethodTestSites.createSite("sitePreset", siteShortName1, null, null, SiteVisibility.PUBLIC, "UserSiteOwner");
        List members = SITE_SERVICE.listSiteMemberships("UserSiteCollaborator", 0);
        Assert.assertNotNull((Object)members);
        Assert.assertEquals((long)1L, (long)members.size());
        Assert.assertEquals((Object)"UserSiteCollaborator", (Object)((SiteMembership)members.get(0)).getPersonId());
        Assert.assertEquals((Object)"SiteCollaborator", (Object)((SiteMembership)members.get(0)).getRole());
        Assert.assertEquals((Object)secondSiteShortName, (Object)((SiteMembership)members.get(0)).getSiteInfo().getShortName());
        members = SITE_SERVICE.listSiteMemberships("UserSiteCollaborator", 50);
        Assert.assertNotNull((Object)members);
        Assert.assertEquals((long)1L, (long)members.size());
        Assert.assertEquals((Object)"UserSiteCollaborator", (Object)((SiteMembership)members.get(0)).getPersonId());
        Assert.assertEquals((Object)"SiteCollaborator", (Object)((SiteMembership)members.get(0)).getRole());
        Assert.assertEquals((Object)secondSiteShortName, (Object)((SiteMembership)members.get(0)).getSiteInfo().getShortName());
    }

    public static class TestData {
        public final Map<String, String> userNameToRoleMap;
        public final NodeRef testDocNodeRef;

        public TestData(Map<String, String> userNameToRoleMap, NodeRef testDocNodeRef) {
            this.userNameToRoleMap = userNameToRoleMap;
            this.testDocNodeRef = testDocNodeRef;
        }
    }
}

