/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.admin.SysAdminParamsImpl;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.security.person.UserNameMatcherImpl;
import org.alfresco.repo.site.SiteDoesNotExistException;
import org.alfresco.repo.site.SiteInfoImpl;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteMemberInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class, LuceneTests.class})
@Transactional
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:org/alfresco/repo/site/site-custom-context.xml"})
public class SiteServiceImplTest
extends BaseAlfrescoSpringTest {
    public static final StoreRef SITE_STORE = new StoreRef("workspace://SpacesStore");
    private static final String TEST_SITE_PRESET = "testSitePreset";
    private static final String TEST_SITE_PRESET_2 = "testSitePreset2";
    private static final String TEST_TITLE = "TitleTest This is my title";
    private static final String TEST_DESCRIPTION = "DescriptionTest This is my description";
    private static final String USER_ONE = "UserOne_SiteServiceImplTest";
    private static final String USER_TWO = "UserTwo_SiteServiceImplTest";
    private static final String USER_THREE = "UserThree_SiteServiceImplTest";
    private static final String USER_FOUR = "UserFour_SiteServiceImplTest";
    private static final String USER_SITE_ADMIN = "UserSiteAdmin_SiteServiceImplTest";
    private static final String GROUP_ONE = "GrpOne_SiteServiceImplTest";
    private static final String GROUP_TWO = "GrpTwo_SiteServiceImplTest";
    private static final String GROUP_THREE = "GrpThree_SiteServiceImplTest";
    private static final String GROUP_FOUR = "GrpFour_SiteServiceImplTest";
    private static final String GROUP_ONE_DISPLAY = "DisplayOfGrpOne-SiteServiceImplTest";
    private static final String GROUP_TWO_DISPLAY = "DisplayOfGrpTwo-SiteServiceImplTest";
    private static boolean IS_FIRST_SETUP = true;
    private CopyService copyService;
    private ScriptService scriptService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private AuthenticationComponent authenticationComponent;
    private TaggingService taggingService;
    private AuthorityService authorityService;
    private FileFolderService fileFolderService;
    private NodeArchiveService nodeArchiveService;
    private PermissionService permissionService;
    private SiteService siteService;
    private UserNameMatcherImpl userNameMatcherImpl;
    private SiteServiceImpl siteServiceImpl;
    private SysAdminParams sysAdminParams;
    private String groupOne;
    private String groupTwo;
    private String groupThree;
    private String groupFour;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                SiteServiceImplTest.this.nodeService = (NodeService)SiteServiceImplTest.this.applicationContext.getBean("nodeService");
                SiteServiceImplTest.this.contentService = (ContentService)SiteServiceImplTest.this.applicationContext.getBean("contentService");
                SiteServiceImplTest.this.authenticationService = (MutableAuthenticationService)SiteServiceImplTest.this.applicationContext.getBean("authenticationService");
                SiteServiceImplTest.this.actionService = (ActionService)SiteServiceImplTest.this.applicationContext.getBean("actionService");
                SiteServiceImplTest.this.transactionService = (TransactionService)SiteServiceImplTest.this.applicationContext.getBean("transactionComponent");
                SiteServiceImplTest.this.authenticationComponent = (AuthenticationComponent)SiteServiceImplTest.this.applicationContext.getBean("authenticationComponent");
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.storeRef = SiteServiceImplTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                SiteServiceImplTest.this.rootNodeRef = SiteServiceImplTest.this.nodeService.getRootNode(SiteServiceImplTest.this.storeRef);
                SiteServiceImplTest.this.copyService = (CopyService)SiteServiceImplTest.this.applicationContext.getBean("CopyService");
                SiteServiceImplTest.this.scriptService = (ScriptService)SiteServiceImplTest.this.applicationContext.getBean("ScriptService");
                SiteServiceImplTest.this.nodeService = (NodeService)SiteServiceImplTest.this.applicationContext.getBean("NodeService");
                SiteServiceImplTest.this.authenticationComponent = (AuthenticationComponent)SiteServiceImplTest.this.applicationContext.getBean("authenticationComponent");
                SiteServiceImplTest.this.taggingService = (TaggingService)SiteServiceImplTest.this.applicationContext.getBean("TaggingService");
                SiteServiceImplTest.this.authorityService = (AuthorityService)SiteServiceImplTest.this.applicationContext.getBean("AuthorityService");
                SiteServiceImplTest.this.fileFolderService = (FileFolderService)SiteServiceImplTest.this.applicationContext.getBean("FileFolderService");
                SiteServiceImplTest.this.nodeArchiveService = (NodeArchiveService)SiteServiceImplTest.this.applicationContext.getBean("nodeArchiveService");
                SiteServiceImplTest.this.permissionService = (PermissionService)SiteServiceImplTest.this.applicationContext.getBean("PermissionService");
                SiteServiceImplTest.this.dictionaryService = (DictionaryService)SiteServiceImplTest.this.applicationContext.getBean("DictionaryService");
                SiteServiceImplTest.this.namespaceService = (NamespaceService)SiteServiceImplTest.this.applicationContext.getBean("namespaceService");
                SiteServiceImplTest.this.siteService = (SiteService)SiteServiceImplTest.this.applicationContext.getBean("SiteService");
                SiteServiceImplTest.this.siteServiceImpl = (SiteServiceImpl)SiteServiceImplTest.this.applicationContext.getBean("siteService");
                SiteServiceImplTest.this.sysAdminParams = (SysAdminParams)SiteServiceImplTest.this.applicationContext.getBean("sysAdminParams");
                SiteServiceImplTest.this.userNameMatcherImpl = (UserNameMatcherImpl)SiteServiceImplTest.this.applicationContext.getBean("userNameMatcher");
                if (IS_FIRST_SETUP) {
                    SiteServiceImplTest.this.createUser(SiteServiceImplTest.USER_ONE, "UserOne");
                    SiteServiceImplTest.this.createUser(SiteServiceImplTest.USER_TWO, "UserTwo");
                    SiteServiceImplTest.this.createUser(SiteServiceImplTest.USER_THREE, "UsRthree");
                    SiteServiceImplTest.this.createUser(SiteServiceImplTest.USER_FOUR, "UsRFoUr");
                    SiteServiceImplTest.this.createUser(SiteServiceImplTest.USER_SITE_ADMIN, "UserAdmin");
                    SiteServiceImplTest.this.groupOne = SiteServiceImplTest.this.authorityService.createAuthority(AuthorityType.GROUP, SiteServiceImplTest.GROUP_ONE, SiteServiceImplTest.GROUP_ONE_DISPLAY, null);
                    SiteServiceImplTest.this.authorityService.addAuthority(SiteServiceImplTest.this.groupOne, SiteServiceImplTest.USER_TWO);
                    SiteServiceImplTest.this.groupTwo = SiteServiceImplTest.this.authorityService.createAuthority(AuthorityType.GROUP, SiteServiceImplTest.GROUP_TWO, SiteServiceImplTest.GROUP_TWO_DISPLAY, null);
                    SiteServiceImplTest.this.authorityService.addAuthority(SiteServiceImplTest.this.groupTwo, SiteServiceImplTest.USER_TWO);
                    SiteServiceImplTest.this.authorityService.addAuthority(SiteServiceImplTest.this.groupTwo, SiteServiceImplTest.USER_THREE);
                    SiteServiceImplTest.this.groupThree = SiteServiceImplTest.this.authorityService.createAuthority(AuthorityType.GROUP, SiteServiceImplTest.GROUP_THREE);
                    SiteServiceImplTest.this.authorityService.addAuthority(SiteServiceImplTest.this.groupThree, SiteServiceImplTest.USER_TWO);
                    SiteServiceImplTest.this.authorityService.addAuthority(SiteServiceImplTest.this.groupThree, SiteServiceImplTest.USER_THREE);
                    SiteServiceImplTest.this.groupFour = SiteServiceImplTest.this.authorityService.createAuthority(AuthorityType.GROUP, SiteServiceImplTest.GROUP_FOUR);
                    SiteServiceImplTest.this.authorityService.addAuthority(SiteServiceImplTest.this.groupThree, SiteServiceImplTest.this.groupFour);
                    SiteServiceImplTest.this.authorityService.addAuthority(SiteServiceImplTest.this.groupFour, SiteServiceImplTest.USER_FOUR);
                    SiteServiceImplTest.this.authorityService.addAuthority("GROUP_SITE_ADMINISTRATORS", SiteServiceImplTest.USER_SITE_ADMIN);
                    IS_FIRST_SETUP = false;
                } else {
                    SiteServiceImplTest.this.groupOne = SiteServiceImplTest.this.authorityService.getName(AuthorityType.GROUP, SiteServiceImplTest.GROUP_ONE);
                    SiteServiceImplTest.this.groupTwo = SiteServiceImplTest.this.authorityService.getName(AuthorityType.GROUP, SiteServiceImplTest.GROUP_TWO);
                    SiteServiceImplTest.this.groupThree = SiteServiceImplTest.this.authorityService.getName(AuthorityType.GROUP, SiteServiceImplTest.GROUP_THREE);
                    SiteServiceImplTest.this.groupFour = SiteServiceImplTest.this.authorityService.getName(AuthorityType.GROUP, SiteServiceImplTest.GROUP_FOUR);
                }
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_ONE);
                return null;
            }
        };
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work, false, true);
    }

    @Override
    @After
    public void after() throws Exception {
        super.after();
        this.siteServiceImpl.setSysAdminParams(this.sysAdminParams);
    }

    @Test
    public void testCreateSite() throws Exception {
        String mySiteTest = "mySiteTest" + UUID.randomUUID();
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, mySiteTest, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, mySiteTest, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        String name = "!\u00c2\u00a3$%^&*()_+=-[]{}";
        siteInfo = this.siteService.createSite(TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, true);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        siteInfo = this.siteService.getSite(name);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        name = "\u00c3\u00a9\u00c3\u00ad\u00c3\u00b3\u00c3\u00ba\u00c3\ufffd\u00c3\u2030\u00c3\ufffd\u00c3\u201c\u00c3\u0161";
        siteInfo = this.siteService.createSite(TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        siteInfo = this.siteService.getSite(name);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        SiteServiceImplTest.assertEquals((String)siteInfo.getShortName(), (String)this.siteService.getSiteShortName(siteNodeRef));
        Locale locale = Locale.getDefault();
        try {
            I18NUtil.setLocale((Locale)Locale.FRENCH);
            this.nodeService.setProperty(siteNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Localized-title"));
            this.nodeService.setProperty(siteNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Localized-description"));
            siteInfo = this.siteService.getSite(name);
            this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, name, "Localized-title", "Localized-description", SiteVisibility.PUBLIC);
        }
        finally {
            I18NUtil.setLocale((Locale)locale);
        }
        try {
            this.siteService.createSite(TEST_SITE_PRESET, mySiteTest, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            SiteServiceImplTest.fail((String)"Shouldn't allow duplicate site short names.");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
        try {
            this.siteService.createSite(TEST_SITE_PRESET, "InvalidSiteType", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC, ServiceRegistry.CMIS_SERVICE);
            SiteServiceImplTest.fail((String)"Shouldn't allow invalid site type.");
        }
        catch (SiteServiceException siteServiceException) {}
    }

    @Test
    public void testHasSite() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_ONE);
                String publicsite1 = "publicsite1" + UUID.randomUUID();
                String privatesite1 = "privatesite1" + UUID.randomUUID();
                SiteServiceImplTest.this.createSite(publicsite1, "doclib", SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.createSite(privatesite1, "doclib", SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                SiteServiceImplTest.assertTrue((SiteServiceImplTest.this.siteService.getSite(publicsite1) != null ? 1 : 0) != 0);
                SiteServiceImplTest.assertTrue((SiteServiceImplTest.this.siteService.getSite(privatesite1) == null ? 1 : 0) != 0);
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.hasSite(publicsite1));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.hasSite(privatesite1));
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(publicsite1);
                SiteServiceImplTest.this.siteService.deleteSite(privatesite1);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testETHREEOH_2133() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String siteShortName = "wibble" + UUID.randomUUID();
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, siteShortName, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_THREE);
                try {
                    SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, siteShortName, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                    SiteServiceImplTest.fail((String)"Shouldn't allow duplicate site short names.");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(siteShortName);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testConfigurableSitePublicGroup() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        ChildApplicationContextFactory sysAdminSubsystem = (ChildApplicationContextFactory)this.applicationContext.getBean("sysAdmin");
        try {
            String groupName = sysAdminSubsystem.getProperty("site.public.group");
            SiteServiceImplTest.assertEquals((String)"site.public.group was not the pristine value", (String)"GROUP_EVERYONE", (String)groupName);
            SiteInfo unconfiguredSite = this.siteService.createSite(TEST_SITE_PRESET, "unconfigured", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            SiteServiceImplTest.assertTrue((boolean)this.containsConsumerPermission("GROUP_EVERYONE", unconfiguredSite));
            String newGroupName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + System.currentTimeMillis();
            String prefixedNewGroupName = "GROUP_" + newGroupName;
            sysAdminSubsystem.stop();
            sysAdminSubsystem.setProperty("site.public.group", prefixedNewGroupName);
            sysAdminSubsystem.start();
            boolean expectedExceptionThrown = false;
            try {
                this.siteService.createSite(TEST_SITE_PRESET, "thisShouldFail", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            }
            catch (SiteServiceException siteServiceException) {
                expectedExceptionThrown = true;
            }
            if (!expectedExceptionThrown) {
                SiteServiceImplTest.fail((String)"Expected exception on createSite with non-existent group was not thrown.");
            }
            this.authorityService.createAuthority(AuthorityType.GROUP, newGroupName);
            SiteInfo configuredSite = this.siteService.createSite(TEST_SITE_PRESET, "configured", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
            SiteServiceImplTest.assertTrue((String)"The configured site should not have GROUP_EVERYONE as SiteContributor", (!this.containsConsumerPermission("GROUP_EVERYONE", configuredSite) ? 1 : 0) != 0);
            SiteServiceImplTest.assertTrue((String)"The configured site should have (newGroupName) as SiteContributor", (boolean)this.containsConsumerPermission(prefixedNewGroupName, configuredSite));
        }
        finally {
            sysAdminSubsystem.stop();
            sysAdminSubsystem.setProperty("site.public.group", "GROUP_EVERYONE");
            sysAdminSubsystem.start();
        }
    }

    private boolean containsConsumerPermission(String groupName, SiteInfo unconfiguredSite) {
        boolean result = false;
        Set perms = this.permissionService.getAllSetPermissions(unconfiguredSite.getNodeRef());
        for (AccessPermission p : perms) {
            if (!p.getAuthority().equals(groupName) || !p.getPermission().equals("SiteConsumer")) continue;
            result = true;
        }
        return result;
    }

    @Test
    public void testETHREEOH_15() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String mySiteTest = "mySiteTest" + UUID.randomUUID();
                SiteInfo siteInfo = SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, mySiteTest, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, mySiteTest, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
                SiteServiceImplTest.this.siteService.setMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_TWO, "SiteManager");
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                SiteServiceImplTest.this.siteService.setMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_THREE, "SiteContributor");
                SiteServiceImplTest.this.siteService.removeMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_THREE);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
                SiteServiceImplTest.this.siteService.removeMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_TWO);
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.setMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_THREE, "SiteContributor");
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_THREE);
                try {
                    SiteServiceImplTest.this.siteService.setMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_TWO, "SiteContributor");
                    SiteServiceImplTest.fail((String)"Shouldn't be able to do this cos you don't have permissions");
                }
                catch (Exception exception) {}
                try {
                    SiteServiceImplTest.this.siteService.removeMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_ONE);
                    SiteServiceImplTest.fail((String)"Shouldn't be able to do this cos you don't have permissions");
                }
                catch (Exception exception) {}
                SiteServiceImplTest.this.siteService.removeMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_THREE);
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(mySiteTest);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    private void checkSiteInfo(SiteInfo siteInfo, String expectedSitePreset, String expectedShortName, String expectedTitle, String expectedDescription, SiteVisibility expectedVisibility) {
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        SiteServiceImplTest.assertEquals((String)expectedSitePreset, (String)siteInfo.getSitePreset());
        SiteServiceImplTest.assertEquals((String)expectedShortName, (String)siteInfo.getShortName());
        SiteServiceImplTest.assertEquals((String)expectedTitle, (String)siteInfo.getTitle());
        SiteServiceImplTest.assertEquals((String)expectedDescription, (String)siteInfo.getDescription());
        SiteServiceImplTest.assertEquals((Object)expectedVisibility, (Object)siteInfo.getVisibility());
        SiteServiceImplTest.assertNotNull((Object)siteInfo.getNodeRef());
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(siteInfo.getNodeRef()));
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testListSites() throws Exception {
        String shortName;
        String testTitlePrefix = TEST_TITLE.substring(0, 9);
        List sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", (Object)sites);
        int preexistingSitesCount = sites.size();
        this.siteService.createSite(TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.siteService.createSite(TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET_2, "mySiteFour", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        this.siteService.createSite(TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 5), (int)sites.size());
        List sitesFromFind = this.siteService.findSites(null, null, 100);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 5), (int)sitesFromFind.size());
        sitesFromFind = this.siteService.findSites(null, 100);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 5), (int)sitesFromFind.size());
        List siteFromFind = this.siteService.findSites(null, null, 1);
        SiteServiceImplTest.assertEquals((String)"SiteService.findSites did not limit results", (int)(sites.isEmpty() ? 0 : 1), (int)siteFromFind.size());
        sites = this.siteService.listSites("mySiteO", null);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'mySiteO*'", (int)1, (int)sites.size());
        sitesFromFind = this.siteService.findSites("One", null, 100);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'One'", (int)1, (int)sitesFromFind.size());
        ArrayList<FilterPropString> filterProps = new ArrayList<FilterPropString>();
        filterProps.add(new FilterPropString(ContentModel.PROP_NAME, "mySiteO", FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE));
        PagingResults pageSite = this.siteService.listSites(filterProps, null, new PagingRequest(100));
        SiteServiceImplTest.assertNotNull((Object)pageSite);
        SiteServiceImplTest.assertNotNull((Object)pageSite.getQueryExecutionId());
        SiteServiceImplTest.assertFalse((boolean)pageSite.hasMoreItems());
        sites = this.siteService.listSites(testTitlePrefix, null);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)("Matched wrong number of sites starting with '" + testTitlePrefix + "'"), (int)5, (int)sites.size());
        sitesFromFind = this.siteService.findSites("title", null, 100);
        SiteServiceImplTest.assertEquals((String)("Matched wrong number of sites containing 'title'\n" + sitesFromFind), (int)5, (int)sitesFromFind.size());
        sites = this.siteService.listSites("description", null);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'description'", (int)5, (int)sites.size());
        sitesFromFind = this.siteService.findSites("description", null, 100);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites named 'description'", (int)5, (int)sitesFromFind.size());
        sites = this.siteService.findSites(null, TEST_SITE_PRESET, 100);
        SiteServiceImplTest.assertNotNull((Object)sites);
        sites = this.siteService.listSites(null, TEST_SITE_PRESET);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites with PRESET", (int)2, (int)sites.size());
        sites = this.siteService.listSites(null, TEST_SITE_PRESET_2);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites with PRESET_2", (int)3, (int)sites.size());
        for (SiteInfo site : sites) {
            String shortName2 = site.getShortName();
            if (shortName2.equals("mySiteOne")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName2.equals("mySiteTwo")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                continue;
            }
            if (shortName2.equals("mySiteThree")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName2.equals("mySiteFour")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFour", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                continue;
            }
            if (shortName2.equals("mySiteFive")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
                continue;
            }
            SiteServiceImplTest.fail((String)("The shortname " + shortName2 + " is not recognised"));
        }
        HashSet<String> sitesSet = new HashSet<String>(2);
        sitesSet.add("mySiteOne");
        sitesSet.add("mySiteTwo");
        sites = this.siteServiceImpl.listSites(sitesSet);
        SiteServiceImplTest.assertEquals((int)2, (int)sites.size());
        sites = this.siteService.listSites(USER_TWO);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((int)0, (int)sites.size());
        this.siteService.setMembership("mySiteOne", USER_TWO, "SiteConsumer");
        this.siteService.setMembership("mySiteTwo", USER_TWO, "SiteConsumer");
        sites = this.siteService.listSites(USER_TWO);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((int)2, (int)sites.size());
        sites = this.siteService.listSites(USER_ONE);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((int)5, (int)sites.size());
        sites = this.siteService.listSites("mySiteOne", null, 10);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((int)1, (int)sites.size());
        sitesFromFind = this.siteService.findSites("One", null, 100);
        SiteServiceImplTest.assertEquals((int)1, (int)sitesFromFind.size());
        sitesFromFind = this.siteService.findSites("ite", null, 100);
        SiteServiceImplTest.assertEquals((int)5, (int)sitesFromFind.size());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        sitesFromFind = this.siteService.findSites("ite", null, 100);
        SiteServiceImplTest.assertEquals((int)4, (int)sitesFromFind.size());
        for (SiteInfo site : sites) {
            shortName = site.getShortName();
            if (shortName.equals("mySiteOne")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteTwo")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                continue;
            }
            if (shortName.equals("mySiteThree")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteFour")) {
                SiteServiceImplTest.fail((String)"Can see private site mySiteFour");
                continue;
            }
            if (shortName.equals("mySiteFive")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
                continue;
            }
            SiteServiceImplTest.fail((String)("The shortname " + shortName + " is not recognised"));
        }
        this.authenticationComponent.setCurrentUser(USER_THREE);
        sitesFromFind = this.siteService.findSites("ite", null, 100);
        SiteServiceImplTest.assertEquals((int)3, (int)sitesFromFind.size());
        for (SiteInfo site : sites) {
            shortName = site.getShortName();
            if (shortName.equals("mySiteOne")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteTwo")) {
                SiteServiceImplTest.fail((String)"Can see private site mySiteTwo");
                continue;
            }
            if (shortName.equals("mySiteThree")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteThree", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                continue;
            }
            if (shortName.equals("mySiteFour")) {
                SiteServiceImplTest.fail((String)"Can see private site mySiteFour");
                continue;
            }
            if (shortName.equals("mySiteFive")) {
                this.checkSiteInfo(site, TEST_SITE_PRESET_2, "mySiteFive", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
                continue;
            }
            SiteServiceImplTest.fail((String)("The shortname " + shortName + " is not recognised"));
        }
    }

    @Test
    public void testMNT_13710() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String siteName = "test" + System.currentTimeMillis();
                ArrayList<String> roleList = new ArrayList<String>();
                roleList.add("test_customrole");
                roleList.add("testCustomrole");
                try {
                    SiteServiceImplTest.this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
                    SiteInfo siteInfo = SiteServiceImplTest.this.siteService.createSite(siteName, siteName, siteName, siteName, SiteVisibility.PUBLIC);
                    for (String role : roleList) {
                        SiteServiceImplTest.this.siteService.setMembership(siteInfo.getShortName(), SiteServiceImplTest.USER_ONE, role);
                        List list = SiteServiceImplTest.this.siteServiceImpl.getMembersRoles(siteName, SiteServiceImplTest.USER_ONE);
                        SiteServiceImplTest.assertTrue((boolean)list.contains(role));
                    }
                }
                finally {
                    if (SiteServiceImplTest.this.siteService.getSite(siteName) != null) {
                        SiteServiceImplTest.this.siteService.deleteSite(siteName);
                    }
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testListSitesCaseSensitivity() throws Exception {
        TEST_TITLE.substring(0, 9);
        this.siteService.createSite("testCaseSensitive", "mySiteCaseSensitive", "Case Sensitive Title", "Test of case sensitivity", SiteVisibility.PUBLIC);
        boolean existingValue = this.userNameMatcherImpl.getUserNamesAreCaseSensitive();
        try {
            this.userNameMatcherImpl.setUserNamesAreCaseSensitive(true);
            SiteServiceImplTest.assertTrue((String)"Case Sensitive - non matching case", (this.siteService.listSites(USER_ONE.toLowerCase()).size() == 0 ? 1 : 0) != 0);
            SiteServiceImplTest.assertTrue((String)"Case Sensitive - matching case", (this.siteService.listSites(USER_ONE).size() > 0 ? 1 : 0) != 0);
            this.userNameMatcherImpl.setUserNamesAreCaseSensitive(false);
            SiteServiceImplTest.assertTrue((String)"Not Case Sensitive - non matching case", (this.siteService.listSites(USER_ONE.toLowerCase()).size() > 0 ? 1 : 0) != 0);
            SiteServiceImplTest.assertTrue((String)"Not Case Sensitive - matching case", (this.siteService.listSites(USER_ONE).size() > 0 ? 1 : 0) != 0);
        }
        finally {
            this.userNameMatcherImpl.setUserNamesAreCaseSensitive(existingValue);
        }
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testfindSitesWithWildcardTitles() throws Exception {
        List preexistingSites = this.siteService.findSites(null, null, 0);
        int preexistingSitesCount = preexistingSites.size();
        this.siteService.createSite(TEST_SITE_PRESET, "siteAlpha", "asterix", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteBeta", "asterix*obelix", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        List sites = this.siteService.findSites("asterix", null, 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites with title equal to 'asterix'", (int)2, (int)sites.size());
        sites = this.siteService.findSites("*", null, 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites using '*'", (int)(preexistingSitesCount + 2), (int)sites.size());
        sites = this.siteService.findSites("as?erix", null, 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites using '?'", (int)2, (int)sites.size());
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testfindSitesForLiveSearchWithWildcardTitles() throws Exception {
        List preexistingSites = this.siteService.findSites(null, 0);
        int preexistingSitesCount = preexistingSites.size();
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveA", "getafix", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveB", "getafix1vitalstatistix", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveC", "Armorican Gaul France", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveD", "n3w s1t3 creat3ed 88", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveE", "n3w s1t3 creat3ed 99", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveF", "super exciting product", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveG", "super exciting launch", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveH", "amazing sales 54", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveI", "wonderfulsupport32", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveJ", "great89service", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, "siteLiveK", "my top draw", TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        List sites = this.siteService.findSites("getafix", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites with title equal to 'getafix'", (int)2, (int)sites.size());
        sites = this.siteService.findSites("*", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites using '*'", (int)(preexistingSitesCount + 11), (int)sites.size());
        sites = this.siteService.findSites("ge?afix", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites using '?'", (int)2, (int)sites.size());
        sites = this.siteService.findSites("Armorican", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("Gaul", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("France", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("Armorican Gaul", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("Armori", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("Fran", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("n3w s1t3 88", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("n3w s1t3 99", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)1, (int)sites.size());
        sites = this.siteService.findSites("n3w s1t3", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)2, (int)sites.size());
        sites = this.siteService.findSites("s1t3", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for tokenized search", (int)2, (int)sites.size());
        sites = this.siteService.findSites("super", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for super", (int)2, (int)sites.size());
        sites = this.siteService.findSites("exciting", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for exciting", (int)2, (int)sites.size());
        sites = this.siteService.findSites("product", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for product", (int)1, (int)sites.size());
        sites = this.siteService.findSites("super product", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for super product", (int)1, (int)sites.size());
        sites = this.siteService.findSites("super launch", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for super launch", (int)1, (int)sites.size());
        sites = this.siteService.findSites("exciting launch", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for super launch", (int)1, (int)sites.size());
        sites = this.siteService.findSites("super exciting", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for super exciting", (int)2, (int)sites.size());
        sites = this.siteService.findSites("amazing sales 54", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for amazing sales 54", (int)1, (int)sites.size());
        sites = this.siteService.findSites("wonderfulsupport32", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for wonderfulsupport32", (int)1, (int)sites.size());
        sites = this.siteService.findSites("great89service", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for great89service", (int)1, (int)sites.size());
        sites = this.siteService.findSites("top draw", 0);
        SiteServiceImplTest.assertNotNull((Object)sites);
        SiteServiceImplTest.assertEquals((String)"Matched wrong number of sites for top draw", (int)1, (int)sites.size());
    }

    @Test
    public void testGetSite() {
        SiteInfo siteInfo = this.siteService.getSite("testGetSite");
        SiteServiceImplTest.assertNull((Object)siteInfo);
        this.siteService.createSite(TEST_SITE_PRESET, "testGetSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        siteInfo = this.siteService.getSite("testGetSite");
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testGetSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        NodeRef container = this.siteService.createContainer(siteInfo.getShortName(), "folder.component", ContentModel.TYPE_FOLDER, null);
        NodeRef content = this.nodeService.createNode(container, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT).getChildRef();
        siteInfo = this.siteService.getSite(content);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, "testGetSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        NodeRef siteContainer = SiteServiceImpl.getSiteContainer((String)siteInfo.getShortName(), (String)"folder.component", (boolean)false, (SiteService)this.siteService, (TransactionService)this.transactionService, (TaggingService)this.taggingService);
        SiteServiceImplTest.assertEquals((String)container.getId(), (String)siteContainer.getId());
        PagingResults containers = this.siteService.listContainers(siteInfo.getShortName(), new PagingRequest(1000));
        SiteServiceImplTest.assertNotNull((Object)containers);
        try {
            SiteServiceImpl.getSiteContainer((String)"NON_SENSE", (String)"folder.component", (boolean)true, (SiteService)this.siteService, (TransactionService)this.transactionService, (TaggingService)this.taggingService);
            SiteServiceImplTest.fail((String)"Shouldn't get here");
        }
        catch (AlfrescoRuntimeException exception) {
            SiteServiceImplTest.assertTrue((boolean)exception.getMessage().contains("Unable to create the"));
        }
    }

    @Test
    public void testUpdateSite() {
        SiteInfoImpl siteInfo = new SiteInfoImpl(TEST_SITE_PRESET, "testUpdateSite", "changedTitle", "changedDescription", SiteVisibility.PRIVATE, null);
        try {
            this.siteService.updateSite((SiteInfo)siteInfo);
            SiteServiceImplTest.fail((String)"Shouldn't be able to update a site that does not exist");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
        this.siteService.createSite(TEST_SITE_PRESET, "testUpdateSite", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.updateSite((SiteInfo)siteInfo);
        siteInfo = this.siteService.getSite("testUpdateSite");
        this.checkSiteInfo((SiteInfo)siteInfo, TEST_SITE_PRESET, "testUpdateSite", "changedTitle", "changedDescription", SiteVisibility.PRIVATE);
        siteInfo.setVisibility(SiteVisibility.PUBLIC);
        this.siteService.updateSite((SiteInfo)siteInfo);
        this.checkSiteInfo((SiteInfo)siteInfo, TEST_SITE_PRESET, "testUpdateSite", "changedTitle", "changedDescription", SiteVisibility.PUBLIC);
    }

    @Test
    public void testDeleteSite_DoesNotExist() {
        try {
            this.siteService.deleteSite("testDeleteSite");
            SiteServiceImplTest.fail((String)"Shouldn't be able to delete a site that does not exist");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    @Test
    public void testDeleteSite_ViaNodeService() {
        String siteShortName = "testUpdateSite";
        this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteInfo siteInfo = this.siteService.getSite(siteShortName);
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        try {
            this.nodeService.deleteNode(siteInfo.getNodeRef());
            SiteServiceImplTest.fail((String)"Shouldn't be able to delete a site via the nodeService");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    @Test
    public void testMoveSite_ViaNodeService() {
        String siteShortName1 = "testMoveSite" + GUID.generate();
        String siteShortName2 = "testMoveSite" + GUID.generate();
        this.siteService.createSite(TEST_SITE_PRESET, siteShortName1, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.createSite(TEST_SITE_PRESET, siteShortName2, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteInfo siteInfo1 = this.siteService.getSite(siteShortName1);
        SiteServiceImplTest.assertNotNull((Object)siteInfo1);
        SiteInfo siteInfo2 = this.siteService.getSite(siteShortName2);
        SiteServiceImplTest.assertNotNull((Object)siteInfo2);
        try {
            this.nodeService.moveNode(siteInfo1.getNodeRef(), siteInfo2.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)GUID.generate()));
            SiteServiceImplTest.fail((String)"Shouldn't be able to move a site via the nodeService");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
    }

    @Test
    public void testMoveFolderStructureWithNonInheritedPermission() {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        String test1SiteShortName = "test1" + GUID.generate();
        String test2SiteShortName = "test2" + GUID.generate();
        this.createSite(test1SiteShortName, "documentLibrary", SiteVisibility.PUBLIC);
        this.createSite(test2SiteShortName, "documentLibrary", SiteVisibility.PUBLIC);
        SiteInfo test1SiteInfo = this.siteService.getSite(test1SiteShortName);
        SiteServiceImplTest.assertNotNull((Object)test1SiteInfo);
        SiteInfo test2SiteInfo = this.siteService.getSite(test2SiteShortName);
        SiteServiceImplTest.assertNotNull((Object)test2SiteInfo);
        this.siteService.setMembership(test1SiteShortName, USER_ONE, "SiteManager");
        this.siteService.setMembership(test1SiteShortName, USER_TWO, "SiteManager");
        this.siteService.setMembership(test2SiteShortName, USER_ONE, "SiteManager");
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        NodeRef documentLibraryTest1Site = this.siteService.getContainer(test1SiteShortName, "documentLibrary");
        SiteServiceImplTest.assertNotNull((Object)documentLibraryTest1Site);
        NodeRef fol1 = this.fileFolderService.create(documentLibraryTest1Site, "fol1-" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef fol2 = this.fileFolderService.create(fol1, "fol2-" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        this.fileFolderService.create(fol2, "fol3-" + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
        this.permissionService.setInheritParentPermissions(fol2, false);
        String test1SiteGroupPrefix = this.siteServiceImpl.getSiteGroup(test1SiteShortName, true);
        String test1SiteManagerAuthority = String.valueOf(test1SiteGroupPrefix) + "_" + "SiteManager";
        this.permissionService.setPermission(fol2, test1SiteManagerAuthority, "SiteManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        List childAssocs = this.nodeService.getChildAssocs(documentLibraryTest1Site);
        SiteServiceImplTest.assertEquals((String)"Size should be 1", (int)1, (int)childAssocs.size());
        SiteServiceImplTest.assertTrue((String)"Folder name should start with fol1", (boolean)this.getFirstName(childAssocs).startsWith("fol1"));
        childAssocs = this.nodeService.getChildAssocs(((ChildAssociationRef)childAssocs.get(0)).getChildRef());
        SiteServiceImplTest.assertEquals((String)"Size should be 1", (int)1, (int)childAssocs.size());
        SiteServiceImplTest.assertTrue((String)"Folder name should start with fol2", (boolean)this.getFirstName(childAssocs).startsWith("fol2"));
        childAssocs = this.nodeService.getChildAssocs(((ChildAssociationRef)childAssocs.get(0)).getChildRef());
        SiteServiceImplTest.assertEquals((String)"Size should be 1", (int)1, (int)childAssocs.size());
        SiteServiceImplTest.assertTrue((String)"Folder name should start with fol3", (boolean)this.getFirstName(childAssocs).startsWith("fol3"));
        NodeRef documentLibraryTest2Site = this.siteService.getContainer(test2SiteShortName, "documentLibrary");
        SiteServiceImplTest.assertNotNull((Object)documentLibraryTest2Site);
        childAssocs = this.nodeService.getChildAssocs(documentLibraryTest2Site);
        SiteServiceImplTest.assertTrue((String)"Folder should be empty.", (boolean)childAssocs.isEmpty());
        this.nodeService.moveNode(fol1, documentLibraryTest2Site, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)GUID.generate()));
        this.siteService.cleanSitePermissions(fol1, test2SiteInfo);
        childAssocs = this.nodeService.getChildAssocs(documentLibraryTest1Site);
        SiteServiceImplTest.assertTrue((String)"test1Site document library should be empty.", (boolean)childAssocs.isEmpty());
        SiteServiceImplTest.assertFalse((String)"After the move the folder should keep the inherit permission value(false).", (boolean)this.permissionService.getInheritParentPermissions(fol2));
        childAssocs = this.nodeService.getChildAssocs(documentLibraryTest2Site);
        SiteServiceImplTest.assertEquals((String)"Size should be 1", (int)1, (int)childAssocs.size());
        SiteServiceImplTest.assertTrue((String)"Folder name should start with fol1", (boolean)this.getFirstName(childAssocs).startsWith("fol1"));
        childAssocs = this.nodeService.getChildAssocs(((ChildAssociationRef)childAssocs.get(0)).getChildRef());
        SiteServiceImplTest.assertEquals((String)"Size should be 1", (int)1, (int)childAssocs.size());
        SiteServiceImplTest.assertTrue((String)"Folder name should start with fol2", (boolean)this.getFirstName(childAssocs).startsWith("fol2"));
        childAssocs = this.nodeService.getChildAssocs(((ChildAssociationRef)childAssocs.get(0)).getChildRef());
        SiteServiceImplTest.assertEquals((String)"Size should be 1", (int)1, (int)childAssocs.size());
        SiteServiceImplTest.assertTrue((String)"Folder name should start with fol3", (boolean)this.getFirstName(childAssocs).startsWith("fol3"));
    }

    private String getFirstName(List<ChildAssociationRef> childAssocs) {
        return ((Serializable)this.nodeService.getProperties(childAssocs.get(0).getChildRef()).get(ContentModel.PROP_NAME)).toString();
    }

    @Test
    public void testDeleteSite() {
        SiteService smallSiteService = (SiteService)this.applicationContext.getBean("siteService");
        final String testGroupName = "siteServiceImplTestGroup_" + GUID.generate();
        String testGroup = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return SiteServiceImplTest.this.authorityService.createAuthority(AuthorityType.GROUP, testGroupName);
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        String siteShortName = "testUpdateSite";
        this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteInfo siteInfo = this.siteService.getSite(siteShortName);
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        this.siteService.setMembership(siteShortName, testGroup, "SiteContributor");
        this.siteService.deleteSite(siteShortName);
        SiteServiceImplTest.assertNull((Object)this.siteService.getSite(siteShortName));
        NodeRef archivedNodeRef = this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef());
        SiteServiceImplTest.assertTrue((String)"Deleted sites can be recovered from the Trash.", (boolean)this.nodeService.exists(archivedNodeRef));
        SiteServiceImplTest.assertTrue((boolean)this.authorityService.authorityExists(((SiteServiceImpl)smallSiteService).getSiteGroup(siteShortName, true)));
        SiteServiceImplTest.assertTrue((boolean)this.authorityService.authorityExists(((SiteServiceImpl)smallSiteService).getSiteGroup(siteShortName)));
        Set permissions = this.permissionService.getSettablePermissions(SiteModel.TYPE_SITE);
        for (String permission : permissions) {
            String siteRoleGroup = ((SiteServiceImpl)smallSiteService).getSiteRoleGroup(siteShortName, permission, true);
            SiteServiceImplTest.assertTrue((boolean)this.authorityService.authorityExists(siteRoleGroup));
        }
        SiteServiceImplTest.assertTrue((boolean)this.authorityService.authorityExists(testGroup));
    }

    @Test
    public void testIsPublic() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                List sites = SiteServiceImplTest.this.siteService.listSites(null, null);
                SiteServiceImplTest.assertNotNull((String)"initial sites list was null.", (Object)sites);
                int preexistingSiteCount = sites.size();
                String isPublicTrue = "isPublicTrue" + UUID.randomUUID();
                String isPublicFalse = "isPublicFalse" + UUID.randomUUID();
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, isPublicTrue, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, isPublicFalse, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                sites = SiteServiceImplTest.this.siteService.listSites(null, null);
                SiteServiceImplTest.assertNotNull((Object)sites);
                SiteServiceImplTest.assertEquals((int)(preexistingSiteCount + 2), (int)sites.size());
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                sites = SiteServiceImplTest.this.siteService.listSites(null, null);
                SiteServiceImplTest.assertNotNull((Object)sites);
                SiteServiceImplTest.assertEquals((int)(preexistingSiteCount + 1), (int)sites.size());
                SiteInfo userTwoSite = SiteServiceImplTest.this.siteService.getSite(isPublicTrue);
                SiteServiceImplTest.this.checkSiteInfo(userTwoSite, SiteServiceImplTest.TEST_SITE_PRESET, isPublicTrue, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_ONE);
                SiteServiceImplTest.this.siteService.setMembership(isPublicFalse, SiteServiceImplTest.USER_TWO, "SiteConsumer");
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                sites = SiteServiceImplTest.this.siteService.listSites(null, null);
                SiteServiceImplTest.assertNotNull((Object)sites);
                SiteServiceImplTest.assertEquals((int)(preexistingSiteCount + 2), (int)sites.size());
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(isPublicTrue);
                SiteServiceImplTest.this.siteService.deleteSite(isPublicFalse);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testMembership() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String siteShortName = "testMembership" + UUID.randomUUID();
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, siteShortName, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                Map members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_TWO, "SiteConsumer");
                SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_THREE, "SiteCollaborator");
                members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)3, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_TWO)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, "SiteManager", 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, SiteServiceImplTest.USER_TWO, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_TWO)));
                SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_TWO, "SiteCollaborator");
                members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)3, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((String)members.get(SiteServiceImplTest.USER_TWO)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, null, false, new SiteService.SiteMembersCallback(){
                    List<String> USERS = Arrays.asList("UserOne_SiteServiceImplTest", "UserTwo_SiteServiceImplTest", "UserThree_SiteServiceImplTest");
                    int userCount = 0;

                    public void siteMember(String authority, String permission) {
                        if (this.USERS.contains(authority)) {
                            ++this.userCount;
                        }
                    }

                    public boolean isDone() {
                        return this.userCount == this.USERS.size();
                    }
                });
                SiteServiceImplTest.this.siteService.removeMembership(siteShortName, SiteServiceImplTest.USER_TWO);
                members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)2, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, null, 1);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                members = SiteServiceImplTest.this.siteService.listMembers(siteShortName, null, null, 2);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)2, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                try {
                    SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_TWO, "SiteCollaborator");
                    SiteServiceImplTest.fail((String)"A non member shouldnt be able to set memberships");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                try {
                    SiteServiceImplTest.this.siteService.removeMembership(siteShortName, SiteServiceImplTest.USER_THREE);
                    SiteServiceImplTest.fail((String)"A non member shouldnt be able to remove a membership");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_THREE);
                try {
                    SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_TWO, "SiteCollaborator");
                    SiteServiceImplTest.fail((String)"A member who isn't a manager shouldnt be able to set memberships");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                SiteServiceImplTest.this.siteService.removeMembership(siteShortName, SiteServiceImplTest.USER_THREE);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_ONE);
                SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_TWO, "SiteManager");
                SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_TWO, "SiteCollaborator");
                try {
                    SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_ONE, "SiteCollaborator");
                    SiteServiceImplTest.fail((String)"You can not change the role of the last site memnager");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                SiteServiceImplTest.this.siteService.setMembership(siteShortName, SiteServiceImplTest.USER_TWO, "SiteManager");
                SiteServiceImplTest.this.siteService.removeMembership(siteShortName, SiteServiceImplTest.USER_ONE);
                try {
                    SiteServiceImplTest.this.siteService.removeMembership(siteShortName, SiteServiceImplTest.USER_TWO);
                    SiteServiceImplTest.fail((String)"You can not remove the last site memnager from a site");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(siteShortName);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testDefaults() {
        SiteServiceImplTest.assertFalse((boolean)this.siteService.isSiteAdmin(null));
        SiteServiceImplTest.assertTrue((boolean)this.siteService.hasCreateSitePermissions());
        Comparator comparator = this.siteServiceImpl.getRoleComparator();
        SiteServiceImplTest.assertNotNull((Object)comparator);
    }

    @Test
    public void testListSiteMemberships() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String siteName1 = "testMembership1" + UUID.randomUUID();
                String siteName2 = "testMembership2" + UUID.randomUUID();
                String siteName3 = "testMembership3" + UUID.randomUUID();
                String publicSite = "publicSite" + UUID.randomUUID();
                String moderatedSite = "moderatedSite" + UUID.randomUUID();
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, siteName1, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                List members = SiteServiceImplTest.this.siteService.listSiteMemberships(SiteServiceImplTest.USER_ONE, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertEquals((String)SiteServiceImplTest.USER_ONE, (String)((SiteMembership)members.get(0)).getPersonId());
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((SiteMembership)members.get(0)).getRole());
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_FOUR);
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, publicSite, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.siteService.setMembership(publicSite, SiteServiceImplTest.USER_ONE, "SiteConsumer");
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, moderatedSite, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.MODERATED);
                SiteServiceImplTest.this.siteService.setMembership(moderatedSite, SiteServiceImplTest.USER_ONE, "SiteContributor");
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_ONE);
                PagingResults siteM = SiteServiceImplTest.this.siteService.listSitesPaged(SiteServiceImplTest.USER_ONE, null, new PagingRequest(1000));
                SiteServiceImplTest.assertNotNull((Object)siteM);
                SiteServiceImplTest.assertFalse((boolean)siteM.hasMoreItems());
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, siteName2, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.siteService.setMembership(siteName2, SiteServiceImplTest.USER_ONE, "SiteConsumer");
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_THREE);
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, siteName3, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.siteService.setMembership(siteName3, SiteServiceImplTest.USER_ONE, "SiteCollaborator");
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_ONE);
                members = SiteServiceImplTest.this.siteService.listSiteMemberships(SiteServiceImplTest.USER_ONE, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)5, (int)members.size());
                SiteServiceImplTest.assertEquals((String)SiteServiceImplTest.USER_ONE, (String)((SiteMembership)members.get(0)).getPersonId());
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((SiteMembership)members.get(0)).getRole());
                SiteServiceImplTest.assertEquals((String)siteName1, (String)((SiteMembership)members.get(0)).getSiteInfo().getShortName());
                SiteServiceImplTest.assertEquals((String)SiteServiceImplTest.USER_ONE, (String)((SiteMembership)members.get(1)).getPersonId());
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((SiteMembership)members.get(1)).getRole());
                SiteServiceImplTest.assertEquals((String)publicSite, (String)((SiteMembership)members.get(1)).getSiteInfo().getShortName());
                SiteServiceImplTest.assertEquals((String)SiteServiceImplTest.USER_ONE, (String)((SiteMembership)members.get(2)).getPersonId());
                SiteServiceImplTest.assertEquals((String)"SiteContributor", (String)((SiteMembership)members.get(2)).getRole());
                SiteServiceImplTest.assertEquals((String)moderatedSite, (String)((SiteMembership)members.get(2)).getSiteInfo().getShortName());
                SiteServiceImplTest.assertEquals((String)SiteServiceImplTest.USER_ONE, (String)((SiteMembership)members.get(3)).getPersonId());
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((SiteMembership)members.get(3)).getRole());
                SiteServiceImplTest.assertEquals((String)siteName2, (String)((SiteMembership)members.get(3)).getSiteInfo().getShortName());
                SiteServiceImplTest.assertEquals((String)SiteServiceImplTest.USER_ONE, (String)((SiteMembership)members.get(4)).getPersonId());
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((SiteMembership)members.get(4)).getRole());
                SiteServiceImplTest.assertEquals((String)siteName3, (String)((SiteMembership)members.get(4)).getSiteInfo().getShortName());
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                members = SiteServiceImplTest.this.siteService.listSiteMemberships(SiteServiceImplTest.USER_ONE, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)members.size(), (int)2);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_SITE_ADMIN);
                members = SiteServiceImplTest.this.siteService.listSiteMemberships(SiteServiceImplTest.USER_ONE, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)members.size(), (int)5);
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(siteName1);
                SiteServiceImplTest.this.siteService.deleteSite(siteName2);
                SiteServiceImplTest.this.siteService.deleteSite(siteName3);
                SiteServiceImplTest.this.siteService.deleteSite(publicSite);
                SiteServiceImplTest.this.siteService.deleteSite(moderatedSite);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testJoinLeave() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String testMembershipPublic = "testMembershipPublic" + UUID.randomUUID();
                String testMembershipPrivate = "testMembershipPrivate" + UUID.randomUUID();
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, testMembershipPublic, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, testMembershipPrivate, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                try {
                    SiteServiceImplTest.this.siteService.setMembership(testMembershipPublic, SiteServiceImplTest.USER_TWO, "SiteCollaborator");
                    SiteServiceImplTest.fail((String)"This should have failed because you don't have permissions");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                SiteServiceImplTest.this.siteService.setMembership(testMembershipPublic, SiteServiceImplTest.USER_TWO, "SiteConsumer");
                try {
                    SiteServiceImplTest.this.siteService.setMembership(testMembershipPrivate, SiteServiceImplTest.USER_TWO, "SiteConsumer");
                    SiteServiceImplTest.fail((String)"This should have failed because you can't do this to a private site unless you are site manager");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                try {
                    SiteServiceImplTest.this.siteService.setMembership(testMembershipPublic, SiteServiceImplTest.USER_THREE, "SiteConsumer");
                    SiteServiceImplTest.fail((String)"This should have failed because you can't add another user as a consumer of a public site");
                }
                catch (AlfrescoRuntimeException alfrescoRuntimeException) {}
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_ONE);
                SiteServiceImplTest.this.siteService.setMembership(testMembershipPublic, SiteServiceImplTest.USER_THREE, "SiteCollaborator");
                SiteServiceImplTest.this.siteService.setMembership(testMembershipPrivate, SiteServiceImplTest.USER_TWO, "SiteConsumer");
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                try {
                    SiteServiceImplTest.this.siteService.removeMembership(testMembershipPublic, SiteServiceImplTest.USER_THREE);
                    SiteServiceImplTest.fail((String)"Cannot remove membership");
                }
                catch (Exception exception) {}
                SiteServiceImplTest.this.siteService.removeMembership(testMembershipPublic, SiteServiceImplTest.USER_TWO);
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(testMembershipPublic);
                SiteServiceImplTest.this.siteService.deleteSite(testMembershipPrivate);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testContainer() {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, "testContainer", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        boolean hasContainer = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertFalse((boolean)hasContainer);
        NodeRef container1 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertNull((Object)container1);
        container1 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component", null, null);
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container1));
        NodeRef container2 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertNotNull((Object)container2);
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container2));
        SiteServiceImplTest.assertTrue((boolean)container1.equals((Object)container2));
        boolean hasContainer2 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component");
        SiteServiceImplTest.assertTrue((boolean)hasContainer2);
        boolean hasContainer3 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component2");
        SiteServiceImplTest.assertFalse((boolean)hasContainer3);
        NodeRef container3 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component2");
        SiteServiceImplTest.assertNull((Object)container3);
        container3 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component2", null, null);
        SiteServiceImplTest.assertNotNull((Object)container3);
        SiteServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container3));
        SiteServiceImplTest.assertFalse((boolean)container1.equals((Object)container3));
        boolean hasContainer4 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component2");
        SiteServiceImplTest.assertTrue((boolean)hasContainer4);
        boolean hasContainer5 = this.siteService.hasContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertFalse((boolean)hasContainer5);
        NodeRef container5 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertNull((Object)container5);
        container5 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component3", ContentModel.TYPE_FOLDER, null);
        SiteServiceImplTest.assertNotNull((Object)container5);
        NodeRef container6 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertNotNull((Object)container6);
        container6 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component3", null, null);
        SiteServiceImplTest.assertNotNull((Object)container6);
        SiteServiceImplTest.assertTrue((boolean)container5.equals((Object)container6));
        SiteServiceImplTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(container6));
        NodeRef container7 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component3");
        SiteServiceImplTest.assertNotNull((Object)container7);
        container7 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component3", ForumModel.TYPE_FORUM, null);
        SiteServiceImplTest.assertNotNull((Object)container7);
        SiteServiceImplTest.assertTrue((boolean)container5.equals((Object)container7));
        SiteServiceImplTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(container7));
        NodeRef container8 = this.siteService.getContainer(siteInfo.getShortName(), "folder.component4");
        SiteServiceImplTest.assertNull((Object)container8);
        container8 = this.siteService.createContainer(siteInfo.getShortName(), "folder.component4", ForumModel.TYPE_FORUM, null);
        SiteServiceImplTest.assertNotNull((Object)container8);
        SiteServiceImplTest.assertEquals((Object)ForumModel.TYPE_FORUM, (Object)this.nodeService.getType(container8));
        try {
            this.siteService.hasContainer("IDONT_EXISTS", "folder.component2");
            SiteServiceImplTest.fail((String)"Shouldn't get here");
        }
        catch (SiteDoesNotExistException siteDoesNotExistException) {}
    }

    @Test
    public void testSiteGetRoles() {
        List roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertNotNull((Object)roles);
        SiteServiceImplTest.assertFalse((boolean)roles.isEmpty());
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
    }

    @Test
    public void testCustomSiteProperties() {
        QName additionalInformationQName = QName.createQName((String)"http://www.alfresco.org/model/sitecustomproperty/1.0", (String)"additionalInformation");
        String siteShortName = "mySiteTest" + UUID.randomUUID();
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.checkSiteInfo(siteInfo, TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteServiceImplTest.assertNull((Object)siteInfo.getCustomProperty(additionalInformationQName));
        SiteServiceImplTest.assertNotNull((Object)siteInfo.getCustomProperties());
        SiteServiceImplTest.assertTrue((boolean)siteInfo.getCustomProperties().isEmpty());
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(additionalInformationQName, "information");
        this.nodeService.addAspect(siteNodeRef, QName.createQName((String)"http://www.alfresco.org/model/site/1.0", (String)"customSiteProperties"), properties);
        siteInfo = this.siteService.getSite(siteShortName);
        SiteServiceImplTest.assertNotNull((Object)siteInfo);
        SiteServiceImplTest.assertEquals((Object)"information", (Object)siteInfo.getCustomProperty(additionalInformationQName));
        SiteServiceImplTest.assertNotNull((Object)siteInfo.getCustomProperties());
        SiteServiceImplTest.assertFalse((boolean)siteInfo.getCustomProperties().isEmpty());
        SiteServiceImplTest.assertEquals((int)1, (int)siteInfo.getCustomProperties().size());
        SiteServiceImplTest.assertEquals((Object)"information", siteInfo.getCustomProperties().get(additionalInformationQName));
    }

    @Test
    public void testCustomSiteType() {
        DictionaryDAO dictionaryDAO = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        M2Model model = M2Model.createModel((String)"cm:CustomSiteModel");
        model.createNamespace("http://example.com/site", "cs");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/site/1.0", "st");
        M2Type customType = model.createType("cs:customSite");
        customType.setTitle("customSite");
        customType.setParentName("st:" + SiteModel.TYPE_SITE.getLocalName());
        M2Property customProp = customType.createProperty("cs:customSiteProp");
        customProp.setTitle("customSiteProp");
        customProp.setType("d:text");
        dictionaryDAO.putModel(model);
        QName customTypeQ = QName.createQName((String)"cs", (String)"customSite", (NamespacePrefixResolver)this.namespaceService);
        TypeDefinition td = this.dictionaryService.getType(customTypeQ);
        SiteServiceImplTest.assertNotNull((Object)td);
        SiteInfo site = this.siteService.createSite("custom", "custom", "Custom", "Custom", SiteVisibility.PUBLIC);
        List roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        this.nodeService.setType(site.getNodeRef(), customTypeQ);
        roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        PermissionService testPermissionService = (PermissionService)Mockito.spy((Object)((PermissionService)this.applicationContext.getBean("permissionServiceImpl")));
        HashSet<String> customPerms = new HashSet<String>();
        customPerms.add("SiteManager");
        customPerms.add("CUSTOM");
        Mockito.when((Object)testPermissionService.getSettablePermissions(customTypeQ)).thenReturn(customPerms);
        SiteServiceImpl siteServiceImpl = (SiteServiceImpl)this.applicationContext.getBean("siteService");
        siteServiceImpl.setPermissionService(testPermissionService);
        roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)2, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("CUSTOM"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        siteServiceImpl.setPermissionService(this.permissionService);
        roles = this.siteService.getSiteRoles();
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
        roles = this.siteService.getSiteRoles(site.getShortName());
        SiteServiceImplTest.assertEquals((int)7, (int)roles.size());
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteContributor"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteCollaborator"));
        SiteServiceImplTest.assertEquals((boolean)true, (boolean)roles.contains("SiteManager"));
    }

    @Test
    public void testGroupMembership() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String testGroupMembership = "testGroupMembership" + UUID.randomUUID();
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, testGroupMembership, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                Map members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, null, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertTrue((!SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_TWO) ? 1 : 0) != 0);
                SiteServiceImplTest.assertTrue((!SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_THREE) ? 1 : 0) != 0);
                SiteServiceImplTest.this.siteService.setMembership(testGroupMembership, SiteServiceImplTest.this.groupTwo, "SiteConsumer");
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, null, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)2, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.this.groupTwo)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, null, null, 0, true);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)3, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_TWO)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)SiteServiceImplTest.this.siteService.getMembersRoleInfo(testGroupMembership, SiteServiceImplTest.USER_ONE).getMemberRole());
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, null, "SiteManager", 0, true);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, null, "SiteConsumer", 0, true);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)2, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_TWO)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, "UserOne*", null, 0, true);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, "UserTwo*", null, 0, true);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_TWO)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, "UserTwo*", null, 0, false);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)0, (int)members.size());
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, SiteServiceImplTest.GROUP_TWO, null, 0, false);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.this.groupTwo)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, SiteServiceImplTest.GROUP_TWO_DISPLAY, null, 0, false);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)1, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.this.groupTwo)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, SiteServiceImplTest.GROUP_TWO, null, 0, true);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)0, (int)members.size());
                SiteServiceImplTest.this.siteService.setMembership(testGroupMembership, SiteServiceImplTest.USER_THREE, "SiteCollaborator");
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, null, null, 0);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)3, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.this.groupTwo)));
                members = SiteServiceImplTest.this.siteService.listMembers(testGroupMembership, null, null, 0, true);
                SiteServiceImplTest.assertNotNull((Object)members);
                SiteServiceImplTest.assertEquals((int)3, (int)members.size());
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)((String)members.get(SiteServiceImplTest.USER_ONE)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)((String)members.get(SiteServiceImplTest.USER_TWO)));
                SiteServiceImplTest.assertTrue((boolean)members.containsKey(SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)((String)members.get(SiteServiceImplTest.USER_THREE)));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertTrue((!SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_FOUR) ? 1 : 0) != 0);
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.this.groupTwo));
                SiteServiceImplTest.this.siteService.setMembership(testGroupMembership, SiteServiceImplTest.USER_THREE, "SiteContributor");
                SiteServiceImplTest.this.siteService.setMembership(testGroupMembership, SiteServiceImplTest.this.groupThree, "SiteManager");
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertTrue((boolean)SiteServiceImplTest.this.siteService.isMember(testGroupMembership, SiteServiceImplTest.USER_FOUR));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_ONE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_TWO));
                SiteServiceImplTest.assertEquals((String)"SiteContributor", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_THREE));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.this.groupThree));
                SiteServiceImplTest.assertEquals((String)"SiteManager", (String)SiteServiceImplTest.this.siteService.getMembersRole(testGroupMembership, SiteServiceImplTest.USER_FOUR));
                boolean failed = false;
                try {
                    SiteServiceImplTest.this.siteService.setMembership(testGroupMembership, SiteServiceImplTest.this.groupThree, "rubbish");
                }
                catch (UnknownAuthorityException unknownAuthorityException) {
                    failed = true;
                }
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(testGroupMembership);
                if (!failed) {
                    SiteServiceImplTest.fail((String)"Expected exception not thrown.");
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testUserRoleInGroups() {
        String sitName = "testMembership2" + UUID.randomUUID();
        this.siteService.createSite(TEST_SITE_PRESET, sitName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        this.siteService.setMembership(sitName, this.groupOne, "SiteCollaborator");
        this.siteService.setMembership(sitName, this.groupTwo, "SiteConsumer");
        List roles = this.siteService.listMembersInfo(sitName, USER_TWO, null, 0, true);
        SiteServiceImplTest.assertEquals((String)((SiteMemberInfo)roles.get(0)).getMemberRole(), (String)"SiteCollaborator");
    }

    @Test
    public void testSiteVisibility() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                SiteInfo siteInfo = SiteServiceImplTest.this.createTestSiteWithContent("testSiteVisibilityPublicSite", "testComp", SiteVisibility.PUBLIC);
                SiteServiceImplTest.assertEquals((Object)SiteVisibility.PUBLIC.toString(), (Object)SiteServiceImplTest.this.nodeService.getProperty(siteInfo.getNodeRef(), SiteModel.PROP_SITE_VISIBILITY));
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityPublicSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                siteInfo = SiteServiceImplTest.this.siteService.getSite("testSiteVisibilityPublicSite");
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityPublicSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.testVisibilityPermissions("Testing visibility of public site", SiteServiceImplTest.USER_TWO, siteInfo, true, true);
                siteInfo = SiteServiceImplTest.this.createTestSiteWithContent("testSiteVisibilityModeratedSite", "testComp", SiteVisibility.MODERATED);
                SiteServiceImplTest.assertEquals((Object)SiteVisibility.MODERATED.toString(), (Object)SiteServiceImplTest.this.nodeService.getProperty(siteInfo.getNodeRef(), SiteModel.PROP_SITE_VISIBILITY));
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityModeratedSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.MODERATED);
                siteInfo = SiteServiceImplTest.this.siteService.getSite("testSiteVisibilityModeratedSite");
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityModeratedSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.MODERATED);
                SiteServiceImplTest.this.testVisibilityPermissions("Testing visibility of moderated site", SiteServiceImplTest.USER_TWO, siteInfo, true, false);
                siteInfo = SiteServiceImplTest.this.createTestSiteWithContent("testSiteVisibilityPrivateSite", "testComp", SiteVisibility.PRIVATE);
                SiteServiceImplTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)SiteServiceImplTest.this.nodeService.getProperty(siteInfo.getNodeRef(), SiteModel.PROP_SITE_VISIBILITY));
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityPrivateSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                siteInfo = SiteServiceImplTest.this.siteService.getSite("testSiteVisibilityPrivateSite");
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityPrivateSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.testVisibilityPermissions("Testing visibility of private site", SiteServiceImplTest.USER_TWO, siteInfo, false, false);
                SiteInfo changeSite = SiteServiceImplTest.this.createTestSiteWithContent("testSiteVisibilityChangeSite", "testComp", SiteVisibility.PUBLIC);
                changeSite.setVisibility(SiteVisibility.MODERATED);
                SiteServiceImplTest.this.siteService.updateSite(changeSite);
                siteInfo = SiteServiceImplTest.this.siteService.getSite("testSiteVisibilityChangeSite");
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityChangeSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.MODERATED);
                SiteServiceImplTest.this.testVisibilityPermissions("Testing visibility of moderated site", SiteServiceImplTest.USER_TWO, siteInfo, true, false);
                changeSite.setVisibility(SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.siteService.updateSite(changeSite);
                siteInfo = SiteServiceImplTest.this.siteService.getSite("testSiteVisibilityChangeSite");
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityChangeSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                SiteServiceImplTest.this.testVisibilityPermissions("Testing visibility of moderated site", SiteServiceImplTest.USER_TWO, siteInfo, false, false);
                changeSite.setVisibility(SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.siteService.updateSite(changeSite);
                siteInfo = SiteServiceImplTest.this.siteService.getSite("testSiteVisibilityChangeSite");
                SiteServiceImplTest.this.checkSiteInfo(siteInfo, SiteServiceImplTest.TEST_SITE_PRESET, "testSiteVisibilityChangeSite", SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PUBLIC);
                SiteServiceImplTest.this.testVisibilityPermissions("Testing visibility of moderated site", SiteServiceImplTest.USER_TWO, siteInfo, true, true);
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite("testSiteVisibilityPublicSite");
                SiteServiceImplTest.this.siteService.deleteSite("testSiteVisibilityModeratedSite");
                SiteServiceImplTest.this.siteService.deleteSite("testSiteVisibilityPrivateSite");
                SiteServiceImplTest.this.siteService.deleteSite("testSiteVisibilityChangeSite");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    private Map<String, Set<String>> getAllowedPermissionsMap(SiteInfo site) {
        NodeRef nodeRef = site.getNodeRef();
        return this.getAllowedPermissionsMap(nodeRef);
    }

    private Map<String, Set<String>> getAllowedPermissionsMap(NodeRef nodeRef) {
        HashMap<String, Set<String>> perms = new HashMap<String, Set<String>>();
        for (AccessPermission ap : this.permissionService.getAllSetPermissions(nodeRef)) {
            if (ap.getAccessStatus() != AccessStatus.ALLOWED) continue;
            HashSet<String> permsValue = (HashSet<String>)perms.get(ap.getAuthority());
            if (permsValue == null) {
                permsValue = new HashSet<String>();
            }
            permsValue.add(ap.getPermission());
            perms.put(ap.getAuthority(), permsValue);
        }
        return perms;
    }

    @Test
    public void testNonDefaultPublicGroupPermissions() throws Exception {
        SiteServiceImplTest.assertEquals((String)"GROUP_EVERYONE", (String)this.sysAdminParams.getSitePublicGroup());
        SysAdminParamsImpl sp = new SysAdminParamsImpl();
        sp.setSitePublicGroup(this.groupFour);
        this.siteServiceImpl.setSysAdminParams((SysAdminParams)sp);
        SiteInfo s1 = this.siteService.createSite(TEST_SITE_PRESET, "SiteTest_priv", "priv", "priv", SiteVisibility.PRIVATE);
        SiteInfo s2 = this.siteService.createSite(TEST_SITE_PRESET, "SiteTest_mod", "mod", "mod", SiteVisibility.MODERATED);
        SiteInfo s3 = this.siteService.createSite(TEST_SITE_PRESET, "SiteTest_pub", "pub", "pub", SiteVisibility.PUBLIC);
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s1).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s2).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s3).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertEquals(null, this.getAllowedPermissionsMap(s1).get(this.groupFour));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s2).get(this.groupFour).contains("SiteConsumer"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s3).get(this.groupFour).contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s1.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s2.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s3.getShortName(), USER_ONE));
        s1.setVisibility(SiteVisibility.PUBLIC);
        s2.setVisibility(SiteVisibility.PUBLIC);
        s3.setVisibility(SiteVisibility.PRIVATE);
        this.siteService.updateSite(s1);
        this.siteService.updateSite(s2);
        this.siteService.updateSite(s3);
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s1).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s2).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s3).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s1).get(this.groupFour).contains("SiteConsumer"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s2).get(this.groupFour).contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals(null, this.getAllowedPermissionsMap(s3).get(this.groupFour));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s1.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s2.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s3.getShortName(), USER_ONE));
        s1.setVisibility(SiteVisibility.PRIVATE);
        s2.setVisibility(SiteVisibility.MODERATED);
        s3.setVisibility(SiteVisibility.PUBLIC);
        this.siteService.updateSite(s1);
        this.siteService.updateSite(s2);
        this.siteService.updateSite(s3);
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s1).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s2).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s3).get("GROUP_EVERYONE").contains("ReadPermissions"));
        SiteServiceImplTest.assertEquals(null, this.getAllowedPermissionsMap(s1).get(this.groupFour));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s2).get(this.groupFour).contains("SiteConsumer"));
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(s3).get(this.groupFour).contains("SiteConsumer"));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s1.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s2.getShortName(), USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)this.siteService.getMembersRole(s3.getShortName(), USER_ONE));
    }

    private SiteInfo createTestSiteWithContent(String siteShortName, String componentId, SiteVisibility visibility) {
        return this.createTestSiteWithContent(siteShortName, componentId, visibility, "");
    }

    private SiteInfo createTestSiteWithContent(String siteShortName, String componentId, SiteVisibility visibility, String fileFolderPrefix) {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, visibility);
        NodeRef siteContainer = this.siteService.createContainer(siteShortName, componentId, ContentModel.TYPE_FOLDER, null);
        FileInfo fileInfo = this.fileFolderService.create(siteContainer, String.valueOf(fileFolderPrefix) + "file.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.fileFolderService.getWriter(fileInfo.getNodeRef());
        writer.putContent("Just some old content that doesn't mean anything");
        FileInfo folder1Info = this.fileFolderService.create(siteContainer, String.valueOf(fileFolderPrefix) + "folder", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo2 = this.fileFolderService.create(folder1Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "fileInFolder.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer2 = this.fileFolderService.getWriter(fileInfo2.getNodeRef());
        writer2.putContent("Just some old content that doesn't mean anything");
        FileInfo folder2Info = this.fileFolderService.create(folder1Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "subfolder", ContentModel.TYPE_FOLDER);
        FileInfo fileInfo3 = this.fileFolderService.create(folder2Info.getNodeRef(), String.valueOf(fileFolderPrefix) + "fileInSubfolder.txt", ContentModel.TYPE_CONTENT);
        ContentWriter writer3 = this.fileFolderService.getWriter(fileInfo3.getNodeRef());
        writer3.putContent("Just some old content that doesn't mean anything");
        return siteInfo;
    }

    private void testVisibilityPermissions(String message, String userName, SiteInfo siteInfo, boolean listSite, boolean readSite) {
        block10: {
            String holdUser = this.authenticationComponent.getCurrentUserName();
            this.authenticationComponent.setCurrentUser(userName);
            try {
                List sites = this.siteService.listSites(null, null);
                boolean siteInList = sites.contains(siteInfo);
                if (listSite && !siteInList) {
                    SiteServiceImplTest.fail((String)(String.valueOf(message) + ":  The site '" + siteInfo.getShortName() + "' was expected in the list of sites for user '" + userName + "'"));
                } else if (!listSite && siteInList) {
                    SiteServiceImplTest.fail((String)(String.valueOf(message) + ":  The site '" + siteInfo.getShortName() + "' was NOT expected in the list of sites for user '" + userName + "'"));
                }
                if (!siteInList) break block10;
                try {
                    NodeRef folder = this.siteService.getContainer(siteInfo.getShortName(), "testComp");
                    this.fileFolderService.listFiles(folder);
                    if (!readSite) {
                        SiteServiceImplTest.fail((String)(String.valueOf(message) + ":  Content of the site '" + siteInfo.getShortName() + "' was NOT expected to be read by user '" + userName + "'"));
                    }
                }
                catch (Exception exception) {
                    if (readSite) {
                        SiteServiceImplTest.fail((String)(String.valueOf(message) + ":  Content of the site '" + siteInfo.getShortName() + "' was expected to be read by user '" + userName + "'"));
                    }
                }
            }
            finally {
                this.authenticationComponent.setCurrentUser(holdUser);
            }
        }
    }

    @Test
    public void testALFCOM_3109() {
        String siteName = "testALFCOM_3019";
        this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        Map members = this.siteService.listMembers(siteName, null, null, 0);
        String managerName = (String)members.keySet().iterator().next();
        this.siteService.setMembership(siteName, this.groupTwo, "SiteManager");
        this.siteService.setMembership(siteName, managerName, "SiteContributor");
        try {
            this.siteService.setMembership(siteName, this.groupTwo, "SiteContributor");
            SiteServiceImplTest.fail();
        }
        catch (Exception exception) {}
        this.siteService.setMembership(siteName, managerName, "SiteManager");
        this.siteService.setMembership(siteName, this.groupTwo, "SiteContributor");
        try {
            this.siteService.setMembership(siteName, managerName, "SiteContributor");
            SiteServiceImplTest.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testALFCOM_3111() {
        String siteName = "testALFCOM_3019";
        this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        Map members = this.siteService.listMembers(siteName, null, null, 0);
        String managerName = (String)members.keySet().iterator().next();
        this.siteService.setMembership(siteName, this.groupTwo, "SiteManager");
        this.siteService.removeMembership(siteName, managerName);
        try {
            this.siteService.removeMembership(siteName, this.groupTwo);
            SiteServiceImplTest.fail();
        }
        catch (Exception exception) {}
        this.siteService.setMembership(siteName, managerName, "SiteManager");
        this.siteService.removeMembership(siteName, this.groupTwo);
        try {
            this.siteService.removeMembership(siteName, managerName);
            SiteServiceImplTest.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testETHREEOH_1268() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> work = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                String siteName = "testALFCOM_XXXX" + UUID.randomUUID();
                SiteServiceImplTest.this.siteService.createSite(SiteServiceImplTest.TEST_SITE_PRESET, siteName, SiteServiceImplTest.TEST_TITLE, SiteServiceImplTest.TEST_DESCRIPTION, SiteVisibility.PRIVATE);
                SiteInfo si = SiteServiceImplTest.this.siteService.getSite(siteName);
                SiteServiceImplTest.assertNotNull((String)"site info is null", (Object)si);
                SiteServiceImplTest.this.authenticationComponent.setCurrentUser(SiteServiceImplTest.USER_TWO);
                si = SiteServiceImplTest.this.siteService.getSite(siteName);
                SiteServiceImplTest.assertNull((String)"site info is not null", (Object)si);
                SiteServiceImplTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                SiteServiceImplTest.this.siteService.deleteSite(siteName);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
    }

    @Test
    public void testALF_3200() throws Exception {
        String siteName = "testALF_3200";
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        try {
            this.fileFolderService.rename(siteNodeRef, "RenamedName");
            SiteServiceImplTest.fail((String)"Shouldn't be able to rename a site but did");
        }
        catch (SiteServiceException siteServiceException) {}
        SiteServiceImplTest.assertEquals((Object)TEST_TITLE, (Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_TITLE));
        String newName = "ChangedTitleName";
        String newName2 = "Changed2Title2Name";
        this.nodeService.setProperty(siteNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)newName));
        SiteServiceImplTest.assertEquals((Object)newName, (Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_TITLE));
        siteInfo = this.siteService.getSite(siteNodeRef);
        SiteServiceImplTest.assertEquals((String)newName, (String)siteInfo.getTitle());
        siteInfo.setTitle(newName2);
        this.siteService.updateSite(siteInfo);
        SiteServiceImplTest.assertEquals((String)newName2, (String)siteInfo.getTitle());
        SiteServiceImplTest.assertEquals((Object)newName2, (Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_TITLE));
    }

    @Test
    public void testALF_5556() throws Exception {
        String siteName = "testALF_5556";
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.MODERATED);
        NodeRef container = this.siteService.createContainer(siteInfo.getShortName(), "folder.component", null, null);
        try {
            this.fileFolderService.rename(container, "RenamedContainer");
            SiteServiceImplTest.fail((String)"Shouldn't be able to rename a container but was able to");
        }
        catch (SiteServiceException siteServiceException) {}
    }

    @Test
    public void testALF8036_PermissionsAfterCopyingFolderBetweenSites() throws Exception {
        this.alf8036Impl(true);
    }

    private void alf8036Impl(boolean copyNotMove) {
        SiteInfo fromSite = this.createTestSiteWithContent("fromSite", "doclib", SiteVisibility.PUBLIC, "FROM");
        SiteInfo toSite = this.createTestSiteWithContent("toSite", "doclib", SiteVisibility.PUBLIC, "TO");
        NodeRef fromDoclibContainer = this.nodeService.getChildByName(fromSite.getNodeRef(), ContentModel.ASSOC_CONTAINS, "doclib");
        SiteServiceImplTest.assertNotNull((Object)fromDoclibContainer);
        NodeRef fromFolder = this.nodeService.getChildByName(fromDoclibContainer, ContentModel.ASSOC_CONTAINS, "FROMfolder");
        SiteServiceImplTest.assertNotNull((Object)fromFolder);
        NodeRef fromSubFolder = this.nodeService.getChildByName(fromFolder, ContentModel.ASSOC_CONTAINS, "FROMsubfolder");
        SiteServiceImplTest.assertNotNull((Object)fromSubFolder);
        this.permissionService.setPermission(fromFolder, this.siteServiceImpl.getSiteRoleGroup(fromSite.getShortName(), "SiteContributor", true), "SiteConsumer", false);
        this.permissionService.setPermission(fromSubFolder, this.siteServiceImpl.getSiteRoleGroup(fromSite.getShortName(), "SiteCollaborator", true), "SiteConsumer", false);
        NodeRef toDoclibContainer = this.nodeService.getChildByName(toSite.getNodeRef(), ContentModel.ASSOC_CONTAINS, "doclib");
        SiteServiceImplTest.assertNotNull((Object)toDoclibContainer);
        NodeRef toFolder = this.nodeService.getChildByName(toDoclibContainer, ContentModel.ASSOC_CONTAINS, "TOfolder");
        SiteServiceImplTest.assertNotNull((Object)toFolder);
        NodeRef relocatedNode = copyNotMove ? this.copyService.copy(fromFolder, toFolder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, true) : this.nodeService.moveNode(fromFolder, toDoclibContainer, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS).getChildRef();
        this.siteService.cleanSitePermissions(relocatedNode, null);
        HashMap<String, String> expectedPermissions = new HashMap<String, String>();
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteManager"), "SiteManager");
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteCollaborator"), "SiteCollaborator");
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteContributor"), "SiteContributor");
        expectedPermissions.put(this.siteService.getSiteRoleGroup(toSite.getShortName(), "SiteConsumer"), "SiteConsumer");
        this.validatePermissionsOnRelocatedNode(fromSite, toSite, relocatedNode, expectedPermissions);
        NodeRef copyOfSubFolder = this.nodeService.getChildByName(relocatedNode, ContentModel.ASSOC_CONTAINS, "FROMsubfolder");
        SiteServiceImplTest.assertNotNull((Object)copyOfSubFolder);
        this.validatePermissionsOnRelocatedNode(fromSite, toSite, copyOfSubFolder, expectedPermissions);
    }

    @Test
    public void testALF_1017_nonSitesInSitesSpace() throws Exception {
        List sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", (Object)sites);
        int preexistingSitesCount = sites.size();
        SiteInfo site1 = this.siteService.createSite(TEST_SITE_PRESET, "mySiteOne", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        SiteInfo site2 = this.siteService.createSite(TEST_SITE_PRESET, "mySiteTwo", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", (Object)sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 2), (int)sites.size());
        final NodeRef sitesSpace = this.nodeService.getPrimaryParent(site1.getNodeRef()).getParentRef();
        NodeRef folder = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImplTest.this.nodeService.createNode(sitesSpace, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Folder"), ContentModel.TYPE_FOLDER).getChildRef();
            }
        });
        NodeRef document = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return SiteServiceImplTest.this.nodeService.createNode(sitesSpace, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"Document"), ContentModel.TYPE_CONTENT).getChildRef();
            }
        });
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", (Object)sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 2), (int)sites.size());
        this.siteService.deleteSite(site2.getShortName());
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", (Object)sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 1), (int)sites.size());
        this.nodeService.deleteNode(folder);
        this.nodeService.deleteNode(document);
        sites = this.siteService.listSites(null, null);
        SiteServiceImplTest.assertNotNull((String)"sites list was null.", (Object)sites);
        SiteServiceImplTest.assertEquals((int)(preexistingSitesCount + 1), (int)sites.size());
    }

    private SiteInfo createSite(String siteShortName, String componentId, SiteVisibility visibility) {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, visibility);
        this.siteService.createContainer(siteShortName, componentId, ContentModel.TYPE_FOLDER, null);
        return siteInfo;
    }

    @Test
    public void testRenameSite() {
        try {
            String siteName = GUID.generate();
            SiteInfo siteInfo = this.createSite(siteName, "doclib", SiteVisibility.PUBLIC);
            NodeRef childRef = siteInfo.getNodeRef();
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_NAME, String.valueOf(siteName) + "Renamed");
            this.nodeService.addProperties(childRef, props);
            SiteServiceImplTest.fail((String)"Should have caught rename");
        }
        catch (SiteServiceException e) {
            SiteServiceImplTest.assertTrue((boolean)e.getMessage().contains("can not be renamed"));
        }
    }

    private void validatePermissionsOnRelocatedNode(SiteInfo fromSite, SiteInfo toSite, NodeRef relocatedNode, Map<String, String> expectedPermissions) {
        Set permissions = this.permissionService.getAllSetPermissions(relocatedNode);
        for (String sitePermission : SiteModel.STANDARD_PERMISSIONS) {
            String siteRoleGroup = this.siteServiceImpl.getSiteRoleGroup(fromSite.getShortName(), sitePermission, true);
            AccessPermission ap = this.getPermission(permissions, siteRoleGroup);
            SiteServiceImplTest.assertNull((String)("Permission " + siteRoleGroup + " was unexpectedly present"), (Object)ap);
        }
        for (String authority : expectedPermissions.keySet()) {
            AccessPermission ap = this.getPermission(permissions, authority);
            SiteServiceImplTest.assertNotNull((String)("Permission " + authority + " missing"), (Object)ap);
            SiteServiceImplTest.assertEquals((String)authority, (String)ap.getAuthority());
            SiteServiceImplTest.assertEquals((String)("Wrong permission for " + authority), (String)expectedPermissions.get(authority), (String)ap.getPermission());
            SiteServiceImplTest.assertTrue((boolean)ap.isInherited());
        }
    }

    private AccessPermission getPermission(Set<AccessPermission> permissions, String expectedAuthority) {
        AccessPermission result = null;
        for (AccessPermission ap : permissions) {
            if (!expectedAuthority.equals(ap.getAuthority())) continue;
            result = ap;
        }
        return result;
    }

    @Test
    public void testPermissionsAfterMovingFolderBetweenSites() throws Exception {
        this.alf8036Impl(false);
    }

    @Test
    public void testJSAPI() throws Exception {
        SiteInfo siteInfo = this.siteService.createSite(TEST_SITE_PRESET, "mySiteWithCustomProperty", TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PUBLIC);
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(QName.createQName((String)"http://www.alfresco.org/model/sitecustomproperty/1.0", (String)"additionalInformation"), "information");
        this.nodeService.addAspect(siteNodeRef, QName.createQName((String)"http://www.alfresco.org/model/site/1.0", (String)"customSiteProperties"), properties);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("customSiteName", "mySiteWithCustomProperty");
        model.put("preexistingSiteCount", this.siteService.listSites(null, null).size());
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/site/script/test_siteService.js");
        this.scriptService.executeScript((ScriptLocation)location, model);
    }

    @Test
    public void testListMembersInfo() {
        String siteShortName = "testMemberInfo";
        this.siteService.createSite(TEST_SITE_PRESET, siteShortName, TEST_TITLE, TEST_DESCRIPTION, SiteVisibility.PRIVATE);
        List members = this.siteService.listMembersInfo(siteShortName, null, null, 0, false);
        SiteServiceImplTest.assertNotNull((Object)members);
        SiteServiceImplTest.assertEquals((int)1, (int)members.size());
        SiteMemberInfo user = (SiteMemberInfo)members.get(0);
        SiteServiceImplTest.assertNotNull((Object)user);
        SiteServiceImplTest.assertTrue((boolean)user.getMemberName().equals(USER_ONE));
        SiteServiceImplTest.assertEquals((String)"SiteManager", (String)user.getMemberRole());
        SiteServiceImplTest.assertFalse((String)"USER_ONE is NOT member of any group", (boolean)user.isMemberOfGroup());
        this.siteService.setMembership(siteShortName, this.groupTwo, "SiteCollaborator");
        this.siteService.setMembership(siteShortName, USER_FOUR, "SiteConsumer");
        members = this.siteService.listMembersInfo(siteShortName, null, null, 0, true);
        SiteServiceImplTest.assertNotNull((Object)members);
        SiteServiceImplTest.assertEquals((int)4, (int)members.size());
        user = this.lookupMemberInfoByUserName(members, USER_TWO);
        SiteServiceImplTest.assertNotNull((Object)user);
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)user.getMemberRole());
        SiteServiceImplTest.assertTrue((String)"USER_TWO is member of group two", (boolean)user.isMemberOfGroup());
        user = this.lookupMemberInfoByUserName(members, USER_THREE);
        SiteServiceImplTest.assertNotNull((Object)user);
        SiteServiceImplTest.assertEquals((String)"SiteCollaborator", (String)user.getMemberRole());
        SiteServiceImplTest.assertTrue((String)"USER_THREE is member of group two", (boolean)user.isMemberOfGroup());
        user = this.lookupMemberInfoByUserName(members, USER_FOUR);
        SiteServiceImplTest.assertNotNull((Object)user);
        SiteServiceImplTest.assertEquals((String)"SiteConsumer", (String)user.getMemberRole());
        SiteServiceImplTest.assertFalse((String)"USER_FOUR is NOT member of any group", (boolean)user.isMemberOfGroup());
    }

    private SiteMemberInfo lookupMemberInfoByUserName(List<SiteMemberInfo> members, String name) {
        for (SiteMemberInfo info : members) {
            if (!name.equals(info.getMemberName())) continue;
            return info;
        }
        return null;
    }

    @Test
    public void testPrivateSite() throws Exception {
        String siteName = GUID.generate();
        SiteInfo siteInfo = this.createSite(siteName, "doclib", SiteVisibility.PRIVATE);
        NodeRef container = this.siteService.getContainer(siteInfo.getShortName(), "doclib");
        SiteServiceImplTest.assertNull((String)"GROUP_EVERYONE shouldn't have any permissions on a private site's containers", this.getAllowedPermissionsMap(container).get("GROUP_EVERYONE"));
    }

    @Test
    public void testModeratedSite() throws Exception {
        String siteName = GUID.generate();
        SiteInfo siteInfo = this.createSite(siteName, "doclib", SiteVisibility.MODERATED);
        NodeRef container = this.siteService.getContainer(siteInfo.getShortName(), "doclib");
        SiteServiceImplTest.assertNull((String)"GROUP_EVERYONE shouldn't have any permissions on a moderated site's containers", this.getAllowedPermissionsMap(container).get("GROUP_EVERYONE"));
    }

    @Test
    public void testChangeSiteVisibility() {
        String siteName = GUID.generate();
        SiteInfo siteInfo = this.createSite(siteName, "doclib", SiteVisibility.PRIVATE);
        NodeRef container = this.siteService.getContainer(siteInfo.getShortName(), "doclib");
        siteInfo.setVisibility(SiteVisibility.PUBLIC);
        this.siteService.updateSite(siteInfo);
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(container).get("GROUP_EVERYONE").contains("ReadPermissions"));
        siteInfo.setVisibility(SiteVisibility.MODERATED);
        this.siteService.updateSite(siteInfo);
        SiteServiceImplTest.assertNull((String)"GROUP_EVERYONE shouldn't have any permissions on a moderated site's containers", this.getAllowedPermissionsMap(container).get("GROUP_EVERYONE"));
        siteInfo.setVisibility(SiteVisibility.PUBLIC);
        this.siteService.updateSite(siteInfo);
        SiteServiceImplTest.assertTrue((boolean)this.getAllowedPermissionsMap(container).get("GROUP_EVERYONE").contains("ReadPermissions"));
        siteInfo.setVisibility(SiteVisibility.PRIVATE);
        this.siteService.updateSite(siteInfo);
        SiteServiceImplTest.assertNull((String)"GROUP_EVERYONE shouldn't have any permissions on a moderated site's containers", this.getAllowedPermissionsMap(container).get("GROUP_EVERYONE"));
    }

    @Test
    public void testDeleteSiteAsAdministrator() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String shortName = GUID.generate();
        this.createSite(shortName, "doclib", SiteVisibility.MODERATED);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        try {
            this.siteService.deleteSite(shortName);
            SiteServiceImplTest.fail((String)"We should not reach this point. the user that tries to run this code, add the file, is not yet a member of the site");
        }
        catch (AccessDeniedException accessDeniedException) {}
        this.authenticationComponent.setCurrentUser(USER_SITE_ADMIN);
        this.siteService.deleteSite(shortName);
    }

    @Test
    public void testFindSitesQueryWithReservedCharacter() {
        SiteServiceImpl cut = new SiteServiceImpl();
        ArgumentCaptor searchParametersCaptor = ArgumentCaptor.forClass(SearchParameters.class);
        MemoryCache cache = new MemoryCache();
        cache.put((Serializable)((Object)"key.sitehome.noderef"), (Object)new NodeRef("mock", "mock", "mock"));
        cut.setSingletonCache((SimpleCache)cache);
        SearchService searchService = (SearchService)Mockito.mock(SearchService.class);
        cut.setSearchService(searchService);
        Mockito.when((Object)searchService.query((SearchParameters)ArgumentMatchers.any(SearchParameters.class))).thenReturn((Object)new EmptyResultSet());
        cut.findSites("-chu", 5);
        ((SearchService)Mockito.verify((Object)searchService)).query((SearchParameters)searchParametersCaptor.capture());
        SearchParameters actualSearchParameters = (SearchParameters)searchParametersCaptor.getValue();
        Assertions.assertThat((String)actualSearchParameters.getQuery()).isEqualTo("+TYPE:\"{http://www.alfresco.org/model/site/1.0}site\" AND ( cm:name:\"\\-chu*\" OR  cm:title: (\"\\-chu*\" ) OR cm:description:\"\\-chu\")");
    }
}

