/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.handler;

import org.alfresco.email.server.handler.AbstractForumEmailMessageHandler;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class ForumEmailMessageHandler
extends AbstractForumEmailMessageHandler {
    @Override
    public void processMessage(NodeRef nodeRef, EmailMessage message) {
        NodeRef topicNode;
        String messageSubject = message.getSubject() != null ? message.getSubject() : "EMPTY_SUBJECT_" + System.currentTimeMillis();
        QName nodeTypeQName = this.getNodeService().getType(nodeRef);
        if (this.getDictionaryService().isSubClass(nodeTypeQName, ForumModel.TYPE_FORUM)) {
            topicNode = this.getTopicNode(nodeRef, messageSubject);
            if (topicNode == null) {
                topicNode = this.addTopicNode(nodeRef, messageSubject);
            }
        } else {
            throw new AlfrescoRuntimeException("\nMessage handler " + this.getClass().getName() + " cannot handle type " + nodeTypeQName + ".\n" + "Check the message handler mappings.");
        }
        this.addPostNode(topicNode, message);
    }
}

