/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.springframework.extensions.surf.util.I18NUtil;

public class ExporterActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "export";
    public static final String PARAM_STORE = "store";
    public static final String PARAM_PACKAGE_NAME = "package-name";
    public static final String PARAM_DESTINATION_FOLDER = "destination";
    public static final String PARAM_INCLUDE_CHILDREN = "include-children";
    public static final String PARAM_INCLUDE_SELF = "include-self";
    public static final String PARAM_ENCODING = "encoding";
    private static final String TEMP_FILE_PREFIX = "alf";
    private ExporterService exporterService;
    private MimetypeService mimetypeService;
    private NodeService nodeService;
    private ContentService contentService;

    public void setExporterService(ExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        File zipFile = null;
        try {
            try {
                String packageName = (String)((Object)ruleAction.getParameterValue(PARAM_PACKAGE_NAME));
                File dataFile = new File(packageName);
                File contentDir = new File(packageName);
                zipFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)"acp");
                ACPExportPackageHandler zipHandler = new ACPExportPackageHandler(new FileOutputStream(zipFile), dataFile, contentDir, this.mimetypeService);
                ExporterCrawlerParameters params = new ExporterCrawlerParameters();
                boolean includeChildren = true;
                Boolean withKids = (Boolean)ruleAction.getParameterValue(PARAM_INCLUDE_CHILDREN);
                if (withKids != null) {
                    includeChildren = withKids;
                }
                params.setCrawlChildNodes(includeChildren);
                boolean includeSelf = false;
                Boolean andMe = (Boolean)ruleAction.getParameterValue(PARAM_INCLUDE_SELF);
                if (andMe != null) {
                    includeSelf = andMe;
                }
                params.setCrawlSelf(includeSelf);
                params.setExportFrom(new Location(actionedUponNodeRef));
                this.exporterService.exportView(zipHandler, params, null);
                NodeRef zip = this.createExportZip(ruleAction, actionedUponNodeRef);
                ContentWriter writer = this.contentService.getWriter(zip, ContentModel.PROP_CONTENT, true);
                writer.setEncoding((String)((Object)ruleAction.getParameterValue(PARAM_ENCODING)));
                writer.setMimetype("application/acp");
                writer.putContent(zipFile);
            }
            catch (FileNotFoundException fnfe) {
                throw new ActionServiceException("export.package.error", fnfe);
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.delete();
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_PACKAGE_NAME, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_PACKAGE_NAME)));
        paramList.add(new ParameterDefinitionImpl(PARAM_ENCODING, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_ENCODING)));
        paramList.add(new ParameterDefinitionImpl(PARAM_STORE, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_STORE)));
        paramList.add(new ParameterDefinitionImpl(PARAM_DESTINATION_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_DESTINATION_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_INCLUDE_CHILDREN, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_INCLUDE_CHILDREN)));
        paramList.add(new ParameterDefinitionImpl(PARAM_INCLUDE_SELF, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_INCLUDE_SELF)));
    }

    private NodeRef createExportZip(Action ruleAction, NodeRef actionedUponNodeRef) {
        NodeRef exportDest = (NodeRef)ruleAction.getParameterValue(PARAM_DESTINATION_FOLDER);
        String packageName = (String)((Object)ruleAction.getParameterValue(PARAM_PACKAGE_NAME));
        if (!packageName.endsWith(".acp")) {
            packageName = String.valueOf(packageName) + (packageName.charAt(packageName.length() - 1) == '.' ? "acp" : ".acp");
        }
        HashMap<QName, String> contentProps = new HashMap<QName, String>(1);
        contentProps.put(ContentModel.PROP_NAME, packageName);
        String assocName = QName.createValidLocalName((String)packageName);
        ChildAssociationRef assocRef = this.nodeService.createNode(exportDest, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)assocName), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef zipNodeRef = assocRef.getChildRef();
        String desc = "";
        String storeRef = (String)((Object)ruleAction.getParameterValue(PARAM_STORE));
        NodeRef rootNode = this.nodeService.getRootNode(new StoreRef(storeRef));
        if (rootNode.equals((Object)actionedUponNodeRef)) {
            desc = I18NUtil.getMessage((String)"export.root.package.description");
        } else {
            String spaceName = (String)((Object)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_NAME));
            String pattern = I18NUtil.getMessage((String)"export.package.description");
            if (pattern != null && spaceName != null) {
                desc = MessageFormat.format(pattern, spaceName);
            }
        }
        HashMap<QName, String> titledProps = new HashMap<QName, String>(3, 1.0f);
        titledProps.put(ContentModel.PROP_TITLE, packageName);
        titledProps.put(ContentModel.PROP_DESCRIPTION, desc);
        this.nodeService.addAspect(zipNodeRef, ContentModel.ASPECT_TITLED, titledProps);
        return zipNodeRef;
    }
}

