/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodePropertyEntity;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;

public class NodeStringLengthWorker
implements ApplicationContextAware {
    private static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"NodeStringLengthWorker");
    private static final long LOCK_TTL = 60000L;
    private static Log logger = LogFactory.getLog(NodeStringLengthWorker.class);
    private final NodeDAO nodeDAO;
    private final JobLockService jobLockService;
    private final TransactionService transactionService;
    private final QNameDAO qnameDAO;
    private final BehaviourFilter behaviourFilter;
    private ApplicationContext ctx;
    private final int queryRange;
    private final int threadCount;
    private final int batchSize;

    public NodeStringLengthWorker(NodeDAO nodeDAO, JobLockService jobLockService, TransactionService transactionService, QNameDAO qnameDAO, BehaviourFilter behaviourFilter, int queryRange, int threadCount) {
        this.nodeDAO = nodeDAO;
        this.jobLockService = jobLockService;
        this.transactionService = transactionService;
        this.qnameDAO = qnameDAO;
        this.behaviourFilter = behaviourFilter;
        this.queryRange = queryRange;
        this.threadCount = threadCount;
        this.batchSize = 100;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctx = applicationContext;
    }

    public NodeStringLengthWorkResult execute() {
        NodeStringLengthWorkResult progress;
        block13: {
            progress = new NodeStringLengthWorkResult();
            JobLockService.JobLockRefreshCallback lockCallback = new JobLockService.JobLockRefreshCallback(){

                @Override
                public void lockReleased() {
                    progress.inProgress.set(false);
                }

                @Override
                public boolean isActive() {
                    return progress.inProgress.get();
                }
            };
            String lockToken = null;
            try {
                progress.inProgress.set(true);
                lockToken = this.jobLockService.getLock(LOCK, 60000L);
                this.jobLockService.refreshLock(lockToken, LOCK, 60000L, lockCallback);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"NodeStringLengthWorker: Starting");
                }
                this.doWork(progress);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("NodeStringLengthWorker: " + progress));
                }
            }
            catch (LockAcquisitionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping node string length job: " + e.getMessage()));
                }
                if (lockToken != null) {
                    this.jobLockService.releaseLock(lockToken, LOCK);
                }
                progress.inProgress.set(false);
                break block13;
            }
            catch (Exception e) {
                try {
                    progress.inProgress.set(false);
                    logger.error((Object)("Node string length job " + progress));
                    logger.error((Object)"Stopping node string length job with exception.", (Throwable)e);
                    if (lockToken != null) {
                        this.jobLockService.releaseLock(lockToken, LOCK);
                    }
                    progress.inProgress.set(false);
                    break block13;
                }
                catch (Throwable throwable) {
                    if (lockToken != null) {
                        this.jobLockService.releaseLock(lockToken, LOCK);
                    }
                    progress.inProgress.set(false);
                    throw throwable;
                }
            }
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK);
            }
            progress.inProgress.set(false);
        }
        return progress;
    }

    private synchronized void doWork(NodeStringLengthWorkResult progress) throws Exception {
        NodeStringLengthWorkProvider workProvider = new NodeStringLengthWorkProvider(progress);
        NodeStringLengthBatch worker = new NodeStringLengthBatch(progress);
        RetryingTransactionHelper retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
        retryingTransactionHelper.setForceWritable(true);
        BatchProcessor<NodePropertyEntity> batchProcessor = new BatchProcessor<NodePropertyEntity>("NodeStringLengthWorker", retryingTransactionHelper, workProvider, this.threadCount, this.batchSize, (ApplicationEventPublisher)this.ctx, logger, 1000);
        batchProcessor.process(worker, true);
    }

    private class NodeStringLengthBatch
    extends BatchProcessor.BatchProcessWorkerAdaptor<NodePropertyEntity> {
        private final int typeOrdinalText = NodePropertyValue.convertToTypeOrdinal(DataTypeDefinition.TEXT);
        private final int typeOrdinalAny = NodePropertyValue.convertToTypeOrdinal(DataTypeDefinition.ANY);
        private final NodeStringLengthWorkResult progress;

        private NodeStringLengthBatch(NodeStringLengthWorkResult progress) {
            this.progress = progress;
        }

        @Override
        public void process(NodePropertyEntity entry) throws Throwable {
            this.progress.propertiesProcessed.incrementAndGet();
            try {
                Long nodeId = entry.getNodeId();
                NodePropertyValue prop = entry.getValue();
                String text = (String)((Object)prop.getValue(DataTypeDefinition.TEXT));
                boolean repersist = false;
                int persistedTypeOrdinal = prop.getPersistedType();
                if (text.length() > SchemaBootstrap.getMaxStringLength()) {
                    if (this.typeOrdinalAny != persistedTypeOrdinal) {
                        repersist = true;
                    }
                } else if (this.typeOrdinalText != persistedTypeOrdinal) {
                    repersist = true;
                }
                if (repersist) {
                    NodeStringLengthWorker.this.behaviourFilter.disableBehaviour();
                    this.progress.propertiesChanged.incrementAndGet();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Fixing property " + this.getIdentifier(entry) + ".  Value: " + text));
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Fixing property " + this.getIdentifier(entry)));
                    }
                    Long propQNameId = entry.getKey().getQnameId();
                    QName propQName = (QName)NodeStringLengthWorker.this.qnameDAO.getQName(propQNameId).getSecond();
                    NodeStringLengthWorker.this.nodeDAO.removeNodeProperties(nodeId, Collections.singleton(propQName));
                    NodeStringLengthWorker.this.nodeDAO.addNodeProperty(nodeId, propQName, (Serializable)((Object)text));
                }
            }
            catch (Exception e) {
                this.progress.errors.incrementAndGet();
                throw e;
            }
        }

        @Override
        public String getIdentifier(NodePropertyEntity entry) {
            Long nodeId = entry.getNodeId();
            NodePropertyValue prop = entry.getValue();
            return "Property with persisted type " + prop.getPersistedType() + " on node " + NodeStringLengthWorker.this.nodeDAO.getNodePair(nodeId);
        }
    }

    public static class NodeStringLengthJob
    implements Job {
        public static final String JOB_DATA_NODE_WORKER = "nodeStringLengthWorker";

        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            Object nodeStringLengthWorkerObj = jobData.get((Object)JOB_DATA_NODE_WORKER);
            if (nodeStringLengthWorkerObj == null || !(nodeStringLengthWorkerObj instanceof NodeStringLengthWorker)) {
                throw new AlfrescoRuntimeException("MaxStringLengthJob data 'nodeStringLengthWorker' must reference a " + NodeStringLengthWorker.class.getSimpleName());
            }
            NodeStringLengthWorker worker = (NodeStringLengthWorker)nodeStringLengthWorkerObj;
            worker.execute();
        }
    }

    private class NodeStringLengthWorkProvider
    implements BatchProcessWorkProvider<NodePropertyEntity> {
        private final long maxNodeId;
        private final NodeStringLengthWorkResult progress;

        private NodeStringLengthWorkProvider(NodeStringLengthWorkResult progress) {
            this.progress = progress;
            this.maxNodeId = NodeStringLengthWorker.this.nodeDAO.getMaxNodeId();
        }

        @Override
        public int getTotalEstimatedWorkSize() {
            return -1;
        }

        @Override
        public long getTotalEstimatedWorkSizeLong() {
            return -1L;
        }

        @Override
        public Collection<NodePropertyEntity> getNextWork() {
            if (this.progress.errors.get() > 1000) {
                logger.warn((Object)"Node string length work terminating; too many errors.");
                return Collections.emptyList();
            }
            List<NodePropertyEntity> ret = Collections.emptyList();
            while (ret.isEmpty() && this.progress.currentMinNodeId.get() < this.maxNodeId) {
                Long minNodeId = null;
                if (this.progress.currentMinNodeId.get() == 0L) {
                    minNodeId = NodeStringLengthWorker.this.nodeDAO.getMinNodeId();
                    this.progress.currentMinNodeId.set(minNodeId);
                } else {
                    minNodeId = this.progress.currentMinNodeId.addAndGet(NodeStringLengthWorker.this.queryRange);
                }
                long maxNodeId = minNodeId + (long)NodeStringLengthWorker.this.queryRange;
                ret = NodeStringLengthWorker.this.nodeDAO.selectNodePropertiesByDataType(DataTypeDefinition.TEXT, minNodeId, maxNodeId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Node string length work provider found " + ret.size() + " new property entities."));
            }
            return ret;
        }
    }

    public static class NodeStringLengthWorkResult {
        private final AtomicBoolean inProgress = new AtomicBoolean(false);
        private final AtomicInteger propertiesProcessed = new AtomicInteger(0);
        private final AtomicInteger propertiesChanged = new AtomicInteger(0);
        private final AtomicInteger errors = new AtomicInteger(0);
        private final AtomicLong currentMinNodeId = new AtomicLong(0L);

        public String toString() {
            String part1 = "Changed";
            String part2 = String.format(" %4d out of a potential %4d properties. ", this.propertiesChanged.get(), this.propertiesProcessed.get());
            String part3 = String.format("[%2d Errors]", this.errors.get());
            return String.valueOf(part1) + part2 + part3;
        }

        public int getPropertiesProcessed() {
            return this.propertiesProcessed.get();
        }

        public int getPropertiesChanged() {
            return this.propertiesChanged.get();
        }

        public int getErrors() {
            return this.errors.get();
        }
    }
}

