/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.quickshare;

import java.util.List;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionException;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryAction;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuickShareLinkExpiryActionExecutor
extends ActionExecuterAbstractBase {
    private static final Log LOGGER = LogFactory.getLog(QuickShareLinkExpiryActionExecutor.class);
    private QuickShareService quickShareService;

    public void setQuickShareService(QuickShareService quickShareService) {
        this.quickShareService = quickShareService;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (!(action instanceof QuickShareLinkExpiryAction)) {
            if (action.getActionDefinitionName().equals("quickShareLinkExpiryActionExecutor")) {
                action = new QuickShareLinkExpiryActionImpl(action);
            } else {
                return;
            }
        }
        QuickShareLinkExpiryAction quickShareLinkExpiryAction = (QuickShareLinkExpiryAction)action;
        String sharedId = quickShareLinkExpiryAction.getSharedId();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Unsharing the shared id [" + sharedId + "] for the node:" + this.quickShareService.getTenantNodeRefFromSharedId(sharedId).getSecond()));
        }
        if (StringUtils.isEmpty((CharSequence)sharedId)) {
            throw new QuickShareLinkExpiryActionException("Shared id is not specified.");
        }
        try {
            this.quickShareService.unshareContent(sharedId);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Unshared the shared id:" + sharedId));
            }
        }
        catch (Exception ex) {
            if (ex instanceof QuickShareLinkExpiryActionException) {
                LOGGER.error((Object)("Couldn't delete the quick share expiry action [" + quickShareLinkExpiryAction.getNodeRef() + "] for the sharedId:" + sharedId));
            }
            LOGGER.error((Object)("Couldn't unshare the shared Id:" + sharedId));
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }
}

