/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.UnsupportedEncodingException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.httpclient.RequestHeadersHttpClient;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.SolrStoreMapping;
import org.alfresco.repo.search.impl.solr.SolrStoreMappingWrapper;
import org.alfresco.util.Pair;
import org.alfresco.util.shard.ExplicitShardingPolicy;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.HttpClient;
import org.springframework.beans.factory.BeanFactory;

public class ExplicitSolrStoreMappingWrapper
implements SolrStoreMappingWrapper {
    private HttpClientFactory httpClientFactory;
    private LinkedHashSet<HttpClientAndBaseUrl> httpClientsAndBaseURLs = new LinkedHashSet();
    private ExplicitShardingPolicy policy;
    private Random random;
    private BeanFactory beanFactory;
    private SolrStoreMapping wrapped;

    public ExplicitSolrStoreMappingWrapper(SolrStoreMapping wrapped, BeanFactory beanFactory) {
        this.wrapped = wrapped;
        this.beanFactory = beanFactory;
        this.init();
    }

    public void init() {
        this.httpClientFactory = (HttpClientFactory)this.beanFactory.getBean(this.wrapped.getHttpClientFactory());
        this.random = new Random(123L);
        if (this.wrapped.getNodes() == null || this.wrapped.getNodes().length == 0) {
            RequestHeadersHttpClient httpClient = this.httpClientFactory.getHttpClient();
            httpClient.getParams();
            this.httpClientsAndBaseURLs.add(new HttpClientAndBaseUrl((HttpClient)httpClient, this.wrapped.getBaseUrl()));
        } else {
            String[] stringArray = this.wrapped.getNodes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String node = stringArray[n2];
                String nodeHost = this.httpClientFactory.getHost();
                String nodePort = "" + this.httpClientFactory.getPort();
                String nodeBaseUrl = this.wrapped.getBaseUrl();
                if (node.length() > 0) {
                    int forward;
                    int colon = node.indexOf(58);
                    int n3 = forward = colon > -1 ? node.indexOf(47, colon) : node.indexOf(47);
                    if (colon == -1) {
                        if (forward == -1) {
                            if (node.startsWith("/")) {
                                nodeBaseUrl = node;
                            }
                            try {
                                int port = Integer.parseInt(node);
                                nodePort = "" + port;
                            }
                            catch (NumberFormatException numberFormatException) {
                                nodeHost = node;
                            }
                        } else {
                            try {
                                String potentialPort = node.substring(0, forward);
                                if (potentialPort.length() > 0) {
                                    int port = Integer.parseInt(potentialPort);
                                    nodePort = "" + port;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                nodeHost = node.substring(0, forward);
                            }
                            nodeBaseUrl = node.substring(forward);
                        }
                    } else if (forward == -1) {
                        String port;
                        if (colon > 0) {
                            nodeHost = node.substring(0, colon);
                        }
                        if (colon + 1 < node.length() && (port = node.substring(colon + 1)).length() > 0) {
                            nodePort = port;
                        }
                    } else {
                        String port;
                        if (colon > 0) {
                            nodeHost = node.substring(0, colon);
                        }
                        if ((port = node.substring(colon + 1, forward)).length() > 0) {
                            nodePort = port;
                        }
                        nodeBaseUrl = node.substring(forward);
                    }
                }
                try {
                    int realPort = Integer.parseInt(nodePort);
                    this.httpClientsAndBaseURLs.add(new HttpClientAndBaseUrl((HttpClient)this.httpClientFactory.getHttpClient(nodeHost, realPort), nodeBaseUrl));
                }
                catch (NumberFormatException numberFormatException) {
                    this.httpClientsAndBaseURLs.add(new HttpClientAndBaseUrl((HttpClient)this.httpClientFactory.getHttpClient(nodeHost, this.httpClientFactory.getPort()), nodeBaseUrl));
                }
                ++n2;
            }
        }
        this.policy = new ExplicitShardingPolicy(this.wrapped.getNumShards(), this.wrapped.getReplicationFactor(), this.httpClientsAndBaseURLs.size());
    }

    @Override
    public boolean isSharded() {
        return this.wrapped.getNumShards() > 1;
    }

    @Override
    public String getShards() {
        if (!this.policy.configurationIsValid()) {
            throw new AlfrescoRuntimeException("Invalid shard configuration: shard = " + this.wrapped.getNumShards() + "   reoplicationFactor = " + this.wrapped.getReplicationFactor() + " with node count = " + this.httpClientsAndBaseURLs.size());
        }
        return this.getShards2();
    }

    private String getShards2() {
        try {
            URLCodec encoder = new URLCodec();
            StringBuilder builder = new StringBuilder();
            int shard = 0;
            while (shard < this.wrapped.getNumShards()) {
                int position = this.random.nextInt(this.wrapped.getReplicationFactor());
                List nodeInstances = this.policy.getNodeInstancesForShardId(shard);
                Integer nodeId = (Integer)nodeInstances.get(position);
                if (builder.length() > 0) {
                    builder.append(',');
                }
                HttpClientAndBaseUrl httpClientAndBaseUrl = this.httpClientsAndBaseURLs.toArray(new HttpClientAndBaseUrl[0])[nodeId - 1];
                builder.append(encoder.encode(String.valueOf(httpClientAndBaseUrl.getProtocol()) + "://", "UTF-8"));
                builder.append(encoder.encode(httpClientAndBaseUrl.getHost(), "UTF-8"));
                builder.append(':');
                builder.append(encoder.encode("" + httpClientAndBaseUrl.getPort(), "UTF-8"));
                if (httpClientAndBaseUrl.getBaseUrl().startsWith("/")) {
                    builder.append(encoder.encode(httpClientAndBaseUrl.getBaseUrl(), "UTF-8"));
                } else {
                    builder.append(encoder.encode("/" + httpClientAndBaseUrl.getBaseUrl(), "UTF-8"));
                }
                if (this.isSharded()) {
                    builder.append('-').append(shard);
                }
                ++shard;
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new QueryParserException("", e);
        }
    }

    public int getNodeCount() {
        return this.httpClientsAndBaseURLs.size();
    }

    @Override
    public Pair<HttpClient, String> getHttpClientAndBaseUrl() {
        if (!this.policy.configurationIsValid()) {
            throw new AlfrescoRuntimeException("Invalid shard configuration: shard = " + this.wrapped.getNumShards() + "   reoplicationFactor = " + this.wrapped.getReplicationFactor() + " with node count = " + this.httpClientsAndBaseURLs.size());
        }
        int shard = this.random.nextInt(this.wrapped.getNumShards());
        int position = this.random.nextInt(this.wrapped.getReplicationFactor());
        List nodeInstances = this.policy.getNodeInstancesForShardId(shard);
        Integer nodeId = (Integer)nodeInstances.get(position);
        HttpClientAndBaseUrl httpClientAndBaseUrl = this.httpClientsAndBaseURLs.toArray(new HttpClientAndBaseUrl[0])[nodeId - 1];
        return new Pair((Object)httpClientAndBaseUrl.httpClient, (Object)(this.isSharded() ? String.valueOf(httpClientAndBaseUrl.baseUrl) + "-" + shard : httpClientAndBaseUrl.baseUrl));
    }

    private static class HttpClientAndBaseUrl {
        private HttpClient httpClient;
        private String baseUrl;

        HttpClientAndBaseUrl(HttpClient httpClient, String baseUrl) {
            this.httpClient = httpClient;
            this.baseUrl = baseUrl;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getHost() {
            return this.httpClient.getHostConfiguration().getHost();
        }

        public int getPort() {
            return this.httpClient.getHostConfiguration().getPort();
        }

        public String getProtocol() {
            return this.httpClient.getHostConfiguration().getProtocol().getScheme();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.baseUrl == null ? 0 : this.baseUrl.hashCode());
            result = 31 * result + (this.getHost() == null ? 0 : this.getHost().hashCode());
            result = 31 * result + this.getPort();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HttpClientAndBaseUrl other = (HttpClientAndBaseUrl)obj;
            if (this.baseUrl == null ? other.baseUrl != null : !this.baseUrl.equals(other.baseUrl)) {
                return false;
            }
            if (this.httpClient == null) {
                if (other.httpClient != null) {
                    return false;
                }
            } else {
                if (!this.getHost().equals(other.getHost())) {
                    return false;
                }
                if (this.getPort() != other.getPort()) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "HttpClientAndBaseUrl [getBaseUrl()=" + this.getBaseUrl() + ", getHost()=" + this.getHost() + ", getPort()=" + this.getPort() + "]";
        }
    }
}

