/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.tools.Tool;
import org.alfresco.tools.ToolArgumentException;
import org.alfresco.tools.ToolContext;
import org.alfresco.tools.ToolException;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenameUser
extends Tool {
    private static Log logger = LogFactory.getLog(RenameUser.class);
    protected RenameUserToolContext context;
    private boolean login = true;
    PersonService personService;
    NodeService nodeService;

    private PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = this.getServiceRegistry().getPersonService();
        }
        return this.personService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = this.getServiceRegistry().getNodeService();
        }
        return this.nodeService;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public static void main(String[] args) {
        RenameUser tool = new RenameUser();
        tool.start(args);
    }

    @Override
    protected ToolContext processArgs(String[] args) throws ToolArgumentException {
        this.context = new RenameUserToolContext();
        this.context.setLogin(this.login);
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-h") || args[i].equals("-help")) {
                this.context.setHelp(true);
                break;
            }
            if (args[i].equals("-user")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <user> for the option -user must be specified");
                }
                this.context.setUsername(args[i]);
            } else if (args[i].equals("-pwd")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <password> for the option -pwd must be specified");
                }
                this.context.setPassword(args[i]);
            } else if (args[i].equals("-encoding")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <encoding> for the option -encoding must be specified");
                }
                try {
                    this.context.encoding = Charset.forName(args[i]);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    throw new ToolArgumentException("The value <encoding> is not recognised");
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new ToolArgumentException("The value <encoding> is unsupported");
                }
            } else if (args[i].equals("-quiet")) {
                this.context.setQuiet(true);
            } else if (args[i].equals("-verbose")) {
                this.context.setVerbose(true);
            } else if (args[i].equals("-f") || args[i].equals("-file")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <filename> for the option -file must be specified");
                }
                this.context.setFilename(args[i]);
            } else if (!args[i].startsWith("-")) {
                String newUsername;
                if (++i == args.length || args[i - 1].trim().length() == 0 || args[i].trim().length() == 0) {
                    throw new ToolArgumentException("Both <oldUsername> <newUsername> must be specified");
                }
                if (this.context.userCount() > 0) {
                    throw new ToolArgumentException("Only one <oldUsername> <newUsername> pair may be specified on the command line. See the -file option");
                }
                String oldUsername = args[i - 1].trim();
                String error = this.context.add(-1, null, oldUsername, newUsername = args[i].trim());
                if (error != null) {
                    throw new ToolArgumentException(error);
                }
            } else {
                throw new ToolArgumentException("Unknown option " + args[i]);
            }
            ++i;
        }
        return this.context;
    }

    @Override
    protected void displayHelp() {
        this.logError("This tool provides minimal support for renaming users. It fixes");
        this.logError("authorities, group memberships and current zone (older versions");
        this.logError("still require a property change).");
        this.logError("");
        this.logError("WARNING: It does NOT change properties that store the username such");
        this.logError("         as (creator, modifier, lock owner or owner). Of these owner");
        this.logError("         and lock affect user rights. The username is also used");
        this.logError("         directly in workflow, for RM caveats, for Share invites and");
        this.logError("         auditing");
        this.logError("");
        this.logError("Usage: renameUser -user username [options] oldUsername newUsername");
        this.logError("       renameUser -user username [options] -file filename");
        this.logError("");
        this.logError("   username: username for login");
        this.logError("oldUsername: current username ");
        this.logError("newUsername: replacement username ");
        this.logError("");
        this.logError("Options:");
        this.logError(" -h[elp] display this help");
        this.logError(" -pwd password for login");
        this.logError(" -f[ile] csv file of old and new usernames");
        this.logError(" -encoding for source file (default: " + Charset.defaultCharset() + ")");
        this.logError(" -quiet do not display any messages during rename");
        this.logError(" -verbose report rename progress");
    }

    @Override
    protected String getToolName() {
        return "Alfresco Rename User";
    }

    @Override
    protected int execute() throws ToolException {
        final AtomicInteger status = new AtomicInteger(0);
        BatchProcessor.BatchProcessWorkerAdaptor<User> worker = new BatchProcessor.BatchProcessWorkerAdaptor<User>(){

            @Override
            public void process(final User user) throws Throwable {
                AuthenticationUtil.RunAsWork<Void> runAsWork = new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        try {
                            RenameUser.this.renameUser(user.getOldUsername(), user.getNewUsername());
                        }
                        catch (Throwable t) {
                            status.set(RenameUser.this.handleError(t));
                        }
                        return null;
                    }
                };
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)RenameUser.this.context.getUsername());
            }
        };
        BatchProcessor<User> processor = new BatchProcessor<User>("HomeFolderProviderSynchronizer", this.getServiceRegistry().getTransactionService().getRetryingTransactionHelper(), new WorkProvider(this.context), 2, 20, null, logger, 100);
        processor.process((BatchProcessor.BatchProcessWorker<User>)worker, true);
        return status.get();
    }

    private void renameUser(String oldUsername, String newUsername) {
        this.logInfo("\"" + oldUsername + "\" --> \"" + newUsername + "\"");
        try {
            NodeRef person = this.getPersonService().getPerson(oldUsername, false);
            AlfrescoTransactionSupport.bindResource((Object)"PersonServiceImpl.KEY_ALLOW_UID_UPDATE", (Object)Boolean.TRUE);
            this.getNodeService().setProperty(person, ContentModel.PROP_USERNAME, (Serializable)((Object)newUsername));
        }
        catch (NoSuchPersonException noSuchPersonException) {
            this.logError("User does not exist: " + oldUsername);
        }
    }

    public class RenameUserToolContext
    extends ToolContext {
        private List<User> usernames = new ArrayList<User>();
        private Set<String> uniqueNames = new HashSet<String>();
        private String filename;
        private Charset encoding = Charset.defaultCharset();

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String add(int lineNumber, String line, String oldUsername, String newUsername) {
            String error = null;
            if (oldUsername.equals(newUsername)) {
                error = "Old and new usernames are the same";
                if (line != null) {
                    error = "Error on line " + lineNumber + " (" + error + "): " + line;
                }
            } else if (this.uniqueNames.contains(oldUsername)) {
                error = "Old username already specified";
                if (line != null) {
                    error = "Error on line " + lineNumber + " (" + error + "): " + line;
                }
            } else if (this.uniqueNames.contains(newUsername)) {
                error = "New username already specified";
                if (line != null) {
                    error = "Error on line " + lineNumber + " (" + error + "): " + line;
                }
            } else {
                this.add(new User(oldUsername, newUsername));
            }
            return error;
        }

        private void add(User user) {
            this.usernames.add(user);
            this.uniqueNames.add(user.getOldUsername());
            this.uniqueNames.add(user.getNewUsername());
        }

        public int userCount() {
            return this.usernames.size();
        }

        public Iterator<User> iterator() {
            return this.usernames.iterator();
        }

        @Override
        void validate() {
            super.validate();
            if (this.filename != null) {
                if (this.userCount() > 0) {
                    throw new ToolArgumentException("<filename> should not have been specified if <oldUsername> <newUsername> has been specified on the command line.");
                }
                File file = new File(this.filename);
                if (!file.exists()) {
                    throw new ToolArgumentException("File " + this.filename + " does not exist.");
                }
                if (!this.readFile(file)) {
                    throw new ToolArgumentException("File " + this.filename + " contained errors.");
                }
            }
            if (this.userCount() == 0) {
                throw new ToolArgumentException("No old and new usernames have been specified.");
            }
        }

        private boolean readFile(File file) {
            BufferedReader in = null;
            boolean noErrors = true;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding.name()));
                    int lineNumber = 1;
                    String line = in.readLine();
                    while (line != null) {
                        int i = line.indexOf(35);
                        if (i != -1) {
                            line = line.substring(0, i);
                        }
                        if (line.trim().length() != 0) {
                            String[] names = line.split(",");
                            String oldUsername = names[0].trim();
                            String newUsername = names[1].trim();
                            if (names.length != 2 || oldUsername.length() == 0 || newUsername.length() == 0) {
                                RenameUser.this.logError("Error on line " + lineNumber + ": " + line);
                                noErrors = false;
                            } else {
                                String error = RenameUser.this.context.add(lineNumber, line, oldUsername, newUsername);
                                if (error != null) {
                                    RenameUser.this.logError(error);
                                    noErrors = false;
                                }
                            }
                        }
                        line = in.readLine();
                        ++lineNumber;
                    }
                }
                catch (IOException e) {
                    throw new ToolArgumentException("Failed to read <filename>.", e);
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return noErrors;
        }
    }

    public class User {
        private final String oldUsername;
        private final String newUsername;

        public User(String oldUsername, String newUsername) {
            this.oldUsername = oldUsername;
            this.newUsername = newUsername;
        }

        public String getOldUsername() {
            return this.oldUsername;
        }

        public String getNewUsername() {
            return this.newUsername;
        }
    }

    private class WorkProvider
    implements BatchProcessWorkProvider<User> {
        private static final int BATCH_SIZE = 100;
        private final VmShutdownListener vmShutdownLister = new VmShutdownListener("getRenameUserWorkProvider");
        private final Iterator<User> iterator;
        private final int size;

        public WorkProvider(RenameUserToolContext context) {
            this.iterator = context.iterator();
            this.size = context.userCount();
        }

        @Override
        public synchronized int getTotalEstimatedWorkSize() {
            return this.size;
        }

        @Override
        public synchronized long getTotalEstimatedWorkSizeLong() {
            return this.size;
        }

        @Override
        public synchronized Collection<User> getNextWork() {
            if (this.vmShutdownLister.isVmShuttingDown()) {
                return Collections.emptyList();
            }
            ArrayList<User> results = new ArrayList<User>(100);
            while (results.size() < 100 && this.iterator.hasNext()) {
                results.add(this.iterator.next());
            }
            return results;
        }
    }
}

