/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import jakarta.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class LanguagesTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private ServiceRegistry serviceRegistry;
    private UserTransaction txn;
    private NodeRef rootNodeRef;
    private NodeRef workingRootNodeRef;

    public void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        IntegrityChecker.setWarnInTransaction();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        StoreRef storeRef = this.nodeService.createStore("workspace", String.valueOf(this.getName()) + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.workingRootNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
    }

    public void tearDown() throws Exception {
        try {
            if (this.txn.getStatus() != 4 && this.txn.getStatus() != 3) {
                this.txn.rollback();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testCreateNodeInUTF8() throws Exception {
        String Czech1 = "Vytvo\u0159it slo\u017eku " + System.currentTimeMillis();
        String Czech2 = "Nov\u00e1 slo\u017eka " + System.currentTimeMillis();
        String Russian = "\u041d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c " + System.currentTimeMillis();
        String Japaneese = "\u65e5\u672c\u8a9e\u3067\u306e\u30bf\u30a4\u30c8\u30eb " + System.currentTimeMillis();
        this.testNodesCreating(new String[]{Czech1, Czech2});
        this.testNodesCreating(new String[]{Russian});
        this.testNodesCreating(new String[]{Japaneese});
    }

    private void testNodesCreating(String[] nodeNames) {
        String[] stringArray = nodeNames;
        int n = nodeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String node = stringArray[n2];
            this.fileFolderService.create(this.workingRootNodeRef, node, ContentModel.TYPE_CONTENT);
            ++n2;
        }
    }
}

