/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.quickshare;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionException;
import org.alfresco.repo.quickshare.QuickShareLinkExpiryActionImpl;
import org.alfresco.repo.quickshare.QuickShareServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.quickshare.InvalidSharedIdException;
import org.alfresco.service.cmr.quickshare.QuickShareDTO;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryAction;
import org.alfresco.service.cmr.quickshare.QuickShareLinkExpiryActionPersister;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporaryModels;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public class QuickShareServiceIntegrationTest {
    private static final ApplicationContextInit testContext = new ApplicationContextInit();
    private static final String MODEL = "<?xml version='1.0' encoding='UTF-8'?><model name='lx:lxmodel' xmlns='http://www.alfresco.org/model/dictionary/1.0'><description>LX model</description><author>Peter L\u00f6fgren</author><version>1.0</version><imports><import uri='http://www.alfresco.org/model/dictionary/1.0' prefix='d' /><import uri='http://www.alfresco.org/model/content/1.0' prefix='cm' /></imports><namespaces><namespace uri='http://bugtestmodel' prefix='lx' /></namespaces><constraints></constraints><types><type name='lx:doc'><title>LX dokument</title><parent>cm:content</parent><mandatory-aspects><aspect>cm:generalclassifiable</aspect></mandatory-aspects></type><type name='lx:doc2'><title>LX dokument 2</title><parent>cm:cmobject</parent></type></types></model>";
    private static CopyService copyService;
    private static NodeService nodeService;
    private static QuickShareService quickShareService;
    private static QuickShareService directQuickShareService;
    private static Repository repository;
    private static AttributeService attributeService;
    private static PermissionService permissionService;
    private static NodeArchiveService nodeArchiveService;
    private static ScheduledPersistedActionService scheduledPersistedActionService;
    private static QuickShareLinkExpiryActionPersister quickShareLinkExpiryActionPersister;
    private static RetryingTransactionHelper transactionHelper;
    private static Properties globalProperties;
    private static SiteService siteService;
    private static AlfrescoPerson user1;
    private static AlfrescoPerson user2;
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(testContext);
    @Rule
    public TemporaryModels temporaryModels = new TemporaryModels(testContext);
    @ClassRule
    public static RuleChain classChain;
    private NodeRef testNode;
    private NodeRef userHome;

    static {
        user1 = new AlfrescoPerson(testContext, "UserOne");
        user2 = new AlfrescoPerson(testContext, "UserTwo");
        classChain = RuleChain.outerRule((TestRule)testContext).around((TestRule)user1).around((TestRule)user2);
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        QuickShareServiceIntegrationTest.findServices();
    }

    private static void findServices() {
        ApplicationContext ctx = testContext.getApplicationContext();
        copyService = (CopyService)ctx.getBean("CopyService", CopyService.class);
        nodeService = (NodeService)ctx.getBean("NodeService", NodeService.class);
        directQuickShareService = (QuickShareService)ctx.getBean("quickShareService", QuickShareService.class);
        quickShareService = (QuickShareService)ctx.getBean("QuickShareService", QuickShareService.class);
        repository = (Repository)ctx.getBean("repositoryHelper", Repository.class);
        attributeService = (AttributeService)ctx.getBean("AttributeService", AttributeService.class);
        permissionService = (PermissionService)ctx.getBean("PermissionService", PermissionService.class);
        nodeArchiveService = (NodeArchiveService)ctx.getBean("nodeArchiveService", NodeArchiveService.class);
        scheduledPersistedActionService = (ScheduledPersistedActionService)ctx.getBean("scheduledPersistedActionService", ScheduledPersistedActionService.class);
        quickShareLinkExpiryActionPersister = (QuickShareLinkExpiryActionPersister)ctx.getBean("quickShareLinkExpiryActionPersister", QuickShareLinkExpiryActionPersister.class);
        transactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        globalProperties = (Properties)ctx.getBean("global-properties", Properties.class);
        siteService = (SiteService)ctx.getBean("SiteService");
    }

    @Before
    public void createTestData() {
        this.userHome = repository.getUserHome(user1.getPersonNode());
        this.testNode = this.testNodes.createNodeWithTextContent(this.userHome, "Quick Share Test Node", ContentModel.TYPE_CONTENT, user1.getUsername(), "Quick Share Test Node Content");
    }

    @After
    public void clearTestData() {
        if (this.testNode != null) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    nodeService.deleteNode(QuickShareServiceIntegrationTest.this.testNode);
                    return null;
                }
            }, (String)user1.getUsername());
        }
    }

    @Test
    public void getMetaDataFromNodeRefByOwner() {
        Map metadata = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                return quickShareService.getMetaData(QuickShareServiceIntegrationTest.this.testNode);
            }
        }, (String)user1.getUsername());
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((metadata.size() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=AccessDeniedException.class)
    public void getMetaDataFromNodeRefByNonOwner() {
        Map cfr_ignored_0 = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                return quickShareService.getMetaData(QuickShareServiceIntegrationTest.this.testNode);
            }
        }, (String)user2.getUsername());
    }

    @Test
    public void share() {
        this.share(this.testNode, user1.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertTrue((boolean)nodeService.getAspects(QuickShareServiceIntegrationTest.this.testNode).contains(QuickShareModel.ASPECT_QSHARE));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
                Assert.assertEquals((Object)user1.getUsername(), (Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDBY));
                return null;
            }
        });
    }

    @Test
    public void unshare() {
        QuickShareDTO dto = this.share(this.testNode, user1.getUsername());
        this.unshare(dto.getId(), user1.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertFalse((boolean)nodeService.getAspects(QuickShareServiceIntegrationTest.this.testNode).contains(QuickShareModel.ASPECT_QSHARE));
                Assert.assertNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
                Assert.assertNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDBY));
                return null;
            }
        });
    }

    @Test
    public void testDeleteAndRestoreSharedNode() {
        this.share(this.testNode, user1.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertTrue((boolean)nodeService.hasAspect(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.ASPECT_QSHARE));
                return null;
            }
        });
        this.testNode = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                nodeService.deleteNode(QuickShareServiceIntegrationTest.this.testNode);
                NodeRef archivedNode = nodeArchiveService.getArchivedNode(QuickShareServiceIntegrationTest.this.testNode);
                Assert.assertNotNull((Object)archivedNode);
                RestoreNodeReport restoreNodeReport = nodeArchiveService.restoreArchivedNode(archivedNode);
                Assert.assertNotNull((Object)restoreNodeReport);
                Assert.assertTrue((restoreNodeReport.getStatus() == RestoreNodeReport.RestoreStatus.SUCCESS ? 1 : 0) != 0);
                NodeRef restoredNodeRef = restoreNodeReport.getRestoredNodeRef();
                Assert.assertNotNull((Object)restoredNodeRef);
                return restoredNodeRef;
            }
        }, (String)user1.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertFalse((boolean)nodeService.hasAspect(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.ASPECT_QSHARE));
                Assert.assertNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
                Assert.assertNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDBY));
                return null;
            }
        });
        final QuickShareDTO dto = this.share(this.testNode, user1.getUsername());
        TenantUtil.runAsDefaultTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                attributeService.removeAttribute(new Serializable[]{".sharedIds", dto.getId()});
                return null;
            }
        });
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertTrue((boolean)nodeService.hasAspect(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.ASPECT_QSHARE));
                return null;
            }
        });
        try {
            this.unshare(dto.getId(), user2.getUsername());
            Assert.fail((String)"user2 shouldn't be able to un-share the node.");
        }
        catch (InvalidSharedIdException invalidSharedIdException) {}
        this.unshare(dto.getId(), user1.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertFalse((boolean)nodeService.hasAspect(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.ASPECT_QSHARE));
                return null;
            }
        });
    }

    private void unshare(final String sharedId, String userName) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                quickShareService.unshareContent(sharedId);
                return null;
            }
        }, (String)userName);
    }

    private QuickShareDTO share(NodeRef nodeRef, String username) {
        return this.share(nodeRef, username, null);
    }

    private QuickShareDTO share(NodeRef nodeRef, String username, Date expiryDate) {
        return (QuickShareDTO)AuthenticationUtil.runAs(() -> quickShareService.shareContent(nodeRef, expiryDate), (String)username);
    }

    @Test
    public void getMetadataFromShareId() {
        QuickShareDTO dto = this.share(this.testNode, user1.getUsername());
        Map metadata = quickShareService.getMetaData(dto.getId());
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((metadata.size() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=InvalidSharedIdException.class)
    public void getMetadataFromShareIdWithInvalidId() {
        UUID uuid = Generators.randomBasedGenerator().generate();
        String sharedId = Base64.encodeBase64URLSafeString((byte[])UUIDUtil.asByteArray((UUID)uuid));
        quickShareService.getMetaData(sharedId);
    }

    @Test
    public void copyNode() {
        this.share(this.testNode, user1.getUsername());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertTrue((boolean)nodeService.hasAspect(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.ASPECT_QSHARE));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDBY));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
                Map originalProps = nodeService.getProperties(QuickShareServiceIntegrationTest.this.testNode);
                NodeRef copyNodeRef = copyService.copyAndRename(QuickShareServiceIntegrationTest.this.testNode, QuickShareServiceIntegrationTest.this.userHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"copy"), true);
                Map copyProps = nodeService.getProperties(copyNodeRef);
                Assert.assertFalse((boolean)nodeService.hasAspect(copyNodeRef, QuickShareModel.ASPECT_QSHARE));
                Assert.assertNull((Object)nodeService.getProperty(copyNodeRef, QuickShareModel.PROP_QSHARE_SHAREDBY));
                Assert.assertNull((Object)nodeService.getProperty(copyNodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                for (QName property : originalProps.keySet()) {
                    if (property.equals((Object)QuickShareModel.PROP_QSHARE_SHAREDBY) || property.equals((Object)QuickShareModel.PROP_QSHARE_SHAREDID)) continue;
                    Assert.assertTrue((String)("Mising property " + property), (boolean)copyProps.containsKey(property));
                }
                return null;
            }
        }, (String)user1.getUsername());
    }

    @Test
    public void testWithCustomContentType() {
        ByteArrayInputStream modelStream = new ByteArrayInputStream(MODEL.getBytes());
        this.temporaryModels.loadModel(modelStream);
        QName sharableType = QName.createQName((String)"{http://bugtestmodel}doc");
        QName unsharableType = QName.createQName((String)"{http://bugtestmodel}doc2");
        NodeRef sharableNode = this.testNodes.createNodeWithTextContent(this.userHome, "Quick Share Custom Type Sharable Test Node", sharableType, user1.getUsername(), "Quick Share Test Node Content");
        Map<String, Object> metadata = this.getMetadata(sharableNode, user1);
        Assert.assertTrue((boolean)((Boolean)metadata.get("sharable")));
        QuickShareDTO dto = this.share(sharableNode, user1.getUsername());
        this.unshare(dto.getId(), user1.getUsername());
        NodeRef unsharableNode = this.testNodes.createNodeWithTextContent(this.userHome, "Quick Share Custom Type Unsharable Test Node", unsharableType, user1.getUsername(), "Quick Share Test Node Content");
        metadata = this.getMetadata(unsharableNode, user1);
        Assert.assertFalse((boolean)((Boolean)metadata.get("sharable")));
        boolean exceptionThrown = false;
        try {
            this.share(unsharableNode, user1.getUsername());
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"InvalidNodeRefException not thrown on trying to share an unsharable content type", (boolean)exceptionThrown);
    }

    private Map<String, Object> getMetadata(final NodeRef nodeRef, AlfrescoPerson user) {
        Map container = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                return quickShareService.getMetaData(nodeRef);
            }
        }, (String)user.getUsername());
        return (Map)container.get("item");
    }

    @Test
    public void cloud928() {
        final NodeRef node = this.testNodes.createNodeWithTextContent(this.userHome, "CLOUD-928 Test Node", ContentModel.TYPE_CONTENT, user1.getUsername(), "Quick Share Test Node Content");
        QuickShareDTO dto = this.share(node, user1.getUsername());
        attributeService.removeAttribute(new Serializable[]{".sharedIds", dto.getId()});
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                nodeService.deleteNode(node);
                return null;
            }
        }, (String)user1.getUsername());
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        NodeRef archivedNode = nodeArchiveService.getArchivedNode(node);
        Assert.assertNotNull((String)("Node " + node.toString() + " hasn't been archived hence the deletion was unsuccessful"), (Object)archivedNode);
    }

    @Test
    public void testModifierAfterSharing() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                permissionService.setPermission(QuickShareServiceIntegrationTest.this.testNode, user2.getUsername(), "Consumer", true);
                return null;
            }
        }, (String)user1.getUsername());
        final Serializable modifiedDate = (Serializable)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Serializable>(){

            public Serializable doWork() throws Exception {
                return nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, ContentModel.PROP_MODIFIED);
            }
        });
        this.share(this.testNode, user2.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertTrue((boolean)nodeService.getAspects(QuickShareServiceIntegrationTest.this.testNode).contains(ContentModel.ASPECT_AUDITABLE));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, ContentModel.PROP_MODIFIER));
                Assert.assertEquals((String)"The modifier has changed after sharing.", (Object)user1.getUsername(), (Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, ContentModel.PROP_MODIFIER));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, ContentModel.PROP_MODIFIED));
                Assert.assertEquals((String)"The modified date has changed after sharing.", (Object)modifiedDate, (Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, ContentModel.PROP_MODIFIED));
                return null;
            }
        });
    }

    @Test
    public void testModifierAfterUnSharing() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                permissionService.setPermission(QuickShareServiceIntegrationTest.this.testNode, user2.getUsername(), "Consumer", true);
                return null;
            }
        }, (String)user1.getUsername());
        QuickShareDTO dto = this.share(this.testNode, user1.getUsername());
        this.unshare(dto.getId(), user2.getUsername());
        String modifier = (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return (String)((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, ContentModel.PROP_MODIFIER));
            }
        });
        Assert.assertEquals((String)"The modifier has changed after sharing.", (Object)user1.getUsername(), (Object)modifier);
    }

    @Test
    public void testSharedLinkExpiryScheduling() throws Exception {
        int numOfSchedules = this.listSchedules();
        Date expiryDate = DateTime.now().plusDays(1).toDate();
        QuickShareDTO quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
        Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
        Assert.assertEquals((Object)quickShareDTO.getId(), (Object)this.getProperty(this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
        Assert.assertNotNull((Object)quickShareDTO.getExpiresAt());
        Assert.assertEquals((Object)expiryDate, (Object)quickShareDTO.getExpiresAt());
        QuickShareLinkExpiryAction expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
        Assert.assertEquals((Object)quickShareDTO.getId(), (Object)expiryAction.getSharedId());
        Assert.assertEquals((Object)quickShareDTO.getExpiresAt(), (Object)expiryAction.getScheduleStart());
        Assert.assertNull((String)"We haven't set interval count.", (Object)expiryAction.getScheduleIntervalCount());
        Assert.assertNull((String)"We haven't set interval period.", (Object)expiryAction.getScheduleIntervalPeriod());
        expiryDate = DateTime.now().plusDays(7).toDate();
        quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
        Assert.assertEquals((Object)expiryDate, (Object)quickShareDTO.getExpiresAt());
        Assert.assertEquals((Object)expiryDate, (Object)this.getProperty(this.testNode, QuickShareModel.PROP_QSHARE_EXPIRY_DATE));
        Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
        Assert.assertEquals((Object)quickShareDTO.getId(), (Object)this.getProperty(this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
        expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
        Assert.assertEquals((Object)quickShareDTO.getId(), (Object)expiryAction.getSharedId());
        Assert.assertEquals((Object)quickShareDTO.getExpiresAt(), (Object)expiryAction.getScheduleStart());
        Assert.assertNull((String)"We haven't set interval count.", (Object)expiryAction.getScheduleIntervalCount());
        Assert.assertNull((String)"We haven't set interval period.", (Object)expiryAction.getScheduleIntervalPeriod());
        this.deleteExpiryAction(expiryAction);
        QuickShareLinkExpiryAction deletedExpiryAction = this.getExpiryAction(quickShareDTO.getId());
        Assert.assertNull((Object)deletedExpiryAction);
        Assert.assertNull((Object)this.getProperty(this.testNode, QuickShareModel.PROP_QSHARE_EXPIRY_DATE));
        this.unshare(quickShareDTO.getId(), user1.getUsername());
        expiryDate = DateTime.now().plusDays(1).toDate();
        quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
        Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
        expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
        Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
        Assert.assertEquals((long)(numOfSchedules + 1), (long)this.listSchedules());
        expiryAction.setScheduleStart(DateTime.now().plusSeconds(5).toDate());
        this.forceSaveNewExpiryTime(expiryAction);
        Thread.sleep(10000L);
        Assert.assertFalse((boolean)this.hasQuickShareAspect(this.testNode));
        Assert.assertNull((Object)this.getProperty(this.testNode, QuickShareModel.PROP_QSHARE_EXPIRY_DATE));
        Assert.assertNull((Object)this.getExpiryAction(quickShareDTO.getId()));
        Assert.assertEquals((long)numOfSchedules, (long)this.listSchedules());
        expiryDate = DateTime.now().plusDays(1).toDate();
        quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
        Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
        expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
        Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
        AuthenticationUtil.runAs(() -> {
            nodeService.deleteNode(this.testNode);
            return null;
        }, (String)user1.getUsername());
        Assert.assertNull((Object)this.getExpiryAction(quickShareDTO.getId()));
        Assert.assertEquals((long)numOfSchedules, (long)this.listSchedules());
        AuthenticationUtil.runAs(() -> {
            NodeRef archivedNode = nodeArchiveService.getArchivedNode(this.testNode);
            RestoreNodeReport restoreNodeReport = nodeArchiveService.restoreArchivedNode(archivedNode);
            Assert.assertNotNull((Object)restoreNodeReport);
            Assert.assertTrue((restoreNodeReport.getStatus() == RestoreNodeReport.RestoreStatus.SUCCESS ? 1 : 0) != 0);
            this.testNode = restoreNodeReport.getRestoredNodeRef();
            return null;
        }, (String)user1.getUsername());
        Assert.assertFalse((boolean)this.hasQuickShareAspect(this.testNode));
        Assert.assertNull((Object)this.getExpiryAction(quickShareDTO.getId()));
        Assert.assertEquals((long)numOfSchedules, (long)this.listSchedules());
    }

    @Test
    public void testSharedLinkExpiryDateValidator() throws Exception {
        try {
            this.share(this.testNode, user1.getUsername(), DateTime.now().minusDays(1).toDate());
            Assert.fail((String)"Should have failed as the expiry date is invalid (passed time).");
        }
        catch (QuickShareLinkExpiryActionException.InvalidExpiryDateException invalidExpiryDateException) {}
        String defaultExpiryDatePeriod = globalProperties.getProperty("system.quickshare.expiry_date.enforce.minimum.period");
        try {
            ((QuickShareServiceImpl)directQuickShareService).setExpiryDatePeriod("DAYS");
            try {
                this.share(this.testNode, user1.getUsername(), DateTime.now().plusHours(1).toDate());
                Assert.fail((String)"Should have failed as the expiry date is invalid (less than 1 day).");
            }
            catch (QuickShareLinkExpiryActionException.InvalidExpiryDateException invalidExpiryDateException) {}
            try {
                this.share(this.testNode, user1.getUsername(), DateTime.now().plusMinutes(30).toDate());
                Assert.fail((String)"Should have failed as the expiry date is invalid (less than 1 day).");
            }
            catch (QuickShareLinkExpiryActionException.InvalidExpiryDateException invalidExpiryDateException) {}
            Date expiryDate = DateTime.now().plusHours(24).toDate();
            QuickShareDTO quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
            Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
            QuickShareLinkExpiryAction expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
            Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
            this.unshare(quickShareDTO.getId(), user1.getUsername());
            expiryDate = DateTime.now().plusYears(1).toDate();
            quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
            Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
            expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
            Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
            this.unshare(quickShareDTO.getId(), user1.getUsername());
            ((QuickShareServiceImpl)directQuickShareService).setExpiryDatePeriod("HOURS");
            try {
                this.share(this.testNode, user1.getUsername(), DateTime.now().plusMinutes(30).toDate());
                Assert.fail((String)"Should have failed as the expiry date is invalid (less than 1 hour).");
            }
            catch (QuickShareLinkExpiryActionException.InvalidExpiryDateException invalidExpiryDateException) {}
            expiryDate = DateTime.now().plusHours(1).toDate();
            quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
            Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
            expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
            Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
            this.unshare(quickShareDTO.getId(), user1.getUsername());
            expiryDate = DateTime.now().plusDays(2).toDate();
            quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
            Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
            expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
            Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
            this.unshare(quickShareDTO.getId(), user1.getUsername());
            ((QuickShareServiceImpl)directQuickShareService).setExpiryDatePeriod("MINUTES");
            try {
                this.share(this.testNode, user1.getUsername(), DateTime.now().plusSeconds(10).toDate());
                Assert.fail((String)"Should have failed as the expiry date is invalid (less than 1 minute).");
            }
            catch (QuickShareLinkExpiryActionException.InvalidExpiryDateException invalidExpiryDateException) {}
            expiryDate = DateTime.now().plusMinutes(5).toDate();
            quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
            Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
            expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
            Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
            this.unshare(quickShareDTO.getId(), user1.getUsername());
            expiryDate = DateTime.now().plusDays(60).toDate();
            quickShareDTO = this.share(this.testNode, user1.getUsername(), expiryDate);
            Assert.assertTrue((boolean)this.hasQuickShareAspect(this.testNode));
            expiryAction = this.getExpiryActionAndAttachSchedule(quickShareDTO.getId());
            Assert.assertEquals((Object)expiryDate, (Object)expiryAction.getScheduleStart());
            this.unshare(quickShareDTO.getId(), user1.getUsername());
        }
        finally {
            ((QuickShareServiceImpl)directQuickShareService).setExpiryDatePeriod(defaultExpiryDatePeriod);
        }
    }

    @Test
    public void testCanDeleteSharedLinkWithAdminUserForPrivateNodes() throws Exception {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)user1.getUsername());
            String randomUUID = Generators.randomBasedGenerator().generate().toString();
            String siteName = "testSite" + randomUUID;
            siteService.createSite("site-dashboard", siteName, "Title for " + siteName, "Description for " + siteName, SiteVisibility.PRIVATE);
            String nodeName = "testNode" + randomUUID;
            NodeRef nodeRefOnPrivateSite = this.testNodes.createNode(siteService.getSite(siteName).getNodeRef(), nodeName, ContentModel.TYPE_CONTENT, user1.getUsername());
            NodeRef nodeRefOnUserHome = this.testNodes.createNode(this.userHome, String.valueOf(nodeName) + "userHome", ContentModel.TYPE_CONTENT, user1.getUsername());
            AuthenticationUtil.setFullyAuthenticatedUser((String)"admin");
            boolean canDeleteSharedLink = this.userCanDeleteSharedLink(nodeRefOnPrivateSite, user1.getUsername());
            Assert.assertEquals((Object)true, (Object)canDeleteSharedLink);
            canDeleteSharedLink = this.userCanDeleteSharedLink(nodeRefOnUserHome, user1.getUsername());
            Assert.assertEquals((Object)true, (Object)canDeleteSharedLink);
            nodeService.deleteNode(nodeRefOnUserHome);
            siteService.deleteSite(siteName);
        }
        finally {
            if (currentUser != null) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)currentUser);
            } else {
                AuthenticationUtil.clearCurrentSecurityContext();
            }
        }
    }

    private QuickShareLinkExpiryAction getExpiryActionAndAttachSchedule(String sharedId) {
        QuickShareLinkExpiryAction expiryAction = this.getExpiryAction(sharedId);
        Assert.assertNotNull((Object)expiryAction);
        Assert.assertNotNull((String)"Expiry action should have been persisted.", (Object)expiryAction.getNodeRef());
        Assert.assertNull((String)"The schedule hasn't been attached yet.", (Object)expiryAction.getSchedule());
        ScheduledPersistedAction scheduledPersistedAction = this.getSchedule(expiryAction);
        Assert.assertNotNull((String)"Scheduled action should have been persisted.", (Object)scheduledPersistedAction);
        expiryAction.setSchedule(scheduledPersistedAction);
        return expiryAction;
    }

    private QuickShareLinkExpiryAction getExpiryAction(String sharedId) {
        return (QuickShareLinkExpiryAction)AuthenticationUtil.runAsSystem(() -> quickShareLinkExpiryActionPersister.loadQuickShareLinkExpiryAction(QuickShareLinkExpiryActionImpl.createQName((String)sharedId)));
    }

    private ScheduledPersistedAction getSchedule(QuickShareLinkExpiryAction linkExpiryAction) {
        return (ScheduledPersistedAction)AuthenticationUtil.runAsSystem(() -> scheduledPersistedActionService.getSchedule((Action)linkExpiryAction));
    }

    private int listSchedules() {
        return (Integer)AuthenticationUtil.runAsSystem(() -> scheduledPersistedActionService.listSchedules().size());
    }

    private void deleteExpiryAction(QuickShareLinkExpiryAction linkExpiryAction) {
        transactionHelper.doInTransaction(() -> {
            quickShareService.deleteQuickShareLinkExpiryAction(linkExpiryAction);
            return null;
        });
    }

    private boolean hasQuickShareAspect(NodeRef nodeRef) {
        return (Boolean)AuthenticationUtil.runAsSystem(() -> nodeService.hasAspect(nodeRef, QuickShareModel.ASPECT_QSHARE));
    }

    private Serializable getProperty(NodeRef nodeRef, QName property) {
        return (Serializable)AuthenticationUtil.runAsSystem(() -> nodeService.getProperty(nodeRef, property));
    }

    private void forceSaveNewExpiryTime(QuickShareLinkExpiryAction linkExpiryAction) {
        transactionHelper.doInTransaction(() -> {
            AuthenticationUtil.runAsSystem(() -> {
                quickShareLinkExpiryActionPersister.saveQuickShareLinkExpiryAction(linkExpiryAction);
                scheduledPersistedActionService.saveSchedule(linkExpiryAction.getSchedule());
                return null;
            });
            return null;
        });
    }

    private boolean userCanDeleteSharedLink(NodeRef nodeRef, String sharedByUserId) {
        return (Boolean)transactionHelper.doInTransaction(() -> quickShareService.canDeleteSharedLink(nodeRef, sharedByUserId));
    }
}

