/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.util.Map;
import java.util.Vector;
import java.util.function.Supplier;
import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceJITProvisioningHandler;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceRemoteUserMapper;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;

public class IdentityServiceRemoteUserMapperTest
extends TestCase {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_PREFIX = "Bearer ";

    public void testValidToken() {
        IdentityServiceRemoteUserMapper mapper = this.givenMapper(Map.of("VaLiD-ToKeN", () -> "johny"));
        HttpServletRequest mockRequest = this.createMockTokenRequest("VaLiD-ToKeN");
        String user = mapper.getRemoteUser(mockRequest);
        IdentityServiceRemoteUserMapperTest.assertEquals((String)"johny", (String)user);
    }

    public void testWrongTokenWithSilentValidation() {
        IdentityServiceRemoteUserMapper mapper = this.givenMapper(Map.of("WrOnG-ToKeN", () -> {
            throw new IdentityServiceFacade.TokenDecodingException("Expected ");
        }));
        mapper.setValidationFailureSilent(true);
        HttpServletRequest mockRequest = this.createMockTokenRequest("WrOnG-ToKeN");
        String user = mapper.getRemoteUser(mockRequest);
        IdentityServiceRemoteUserMapperTest.assertNull((Object)user);
    }

    public void testWrongTokenWithoutSilentValidation() {
        IdentityServiceRemoteUserMapper mapper = this.givenMapper(Map.of("WrOnG-ToKeN", () -> {
            throw new IdentityServiceFacade.TokenDecodingException("Expected");
        }));
        mapper.setValidationFailureSilent(false);
        HttpServletRequest mockRequest = this.createMockTokenRequest("WrOnG-ToKeN");
        Assertions.assertThatExceptionOfType(AuthenticationException.class).isThrownBy(() -> {
            String string = mapper.getRemoteUser(mockRequest);
        }).havingCause().withNoCause().withMessage("Expected");
    }

    private IdentityServiceRemoteUserMapper givenMapper(Map<String, Supplier<String>> tokenToUser) {
        TransactionService transactionService = (TransactionService)Mockito.mock(TransactionService.class);
        IdentityServiceFacade facade = (IdentityServiceFacade)Mockito.mock(IdentityServiceFacade.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        PersonService personService = (PersonService)Mockito.mock(PersonService.class);
        IdentityServiceConfig identityServiceConfig = (IdentityServiceConfig)Mockito.mock(IdentityServiceConfig.class);
        Mockito.when((Object)transactionService.isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)facade.decodeToken(ArgumentMatchers.anyString())).thenAnswer(i -> new TestDecodedToken((Supplier)tokenToUser.get(i.getArgument(0, String.class))));
        Mockito.when((Object)facade.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName()).thenReturn((Object)"preferred_username");
        Mockito.when((Object)personService.getUserIdentifier(ArgumentMatchers.anyString())).thenAnswer(i -> i.getArgument(0, String.class));
        IdentityServiceJITProvisioningHandler jitProvisioning = new IdentityServiceJITProvisioningHandler(facade, personService, transactionService, identityServiceConfig);
        IdentityServiceRemoteUserMapper mapper = new IdentityServiceRemoteUserMapper();
        mapper.setJitProvisioningHandler(jitProvisioning);
        mapper.setActive(true);
        mapper.setBearerTokenResolver((BearerTokenResolver)new DefaultBearerTokenResolver());
        return mapper;
    }

    private HttpServletRequest createMockTokenRequest(String token) {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Vector<String> authHeaderValues = new Vector<String>(1);
        if (token != null) {
            authHeaderValues.add(BEARER_PREFIX + token);
        }
        Mockito.when((Object)mockRequest.getHeaders(AUTHORIZATION_HEADER)).thenReturn(authHeaderValues.elements());
        Mockito.when((Object)mockRequest.getHeader(AUTHORIZATION_HEADER)).thenReturn(authHeaderValues.isEmpty() ? null : (String)authHeaderValues.get(0));
        return mockRequest;
    }

    private static class TestDecodedToken
    implements IdentityServiceFacade.DecodedAccessToken {
        private final Supplier<String> usernameSupplier;

        public TestDecodedToken(Supplier<String> usernameSupplier) {
            this.usernameSupplier = usernameSupplier;
        }

        public String getTokenValue() {
            return "TEST";
        }

        public Instant getExpiresAt() {
            return Instant.now();
        }

        public Object getClaim(String claim) {
            return "preferred_username".equals(claim) ? this.usernameSupplier.get() : null;
        }
    }
}

