/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.repo.transfer.ContentChunkProcessor;
import org.alfresco.repo.transfer.ContentChunkerImpl;
import org.alfresco.service.cmr.repository.ContentData;

public class ContentChunkerImplTest
extends TestCase {
    public void testContentChunkerImpl() throws Exception {
        ContentChunkerImpl chunker = new ContentChunkerImpl();
        final HashSet processedContent = new HashSet();
        chunker.setHandler(new ContentChunkProcessor(){

            public void processChunk(Set<ContentData> data) {
                processedContent.addAll(data);
            }
        });
        chunker.setChunkSize(10L);
        chunker.addContent(new ContentData(null, null, 20L, null));
        ContentChunkerImplTest.assertTrue((String)"size 20 not written immediatley", (processedContent.size() == 1 ? 1 : 0) != 0);
        processedContent.clear();
        chunker.addContent(new ContentData(null, null, 1L, null));
        ContentChunkerImplTest.assertTrue((String)"size 1 not buffered", (processedContent.size() == 0 ? 1 : 0) != 0);
        chunker.flush();
        ContentChunkerImplTest.assertTrue((String)"size 1 not flushed", (processedContent.size() == 1 ? 1 : 0) != 0);
        processedContent.clear();
        int i = 0;
        while (i < 11) {
            chunker.addContent(new ContentData("url" + i, null, 1L, null));
            ++i;
        }
        ContentChunkerImplTest.assertEquals((String)"size 10 not buffered", (int)processedContent.size(), (int)10);
        chunker.flush();
        ContentChunkerImplTest.assertTrue((String)"size 1 not flushed", (processedContent.size() == 11 ? 1 : 0) != 0);
        processedContent.clear();
        i = 0;
        while (i < 100) {
            chunker.addContent(new ContentData("url" + i, null, 3L, null));
            ++i;
        }
        chunker.flush();
        ContentChunkerImplTest.assertEquals((String)"size 100 not written", (int)processedContent.size(), (int)100);
    }
}

