/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.PlainStringifier;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.Stringifier;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Test;

public class ResourceParameterTest
extends TestCase {
    @Test
    public void testResourceParameter() throws Exception {
        RepositoryResource repoNodeRefResource = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef("workspace://SpacesStore/0029-222-333-444")));
        RepositoryResource repoPathResource = new RepositoryResource((RepositoryLocation)new RepositoryPath("/Foo/Bar"));
        ClasspathResource classpathResource = new ClasspathResource("/org/alfresco/");
        ResourceParameter repoNodeRefResourceParam = new ResourceParameter((Resource)repoNodeRefResource);
        ResourceParameter repoPathResourceParam = new ResourceParameter((Resource)repoPathResource);
        ResourceParameter classpathResourceParam = new ResourceParameter((Resource)classpathResource);
        ResourceParameterTest.assertEquals((Object)repoNodeRefResource, (Object)repoNodeRefResourceParam.getValue());
        String repoNodeRefResourceParamStrRepresentation = repoNodeRefResourceParam.stringify((Stringifier)new PlainStringifier());
        ResourceParameterTest.assertEquals((String)"r:repository:node:workspace:SpacesStore:0029-222-333-444", (String)repoNodeRefResourceParamStrRepresentation);
        ResourceParameterTest.assertEquals((Object)repoPathResource, (Object)repoPathResourceParam.getValue());
        String repoPathResourceParamStrRepresentation = repoPathResourceParam.stringify((Stringifier)new PlainStringifier());
        ResourceParameterTest.assertEquals((String)"r:repository:path:/Foo/Bar", (String)repoPathResourceParamStrRepresentation);
        ResourceParameterTest.assertEquals((Object)classpathResource, (Object)classpathResourceParam.getValue());
        String classpathResourceParamStrRepresentation = classpathResourceParam.stringify((Stringifier)new PlainStringifier());
        ResourceParameterTest.assertEquals((String)"r:classpath:/org/alfresco/", (String)classpathResourceParamStrRepresentation);
    }
}

