/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;

public class AspectParameterConstraint
extends BaseParameterConstraint {
    public static final String NAME = "ac-aspects";
    private DictionaryService dictionaryService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected Map<String, String> getAllowableValuesImpl() {
        Map<String, String> values = this.getValues();
        values.values().removeIf(Objects::isNull);
        return values;
    }

    @Override
    public Map<String, String> getValues() {
        return this.dictionaryService.getAllAspects().stream().collect(LinkedHashMap::new, (m, v) -> {
            String string = m.put(v.toPrefixString(), this.getTitle((QName)v));
        }, HashMap::putAll);
    }

    private String getTitle(QName aspect) {
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspect);
        return aspectDef != null ? aspectDef.getTitle((MessageLookup)this.dictionaryService) : null;
    }
}

