/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentExistsException;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRoutingContentStore
implements ContentStore {
    private static Log logger = LogFactory.getLog(AbstractRoutingContentStore.class);
    private String instanceKey = GUID.generate();
    private SimpleCache<Pair<String, String>, ContentStore> storesByContentUrl;
    private ReentrantReadWriteLock.ReadLock storesCacheReadLock;
    private ReentrantReadWriteLock.WriteLock storesCacheWriteLock;

    protected AbstractRoutingContentStore() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.storesCacheReadLock = lock.readLock();
        this.storesCacheWriteLock = lock.writeLock();
    }

    public void setStoresCache(SimpleCache<Pair<String, String>, ContentStore> storesCache) {
        this.storesByContentUrl = storesCache;
    }

    protected abstract List<ContentStore> getAllStores();

    protected abstract ContentStore selectWriteStore(ContentContext var1);

    private ContentStore selectReadStore(String contentUrl) {
        ContentStore store;
        Pair cacheKey;
        block18: {
            cacheKey = new Pair((Object)this.instanceKey, (Object)contentUrl);
            this.storesCacheReadLock.lock();
            try {
                store = (ContentStore)this.storesByContentUrl.get((Serializable)cacheKey);
                if (store == null) break block18;
                try {
                    if (store.exists(contentUrl)) {
                        ContentStore contentStore = store;
                        return contentStore;
                    }
                }
                catch (UnsupportedContentUrlException unsupportedContentUrlException) {
                    throw new AlfrescoRuntimeException("Found a content store that previously supported a URL, but no longer does: \n   Store:       " + store + "\n" + "   Content URL: " + contentUrl);
                }
            }
            finally {
                this.storesCacheReadLock.unlock();
            }
        }
        this.storesCacheWriteLock.lock();
        try {
            store = (ContentStore)this.storesByContentUrl.get((Serializable)cacheKey);
            if (store != null && store.exists(contentUrl)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found mapped store for content URL: \n   Content URL: " + contentUrl + "\n" + "   Store:       " + store));
                }
                ContentStore contentStore = store;
                return contentStore;
            }
            store = null;
            List<ContentStore> stores = this.getAllStores();
            boolean contentUrlSupported = false;
            for (ContentStore storeInList : stores) {
                boolean exists = false;
                try {
                    exists = storeInList.exists(contentUrl);
                    contentUrlSupported = true;
                }
                catch (UnsupportedContentUrlException unsupportedContentUrlException) {}
                if (!exists) continue;
                store = storeInList;
                this.storesByContentUrl.put((Serializable)cacheKey, (Object)store);
                break;
            }
            if (!contentUrlSupported) {
                throw new UnsupportedContentUrlException(this, contentUrl);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mapped content URL to store for reading: \n   Content URL: " + contentUrl + "\n" + "   Store:       " + store));
            }
            ContentStore contentStore = store;
            return contentStore;
        }
        finally {
            this.storesCacheWriteLock.unlock();
        }
    }

    public boolean isContentUrlSupported(String contentUrl) {
        List<ContentStore> stores = this.getAllStores();
        boolean supported = false;
        for (ContentStore store : stores) {
            if (!store.isContentUrlSupported(contentUrl)) continue;
            supported = true;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The url " + (supported ? "is" : "is not") + " supported by at least one store."));
        }
        return supported;
    }

    public boolean isWriteSupported() {
        List<ContentStore> stores = this.getAllStores();
        boolean supported = false;
        for (ContentStore store : stores) {
            if (!store.isWriteSupported()) continue;
            supported = true;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing " + (supported ? "is" : "is not") + " supported by at least one store."));
        }
        return supported;
    }

    public String getRootLocation() {
        return ".";
    }

    public long getSpaceFree() {
        return -1L;
    }

    public long getSpaceTotal() {
        return -1L;
    }

    public boolean exists(String contentUrl) throws ContentIOException {
        ContentStore store = this.selectReadStore(contentUrl);
        return store != null;
    }

    public ContentReader getReader(String contentUrl) throws ContentIOException {
        ContentStore store = this.selectReadStore(contentUrl);
        if (store != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting reader from store: \n   Content URL: " + contentUrl + "\n" + "   Store:       " + store));
            }
            return store.getReader(contentUrl);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting empty reader for content URL: " + contentUrl));
        }
        return new EmptyContentReader(contentUrl);
    }

    public ContentWriter getWriter(ContentContext context) throws ContentIOException {
        ContentStore store;
        String contentUrl = context.getContentUrl();
        Pair cacheKey = new Pair((Object)this.instanceKey, (Object)contentUrl);
        if (contentUrl != null) {
            this.storesCacheReadLock.lock();
            try {
                store = (ContentStore)this.storesByContentUrl.get((Serializable)cacheKey);
                if (store != null) {
                    throw new ContentExistsException(this, contentUrl);
                }
            }
            finally {
                this.storesCacheReadLock.unlock();
            }
        }
        if ((store = this.selectWriteStore(context)) == null) {
            throw new NullPointerException("Unable to find a writer.  'selectWriteStore' may not return null: \n   Router: " + this + "\n" + "   Chose:  " + store);
        }
        if (!store.isWriteSupported()) {
            throw new AlfrescoRuntimeException("A write store was chosen that doesn't support writes: \n   Router: " + this + "\n" + "   Chose:  " + store);
        }
        ContentWriter writer = store.getWriter(context);
        String newContentUrl = writer.getContentUrl();
        Pair newCacheKey = new Pair((Object)this.instanceKey, (Object)newContentUrl);
        this.storesCacheWriteLock.lock();
        try {
            this.storesByContentUrl.put((Serializable)newCacheKey, (Object)store);
        }
        finally {
            this.storesCacheWriteLock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got writer and cache URL from store: \n   Context: " + context + "\n" + "   Writer:  " + writer + "\n" + "   Store:   " + store));
        }
        return writer;
    }

    public ContentWriter getWriter(ContentReader existingContentReader, String newContentUrl) throws ContentIOException {
        return this.getWriter(new ContentContext(existingContentReader, newContentUrl));
    }

    public boolean delete(String contentUrl) throws ContentIOException {
        boolean deleted = true;
        List<ContentStore> stores = this.getAllStores();
        for (ContentStore store : stores) {
            if (!store.isWriteSupported()) continue;
            deleted &= store.delete(contentUrl);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted content URL from stores: \n   Stores:  " + stores.size() + "\n" + "   Deleted: " + deleted));
        }
        return deleted;
    }

    public Map<String, String> getStorageProperties(String contentUrl) {
        ContentStore contentStore = this.selectReadStore(contentUrl);
        if (contentStore == null) {
            this.logNoContentStore(contentUrl);
            return Collections.emptyMap();
        }
        this.logExecution(contentUrl, contentStore, "Getting storage properties from store: ");
        return contentStore.getStorageProperties(contentUrl);
    }

    public boolean requestSendContentToArchive(String contentUrl, Map<String, Serializable> archiveParams) {
        ContentStore contentStore = this.selectReadStore(contentUrl);
        if (contentStore == null) {
            this.logNoContentStore(contentUrl);
            return super.requestSendContentToArchive(contentUrl, archiveParams);
        }
        this.logExecution(contentUrl, contentStore, "Sending content to archive: ");
        return contentStore.requestSendContentToArchive(contentUrl, archiveParams);
    }

    public boolean requestRestoreContentFromArchive(String contentUrl, Map<String, Serializable> restoreParams) {
        ContentStore contentStore = this.selectReadStore(contentUrl);
        if (contentStore == null) {
            this.logNoContentStore(contentUrl);
            return super.requestRestoreContentFromArchive(contentUrl, restoreParams);
        }
        this.logExecution(contentUrl, contentStore, "Restoring content from archive: ");
        return super.requestRestoreContentFromArchive(contentUrl, restoreParams);
    }

    private void logExecution(String contentUrl, ContentStore contentStore, String message) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(String.valueOf(message) + "\n" + "   Content URL: " + contentUrl + "\n" + "   Store:       " + contentStore));
        }
    }

    private void logNoContentStore(String contentUrl) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Content Store not found for content URL: " + contentUrl));
        }
    }
}

