/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public abstract class AbstractCopyBehaviourCallback
implements CopyBehaviourCallback {
    private static final String KEY_NODEREF_REPOINTING_PREFIX = "recordNodeRefPropertiesForRepointing-";

    @Override
    public Pair<CopyBehaviourCallback.AssocCopySourceAction, CopyBehaviourCallback.AssocCopyTargetAction> getAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyAssociationDetails assocCopyDetails) {
        return new Pair((Object)CopyBehaviourCallback.AssocCopySourceAction.COPY_REMOVE_EXISTING, (Object)CopyBehaviourCallback.AssocCopyTargetAction.USE_COPIED_TARGET);
    }

    @Override
    public CopyBehaviourCallback.ChildAssocRecurseAction getChildAssociationRecurseAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
        return CopyBehaviourCallback.ChildAssocRecurseAction.RESPECT_RECURSE_FLAG;
    }

    protected void throwExceptionForUnexpectedBehaviour(CopyDetails copyDetails, String ... otherDetails) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("Behaviour should have been invoked: \n   Aspect: " + this.getClass().getName() + "\n" + "   " + copyDetails + "\n");
        String[] stringArray = otherDetails;
        int n = otherDetails.length;
        int n2 = 0;
        while (n2 < n) {
            String otherDetail = stringArray[n2];
            sb.append("   ").append(otherDetail).append("\n");
            ++n2;
        }
        throw new IllegalStateException(sb.toString());
    }

    public void recordNodeRefsForRepointing(NodeRef sourceNodeRef, Map<QName, Serializable> properties, QName propertyQName) {
        Serializable parameterValue = properties.get(propertyQName);
        if (parameterValue != null && (parameterValue instanceof Collection || parameterValue instanceof NodeRef)) {
            String key = KEY_NODEREF_REPOINTING_PREFIX + propertyQName.toString();
            Map<NodeRef, Serializable> map = TransactionalResourceHelper.getMap(key);
            map.put(sourceNodeRef, parameterValue);
        }
    }

    public void repointNodeRefs(NodeRef sourceNodeRef, NodeRef targetNodeRef, QName propertyQName, Map<NodeRef, NodeRef> copyMap, NodeService nodeService) {
        String key = KEY_NODEREF_REPOINTING_PREFIX + propertyQName.toString();
        Map map = TransactionalResourceHelper.getMap(key);
        Serializable value = (Serializable)map.get(sourceNodeRef);
        if (value == null) {
            return;
        }
        Object newValue = null;
        if (value instanceof Collection) {
            Collection oldList = (Collection)((Object)value);
            ArrayList<Serializable> newList = new ArrayList<Serializable>(oldList.size());
            Iterator iterator = oldList.iterator();
            while (iterator.hasNext()) {
                Serializable oldListValue;
                Serializable newListValue = oldListValue = (Serializable)iterator.next();
                if (oldListValue instanceof NodeRef) {
                    newListValue = this.repointNodeRef(copyMap, (NodeRef)oldListValue);
                }
                newList.add(newListValue);
                if (newListValue.equals(oldListValue)) continue;
                newValue = newList;
            }
        } else if (value instanceof NodeRef) {
            NodeRef newNodeRef = this.repointNodeRef(copyMap, (NodeRef)value);
            if (!newNodeRef.equals((Object)value)) {
                newValue = newNodeRef;
            }
        } else {
            throw new IllegalStateException("Should only have Collections and NodeRef values");
        }
        if (newValue != null) {
            nodeService.setProperty(targetNodeRef, propertyQName, (Serializable)newValue);
        }
    }

    private NodeRef repointNodeRef(Map<NodeRef, NodeRef> copyMap, NodeRef pointerNodeRef) {
        NodeRef copiedPointerNodeRef = copyMap.get(pointerNodeRef);
        if (copiedPointerNodeRef == null) {
            return pointerNodeRef;
        }
        return copiedPointerNodeRef;
    }

    @Override
    public boolean isTopLevelCanBeRenamed(QName classQName, CopyDetails copyDetails) {
        return false;
    }
}

