/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.permissions.ACEType;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.SimpleAccessControlEntry;
import org.alfresco.repo.security.permissions.SimpleAccessControlListProperties;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.repo.security.permissions.impl.PermissionsDaoComponent;
import org.alfresco.repo.security.permissions.impl.SimpleNodePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractPermissionsDaoComponentImpl
implements PermissionsDaoComponent {
    private static Log logger = LogFactory.getLog(AbstractPermissionsDaoComponentImpl.class);
    protected static final boolean INHERIT_PERMISSIONS_DEFAULT = true;
    protected AclDAO aclDaoComponent;
    private Map<String, AccessControlListDAO> fProtocolToACLDAO;
    private AccessControlListDAO fDefaultACLDAO;
    private String uuid = GUID.generate();

    AbstractPermissionsDaoComponentImpl() {
    }

    public void setAclDAO(AclDAO aclDaoComponent) {
        this.aclDaoComponent = aclDaoComponent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractPermissionsDaoComponentImpl)) {
            return false;
        }
        AbstractPermissionsDaoComponentImpl that = (AbstractPermissionsDaoComponentImpl)obj;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public void setProtocolToACLDAO(Map<String, AccessControlListDAO> map) {
        this.fProtocolToACLDAO = map;
    }

    public void setDefaultACLDAO(AccessControlListDAO defaultACLDAO) {
        this.fDefaultACLDAO = defaultACLDAO;
    }

    protected AccessControlListDAO getACLDAO(NodeRef nodeRef) {
        AccessControlListDAO ret = this.fProtocolToACLDAO.get(nodeRef.getStoreRef().getProtocol());
        if (ret == null) {
            return this.fDefaultACLDAO;
        }
        return ret;
    }

    protected Acl getAccessControlList(NodeRef nodeRef) {
        return this.getACLDAO(nodeRef).getAccessControlList(nodeRef);
    }

    protected CreationReport getMutableAccessControlList(NodeRef nodeRef) {
        Acl acl = this.getACLDAO(nodeRef).getAccessControlList(nodeRef);
        if (acl == null) {
            return this.createAccessControlList(nodeRef, true, null);
        }
        switch (acl.getAclType()) {
            case SHARED: 
            case FIXED: 
            case GLOBAL: 
            case LAYERED: {
                return this.createAccessControlList(nodeRef, true, acl);
            }
        }
        this.getACLDAO(nodeRef).forceCopy(nodeRef);
        acl = this.getACLDAO(nodeRef).getAccessControlList(nodeRef);
        return new CreationReport(acl, Collections.emptyList());
    }

    @Override
    public NodePermissionEntry getPermissions(NodeRef nodeRef) {
        SimpleNodePermissionEntry snpe;
        SimpleNodePermissionEntry npe = null;
        Acl acl = null;
        try {
            acl = this.getAccessControlList(nodeRef);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
        npe = acl == null ? (snpe = new SimpleNodePermissionEntry(nodeRef, true, Collections.emptyList())) : this.createSimpleNodePermissionEntry(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got NodePermissionEntry for node: \n   node: " + nodeRef + "\n" + "   acl: " + npe));
        }
        return npe;
    }

    public Map<NodeRef, Set<AccessPermission>> getAllSetPermissions(String authority) {
        throw new UnsupportedOperationException();
    }

    public Set<NodeRef> findNodeByPermission(String authority, PermissionReference permission, boolean allow) {
        throw new UnsupportedOperationException();
    }

    private SimpleNodePermissionEntry createSimpleNodePermissionEntry(NodeRef nodeRef) {
        Acl acl = this.getACLDAO(nodeRef).getAccessControlList(nodeRef);
        if (acl == null) {
            SimpleNodePermissionEntry snpe = new SimpleNodePermissionEntry(nodeRef, true, Collections.emptyList());
            return snpe;
        }
        AccessControlList info = this.aclDaoComponent.getAccessControlList(acl.getId());
        SimpleNodePermissionEntry cached = info.getCachedSimpleNodePermissionEntry();
        if (cached != null) {
            return cached;
        }
        ArrayList<SimplePermissionEntry> spes = new ArrayList<SimplePermissionEntry>(info.getEntries().size());
        for (AccessControlEntry entry : info.getEntries()) {
            SimplePermissionEntry spe = new SimplePermissionEntry(nodeRef, entry.getPermission(), entry.getAuthority(), entry.getAccessStatus(), entry.getPosition());
            spes.add(spe);
        }
        SimpleNodePermissionEntry snpe = new SimpleNodePermissionEntry(nodeRef, acl.getInherits(), spes);
        info.setCachedSimpleNodePermissionEntry(snpe);
        return snpe;
    }

    private SimpleNodePermissionEntry createSimpleNodePermissionEntry(StoreRef storeRef) {
        Acl acl = this.getACLDAO(storeRef).getAccessControlList(storeRef);
        if (acl == null) {
            SimpleNodePermissionEntry snpe = new SimpleNodePermissionEntry(null, true, Collections.emptyList());
            return snpe;
        }
        AccessControlList info = this.aclDaoComponent.getAccessControlList(acl.getId());
        ArrayList<SimplePermissionEntry> spes = new ArrayList<SimplePermissionEntry>(info.getEntries().size());
        for (AccessControlEntry entry : info.getEntries()) {
            SimplePermissionEntry spe = new SimplePermissionEntry(null, entry.getPermission(), entry.getAuthority(), entry.getAccessStatus(), entry.getPosition());
            spes.add(spe);
        }
        SimpleNodePermissionEntry snpe = new SimpleNodePermissionEntry(null, acl.getInherits(), spes);
        return snpe;
    }

    @Override
    public boolean getInheritParentPermissions(NodeRef nodeRef) {
        Acl acl = null;
        try {
            acl = this.getAccessControlList(nodeRef);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return true;
        }
        if (acl == null) {
            return true;
        }
        return this.aclDaoComponent.getAccessControlListProperties(acl.getId()).getInherits();
    }

    @Override
    public void deletePermissions(String authority) {
        this.aclDaoComponent.deleteAccessControlEntries(authority);
    }

    @Override
    public void deletePermissions(NodeRef nodeRef, String authority) {
        Acl acl = null;
        try {
            AccessControlListDAO aclDAO = this.getACLDAO(nodeRef);
            if (aclDAO == null) {
                return;
            }
            acl = aclDAO.getAccessControlList(nodeRef);
            if (acl == null) {
                return;
            }
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return;
        }
        switch (acl.getAclType()) {
            case FIXED: 
            case GLOBAL: {
                throw new IllegalStateException("Can not delete from this acl in a node context " + (Object)((Object)acl.getAclType()));
            }
            case SHARED: {
                break;
            }
            default: {
                CreationReport report = this.getMutableAccessControlList(nodeRef);
                SimpleAccessControlEntry pattern = new SimpleAccessControlEntry();
                pattern.setAuthority(authority);
                pattern.setPosition(0);
                List<AclChange> changes = this.aclDaoComponent.deleteAccessControlEntries(report.getCreated().getId(), pattern);
                this.getACLDAO(nodeRef).updateChangedAcls(nodeRef, changes);
            }
        }
    }

    @Override
    public void deletePermission(NodeRef nodeRef, String authority, PermissionReference permission) {
        Acl acl = null;
        try {
            AccessControlListDAO aclDAO = this.getACLDAO(nodeRef);
            if (aclDAO == null) {
                return;
            }
            acl = aclDAO.getAccessControlList(nodeRef);
            if (acl == null) {
                return;
            }
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return;
        }
        if (acl == null) {
            return;
        }
        switch (acl.getAclType()) {
            case SHARED: 
            case FIXED: 
            case GLOBAL: {
                throw new IllegalStateException("Can not delete from this acl in a node context " + (Object)((Object)acl.getAclType()));
            }
        }
        CreationReport report = this.getMutableAccessControlList(nodeRef);
        SimpleAccessControlEntry pattern = new SimpleAccessControlEntry();
        pattern.setAuthority(authority);
        pattern.setPermission(permission);
        pattern.setPosition(0);
        List<AclChange> changes = this.aclDaoComponent.deleteAccessControlEntries(report.getCreated().getId(), pattern);
        this.getACLDAO(nodeRef).updateChangedAcls(nodeRef, changes);
    }

    @Override
    public void setPermission(NodeRef nodeRef, String authority, PermissionReference permission, boolean allow) {
        CreationReport report = null;
        try {
            report = this.getMutableAccessControlList(nodeRef);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return;
        }
        if (report.getCreated() != null) {
            SimpleAccessControlEntry entry = new SimpleAccessControlEntry();
            entry.setAuthority(authority);
            entry.setPermission(permission);
            entry.setAccessStatus(allow ? AccessStatus.ALLOWED : AccessStatus.DENIED);
            entry.setAceType(ACEType.ALL);
            entry.setPosition(0);
            List<AclChange> changes = this.aclDaoComponent.setAccessControlEntry(report.getCreated().getId(), entry);
            ArrayList<AclChange> all = new ArrayList<AclChange>(changes.size() + report.getChanges().size());
            all.addAll(report.getChanges());
            all.addAll(changes);
            this.getACLDAO(nodeRef).updateChangedAcls(nodeRef, all);
        }
    }

    @Override
    public void setPermission(PermissionEntry permissionEntry) {
        this.setPermission(permissionEntry.getNodeRef(), permissionEntry.getAuthority(), permissionEntry.getPermissionReference(), permissionEntry.isAllowed());
    }

    @Override
    public void setPermission(NodePermissionEntry nodePermissionEntry) {
        NodeRef nodeRef = nodePermissionEntry.getNodeRef();
        Acl existing = this.getAccessControlList(nodeRef);
        if (existing != null) {
            this.deletePermissions(nodeRef);
        }
        existing = this.getAccessControlList(nodeRef);
        CreationReport report = this.createAccessControlList(nodeRef, nodePermissionEntry.inheritPermissions(), existing);
        for (PermissionEntry permissionEntry : nodePermissionEntry.getPermissionEntries()) {
            SimpleAccessControlEntry entry = new SimpleAccessControlEntry();
            entry.setAuthority(permissionEntry.getAuthority());
            entry.setPermission(permissionEntry.getPermissionReference());
            entry.setAccessStatus(permissionEntry.isAllowed() ? AccessStatus.ALLOWED : AccessStatus.DENIED);
            entry.setAceType(ACEType.ALL);
            entry.setPosition(0);
            List<AclChange> changes = this.aclDaoComponent.setAccessControlEntry(report.getCreated().getId(), entry);
            ArrayList<AclChange> all = new ArrayList<AclChange>(changes.size() + report.getChanges().size());
            all.addAll(report.getChanges());
            all.addAll(changes);
            this.getACLDAO(nodeRef).updateChangedAcls(nodeRef, all);
        }
    }

    @Override
    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
        List<AclChange> changes;
        Acl acl = this.getAccessControlList(nodeRef);
        if (acl == null && inheritParentPermissions) {
            return;
        }
        if (acl != null && acl.getInherits() == inheritParentPermissions) {
            return;
        }
        CreationReport report = this.getMutableAccessControlList(nodeRef);
        if (!inheritParentPermissions) {
            changes = this.aclDaoComponent.disableInheritance(report.getCreated().getId(), false);
        } else {
            Long parentAcl = this.getACLDAO(nodeRef).getInheritedAcl(nodeRef);
            changes = this.aclDaoComponent.enableInheritance(report.getCreated().getId(), parentAcl);
        }
        ArrayList<AclChange> all = new ArrayList<AclChange>(changes.size() + report.getChanges().size());
        all.addAll(report.getChanges());
        all.addAll(changes);
        this.getACLDAO(nodeRef).updateChangedAcls(nodeRef, all);
    }

    @Override
    public void deletePermission(StoreRef storeRef, String authority, PermissionReference permission) {
        Acl acl = this.getAccessControlList(storeRef);
        if (acl == null) {
            return;
        }
        acl = this.getMutableAccessControlList(storeRef);
        SimpleAccessControlEntry pattern = new SimpleAccessControlEntry();
        pattern.setAuthority(authority);
        pattern.setPermission(permission);
        pattern.setPosition(0);
        this.aclDaoComponent.deleteAccessControlEntries(acl.getId(), pattern);
    }

    private Acl getMutableAccessControlList(StoreRef storeRef) {
        Acl acl = this.getACLDAO(storeRef).getAccessControlList(storeRef);
        if (acl == null) {
            SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
            properties.setAclType(ACLType.DEFINING);
            properties.setInherits(false);
            properties.setVersioned(false);
            acl = this.aclDaoComponent.createAccessControlList(properties);
            this.getACLDAO(storeRef).setAccessControlList(storeRef, acl);
        }
        return acl;
    }

    private AccessControlListDAO getACLDAO(StoreRef storeRef) {
        AccessControlListDAO ret = this.fProtocolToACLDAO.get(storeRef.getProtocol());
        if (ret == null) {
            return this.fDefaultACLDAO;
        }
        return ret;
    }

    private Acl getAccessControlList(StoreRef storeRef) {
        return this.getACLDAO(storeRef).getAccessControlList(storeRef);
    }

    @Override
    public void deletePermissions(StoreRef storeRef, String authority) {
        Acl acl = this.getAccessControlList(storeRef);
        if (acl == null) {
            return;
        }
        acl = this.getMutableAccessControlList(storeRef);
        SimpleAccessControlEntry pattern = new SimpleAccessControlEntry();
        pattern.setAuthority(authority);
        pattern.setPosition(0);
        this.aclDaoComponent.deleteAccessControlEntries(acl.getId(), pattern);
    }

    @Override
    public void deletePermissions(StoreRef storeRef) {
        this.getACLDAO(storeRef).setAccessControlList(storeRef, null);
    }

    @Override
    public void setPermission(StoreRef storeRef, String authority, PermissionReference permission, boolean allow) {
        Acl acl = this.getMutableAccessControlList(storeRef);
        SimpleAccessControlEntry entry = new SimpleAccessControlEntry();
        entry.setAuthority(authority);
        entry.setPermission(permission);
        entry.setAccessStatus(allow ? AccessStatus.ALLOWED : AccessStatus.DENIED);
        entry.setAceType(ACEType.ALL);
        entry.setPosition(0);
        this.aclDaoComponent.setAccessControlEntry(acl.getId(), entry);
    }

    @Override
    public NodePermissionEntry getPermissions(StoreRef storeRef) {
        SimpleNodePermissionEntry snpe;
        SimpleNodePermissionEntry npe = null;
        Acl acl = null;
        try {
            acl = this.getAccessControlList(storeRef);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
        npe = acl == null ? (snpe = new SimpleNodePermissionEntry(null, true, Collections.emptyList())) : this.createSimpleNodePermissionEntry(storeRef);
        return npe;
    }

    @Override
    public AccessControlListProperties getAccessControlListProperties(NodeRef nodeRef) {
        Acl acl = this.getACLDAO(nodeRef).getAccessControlList(nodeRef);
        if (acl == null) {
            return null;
        }
        return this.aclDaoComponent.getAccessControlListProperties(acl.getId());
    }

    protected abstract CreationReport createAccessControlList(NodeRef var1, boolean var2, Acl var3);

    static class CreationReport {
        Acl created;
        List<AclChange> changes;

        CreationReport(Acl created, List<AclChange> changes) {
            this.created = created;
            this.changes = changes;
        }

        public void setChanges(List<AclChange> changes) {
            this.changes = changes;
        }

        public void setCreated(Acl created) {
            this.created = created;
        }

        public List<AclChange> getChanges() {
            return this.changes;
        }

        public Acl getCreated() {
            return this.created;
        }
    }
}

