/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;

public class MultiTNodeServiceInterceptor
extends DelegatingIntroductionInterceptor {
    private static final long serialVersionUID = -5462852271914961462L;
    private static Log logger = LogFactory.getLog(MultiTNodeServiceInterceptor.class);
    private static ThreadLocal<Boolean> ignoreMT = new ThreadLocal();
    private TenantService tenantService;

    public static boolean setIgnoreMT(boolean ignoreMT) {
        boolean wasIgnoreMT = MultiTNodeServiceInterceptor.isIgnoreMT();
        MultiTNodeServiceInterceptor.ignoreMT.set(ignoreMT);
        return wasIgnoreMT;
    }

    public static boolean isIgnoreMT() {
        if (ignoreMT.get() == null) {
            return false;
        }
        return ignoreMT.get();
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object rawValues;
        if (!AuthenticationUtil.isMtEnabled()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("MT is not enabled - skipping interception for method " + invocation.getMethod().getName()));
            }
            return invocation.proceed();
        }
        String methodName = invocation.getMethod().getName();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Intercepting method " + methodName));
        }
        Object[] args = invocation.getArguments();
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            Object newArg = this.convertInboundValue(arg);
            if (logger.isTraceEnabled() && !EqualsHelper.nullSafeEquals((Object)newArg, (Object)arg)) {
                logger.trace((Object)("Argument converted: \n   Before: " + arg + "\n" + "   After:  " + newArg));
            }
            args[i] = newArg;
            ++i;
        }
        Object ret = null;
        try {
            ret = invocation.proceed();
        }
        catch (InvalidNodeRefException inre) {
            throw new InvalidNodeRefException("Failed invocation: " + invocation, this.tenantService.getBaseName(inre.getNodeRef()), (Throwable)inre);
        }
        if (methodName.equals("getProperty")) {
            if (ret != null) {
                QName qname = (QName)args[1];
                if (qname.equals((Object)ContentModel.PROP_STORE_IDENTIFIER)) {
                    String rawStoreId = (String)ret;
                    ret = this.tenantService.getBaseName(rawStoreId);
                } else if (qname.equals((Object)ContentModel.PROP_CREATOR) || qname.equals((Object)ContentModel.PROP_MODIFIER) || qname.equals((Object)ContentModel.PROP_OWNER)) {
                    String rawUserId = (String)ret;
                    if ("admin".equals(rawUserId)) {
                        ret = this.tenantService.getDomainUser(rawUserId, this.tenantService.getCurrentUserDomain());
                    }
                } else {
                    ret = this.convertOutboundValue(ret);
                }
            }
            return ret;
        }
        if (methodName.equals("getProperties")) {
            if (ret != null) {
                rawValues = (Map)ret;
                for (Map.Entry rawValue : rawValues.entrySet()) {
                    String rawUserId;
                    QName qname = (QName)rawValue.getKey();
                    Object value = (Serializable)rawValue.getValue();
                    if (qname.equals((Object)ContentModel.PROP_STORE_IDENTIFIER) && value != null) {
                        value = this.tenantService.getBaseName((String)value);
                    } else if ((qname.equals((Object)ContentModel.PROP_CREATOR) || qname.equals((Object)ContentModel.PROP_MODIFIER) || qname.equals((Object)ContentModel.PROP_OWNER)) && "admin".equals(rawUserId = (String)value)) {
                        value = this.tenantService.getDomainUser(rawUserId, this.tenantService.getCurrentUserDomain());
                    }
                    rawValues.put(qname, (Serializable)this.convertOutboundValue(value));
                }
                ret = rawValues;
            }
            return ret;
        }
        if (methodName.equals("getStores")) {
            if (ret == null || !(ret instanceof List)) {
                return null;
            }
            rawValues = (List)ret;
            ArrayList<StoreRef> convertedValues = new ArrayList<StoreRef>(rawValues.size());
            Iterator iterator = rawValues.iterator();
            while (iterator.hasNext()) {
                StoreRef ref;
                StoreRef storeRef = ref = (StoreRef)iterator.next();
                try {
                    if (this.tenantService.isEnabled() && !AuthenticationUtil.isRunAsUserTheSystemUser()) {
                        this.tenantService.checkDomain(storeRef.getIdentifier());
                        storeRef = this.tenantService.getBaseName(storeRef);
                    }
                    convertedValues.add(storeRef);
                }
                catch (RuntimeException runtimeException) {}
            }
            return convertedValues;
        }
        ret = this.convertOutboundValue(ret);
        return ret;
    }

    private Collection<Object> convertOutboundValues(Collection<Object> rawValues) {
        ArrayList<Object> convertedValues;
        if (rawValues instanceof List) {
            convertedValues = new ArrayList(rawValues.size());
        } else if (rawValues instanceof Set) {
            convertedValues = new HashSet(rawValues.size(), 1.0f);
        } else {
            throw new IllegalArgumentException("Interceptor can only handle List and Set return types.");
        }
        for (Object rawValue : rawValues) {
            Object convertedValue = this.convertOutboundValue(rawValue);
            convertedValues.add(convertedValue);
        }
        return convertedValues;
    }

    private Object convertOutboundValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        StoreRef value = rawValue;
        if (rawValue instanceof Collection) {
            value = this.convertOutboundValues((Collection)rawValue);
        } else if (rawValue instanceof StoreRef) {
            StoreRef ref = rawValue;
            value = this.tenantService.getBaseName(ref);
        } else if (rawValue instanceof NodeRef) {
            NodeRef ref = (NodeRef)rawValue;
            value = this.tenantService.getBaseName(ref);
        } else if (rawValue instanceof ChildAssociationRef) {
            ChildAssociationRef ref = (ChildAssociationRef)rawValue;
            value = this.tenantService.getBaseName(ref);
        } else if (rawValue instanceof AssociationRef) {
            AssociationRef ref = (AssociationRef)rawValue;
            value = this.tenantService.getBaseName(ref);
        } else if (rawValue instanceof Path) {
            Path ref = (Path)rawValue;
            Path outboundPath = new Path();
            for (Path.Element pathElement : ref) {
                if (pathElement instanceof Path.ChildAssocElement) {
                    pathElement = new Path.ChildAssocElement(this.tenantService.getBaseName(((Path.ChildAssocElement)pathElement).getRef()));
                }
                outboundPath.append(pathElement);
            }
            value = outboundPath;
        }
        return value;
    }

    private Collection<Object> convertInboundValues(Collection<Object> rawValues) {
        ArrayList<Object> convertedValues;
        if (rawValues instanceof List) {
            convertedValues = new ArrayList(rawValues.size());
        } else if (rawValues instanceof Set) {
            convertedValues = new HashSet(rawValues.size(), 1.0f);
        } else {
            throw new IllegalArgumentException("Interceptor can only handle List and Set return types.");
        }
        for (Object rawValue : rawValues) {
            Object convertedValue = this.convertInboundValue(rawValue);
            convertedValues.add(convertedValue);
        }
        return convertedValues;
    }

    private Object convertInboundValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        Path value = rawValue;
        if (rawValue instanceof StoreRef) {
            StoreRef ref = (StoreRef)rawValue;
            value = this.tenantService.getName(ref);
        } else if (rawValue instanceof NodeRef) {
            NodeRef ref = (NodeRef)rawValue;
            value = this.tenantService.getName(ref);
        } else if (rawValue instanceof ChildAssociationRef) {
            ChildAssociationRef ref = (ChildAssociationRef)rawValue;
            value = this.tenantService.getName(ref);
        } else if (rawValue instanceof AssociationRef) {
            AssociationRef ref = (AssociationRef)rawValue;
            value = this.tenantService.getName(ref);
        } else if (rawValue instanceof Collection) {
            value = this.convertInboundValues((Collection)rawValue);
        } else if (rawValue instanceof Path) {
            Path ref = rawValue;
            Path inboundPath = new Path();
            for (Path.Element pathElement : ref) {
                if (pathElement instanceof Path.ChildAssocElement) {
                    pathElement = new Path.ChildAssocElement(this.tenantService.getName(((Path.ChildAssocElement)pathElement).getRef()));
                }
                inboundPath.append(pathElement);
            }
            value = inboundPath;
        }
        return value;
    }
}

