/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.List;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.TransferProcessingException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicCorrespondingNodeResolverImpl
implements CorrespondingNodeResolver {
    private static final Log log = LogFactory.getLog(BasicCorrespondingNodeResolverImpl.class);
    private static final String MSG_SPECIFIED_STORE_DOES_NOT_EXIST = "transfer_service.receiver.specified_store_nonexistent";
    private NodeService nodeService;

    @Override
    public CorrespondingNodeResolver.ResolvedParentChildPair resolveCorrespondingNode(NodeRef sourceNodeRef, ChildAssociationRef primaryAssoc, Path parentPath) {
        List children;
        NodeRef parentNodeRef;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to resolve corresponding node for noderef " + sourceNodeRef));
            log.debug((Object)("Supplied parent path: " + parentPath));
            log.debug((Object)("Supplied parent assoc: " + primaryAssoc.toString()));
        }
        CorrespondingNodeResolver.ResolvedParentChildPair result = new CorrespondingNodeResolver.ResolvedParentChildPair(null, null);
        if (this.nodeService.exists(sourceNodeRef)) {
            result.resolvedChild = sourceNodeRef;
        }
        if (!this.nodeService.exists((parentNodeRef = primaryAssoc.getParentRef()).getStoreRef())) {
            throw new TransferProcessingException(MSG_SPECIFIED_STORE_DOES_NOT_EXIST);
        }
        if (!this.nodeService.exists(parentNodeRef)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find node's parent by node ref: " + parentNodeRef));
            }
            parentNodeRef = this.resolveParentPath(primaryAssoc.getParentRef().getStoreRef(), parentPath);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Node's parent has been resolved by noderef: " + parentNodeRef));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parent noderef resolved to node: " + parentNodeRef));
        }
        result.resolvedParent = parentNodeRef;
        if (parentNodeRef != null && result.resolvedChild == null && !(children = this.nodeService.getChildAssocs(parentNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)primaryAssoc.getQName())).isEmpty()) {
            result.resolvedChild = ((ChildAssociationRef)children.get(0)).getChildRef();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved child node to: " + result.resolvedChild));
        }
        return result;
    }

    private NodeRef resolveParentPath(StoreRef store, Path parentPath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to resolve parent path " + parentPath));
        }
        NodeRef node = this.nodeService.getRootNode(store);
        int index = 1;
        while (index < parentPath.size()) {
            Path.Element element;
            QName name;
            List children;
            if ((children = this.nodeService.getChildAssocs(node, RegexQNamePattern.MATCH_ALL, (QNamePattern)(name = QName.createQName((String)(element = parentPath.get(index++)).getElementString())))).isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to resolve path element " + element.getElementString()));
                }
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved path element " + element.getElementString()));
            }
            node = ((ChildAssociationRef)children.get(0)).getChildRef();
        }
        return node;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

