/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.favourites;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.favourites.PersonFavourite;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;

public interface FavouritesService {
    public static final List<Pair<SortFields, Boolean>> DEFAULT_SORT_PROPS = Arrays.asList(new Pair((Object)SortFields.username, (Object)Boolean.TRUE), new Pair((Object)SortFields.type, (Object)Boolean.TRUE), new Pair((Object)SortFields.createdAt, (Object)Boolean.FALSE));

    public Type getType(NodeRef var1);

    @Auditable(parameters={"userName", "nodeRef"})
    public PersonFavourite addFavourite(String var1, NodeRef var2);

    @Auditable(parameters={"userName", "nodeRef"})
    public boolean isFavourite(String var1, NodeRef var2);

    @Auditable(parameters={"userName", "nodeRef"})
    public boolean removeFavourite(String var1, NodeRef var2);

    @Auditable(parameters={"userName", "types", "pagingRequest"})
    public PagingResults<PersonFavourite> getPagedFavourites(String var1, Set<Type> var2, List<Pair<SortFields, Boolean>> var3, PagingRequest var4);

    @Auditable(parameters={"userName", "nodeRef"})
    public PersonFavourite getFavourite(String var1, NodeRef var2);

    public static enum SortFields {
        username,
        type,
        createdAt,
        title;

    }

    public static enum Type {
        FILE,
        FOLDER,
        SITE;

        public static Set<Type> ALL_FILTER_TYPES;

        static {
            ALL_FILTER_TYPES = new HashSet<Type>();
            ALL_FILTER_TYPES.add(FILE);
            ALL_FILTER_TYPES.add(FOLDER);
            ALL_FILTER_TYPES.add(SITE);
            ALL_FILTER_TYPES = Collections.unmodifiableSet(ALL_FILTER_TYPES);
        }
    }
}

