/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.repository.AbstractTransformationSourceOptions;
import org.alfresco.service.cmr.repository.SerializedTransformationOptionsAccessor;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;

public class PagedSourceOptions
extends AbstractTransformationSourceOptions {
    public static final Integer PAGE_1 = 1;
    private Integer startPageNumber;
    private Integer endPageNumber;

    protected static List<String> getDefaultApplicableMimetypes() {
        ArrayList<String> defaults = new ArrayList<String>(17);
        defaults.add("application/pdf");
        defaults.add("application/msword");
        defaults.add("application/vnd.ms-powerpoint");
        defaults.add("image/tiff");
        defaults.add("application/vnd.oasis.opendocument.presentation");
        defaults.add("application/vnd.oasis.opendocument.presentation-template");
        defaults.add("application/vnd.oasis.opendocument.text-template");
        defaults.add("application/vnd.sun.xml.writer");
        defaults.add("application/vnd.sun.xml.impress");
        defaults.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        defaults.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        defaults.add("application/vnd.stardivision.impress");
        defaults.add("application/vnd.stardivision.impress-packed");
        defaults.add("application/vnd.stardivision.writer");
        defaults.add("application/vnd.stardivision.writer-global");
        defaults.add("application/vnd.apple.keynote");
        defaults.add("application/vnd.apple.pages");
        defaults.add("application/wordperfect");
        return defaults;
    }

    public PagedSourceOptions() {
        this.setApplicableMimetypes(PagedSourceOptions.getDefaultApplicableMimetypes());
    }

    public Integer getStartPageNumber() {
        return this.startPageNumber;
    }

    public void setStartPageNumber(Integer startPageNumber) {
        this.startPageNumber = startPageNumber;
    }

    public Integer getEndPageNumber() {
        return this.endPageNumber;
    }

    public void setEndPageNumber(Integer endPageNumber) {
        this.endPageNumber = endPageNumber;
    }

    @Override
    public TransformationSourceOptions mergedOptions(TransformationSourceOptions overridingOptions) {
        if (overridingOptions instanceof PagedSourceOptions) {
            PagedSourceOptions mergedOptions = (PagedSourceOptions)super.mergedOptions(overridingOptions);
            if (((PagedSourceOptions)overridingOptions).getStartPageNumber() != null) {
                mergedOptions.setStartPageNumber(((PagedSourceOptions)overridingOptions).getStartPageNumber());
            }
            if (((PagedSourceOptions)overridingOptions).getEndPageNumber() != null) {
                mergedOptions.setEndPageNumber(((PagedSourceOptions)overridingOptions).getEndPageNumber());
            }
            return mergedOptions;
        }
        return null;
    }

    public static PagedSourceOptions getPage1Instance() {
        PagedSourceOptions sourceOptions = new PagedSourceOptions();
        sourceOptions.setStartPageNumber(PAGE_1);
        sourceOptions.setEndPageNumber(PAGE_1);
        return sourceOptions;
    }

    @Override
    public TransformationSourceOptions.TransformationSourceOptionsSerializer getSerializer() {
        return PagedSourceOptions.createSerializerInstance();
    }

    public static TransformationSourceOptions.TransformationSourceOptionsSerializer createSerializerInstance() {
        return new PagedSourceOptions().new PagedSourceOptionsSerializer();
    }

    public String toString() {
        return "PagedSourceOptions {" + this.startPageNumber + ", " + this.endPageNumber + "}";
    }

    public class PagedSourceOptionsSerializer
    implements TransformationSourceOptions.TransformationSourceOptionsSerializer {
        public static final String PARAM_SOURCE_START_PAGE = "source_start_page";
        public static final String PARAM_SOURCE_END_PAGE = "source_end_page";

        @Override
        public TransformationSourceOptions deserialize(SerializedTransformationOptionsAccessor serializedOptions) {
            int startPageNumber = serializedOptions.getIntegerParam(PARAM_SOURCE_START_PAGE, 1);
            int endPageNumber = serializedOptions.getIntegerParam(PARAM_SOURCE_END_PAGE, 1);
            PagedSourceOptions sourceOptions = new PagedSourceOptions();
            sourceOptions.setStartPageNumber(startPageNumber);
            sourceOptions.setEndPageNumber(endPageNumber);
            return sourceOptions;
        }

        @Override
        public void serialize(TransformationSourceOptions sourceOptions, Map<String, Serializable> parameters) {
            if (parameters == null || sourceOptions == null) {
                return;
            }
            PagedSourceOptions pagedSourceOptions = (PagedSourceOptions)sourceOptions;
            parameters.put(PARAM_SOURCE_START_PAGE, pagedSourceOptions.getStartPageNumber());
            parameters.put(PARAM_SOURCE_END_PAGE, pagedSourceOptions.getEndPageNumber());
        }
    }
}

