/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.util.List;
import java.util.Locale;
import org.alfresco.util.schemacomp.Result;
import org.alfresco.util.schemacomp.model.DbObject;
import org.springframework.extensions.surf.util.I18NUtil;

public class RedundantDbObject
extends Result {
    private static final int SHOW_MAX_MATCHES = 3;
    private DbObject dbObject;
    private List<DbObject> matches;

    public RedundantDbObject(DbObject dbObject, List<DbObject> matches) {
        this.dbObject = dbObject;
        this.matches = matches;
    }

    @Override
    public String describe() {
        return this.doDescribe(I18NUtil.getLocale());
    }

    @Override
    public String describe(Locale locale) {
        return this.doDescribe(locale);
    }

    private String doDescribe(Locale locale) {
        if (this.matches.size() > 3) {
            return I18NUtil.getMessage((String)"system.schema_comp.redundant_obj.many_matches", (Object[])new Object[]{this.matches.size(), this.dbObject, this.describeMatches(), this.matches.size() - 3});
        }
        return I18NUtil.getMessage((String)"system.schema_comp.redundant_obj", (Object[])new Object[]{this.matches.size(), this.dbObject, this.describeMatches()});
    }

    private String describeMatches() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.matches.size() && i < 3) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.matches.get(i));
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return "RedundantDbObject [dbObject=" + this.dbObject + ", matches=" + this.matches + "]";
    }
}

