/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat.jobs;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.heartbeat.jobs.QuartzJobScheduler;
import org.alfresco.repo.scheduler.AlfrescoSchedulerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.TriggerKey;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class QuartzJobSchedulerTest {
    private Scheduler scheduler;
    QuartzJobScheduler hbJobScheduler;

    @Before
    public void setUp() throws Exception {
        SchedulerFactoryBean sfb = new SchedulerFactoryBean();
        sfb.setSchedulerFactoryClass(AlfrescoSchedulerFactory.class);
        sfb.setAutoStartup(false);
        sfb.afterPropertiesSet();
        this.scheduler = sfb.getScheduler();
        this.hbJobScheduler = this.createSimpleJobScheduler();
        this.hbJobScheduler.setScheduler(this.scheduler);
    }

    @Test
    public void testJobsScheduledWithDifferentCronExpressions() throws Exception {
        SimpleHBDataCollector c1 = new SimpleHBDataCollector("c1", "0 0/1 * * * ?");
        SimpleHBDataCollector c2 = new SimpleHBDataCollector("c2", "0 0/2 * * * ?");
        SimpleHBDataCollector c3 = new SimpleHBDataCollector("c3", "0 0/3 * * * ?");
        String triggerName1 = "heartbeat-" + c1.getCollectorId() + "-Trigger";
        String triggerName2 = "heartbeat-" + c2.getCollectorId() + "-Trigger";
        String triggerName3 = "heartbeat-" + c3.getCollectorId() + "-Trigger";
        this.hbJobScheduler.scheduleJob((HBBaseDataCollector)c1);
        this.hbJobScheduler.scheduleJob((HBBaseDataCollector)c2);
        this.hbJobScheduler.scheduleJob((HBBaseDataCollector)c3);
        String testCron1 = ((CronTrigger)this.scheduler.getTrigger(new TriggerKey(triggerName1, "DEFAULT"))).getCronExpression();
        String testCron2 = ((CronTrigger)this.scheduler.getTrigger(new TriggerKey(triggerName2, "DEFAULT"))).getCronExpression();
        String testCron3 = ((CronTrigger)this.scheduler.getTrigger(new TriggerKey(triggerName3, "DEFAULT"))).getCronExpression();
        Assert.assertEquals((String)"Cron expression doesn't match", (Object)"0 0/1 * * * ?", (Object)testCron1);
        Assert.assertEquals((String)"Cron expression doesn't match", (Object)"0 0/2 * * * ?", (Object)testCron2);
        Assert.assertEquals((String)"Cron expression doesn't match", (Object)"0 0/3 * * * ?", (Object)testCron3);
    }

    @Test
    public void testUnscheduling() throws Exception {
        SimpleHBDataCollector c1 = new SimpleHBDataCollector("c1", "0 0/1 * * * ?");
        SimpleHBDataCollector c2 = new SimpleHBDataCollector("c2", "0 0/2 * * * ?");
        SimpleHBDataCollector c3 = new SimpleHBDataCollector("c3", "0 0/3 * * * ?");
        this.hbJobScheduler.scheduleJob((HBBaseDataCollector)c1);
        this.hbJobScheduler.scheduleJob((HBBaseDataCollector)c2);
        this.hbJobScheduler.scheduleJob((HBBaseDataCollector)c3);
        this.hbJobScheduler.unscheduleJob((HBBaseDataCollector)c1);
        this.hbJobScheduler.unscheduleJob((HBBaseDataCollector)c2);
        Assert.assertFalse((boolean)this.isJobScheduledForCollector(c1.getCollectorId(), this.scheduler));
        Assert.assertFalse((boolean)this.isJobScheduledForCollector(c2.getCollectorId(), this.scheduler));
        Assert.assertTrue((boolean)this.isJobScheduledForCollector(c3.getCollectorId(), this.scheduler));
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidCronExpression() throws Exception {
        SimpleHBDataCollector c2 = new SimpleHBDataCollector("c2", "Ivalidcron");
        this.hbJobScheduler.scheduleJob((HBBaseDataCollector)c2);
    }

    private boolean isJobScheduledForCollector(String collectorId, Scheduler scheduler) throws Exception {
        String jobName = "heartbeat-" + collectorId;
        String triggerName = String.valueOf(jobName) + "-Trigger";
        return scheduler.checkExists(new JobKey(jobName, "DEFAULT")) && scheduler.checkExists(new TriggerKey(triggerName, "DEFAULT"));
    }

    private QuartzJobScheduler createSimpleJobScheduler() {
        return new QuartzJobScheduler(){

            protected JobDataMap getJobDetailMap(HBBaseDataCollector collector) {
                return new JobDataMap();
            }

            protected Class<? extends Job> getHeartBeatJobClass() {
                return SimpleJob.class;
            }
        };
    }

    private class SimpleHBDataCollector
    extends HBBaseDataCollector {
        public SimpleHBDataCollector(String collectorId, String cron) {
            super(collectorId, "1.0", cron, (HeartBeatJobScheduler)QuartzJobSchedulerTest.this.hbJobScheduler);
        }

        public List<HBData> collectData() {
            LinkedList<HBData> result = new LinkedList<HBData>();
            result.add(new HBData("systemId2", this.getCollectorId(), "1", new Date()));
            return result;
        }
    }

    private class SimpleJob
    implements Job {
        private SimpleJob() {
        }

        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        }
    }
}

