/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.repo.content.cleanup.ContentStoreCleaner;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.content.cleanup.FileWipingContentCleanerListener;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.node.ContentPropertyRestrictionInterceptor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class ContentStoreCleanerTest
extends TestCase {
    private ApplicationContext ctx;
    private ContentService contentService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private ContentStoreCleaner cleaner;
    private EagerContentStoreCleaner eagerCleaner;
    private ContentStore store;
    private ContentStoreCleanerListener listener;
    private List<String> deletedUrls;
    private ContentDataDAO contentDataDAO;

    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        AuthenticationUtil.setRunAsUserSystem();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.contentService = serviceRegistry.getContentService();
        this.nodeService = serviceRegistry.getNodeService();
        this.transactionService = serviceRegistry.getTransactionService();
        this.jobLockService = serviceRegistry.getJobLockService();
        TransactionService transactionService = serviceRegistry.getTransactionService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        this.contentDataDAO = (ContentDataDAO)this.ctx.getBean("contentDataDAO");
        this.store = (ContentStore)this.ctx.getBean("fileContentStore");
        ArrayList<ContentStoreCleanerListener> listeners = new ArrayList<ContentStoreCleanerListener>(2);
        this.listener = new DummyCleanerListener();
        listeners.add(this.listener);
        listeners.add(new DummyUnsupportiveCleanerListener());
        this.deletedUrls = new ArrayList<String>(5);
        this.eagerCleaner = (EagerContentStoreCleaner)this.ctx.getBean("eagerContentStoreCleaner");
        this.eagerCleaner.setEagerOrphanCleanup(false);
        this.eagerCleaner.setStores(Collections.singletonList(this.store));
        this.eagerCleaner.setListeners(listeners);
        this.cleaner = new ContentStoreCleaner();
        this.cleaner.setEagerContentStoreCleaner(this.eagerCleaner);
        this.cleaner.setJobLockService(this.jobLockService);
        this.cleaner.setContentDataDAO(this.contentDataDAO);
        this.cleaner.setTransactionService(transactionService);
        this.cleaner.setDictionaryService(dictionaryService);
        this.cleaner.setContentService(this.contentService);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void checkForExistence(Set<String> urls, boolean mustExist) {
        for (String url : urls) {
            ContentReader rawReader = this.contentService.getRawReader(url);
            if (mustExist && !rawReader.exists()) {
                ContentStoreCleanerTest.fail((String)("Content URL should have existed but did not: " + url));
                continue;
            }
            if (mustExist || !rawReader.exists()) continue;
            ContentStoreCleanerTest.fail((String)("Content URL should not have existed but did: " + url));
        }
    }

    public void testEagerCleanupOnCommit() throws Exception {
        NodeRef contentNodeRef;
        HashSet<String> urlsToMiss;
        HashSet<String> urlsToExist;
        block2: {
            this.eagerCleaner.setEagerOrphanCleanup(true);
            urlsToExist = new HashSet<String>();
            urlsToMiss = new HashSet<String>();
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> makeContentCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    StoreRef storeRef = ContentStoreCleanerTest.this.nodeService.createStore("test", "testEagerCleanupOnCommit-" + GUID.generate());
                    NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                    Map<QName, String> properties = Collections.singletonMap(ContentModel.PROP_NAME, "test.txt");
                    NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                    ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.putContent("INITIAL CONTENT");
                    urlsToExist.add(writer.getContentUrl());
                    return contentNodeRef;
                }
            };
            contentNodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)makeContentCallback);
            this.checkForExistence(urlsToExist, true);
            this.checkForExistence(urlsToMiss, false);
            RetryingTransactionHelper.RetryingTransactionCallback<String> failUpdateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Throwable {
                    ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.putContent("CONTENT FOR FAIL");
                    urlsToMiss.add(writer.getContentUrl());
                    throw new RuntimeException("FAIL");
                }
            };
            try {
                this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)failUpdateCallback);
                ContentStoreCleanerTest.fail((String)"Transaction was meant to fail");
            }
            catch (RuntimeException e) {
                if (e.getMessage().equals("FAIL")) break block2;
                throw e;
            }
        }
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
        RetryingTransactionHelper.RetryingTransactionCallback<String> successUpdateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("CONTENT FOR SUCCESS");
                urlsToMiss.addAll(urlsToExist);
                urlsToExist.clear();
                urlsToExist.add(writer.getContentUrl());
                return writer.getContentUrl();
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)successUpdateCallback);
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
        RetryingTransactionHelper.RetryingTransactionCallback<ContentData> pointlessUpdateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

            public ContentData execute() throws Throwable {
                ContentData contentData = (ContentData)ContentStoreCleanerTest.this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_CONTENT);
                ContentStoreCleanerTest.this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                return contentData;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)pointlessUpdateCallback);
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                urlsToMiss.addAll(urlsToExist);
                urlsToExist.clear();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteNodeCallback);
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
    }

    public void testEagerCleanupDereferencing() throws Exception {
        ContentPropertyRestrictionInterceptor contentPropertyRestrictionInterceptor = (ContentPropertyRestrictionInterceptor)this.ctx.getBean("contentPropertyRestrictionInterceptor");
        try {
            contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList(((Object)((Object)this)).getClass().getCanonicalName());
            this.eagerCleaner.setEagerOrphanCleanup(true);
            final StoreRef storeRef = this.nodeService.createStore("test", String.valueOf(this.getName()) + "-" + GUID.generate());
            RetryingTransactionHelper.RetryingTransactionCallback<ContentData> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

                public ContentData execute() throws Throwable {
                    NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                    HashMap<QName, String> properties = new HashMap<QName, String>(13);
                    properties.put(ContentModel.PROP_NAME, "test.txt");
                    NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                    ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.putContent("INITIAL CONTENT");
                    ContentData contentData = writer.getContentData();
                    ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                    ContentReader reader = ContentStoreCleanerTest.this.contentService.getRawReader(contentData.getContentUrl());
                    ContentStoreCleanerTest.assertNotNull((Object)reader);
                    ContentStoreCleanerTest.assertTrue((String)"Content was cleaned before end of transaction", (boolean)reader.exists());
                    properties.put(ContentModel.PROP_NAME, "test2.txt");
                    properties.put(ContentModel.PROP_CONTENT, (String)contentData);
                    contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                    reader = ContentStoreCleanerTest.this.contentService.getRawReader(contentData.getContentUrl());
                    ContentStoreCleanerTest.assertNotNull((Object)reader);
                    ContentStoreCleanerTest.assertTrue((String)"Content was cleaned before end of transaction", (boolean)reader.exists());
                    return contentData;
                }
            };
            ContentData contentData = (ContentData)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
            ContentReader reader = this.contentService.getRawReader(contentData.getContentUrl());
            ContentStoreCleanerTest.assertNotNull((Object)reader);
            ContentStoreCleanerTest.assertTrue((String)"Content was cleaned despite being re-referenced in the transaction", (boolean)reader.exists());
        }
        finally {
            contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList("");
        }
    }

    public void testImmediateRemoval() throws Exception {
        this.eagerCleaner.setEagerOrphanCleanup(false);
        final StoreRef storeRef = this.nodeService.createStore("test", String.valueOf(this.getName()) + "-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<ContentData> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

            public ContentData execute() throws Throwable {
                NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("INITIAL CONTENT");
                ContentData contentData = writer.getContentData();
                ContentStoreCleanerTest.this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_TEMPORARY, null);
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                return contentData;
            }
        };
        ContentData contentData = (ContentData)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
        ContentReader reader = this.contentService.getRawReader(contentData.getContentUrl());
        ContentStoreCleanerTest.assertNotNull((Object)reader);
        ContentStoreCleanerTest.assertTrue((String)"Content should not have been eagerly deleted.", (boolean)reader.exists());
        this.cleaner.setProtectDays(0);
        this.cleaner.execute();
        reader = this.contentService.getRawReader(contentData.getContentUrl());
        ContentStoreCleanerTest.assertFalse((String)"Unprotected content was not deleted", (boolean)reader.exists());
        ContentStoreCleanerTest.assertTrue((String)"Content listener was not called", (boolean)this.deletedUrls.contains(reader.getContentUrl()));
    }

    public void testForcedImmediateShredding() throws Exception {
        final HashSet wipedUrls = new HashSet(3);
        final EagerContentStoreCleaner wipingEagerCleaner = new EagerContentStoreCleaner(){
            final FileWipingContentCleanerListener fileWiper = new FileWipingContentCleanerListener();

            protected boolean deleteFromStore(String contentUrl, ContentStore store) {
                this.fileWiper.beforeDelete(store, contentUrl);
                wipedUrls.add(contentUrl);
                return true;
            }
        };
        wipingEagerCleaner.setStores(Collections.singletonList(this.store));
        final StoreRef storeRef = this.nodeService.createStore("test", String.valueOf(this.getName()) + "-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("INITIAL CONTENT");
                return contentNodeRef;
            }
        };
        final NodeRef contentNodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
        RetryingTransactionHelper.RetryingTransactionCallback<String> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                ContentReader reader = ContentStoreCleanerTest.this.contentService.getReader(contentNodeRef, ContentModel.PROP_CONTENT);
                String contentUrl = reader.getContentUrl();
                wipingEagerCleaner.registerOrphanedContentUrl(contentUrl, true);
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                return contentUrl;
            }
        };
        String contentUrl = (String)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteCallback);
        ContentStoreCleanerTest.assertTrue((String)"Expected our URL to have been wiped.", (boolean)wipedUrls.contains(contentUrl));
        this.cleaner.execute();
    }

    public void testShreddingCleanup() throws Exception {
        this.eagerCleaner.setEagerOrphanCleanup(false);
        this.cleaner.setProtectDays(0);
        FileWipingContentCleanerListener fileWiper = new FileWipingContentCleanerListener();
        ArrayList<FileWipingContentCleanerListener> listeners = new ArrayList<FileWipingContentCleanerListener>(1);
        listeners.add(fileWiper);
        this.eagerCleaner.setListeners(listeners);
        final StoreRef storeRef = this.nodeService.createStore("test", String.valueOf(this.getName()) + "-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("INITIAL CONTENT");
                return contentNodeRef;
            }
        };
        final NodeRef contentNodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteCallback);
        this.cleaner.execute();
    }

    public void testMNT_12150() {
        this.eagerCleaner.setEagerOrphanCleanup(false);
        final StoreRef storeRef = this.nodeService.createStore("test", String.valueOf(this.getName()) + "-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<ContentData> prepareCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

            public ContentData execute() throws Throwable {
                NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("INITIAL CONTENT");
                ContentData contentData = writer.getContentData();
                ContentStoreCleanerTest.this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_TEMPORARY, null);
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                return contentData;
            }
        };
        ContentData contentData = (ContentData)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)prepareCallback);
        ArrayList<Object> stores = new ArrayList<Object>(2);
        stores.add(this.store);
        stores.add(new FileContentStore(this.ctx, this.store.getRootLocation()){

            public boolean isContentUrlSupported(String contentUrl) {
                return false;
            }
        });
        this.eagerCleaner.setStores(stores);
        this.eagerCleaner.setListeners(Collections.emptyList());
        this.cleaner.setProtectDays(0);
        this.cleaner.setDeletionFailureAction(ContentStoreCleaner.DeleteFailureAction.KEEP_URL);
        this.cleaner.execute();
        final TreeMap keptUrlsById = new TreeMap();
        final ContentDataDAO.ContentUrlHandler contentUrlHandler = new ContentDataDAO.ContentUrlHandler(){

            public void handle(Long id, String contentUrl, Long orphanTime) {
                keptUrlsById.put(id, contentUrl);
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ContentStoreCleanerTest.this.contentDataDAO.getContentUrlsKeepOrphaned(contentUrlHandler, 1000);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
        for (String url : keptUrlsById.values()) {
            if (!url.equalsIgnoreCase(contentData.getContentUrl())) continue;
            ContentStoreCleanerTest.fail((String)("Failed to cleanup orphaned content: " + contentData.getContentUrl()));
        }
    }

    private class DummyCleanerListener
    implements ContentStoreCleanerListener {
        private DummyCleanerListener() {
        }

        public void beforeDelete(ContentStore store, String contentUrl) throws ContentIOException {
            ContentStoreCleanerTest.this.deletedUrls.add(contentUrl);
        }
    }

    private class DummyUnsupportiveCleanerListener
    implements ContentStoreCleanerListener {
        private DummyUnsupportiveCleanerListener() {
        }

        public void beforeDelete(ContentStore store, String contentUrl) throws ContentIOException {
            throw new UnsupportedContentUrlException(store, contentUrl);
        }
    }
}

