/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.alfresco.RepositoryDiskInterface;
import org.alfresco.filesys.repo.ClientHelper;
import org.alfresco.filesys.repo.CommandExecutor;
import org.alfresco.filesys.repo.OpenFileMode;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.commands.CloseFileCommand;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.CreateFileCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.DoNothingCommand;
import org.alfresco.filesys.repo.rules.commands.MoveFileCommand;
import org.alfresco.filesys.repo.rules.commands.OpenFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReduceQuotaCommand;
import org.alfresco.filesys.repo.rules.commands.RemoveNoContentFileOnError;
import org.alfresco.filesys.repo.rules.commands.RemoveTempFileCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.commands.RestoreFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReturnValueCommand;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandExecutorImpl
implements CommandExecutor {
    private static Log logger = LogFactory.getLog(CommandExecutorImpl.class);
    private TransactionService transactionService;
    private RepositoryDiskInterface repositoryDiskInterface;
    private ExtendedDiskInterface diskInterface;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"diskInterface", (Object)this.diskInterface);
        PropertyCheck.mandatory((Object)this, (String)"repositoryDiskInterface", (Object)this.getRepositoryDiskInterface());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object execute(final SrvSession sess, final TreeConnection tree, final Command command) throws IOException {
        block11: {
            readState = command.getTransactionRequired();
            ret = null;
            if (readState == AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
                ret = this.executeInternal(sess, tree, command, null);
            } else {
                block12: {
                    helper = this.transactionService.getRetryingTransactionHelper();
                    readOnly = readState == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY;
                    cb = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws IOException {
                            try {
                                return CommandExecutorImpl.this.executeInternal(sess, tree, command, null);
                            }
                            catch (IOException e) {
                                throw new PropagatingException(e);
                            }
                        }
                    };
                    try {
                        ret = helper.doInTransaction(cb, readOnly);
                        break block11;
                    }
                    catch (PropagatingException pe) {
                        if (!(command instanceof CompoundCommand)) break block12;
                        if (CommandExecutorImpl.logger.isDebugEnabled()) {
                            CommandExecutorImpl.logger.debug((Object)("error executing command :command" + command), (Throwable)pe);
                        }
                        if ((commands = (c = (CompoundCommand)command).getPostErrorCommands()) == null) break block12;
                        ** for (c2 : commands)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.executeInternal(sess, tree, c2, ret);
                        }
                        catch (Throwable t) {
                            CommandExecutorImpl.logger.warn((Object)"caught and ignored exception from error handler", t);
                        }
                        continue;
                    }
                }
                throw (IOException)pe.getCause();
            }
        }
        if (command instanceof CompoundCommand) {
            CommandExecutorImpl.logger.debug((Object)"post commit of compound command");
            c = (CompoundCommand)command;
            commands = c.getPostCommitCommands();
            if (commands != null) {
                for (Command c2 : commands) {
                    this.executeInternal(sess, tree, c2, ret);
                }
            }
        }
        return ret;
    }

    private Object executeInternal(SrvSession sess, TreeConnection tree, Command command, Object result) throws IOException {
        block45: {
            FileFilterMode.setClient((FileFilterMode.Client)ClientHelper.getClient(sess));
            try {
                if (command instanceof CompoundCommand) {
                    Object ret = null;
                    logger.debug((Object)"compound command received");
                    CompoundCommand x = (CompoundCommand)command;
                    for (Command compoundPart : x.getCommands()) {
                        logger.debug((Object)"running part of compound command");
                        Object val = this.executeInternal(sess, tree, compoundPart, result);
                        if (val == null) continue;
                        ret = val;
                    }
                    Object object = ret;
                    return object;
                }
                if (command instanceof CreateFileCommand) {
                    logger.debug((Object)"create file command");
                    CreateFileCommand create = (CreateFileCommand)command;
                    NetworkFile networkFile = this.repositoryDiskInterface.createFile(create.getRootNode(), create.getPath(), create.getAllocationSize(), create.isHidden());
                    return networkFile;
                }
                if (command instanceof RestoreFileCommand) {
                    logger.debug((Object)"restore file command");
                    RestoreFileCommand restore = (RestoreFileCommand)command;
                    NetworkFile networkFile = this.repositoryDiskInterface.restoreFile(sess, tree, restore.getRootNode(), restore.getPath(), restore.getAllocationSize(), restore.getOriginalNodeRef());
                    return networkFile;
                }
                if (command instanceof DeleteFileCommand) {
                    logger.debug((Object)"delete file command");
                    DeleteFileCommand delete = (DeleteFileCommand)command;
                    NodeRef nodeRef = this.repositoryDiskInterface.deleteFile2(sess, tree, delete.getRootNode(), delete.getPath());
                    return nodeRef;
                }
                if (command instanceof OpenFileCommand) {
                    logger.debug((Object)"open file command");
                    OpenFileCommand o = (OpenFileCommand)command;
                    OpenFileMode mode = o.getMode();
                    NetworkFile networkFile = this.repositoryDiskInterface.openFile(sess, tree, o.getRootNodeRef(), o.getPath(), mode, o.isTruncate());
                    return networkFile;
                }
                if (command instanceof CloseFileCommand) {
                    logger.debug((Object)"close file command");
                    CloseFileCommand c = (CloseFileCommand)command;
                    NodeRef nodeRef = this.repositoryDiskInterface.closeFile(tree, c.getRootNodeRef(), c.getPath(), c.getNetworkFile());
                    return nodeRef;
                }
                if (command instanceof ReduceQuotaCommand) {
                    logger.debug((Object)"reduceQuota file command");
                    ReduceQuotaCommand r = (ReduceQuotaCommand)command;
                    this.repositoryDiskInterface.reduceQuota(sess, tree, r.getNetworkFile());
                    break block45;
                }
                if (command instanceof RenameFileCommand) {
                    logger.debug((Object)"rename command");
                    RenameFileCommand rename = (RenameFileCommand)command;
                    this.repositoryDiskInterface.renameFile(rename.getRootNode(), rename.getFromPath(), rename.getToPath(), rename.isSoft(), false);
                    break block45;
                }
                if (command instanceof MoveFileCommand) {
                    logger.debug((Object)"move command");
                    MoveFileCommand move = (MoveFileCommand)command;
                    this.repositoryDiskInterface.renameFile(move.getRootNode(), move.getFromPath(), move.getToPath(), false, move.isMoveAsSystem());
                    break block45;
                }
                if (command instanceof CopyContentCommand) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Copy content command - copy content");
                    }
                    CopyContentCommand copy = (CopyContentCommand)command;
                    this.repositoryDiskInterface.copyContent(copy.getRootNode(), copy.getFromPath(), copy.getToPath());
                    break block45;
                }
                if (command instanceof DoNothingCommand) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Do Nothing Command - doing nothing");
                    }
                    break block45;
                }
                if (command instanceof ResultCallback) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Result Callback");
                    }
                    ResultCallback callback = (ResultCallback)command;
                    callback.execute(result);
                    break block45;
                }
                if (command instanceof RemoveTempFileCommand) {
                    File file;
                    boolean isDeleted;
                    RemoveTempFileCommand r = (RemoveTempFileCommand)command;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Remove Temp File:" + r.getNetworkFile()));
                    }
                    if (isDeleted = (file = r.getNetworkFile().getFile()).delete()) break block45;
                    logger.debug((Object)("unable to delete temp file:" + r.getNetworkFile() + ", closed=" + r.getNetworkFile().isClosed()));
                    FileOutputStream fos = new FileOutputStream(file);
                    FileChannel outChan = null;
                    try {
                        try {
                            outChan = fos.getChannel();
                            outChan.truncate(0L);
                        }
                        catch (IOException e) {
                            logger.debug((Object)"unable to clean up file", (Throwable)e);
                            if (outChan != null) {
                                try {
                                    outChan.close();
                                }
                                catch (IOException iOException) {}
                            }
                            fos.close();
                            break block45;
                        }
                    }
                    catch (Throwable throwable) {
                        if (outChan != null) {
                            try {
                                outChan.close();
                            }
                            catch (IOException iOException) {}
                        }
                        fos.close();
                        throw throwable;
                    }
                    if (outChan != null) {
                        try {
                            outChan.close();
                        }
                        catch (IOException iOException) {}
                    }
                    fos.close();
                    break block45;
                }
                if (command instanceof ReturnValueCommand) {
                    ReturnValueCommand r = (ReturnValueCommand)command;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Return value");
                    }
                    Object object = r.getReturnValue();
                    return object;
                }
                if (command instanceof RemoveNoContentFileOnError) {
                    RemoveNoContentFileOnError r = (RemoveNoContentFileOnError)command;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Remove no content file on error");
                    }
                    this.repositoryDiskInterface.deleteEmptyFile(r.getRootNodeRef(), r.getPath());
                }
            }
            finally {
                FileFilterMode.clearClient();
            }
        }
        return null;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setRepositoryDiskInterface(RepositoryDiskInterface repositoryDiskInterface) {
        this.repositoryDiskInterface = repositoryDiskInterface;
    }

    public RepositoryDiskInterface getRepositoryDiskInterface() {
        return this.repositoryDiskInterface;
    }

    public void setDiskInterface(ExtendedDiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    public ExtendedDiskInterface getDiskInterface() {
        return this.diskInterface;
    }

    protected static class PropagatingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropagatingException(Throwable cause) {
            super(cause);
        }
    }
}

