/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CloseFileCommand;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.commands.RestoreFileCommand;
import org.alfresco.filesys.repo.rules.operations.CloseFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.MoveFileOperation;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioRenameDeleteMoveInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioRenameDeleteMoveInstance.class);
    InternalState internalState = InternalState.NONE;
    private Date startTime = new Date();
    private String fileMiddle;
    private String fileFrom;
    private String fileEnd;
    private ScenarioInstance.Ranking ranking;
    private boolean deleteBackup;
    private long timeout = 30000L;
    private boolean isComplete;
    private String folderMiddle;
    private String folderEnd;
    private NodeRef originalNodeRef;

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Instance timed out");
            }
            this.isComplete = true;
            return null;
        }
        switch (this.internalState) {
            case NONE: {
                if (operation instanceof RenameFileOperation) {
                    RenameFileOperation r = (RenameFileOperation)operation;
                    this.fileMiddle = r.getFrom();
                    this.fileEnd = r.getTo();
                    String[] paths = FileName.splitPath((String)r.getFromPath());
                    this.folderMiddle = paths[0];
                    String[] paths2 = FileName.splitPath((String)r.getToPath());
                    this.folderEnd = paths2[0];
                    this.internalState = InternalState.DELETE;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"State error, expected a RENAME");
                    }
                    this.isComplete = true;
                }
            }
            case DELETE: {
                CloseFileOperation c;
                ArrayList<Command> postCommitCommands;
                ArrayList<Command> commands;
                if (operation instanceof DeleteFileOperation) {
                    this.internalState = InternalState.MOVE;
                    DeleteFileOperation d = (DeleteFileOperation)operation;
                    if (d.getName().equalsIgnoreCase(this.fileEnd)) {
                        commands = new ArrayList<Command>();
                        postCommitCommands = new ArrayList<Command>();
                        ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                        RenameFileCommand r1 = new RenameFileCommand(this.fileEnd, "tmp" + this.fileEnd, d.getRootNodeRef(), String.valueOf(this.folderEnd) + "\\" + this.fileEnd, String.valueOf(this.folderEnd) + "\\" + "tmp" + this.fileEnd);
                        this.fileEnd = "tmp" + this.fileEnd;
                        commands.add(r1);
                        commands.add(new DeleteFileCommand(this.fileEnd, d.getRootNodeRef(), String.valueOf(this.folderEnd) + "\\" + this.fileEnd));
                        postCommitCommands.add(this.newDeleteFileCallbackCommand());
                        return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                    }
                }
                if (!(operation instanceof CloseFileOperation) || !(c = (CloseFileOperation)operation).getNetworkFile().hasDeleteOnClose() || !c.getName().equalsIgnoreCase(this.fileEnd)) break;
                this.internalState = InternalState.MOVE;
                commands = new ArrayList();
                postCommitCommands = new ArrayList();
                ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                RenameFileCommand r1 = new RenameFileCommand(this.fileEnd, "tmp" + this.fileEnd, c.getRootNodeRef(), String.valueOf(this.folderEnd) + "\\" + this.fileEnd, String.valueOf(this.folderEnd) + "\\" + "tmp" + this.fileEnd);
                this.fileEnd = "tmp" + this.fileEnd;
                commands.add(r1);
                commands.add(new CloseFileCommand(this.fileEnd, c.getNetworkFile(), c.getRootNodeRef(), String.valueOf(this.folderEnd) + "\\" + this.fileEnd));
                postCommitCommands.add(this.newDeleteFileCallbackCommand());
                return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
            }
            case MOVE: {
                MoveFileOperation m;
                if (!(operation instanceof MoveFileOperation) || this.originalNodeRef == null) break;
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("Tracking rename: " + operation));
                }
                if (!this.fileMiddle.equalsIgnoreCase((m = (MoveFileOperation)operation).getTo())) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Got second rename");
                }
                this.fileFrom = m.getFrom();
                String[] paths = FileName.splitPath((String)m.getFromPath());
                String oldFolder = paths[0];
                ArrayList<Command> commands = new ArrayList<Command>();
                RestoreFileCommand rest1 = new RestoreFileCommand(this.fileEnd, m.getRootNodeRef(), this.folderEnd, 0L, this.originalNodeRef);
                RenameFileCommand r1 = new RenameFileCommand(this.fileEnd, this.fileMiddle, m.getRootNodeRef(), String.valueOf(this.folderEnd) + "\\" + this.fileEnd, String.valueOf(this.folderMiddle) + "\\" + this.fileMiddle);
                commands.add(rest1);
                commands.add(r1);
                CopyContentCommand copyContent = new CopyContentCommand(this.fileFrom, this.fileMiddle, m.getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom, String.valueOf(this.folderMiddle) + "\\" + this.fileMiddle);
                commands.add(copyContent);
                DeleteFileCommand d1 = new DeleteFileCommand(oldFolder, m.getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.fileFrom);
                commands.add(d1);
                this.isComplete = true;
                return new CompoundCommand(commands);
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String toString() {
        return "ScenarioRenameDeleteMove:" + this.fileMiddle;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setDeleteBackup(boolean deleteBackup) {
        this.deleteBackup = deleteBackup;
    }

    public boolean isDeleteBackup() {
        return this.deleteBackup;
    }

    private ResultCallback newDeleteFileCallbackCommand() {
        return new ResultCallback(){

            @Override
            public void execute(Object result) {
                if (result instanceof NodeRef) {
                    logger.debug((Object)"got node ref of deleted node");
                    ScenarioRenameDeleteMoveInstance.this.originalNodeRef = (NodeRef)result;
                }
            }

            @Override
            public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
                return AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
            }
        };
    }

    static enum InternalState {
        NONE,
        DELETE,
        MOVE;

    }
}

