/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.jlan.server.filesys.FileName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ScenarioRenameShuffleInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioRenameShuffleInstance.class);
    private Date startTime = new Date();
    private long timeout = 30000L;
    private boolean isComplete = false;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;
    InternalState state = InternalState.NONE;
    String from;
    String to;

    ScenarioRenameShuffleInstance() {
    }

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Instance timed out");
            }
            this.isComplete = true;
            return null;
        }
        switch (this.state) {
            case NONE: {
                if (!(operation instanceof RenameFileOperation)) break;
                logger.debug((Object)"New scenario initialised");
                RenameFileOperation r = (RenameFileOperation)operation;
                this.from = r.getFrom();
                this.to = r.getTo();
                this.state = InternalState.INITIALISED;
                break;
            }
            case INITIALISED: {
                CreateFileOperation c;
                if (!(operation instanceof CreateFileOperation) || !this.from.equals((c = (CreateFileOperation)operation).getName())) break;
                logger.debug((Object)"transition to LOOK_FOR_DELETE");
                this.state = InternalState.LOOK_FOR_DELETE;
                break;
            }
            case LOOK_FOR_DELETE: {
                DeleteFileOperation d;
                if (!(operation instanceof DeleteFileOperation) || !this.to.equals((d = (DeleteFileOperation)operation).getName())) break;
                logger.debug((Object)"Rename shuffle complete - fire!");
                String[] paths = FileName.splitPath((String)d.getPath());
                String oldFolder = paths[0];
                ArrayList<Command> commands = new ArrayList<Command>();
                CopyContentCommand copyContent = new CopyContentCommand(this.from, this.to, d.getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.from, String.valueOf(oldFolder) + "\\" + this.to);
                RenameFileCommand r1 = new RenameFileCommand(this.to, this.from, d.getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.to, String.valueOf(oldFolder) + "\\" + this.from);
                DeleteFileCommand d1 = new DeleteFileCommand(this.from, d.getRootNodeRef(), String.valueOf(oldFolder) + "\\" + this.from);
                commands.add(copyContent);
                commands.add(d1);
                commands.add(r1);
                logger.debug((Object)"Scenario complete");
                this.isComplete = true;
                return new CompoundCommand(commands);
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    public String toString() {
        return "ScenarioRenameShuffleInstance from:" + this.from + " to:" + this.to;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    static enum InternalState {
        NONE,
        INITIALISED,
        LOOK_FOR_DELETE;

    }
}

