/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.RepoModelDefinition;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class RepoAdminServiceImpl
implements RepoAdminService {
    private static Log logger = LogFactory.getLog(RepoAdminServiceImpl.class);
    private DictionaryDAO dictionaryDAO;
    private SearchService searchService;
    private NodeService nodeService;
    private ContentService contentService;
    private NamespaceService namespaceService;
    private MessageService messageService;
    private RepoUsageComponent repoUsageComponent;
    private RepositoryLocation repoModelsLocation;
    private RepositoryLocation repoMessagesLocation;
    public static final String CRITERIA_ALL = "/*";
    public static final String defaultSubtypeOfDictionaryModel = "subtypeOf('cm:dictionaryModel')";
    public static final String defaultSubtypeOfContent = "subtypeOf('cm:content')";
    private static final String MODELS_LOCATION_NOT_FOUND = "repoadmin_service.models_location_not_found";
    private static final String MODELS_LOCATION_MULTIPLE_FOUND = "repoadmin_service.models_location_multiple_found";
    private static final String MODEL_EXISTS = "repoadmin_service.model_exists";
    private static final String MODEL_DEPLOYMENT_FAILED = "repoadmin_service.model_deployment_failed";
    private static final String MODEL_UNDEPLOYMENT_FAILED = "repoadmin_service.model_undeployment_failed";
    private static final String MODEL_ACTIVATION_FAILED = "repoadmin_service.model_activation_failed";
    private static final String MODEL_DEACTIVATION_FAILED = "repoadmin_service.model_deactivation_failed";
    private static final String MODEL_NOT_FOUND = "repoadmin_service.model_not_found";
    private static final String MODELS_MULTIPLE_FOUND = "repoadmin_service.models_multiple_found";
    private static final String MODEL_ALREADY_ACTIVATED = "repoadmin_service.model_already_activated";
    private static final String MODEL_ALREADY_DEACTIVATED = "repoadmin_service.model_already_deactivated";
    private static final String MODEL_NO_LONGER_EXISTS = "repoadmin_service.model_no_longer_exists";
    private static final String MSG_RESOURCES_NOT_FOUND = "repoadmin_service.msg_resource_not_found";
    private static final String MSG_RESOURCES_DEPLOYMENT_FAILED = "repoadmin_service.msg_resource_deployment_failed";
    private static final String MESSAGES_LOCATION_NOT_FOUND = "repoadmin_service.messages_location_not_found";
    private static final String MESSAGES_LOCATION_MULTIPLE_FOUND = "repoadmin_service.messages_location_multiple_found";
    private static final String MSG_RESOURCES_UNDEPLOYMENT_FAILED = "repoadmin_service.msg_resource_undeployment_failed";
    private static final String MSG_RESOURCES_RELOAD_FAILED = "repoadmin_service.msg_resource_reload_failed";
    private static final String MSG_MISSING_BUNDLE_BASE_NAME = "repoadmin_service.msg_missing_bundle_base_name";
    private static final String MSG_BASE_NAME_CONTAIN_UNDERSCORE = "repoadmin_service.msg_base_name_contain_underscore";
    private static final String MSG_BASE_NAME_CONTAIN_PERIOD = "repoadmin_service.msg_base_name_contain_period";

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setRepoUsageComponent(RepoUsageComponent repoUsageComponent) {
        this.repoUsageComponent = repoUsageComponent;
    }

    public void setRepositoryModelsLocation(RepositoryLocation repoModelsLocation) {
        this.repoModelsLocation = repoModelsLocation;
    }

    public void setRepositoryMessagesLocation(RepositoryLocation repoMessagesLocation) {
        this.repoMessagesLocation = repoMessagesLocation;
    }

    @Override
    public List<RepoModelDefinition> getModels() {
        StoreRef storeRef = this.repoModelsLocation.getStoreRef();
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        ArrayList<RepoModelDefinition> modelsInRepo = new ArrayList<RepoModelDefinition>();
        Collection models = this.dictionaryDAO.getModels(true);
        ArrayList<String> dictionaryModels = new ArrayList<String>();
        for (QName model : models) {
            dictionaryModels.add(model.toPrefixString());
        }
        List nodeRefs = this.searchService.selectNodes(rootNode, String.valueOf(this.repoModelsLocation.getPath()) + CRITERIA_ALL + "[" + defaultSubtypeOfDictionaryModel + "]", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() > 0) {
            for (NodeRef nodeRef : nodeRefs) {
                String modelFileName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                String repoVersion = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
                try {
                    String modelName = null;
                    ContentReader cr = this.contentService.getReader(nodeRef, ContentModel.TYPE_CONTENT);
                    if (cr != null) {
                        try (InputStream is = cr.getContentInputStream();){
                            M2Model model = M2Model.createModel((InputStream)is);
                            modelName = model.getName();
                        }
                    }
                    if (dictionaryModels.contains(modelName)) {
                        modelsInRepo.add(new RepoModelDefinition(modelFileName, repoVersion, this.dictionaryDAO.getModel(QName.createQName((String)modelName, (NamespacePrefixResolver)this.namespaceService)), true));
                        continue;
                    }
                    modelsInRepo.add(new RepoModelDefinition(modelFileName, repoVersion, null, false));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Skip model: " + modelFileName + " (" + t.getMessage() + ")"));
                }
            }
        }
        return modelsInRepo;
    }

    @Override
    public NodeRef deployModel(InputStream modelStream, String modelFileName, boolean activate) {
        try {
            ParameterCheck.mandatory((String)"ModelStream", (Object)modelStream);
            ParameterCheck.mandatoryString((String)"ModelFileName", (String)modelFileName);
            HashMap<QName, String> contentProps = new HashMap<QName, String>();
            contentProps.put(ContentModel.PROP_NAME, modelFileName);
            StoreRef storeRef = this.repoModelsLocation.getStoreRef();
            NodeRef rootNode = this.nodeService.getRootNode(storeRef);
            List nodeRefs = this.searchService.selectNodes(rootNode, this.repoModelsLocation.getPath(), null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() == 0) {
                throw new AlfrescoRuntimeException(MODELS_LOCATION_NOT_FOUND, new Object[]{this.repoModelsLocation.getPath()});
            }
            if (nodeRefs.size() > 1) {
                throw new AlfrescoRuntimeException(MODELS_LOCATION_MULTIPLE_FOUND, new Object[]{this.repoModelsLocation.getPath()});
            }
            NodeRef customModelsSpaceNodeRef = (NodeRef)nodeRefs.get(0);
            nodeRefs = this.searchService.selectNodes(customModelsSpaceNodeRef, "*[@cm:name='" + modelFileName + "' and " + defaultSubtypeOfDictionaryModel + "]", null, (NamespacePrefixResolver)this.namespaceService, false);
            NodeRef modelNodeRef = null;
            if (nodeRefs.size() == 1) {
                modelNodeRef = (NodeRef)nodeRefs.get(0);
            } else {
                try {
                    ChildAssociationRef association = this.nodeService.createNode(customModelsSpaceNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)modelFileName), ContentModel.TYPE_DICTIONARY_MODEL, contentProps);
                    modelNodeRef = association.getChildRef();
                }
                catch (DuplicateChildNodeNameException dcnne) {
                    String msg = "Model already exists: " + modelFileName + " - " + dcnne;
                    logger.warn((Object)msg);
                    throw new ConcurrencyFailureException(this.getLocalisedMessage(MODEL_EXISTS, modelFileName));
                }
                HashMap<QName, String> titledProps = new HashMap<QName, String>();
                titledProps.put(ContentModel.PROP_TITLE, modelFileName);
                titledProps.put(ContentModel.PROP_DESCRIPTION, modelFileName);
                this.nodeService.addAspect(modelNodeRef, ContentModel.ASPECT_TITLED, titledProps);
                HashMap<QName, Boolean> versionProps = new HashMap<QName, Boolean>();
                versionProps.put(ContentModel.PROP_AUTO_VERSION, true);
                this.nodeService.addAspect(modelNodeRef, ContentModel.ASPECT_VERSIONABLE, versionProps);
            }
            ContentWriter writer = this.contentService.getWriter(modelNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/xml");
            writer.setEncoding("UTF-8");
            writer.putContent(modelStream);
            modelStream.close();
            this.nodeService.setProperty(modelNodeRef, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(activate));
            return modelNodeRef;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException(MODEL_DEPLOYMENT_FAILED, e);
        }
    }

    @Override
    public void deployModel(InputStream modelStream, String modelFileName) {
        this.deployModel(modelStream, modelFileName, true);
    }

    @Override
    public QName activateModel(String modelFileName) {
        try {
            return this.activateOrDeactivate(modelFileName, true);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException(MODEL_ACTIVATION_FAILED, e);
        }
    }

    @Override
    public QName deactivateModel(String modelFileName) {
        try {
            return this.activateOrDeactivate(modelFileName, false);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException(MODEL_DEACTIVATION_FAILED, e);
        }
    }

    private QName activateOrDeactivate(String modelFileName, boolean activate) {
        ParameterCheck.mandatoryString((String)"modelFileName", (String)modelFileName);
        StoreRef storeRef = this.repoModelsLocation.getStoreRef();
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(rootNode, String.valueOf(this.repoModelsLocation.getPath()) + "//.[@cm:name='" + modelFileName + "' and " + defaultSubtypeOfDictionaryModel + "]", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new AlfrescoRuntimeException(MODEL_NOT_FOUND, new Object[]{modelFileName});
        }
        if (nodeRefs.size() > 1) {
            throw new AlfrescoRuntimeException(MODELS_MULTIPLE_FOUND, new Object[]{modelFileName});
        }
        NodeRef modelNodeRef = (NodeRef)nodeRefs.get(0);
        boolean isActive = false;
        Boolean value = (Boolean)this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_MODEL_ACTIVE);
        if (value != null) {
            isActive = value;
        }
        QName modelQName = (QName)this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_MODEL_NAME);
        ModelDefinition modelDef = null;
        if (modelQName != null) {
            try {
                modelDef = this.dictionaryDAO.getModel(modelQName);
            }
            catch (DictionaryException e) {
                logger.warn((Object)e);
            }
        }
        if (activate) {
            if (isActive) {
                if (modelDef != null) {
                    throw new AlfrescoRuntimeException(MODEL_ALREADY_ACTIVATED, new Object[]{modelQName});
                }
                logger.warn((Object)"Model is set to active but not loaded in Dictionary - trying to load...");
            } else if (modelDef != null) {
                logger.warn((Object)"Model is loaded in Dictionary but is not set to active - trying to activate...");
            }
        } else if (!isActive) {
            if (modelDef == null) {
                throw new AlfrescoRuntimeException(MODEL_ALREADY_DEACTIVATED, new Object[]{modelQName});
            }
            logger.warn((Object)"Model is set to inactive but loaded in Dictionary - trying to unload...");
        } else if (modelDef == null) {
            logger.warn((Object)"Model is not loaded in Dictionary but is set to active - trying to deactivate...");
        }
        this.nodeService.setProperty(modelNodeRef, ContentModel.PROP_MODEL_ACTIVE, (Serializable)Boolean.valueOf(activate));
        return modelQName;
    }

    @Override
    public QName undeployModel(String modelFileName) {
        ParameterCheck.mandatory((String)"modelFileName", (Object)modelFileName);
        QName modelQName = null;
        try {
            StoreRef storeRef = this.repoModelsLocation.getStoreRef();
            NodeRef rootNode = this.nodeService.getRootNode(storeRef);
            List nodeRefs = null;
            try {
                nodeRefs = this.searchService.selectNodes(rootNode, String.valueOf(this.repoModelsLocation.getPath()) + "//.[@cm:name='" + modelFileName + "' and " + defaultSubtypeOfDictionaryModel + "]", null, (NamespacePrefixResolver)this.namespaceService, false);
            }
            catch (InvalidNodeRefException inre) {
                String msg = "Model no longer exists: " + modelFileName + " - " + (Object)((Object)inre);
                logger.warn((Object)msg);
                throw new ConcurrencyFailureException(this.getLocalisedMessage(MODEL_NO_LONGER_EXISTS, modelFileName));
            }
            if (nodeRefs.size() == 0) {
                throw new AlfrescoRuntimeException(MODEL_NOT_FOUND, new Object[]{modelFileName});
            }
            if (nodeRefs.size() > 1) {
                throw new AlfrescoRuntimeException(MODELS_MULTIPLE_FOUND, new Object[]{modelFileName});
            }
            NodeRef modelNodeRef = (NodeRef)nodeRefs.get(0);
            boolean isActive = false;
            Boolean value = (Boolean)this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_MODEL_ACTIVE);
            if (value != null) {
                isActive = value;
            }
            modelQName = (QName)this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_MODEL_NAME);
            ModelDefinition modelDef = null;
            if (modelQName != null) {
                try {
                    modelDef = this.dictionaryDAO.getModel(modelQName);
                }
                catch (DictionaryException e) {
                    logger.warn((Object)e);
                }
            }
            if (isActive && modelDef == null) {
                logger.warn((Object)"Model is set to active but not loaded in Dictionary - trying to undeploy...");
            }
            this.nodeService.addAspect(modelNodeRef, ContentModel.ASPECT_TEMPORARY, null);
            try {
                this.nodeService.deleteNode(modelNodeRef);
            }
            catch (DictionaryException de) {
                String msg = "Model undeployment failed: " + modelFileName + " - " + (Object)((Object)de);
                logger.warn((Object)msg);
                throw new ConcurrencyFailureException(msg);
            }
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException(MODEL_UNDEPLOYMENT_FAILED, e);
        }
        return modelQName;
    }

    @Override
    public List<String> getMessageBundles() {
        StoreRef storeRef = this.repoMessagesLocation.getStoreRef();
        NodeRef rootNode = this.nodeService.getRootNode(storeRef);
        Set<String> registeredBundles = this.messageService.getRegisteredBundles();
        List nodeRefs = this.searchService.selectNodes(rootNode, String.valueOf(this.repoMessagesLocation.getPath()) + CRITERIA_ALL + "[" + defaultSubtypeOfContent + "]", null, (NamespacePrefixResolver)this.namespaceService, false);
        ArrayList<String> resourceBundlesInRepo = new ArrayList<String>();
        for (NodeRef nodeRef : nodeRefs) {
            String resourceName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            String resourceBundleBaseName = null;
            int idx1 = resourceName.indexOf("_");
            if (idx1 > 0) {
                resourceBundleBaseName = resourceName.substring(0, idx1);
            } else {
                int idx2 = resourceName.indexOf(".");
                if (idx2 > 0) {
                    resourceBundleBaseName = resourceName.substring(0, idx2);
                } else {
                    logger.warn((Object)("Unexpected message resource name: " + resourceName));
                }
            }
            if (registeredBundles != null) {
                for (String registeredBundlePath : registeredBundles) {
                    if (!registeredBundlePath.endsWith(resourceBundleBaseName) || resourceBundlesInRepo.contains(resourceBundleBaseName)) continue;
                    resourceBundlesInRepo.add(resourceBundleBaseName);
                }
                continue;
            }
            logger.error((Object)("Message bundle not registered: " + resourceBundleBaseName));
        }
        return resourceBundlesInRepo;
    }

    @Override
    public String deployMessageBundle(String resourceClasspath) {
        String bundleBaseName;
        block7: {
            ParameterCheck.mandatory((String)"ResourceClasspath", (Object)resourceClasspath);
            bundleBaseName = resourceClasspath;
            int idx = resourceClasspath.lastIndexOf("/");
            if (idx != -1) {
                bundleBaseName = idx < resourceClasspath.length() - 1 ? resourceClasspath.substring(idx + 1) : null;
            }
            this.checkBundleBaseName(bundleBaseName);
            String pattern = "classpath*:" + resourceClasspath + "*" + ".properties";
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            try {
                Resource[] resources = resolver.getResources(pattern);
                if (resources != null && resources.length > 0) {
                    ArrayList<Object> names = new ArrayList<Object>();
                    ArrayList<Resource> filteredResources = new ArrayList<Resource>();
                    int i = 0;
                    while (i < resources.length) {
                        String filename = resources[i].getFilename();
                        if (!names.contains(filename)) {
                            names.add(filename);
                            filteredResources.add(resources[i]);
                        }
                        ++i;
                    }
                    for (Resource resource : filteredResources) {
                        InputStream fileStream = resource.getInputStream();
                        String filename = resource.getFilename();
                        this.deployMessageResourceFile(resourceClasspath, filename, fileStream, false);
                    }
                    StoreRef storeRef = this.repoMessagesLocation.getStoreRef();
                    String repoBundlePath = String.valueOf(storeRef.toString()) + this.repoMessagesLocation.getPath() + "/cm:" + bundleBaseName;
                    this.messageService.registerResourceBundle(repoBundlePath);
                    logger.info((Object)("Message resource bundle deployed: " + bundleBaseName));
                    break block7;
                }
                logger.warn((Object)("No message resources found: " + resourceClasspath));
                throw new AlfrescoRuntimeException(MSG_RESOURCES_NOT_FOUND, new Object[]{resourceClasspath});
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException(MSG_RESOURCES_DEPLOYMENT_FAILED, new Object[]{resourceClasspath}, e);
            }
        }
        return bundleBaseName;
    }

    private void deployMessageResourceFile(String bundleBasePath, String name, InputStream resourceStream, boolean registerResourceBundle) {
        ParameterCheck.mandatory((String)"BundleBasePath", (Object)bundleBasePath);
        ParameterCheck.mandatory((String)"Name", (Object)name);
        ParameterCheck.mandatory((String)"ResourceStream", (Object)resourceStream);
        try {
            HashMap<QName, String> contentProps = new HashMap<QName, String>();
            contentProps.put(ContentModel.PROP_NAME, name);
            StoreRef storeRef = this.repoMessagesLocation.getStoreRef();
            NodeRef rootNode = this.nodeService.getRootNode(storeRef);
            List nodeRefs = this.searchService.selectNodes(rootNode, this.repoMessagesLocation.getPath(), null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() == 0) {
                throw new AlfrescoRuntimeException(MESSAGES_LOCATION_NOT_FOUND, new Object[]{this.repoMessagesLocation.getPath()});
            }
            if (nodeRefs.size() > 1) {
                throw new AlfrescoRuntimeException(MESSAGES_LOCATION_MULTIPLE_FOUND, new Object[]{this.repoMessagesLocation.getPath()});
            }
            NodeRef customLabelsNodeRef = (NodeRef)nodeRefs.get(0);
            ChildAssociationRef association = this.nodeService.createNode(customLabelsNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
            NodeRef content = association.getChildRef();
            HashMap<QName, String> titledProps = new HashMap<QName, String>();
            titledProps.put(ContentModel.PROP_TITLE, name);
            titledProps.put(ContentModel.PROP_DESCRIPTION, name);
            this.nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
            HashMap<QName, Boolean> editProps = new HashMap<QName, Boolean>(1, 1.0f);
            editProps.put(ApplicationModel.PROP_EDITINLINE, true);
            this.nodeService.addAspect(content, ApplicationModel.ASPECT_INLINEEDITABLE, editProps);
            ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent(resourceStream);
            resourceStream.close();
            if (registerResourceBundle) {
                String bundleBaseName = null;
                int idx = bundleBasePath.lastIndexOf("/");
                bundleBaseName = idx != -1 && idx != bundleBasePath.length() - 1 ? bundleBasePath.substring(idx + 1) : bundleBasePath;
                String repoBundlePath = String.valueOf(storeRef.toString()) + this.repoMessagesLocation.getPath() + "/cm:" + bundleBaseName;
                this.messageService.registerResourceBundle(repoBundlePath);
            }
            logger.info((Object)("Message resource deployed: " + name));
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Message resource deployment failed", e);
        }
    }

    @Override
    public void undeployMessageBundle(String bundleBaseName) {
        block4: {
            this.checkBundleBaseName(bundleBaseName);
            try {
                StoreRef storeRef = this.repoMessagesLocation.getStoreRef();
                String repoBundlePath = String.valueOf(storeRef.toString()) + this.repoMessagesLocation.getPath() + "/cm:" + bundleBaseName;
                this.messageService.unregisterResourceBundle(repoBundlePath);
                NodeRef rootNode = this.nodeService.getRootNode(storeRef);
                List nodeRefs = this.searchService.selectNodes(rootNode, String.valueOf(this.repoMessagesLocation.getPath()) + CRITERIA_ALL, null, (NamespacePrefixResolver)this.namespaceService, false);
                boolean found = false;
                for (NodeRef nodeRef : nodeRefs) {
                    String resourceName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    if (!bundleBaseName.equals(this.messageService.getBaseBundleName(resourceName))) continue;
                    this.nodeService.deleteNode(nodeRef);
                    found = true;
                }
                if (found) {
                    logger.info((Object)("Message resources undeployed: " + bundleBaseName));
                    break block4;
                }
                throw new AlfrescoRuntimeException(MSG_RESOURCES_NOT_FOUND, new Object[]{repoBundlePath});
            }
            catch (Throwable t) {
                throw new AlfrescoRuntimeException(MSG_RESOURCES_UNDEPLOYMENT_FAILED, t);
            }
        }
    }

    @Override
    public void reloadMessageBundle(String bundleBaseName) {
        block4: {
            this.checkBundleBaseName(bundleBaseName);
            try {
                StoreRef storeRef = this.repoMessagesLocation.getStoreRef();
                String repoBundlePath = String.valueOf(storeRef.toString()) + this.repoMessagesLocation.getPath() + "/cm:" + bundleBaseName;
                NodeRef rootNode = this.nodeService.getRootNode(storeRef);
                List nodeRefs = this.searchService.selectNodes(rootNode, String.valueOf(this.repoMessagesLocation.getPath()) + CRITERIA_ALL, null, (NamespacePrefixResolver)this.namespaceService, false);
                boolean found = false;
                for (NodeRef nodeRef : nodeRefs) {
                    String resourceName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                    if (!bundleBaseName.equals(this.messageService.getBaseBundleName(resourceName))) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.messageService.unregisterResourceBundle(repoBundlePath);
                    this.messageService.registerResourceBundle(repoBundlePath);
                    logger.info((Object)("Message resources re-loaded: " + bundleBaseName));
                    break block4;
                }
                throw new AlfrescoRuntimeException(MSG_RESOURCES_NOT_FOUND, new Object[]{repoBundlePath});
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException(MSG_RESOURCES_RELOAD_FAILED, e);
            }
        }
    }

    private void checkBundleBaseName(String bundleBaseName) {
        if (bundleBaseName == null || bundleBaseName.equals("")) {
            throw new AlfrescoRuntimeException(MSG_MISSING_BUNDLE_BASE_NAME);
        }
        if (bundleBaseName.indexOf("_") != -1) {
            throw new AlfrescoRuntimeException(MSG_BASE_NAME_CONTAIN_UNDERSCORE, new Object[]{bundleBaseName});
        }
        if (bundleBaseName.indexOf(".") != -1) {
            throw new AlfrescoRuntimeException(MSG_BASE_NAME_CONTAIN_PERIOD, new Object[]{bundleBaseName});
        }
    }

    @Override
    public RepoUsage getRestrictions() {
        return this.repoUsageComponent.getRestrictions();
    }

    @Override
    public RepoUsage getUsage() {
        return this.repoUsageComponent.getUsage();
    }

    @Override
    public boolean updateUsage(RepoUsage.UsageType usageType) {
        return this.repoUsageComponent.updateUsage(usageType);
    }

    @Override
    public RepoUsageStatus getUsageStatus() {
        return this.repoUsageComponent.getUsageStatus();
    }

    private String getLocalisedMessage(String msgId, Object ... params) {
        String localisedMsg = I18NUtil.getMessage((String)msgId, (Object[])params);
        if (localisedMsg == null) {
            localisedMsg = msgId;
        }
        return localisedMsg;
    }
}

