/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractPatch
implements Patch,
ApplicationEventPublisherAware {
    public static final String ERR_PROPERTY_NOT_SET = "patch.general.property_not_set";
    private static final String MSG_PROGRESS = "patch.progress";
    private static final String MSG_DEFERRED = "patch.genericBootstrap.result.deferred";
    private static final long RANGE_10 = 5400000L;
    private static final long RANGE_5 = 14400000L;
    private static final long RANGE_2 = 54000000L;
    private static Log logger = LogFactory.getLog(AbstractPatch.class);
    private static Log progress_logger = LogFactory.getLog(PatchExecuter.class);
    private String id;
    private int fixesFromSchema = -1;
    private int fixesToSchema = -1;
    private int targetSchema = -1;
    private boolean force = false;
    private String description;
    private boolean ignored = false;
    private List<Patch> dependsOn = Collections.emptyList();
    private List<Patch> alternatives = Collections.emptyList();
    private boolean applied = false;
    private boolean applyToTenants = true;
    int percentComplete = 0;
    long startTime;
    private boolean deferred = false;
    private boolean requiresTransaction = true;
    protected PatchService patchService;
    protected TransactionService transactionService;
    protected RetryingTransactionHelper transactionHelper;
    protected NamespaceService namespaceService;
    protected NodeService nodeService;
    protected SearchService searchService;
    protected AuthenticationContext authenticationContext;
    protected TenantAdminService tenantAdminService;
    protected ApplicationEventPublisher applicationEventPublisher;

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Patch").append("[ id=").append(this.id).append(", description=").append(this.description).append(", fixesFromSchema=").append(this.fixesFromSchema).append(", fixesToSchema=").append(this.fixesToSchema).append(", targetSchema=").append(this.targetSchema).append(", ignored=").append(this.ignored).append("]");
        return sb.toString();
    }

    public void setPatchService(PatchService patchService) {
        this.patchService = patchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
        this.transactionHelper = transactionService.getRetryingTransactionHelper();
        this.transactionHelper.setForceWritable(true);
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void init() {
        if (this.patchService == null) {
            throw new AlfrescoRuntimeException("Mandatory property not set: patchService");
        }
        if (!this.isIgnored()) {
            this.patchService.registerPatch(this);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getFixesFromSchema() {
        return this.fixesFromSchema;
    }

    public void setRequiresTransaction(boolean requiresTransaction) {
        this.requiresTransaction = requiresTransaction;
    }

    @Override
    public boolean requiresTransaction() {
        return this.requiresTransaction;
    }

    public void setFixesFromSchema(int version) {
        if (version < 0) {
            throw new IllegalArgumentException("The 'fixesFromSchema' property may not be less than 0");
        }
        this.fixesFromSchema = version;
        if (this.fixesToSchema < this.fixesFromSchema) {
            this.setFixesToSchema(this.fixesFromSchema);
        }
    }

    @Override
    public int getFixesToSchema() {
        return this.fixesToSchema;
    }

    public void setFixesToSchema(int version) {
        if (version < this.fixesFromSchema) {
            throw new IllegalArgumentException("'fixesToSchema' must be greater than or equal to 'fixesFromSchema'");
        }
        this.fixesToSchema = version;
    }

    @Override
    public int getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(int version) {
        if (version <= this.fixesToSchema) {
            throw new IllegalArgumentException("'targetSchema' must be greater than 'fixesToSchema'");
        }
        this.targetSchema = version;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    @Override
    public List<Patch> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<Patch> dependsOn) {
        this.dependsOn = dependsOn;
    }

    @Override
    public List<Patch> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(List<Patch> alternatives) {
        this.alternatives = alternatives;
    }

    @Override
    public boolean applies(int version) {
        return this.fixesFromSchema <= version && version <= this.fixesToSchema;
    }

    protected final void checkPropertyNotNull(Object value, String name) {
        if (value == null) {
            throw new PatchException(ERR_PROPERTY_NOT_SET, name, this);
        }
    }

    public void setApplyToTenants(boolean applyToTenants) {
        this.applyToTenants = applyToTenants;
    }

    protected void checkProperties() {
        this.checkPropertyNotNull(this.id, "id");
        this.checkPropertyNotNull(this.description, "description");
        this.checkPropertyNotNull(this.transactionService, "transactionService");
        this.checkPropertyNotNull(this.transactionHelper, "transactionHelper");
        this.checkPropertyNotNull(this.namespaceService, "namespaceService");
        this.checkPropertyNotNull(this.nodeService, "nodeService");
        this.checkPropertyNotNull(this.searchService, "searchService");
        this.checkPropertyNotNull(this.authenticationContext, "authenticationContext");
        this.checkPropertyNotNull(this.tenantAdminService, "tenantAdminService");
        this.checkPropertyNotNull(this.applicationEventPublisher, "applicationEventPublisher");
        if (this.fixesFromSchema == -1 || this.fixesToSchema == -1 || this.targetSchema == -1) {
            throw new AlfrescoRuntimeException("Patch properties 'fixesFromSchema', 'fixesToSchema' and 'targetSchema' have not all been set on this patch: \n   patch: " + this);
        }
    }

    private String applyWithTxns() throws Exception {
        String temp;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("call applyInternal for main context id:" + this.id));
        }
        RetryingTransactionHelper.RetryingTransactionCallback<String> patchWork = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Exception {
                IntegrityChecker.setWarnInTransaction();
                return AbstractPatch.this.applyInternal();
            }
        };
        StringBuilder sb = new StringBuilder(128);
        if (this.requiresTransaction()) {
            temp = this.transactionHelper.doInTransaction(patchWork, false, true);
            sb.append(temp);
        } else {
            temp = this.applyInternal();
            sb.append(temp);
        }
        if (this.tenantAdminService != null && this.tenantAdminService.isEnabled() && this.applyToTenants) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"call applyInternal for all tennants");
            }
            final List<Tenant> tenants = this.tenantAdminService.getAllTenants();
            BatchProcessWorkProvider<Tenant> provider = new BatchProcessWorkProvider<Tenant>(){
                Iterator<Tenant> i;
                {
                    this.i = list.iterator();
                }

                @Override
                public int getTotalEstimatedWorkSize() {
                    return tenants.size();
                }

                @Override
                public long getTotalEstimatedWorkSizeLong() {
                    return tenants.size();
                }

                @Override
                public Collection<Tenant> getNextWork() {
                    ArrayList<Tenant> chunk = new ArrayList<Tenant>(100);
                    while (this.i.hasNext() && chunk.size() <= 100) {
                        chunk.add(this.i.next());
                    }
                    return chunk;
                }
            };
            BatchProcessor<Tenant> batchProcessor = new BatchProcessor<Tenant>("AbstractPatch Processor for " + this.id, this.transactionHelper, provider, 10, 100, this.applicationEventPublisher, logger, 1000);
            BatchProcessor.BatchProcessWorker<Tenant> worker = new BatchProcessor.BatchProcessWorker<Tenant>(){

                @Override
                public String getIdentifier(Tenant entry) {
                    return entry.getTenantDomain();
                }

                @Override
                public void beforeProcess() throws Throwable {
                }

                @Override
                public void process(Tenant entry) throws Throwable {
                    String tenantDomain = entry.getTenantDomain();
                    String cfr_ignored_0 = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                        public String doWork() throws Exception {
                            return AbstractPatch.this.applyInternal();
                        }
                    }, (String)AbstractPatch.this.tenantAdminService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
                }

                @Override
                public void afterProcess() throws Throwable {
                }
            };
            batchProcessor.process(worker, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("batch worker finished processing id:" + this.id));
            }
            if (batchProcessor.getTotalErrorsLong() > 0L) {
                sb.append("\n and failure during update of tennants total success: " + batchProcessor.getSuccessfullyProcessedEntriesLong() + " number of errors: " + batchProcessor.getTotalErrorsLong() + " lastError" + batchProcessor.getLastError());
            } else {
                sb.append("\n and successful batch update of " + batchProcessor.getTotalResultsLong() + "tennants");
            }
        }
        return sb.toString();
    }

    @Override
    public String applyAsync() throws PatchException {
        return this.apply(true);
    }

    @Override
    public synchronized String apply() throws PatchException {
        return this.apply(false);
    }

    private String apply(boolean async) {
        if (!async) {
            if (this.deferred) {
                return I18NUtil.getMessage((String)MSG_DEFERRED);
            }
            if (this.applied) {
                throw new AlfrescoRuntimeException("The patch has already been executed: \n   patch: " + this);
            }
        }
        this.checkProperties();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nPatch will be applied: \n   patch: " + this));
        }
        try {
            AuthenticationUtil.RunAsWork<String> applyPatchWork = new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    return AbstractPatch.this.applyWithTxns();
                }
            };
            this.startTime = System.currentTimeMillis();
            String report = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)applyPatchWork, (String)AuthenticationUtil.getSystemUserName());
            this.applied = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\nPatch successfully applied: \n   patch: " + this + "\n" + "   report: " + report));
            }
            return report;
        }
        catch (PatchException e) {
            throw e;
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof PatchException) {
                throw (PatchException)((Object)cause);
            }
            String report = this.makeReport(e);
            throw new PatchException(report);
        }
    }

    private String makeReport(Throwable e) {
        StringWriter stringWriter = new StringWriter(1024);
        try (PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);){
            e.printStackTrace(printWriter);
            String string = stringWriter.toString();
            return string;
        }
    }

    protected abstract String applyInternal() throws Exception;

    protected void reportProgress(long estimatedTotal, long currentInteration) {
        if (progress_logger.isDebugEnabled()) {
            progress_logger.debug((Object)(String.valueOf(currentInteration) + "/" + estimatedTotal));
        }
        if (currentInteration == 0L) {
            this.percentComplete = 0;
        } else if (currentInteration * 100L / estimatedTotal > (long)this.percentComplete) {
            int previous = this.percentComplete;
            this.percentComplete = (int)(currentInteration * 100L / estimatedTotal);
            if (this.percentComplete < 100) {
                long currentTime = System.currentTimeMillis();
                long timeSoFar = currentTime - this.startTime;
                long timeRemaining = timeSoFar * (long)(100 - this.percentComplete) / (long)this.percentComplete;
                int report = -1;
                if (timeRemaining > 60000L) {
                    int reportInterval = this.getReportingInterval(timeSoFar, timeRemaining);
                    int i = previous + 1;
                    while (i <= this.percentComplete) {
                        if (i % reportInterval == 0) {
                            report = i;
                        }
                        ++i;
                    }
                    if (report > 0) {
                        Date end = new Date(currentTime + timeRemaining);
                        String msg = I18NUtil.getMessage((String)MSG_PROGRESS, (Object[])new Object[]{this.getId(), report, end});
                        progress_logger.info((Object)msg);
                    }
                }
            }
        }
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    @Override
    public boolean isDeferred() {
        return this.deferred;
    }

    private int getReportingInterval(long soFar, long toGo) {
        long total = soFar + toGo;
        if (total < 5400000L) {
            return 10;
        }
        if (total < 14400000L) {
            return 5;
        }
        if (total < 54000000L) {
            return 2;
        }
        return 1;
    }
}

