/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AsynchronousPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SurfConfigFolderPatch
extends AsynchronousPatch {
    private static final Log logger = LogFactory.getLog(SurfConfigFolderPatch.class);
    private static final Log progress_logger = LogFactory.getLog(PatchExecuter.class);
    private static final String MSG_SUCCESS = "patch.surfConfigFolderPatch.result";
    private static final String SURF_CONFIG = "surf-config";
    private static final String COMPONENTS = "components";
    private static final String PAGES = "pages";
    private static final String SITE = "site";
    private static final int SITE_BATCH_THREADS = 2;
    private static final int SHARED_SURF_CONFIG_BATCH_THREADS = 2;
    private static final int BATCH_SIZE = 1000;
    private static final int SHARED_SURF_CONFIG_BATCH_MAX_QUERY_RANGE = 1000;
    private static final int SITE_BATCH_MAX_QUERY_RANGE = 1000;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private BehaviourFilter behaviourFilter;
    private RuleService ruleService;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.nodeDAO, "nodeDAO");
        this.checkPropertyNotNull(this.qnameDAO, "qnameDAO");
        this.checkPropertyNotNull(this.ruleService, "ruleService");
        this.checkPropertyNotNull(this.behaviourFilter, "behaviourFilter");
    }

    @Override
    protected String applyInternal() throws Exception {
        long start = System.currentTimeMillis();
        final String systemUser = AuthenticationUtil.getSystemUserName();
        SiteWorkProvider siteWorkProvider = new SiteWorkProvider();
        BatchProcessor.BatchProcessWorkerAdaptor<Long> siteWorker = new BatchProcessor.BatchProcessWorkerAdaptor<Long>(){

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.setRunAsUser((String)systemUser);
            }

            @Override
            public void process(Long entry) throws Throwable {
                SurfConfigFolderPatch.this.behaviourFilter.disableBehaviour();
                SurfConfigFolderPatch.this.ruleService.disableRules();
                try {
                    SurfConfigFolderPatch.this.process(entry);
                }
                finally {
                    SurfConfigFolderPatch.this.ruleService.enableRules();
                    SurfConfigFolderPatch.this.behaviourFilter.enableBehaviour();
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.clearCurrentSecurityContext();
            }
        };
        BatchProcessor<Long> siteBatchProcessor = new BatchProcessor<Long>("SurfConfigFolderPatch", this.transactionService.getRetryingTransactionHelper(), siteWorkProvider, 2, 1000, null, progress_logger, 1000);
        int updatedSiteSurfConfig = siteBatchProcessor.process((BatchProcessor.BatchProcessWorker<Long>)siteWorker, true);
        SharedSurfConfigWorkProvider surfConfigWorkProvider = new SharedSurfConfigWorkProvider();
        BatchProcessor.BatchProcessWorkerAdaptor<NodeRef> surfConfigWorker = new BatchProcessor.BatchProcessWorkerAdaptor<NodeRef>(){

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.setRunAsUser((String)systemUser);
            }

            @Override
            public void process(NodeRef entry) throws Throwable {
                SurfConfigFolderPatch.this.behaviourFilter.disableBehaviour();
                SurfConfigFolderPatch.this.ruleService.disableRules();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"\tP: Processing [company_home/sites/surf-config/pages/user] children");
                    }
                    SurfConfigFolderPatch.this.addIndexControlAspectIfNotExist(entry);
                }
                finally {
                    SurfConfigFolderPatch.this.ruleService.enableRules();
                    SurfConfigFolderPatch.this.behaviourFilter.enableBehaviour();
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.clearCurrentSecurityContext();
            }
        };
        BatchProcessor<NodeRef> surfConfigBatchProcessor = new BatchProcessor<NodeRef>("SurfConfigFolderPatch", this.transactionService.getRetryingTransactionHelper(), surfConfigWorkProvider, 2, 1000, null, progress_logger, 1000);
        surfConfigBatchProcessor.process((BatchProcessor.BatchProcessWorker<NodeRef>)surfConfigWorker, true);
        int numOfSites = updatedSiteSurfConfig / 12;
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{numOfSites});
        long end = System.currentTimeMillis();
        logger.info((Object)(String.valueOf(msg) + " in [" + (end - start) + " ms]"));
        return msg;
    }

    private void process(long siteId) {
        Pair<Long, ChildAssociationRef> surfConfigPair;
        String siteName = (String)((Object)this.nodeDAO.getNodeProperty(siteId, ContentModel.PROP_NAME));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\tP: Processing surf-config folder for the site: [" + siteName + ']'));
        }
        if ((surfConfigPair = this.nodeDAO.getChildAssoc(siteId, ContentModel.ASSOC_CONTAINS, SURF_CONFIG)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to find surf-config folder for site: [" + siteName + ']'));
            }
            return;
        }
        NodeRef surfConfigNodeRef = ((ChildAssociationRef)surfConfigPair.getSecond()).getChildRef();
        this.addIndexControlAspectIfNotExist(surfConfigNodeRef);
        NodeRef componentsNodeRef = this.nodeService.getChildByName(surfConfigNodeRef, ContentModel.ASSOC_CONTAINS, COMPONENTS);
        if (componentsNodeRef != null) {
            this.addIndexControlAspectIfNotExist(componentsNodeRef);
            List listOfComponents = this.nodeService.getChildAssocs(componentsNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef comp : listOfComponents) {
                this.addIndexControlAspectIfNotExist(comp.getChildRef());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unable to find surf-config/components folder for site: [" + siteName + ']'));
        }
        NodeRef pagesNodeRef = this.nodeService.getChildByName(surfConfigNodeRef, ContentModel.ASSOC_CONTAINS, PAGES);
        if (pagesNodeRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to find surf-config/pages folder for site: [" + siteName + ']'));
            }
            return;
        }
        this.addIndexControlAspectIfNotExist(pagesNodeRef);
        NodeRef siteNodeRef = this.nodeService.getChildByName(pagesNodeRef, ContentModel.ASSOC_CONTAINS, SITE);
        if (siteNodeRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to find surf-config/pages/site folder for site: [" + siteName + ']'));
            }
            return;
        }
        this.addIndexControlAspectIfNotExist(siteNodeRef);
        NodeRef siteChildNodeRef = this.nodeService.getChildByName(siteNodeRef, ContentModel.ASSOC_CONTAINS, siteName);
        if (siteChildNodeRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unable to find surf-config/pages/site/" + siteName + " folder for site: [" + siteName + ']'));
            }
            return;
        }
        this.addIndexControlAspectIfNotExist(siteChildNodeRef);
        List listOfComponents = this.nodeService.getChildAssocs(siteChildNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef comp : listOfComponents) {
            this.addIndexControlAspectIfNotExist(comp.getChildRef());
        }
    }

    private void addIndexControlAspectIfNotExist(NodeRef nodeRef) {
        Serializable indexProp = this.nodeService.getProperty(nodeRef, ContentModel.PROP_IS_INDEXED);
        if (indexProp == null || ((Boolean)indexProp).booleanValue()) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL, Collections.singletonMap(ContentModel.PROP_IS_INDEXED, false));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\tP: Adding cm:indexControl aspect to node: [" + nodeRef + ']'));
            }
        }
    }

    private class SharedSurfConfigWorkProvider
    implements BatchProcessWorkProvider<NodeRef> {
        private long maxId = Long.MAX_VALUE;
        private long currentId = 0L;

        private SharedSurfConfigWorkProvider() {
        }

        @Override
        public synchronized int getTotalEstimatedWorkSize() {
            return (int)this.getTotalEstimatedWorkSizeLong();
        }

        @Override
        public synchronized long getTotalEstimatedWorkSizeLong() {
            if (this.maxId == Long.MAX_VALUE) {
                this.maxId = SurfConfigFolderPatch.this.patchDAO.getMaxAdmNodeID();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tQ: Max node id: " + this.maxId));
                }
            }
            return 0L;
        }

        @Override
        public synchronized Collection<NodeRef> getNextWork() {
            ArrayList<NodeRef> folderNodes = new ArrayList<NodeRef>(1000);
            int minResults = 500;
            while (this.currentId <= this.maxId && folderNodes.size() < minResults) {
                List<NodeRef> nodeIds = SurfConfigFolderPatch.this.patchDAO.getChildrenOfTheSharedSurfConfigFolder(this.currentId, this.currentId + 1000L);
                folderNodes.addAll(nodeIds);
                this.currentId += 1000L;
            }
            SurfConfigFolderPatch.this.nodeDAO.cacheNodes(folderNodes);
            return folderNodes;
        }
    }

    private class SiteWorkProvider
    implements BatchProcessWorkProvider<Long> {
        private long maxId = Long.MAX_VALUE;
        private long workCount = Long.MAX_VALUE;
        private long currentId = 0L;
        private final Pair<Long, QName> siteTypeQNameId;

        private SiteWorkProvider() {
            this.siteTypeQNameId = SurfConfigFolderPatch.this.qnameDAO.getQName(SiteModel.TYPE_SITE);
        }

        @Override
        public synchronized int getTotalEstimatedWorkSize() {
            return (int)this.getTotalEstimatedWorkSizeLong();
        }

        @Override
        public synchronized long getTotalEstimatedWorkSizeLong() {
            if (this.maxId == Long.MAX_VALUE) {
                this.maxId = SurfConfigFolderPatch.this.patchDAO.getMaxAdmNodeID();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tQ: Max node id: " + this.maxId));
                }
            }
            if (this.workCount == Long.MAX_VALUE) {
                this.workCount = SurfConfigFolderPatch.this.patchDAO.getCountNodesWithTypId(SiteModel.TYPE_SITE);
                this.workCount *= 12L;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tQ: Work count: " + this.workCount));
                }
            }
            return this.workCount;
        }

        @Override
        public synchronized Collection<Long> getNextWork() {
            ArrayList<Long> siteNodeIDs = new ArrayList<Long>(1000);
            if (this.siteTypeQNameId == null) {
                return siteNodeIDs;
            }
            int minResults = 500;
            while (this.currentId <= this.maxId && siteNodeIDs.size() < minResults) {
                List<Long> nodeIds = SurfConfigFolderPatch.this.patchDAO.getNodesByTypeQNameId((Long)this.siteTypeQNameId.getFirst(), this.currentId, this.currentId + 1000L);
                siteNodeIDs.addAll(nodeIds);
                this.currentId += 1000L;
            }
            return siteNodeIDs;
        }
    }
}

