/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.alfresco.repo.audit.extractor.DataExtractor;
import org.alfresco.repo.audit.generator.DataGenerator;
import org.alfresco.repo.audit.model.AuditModelException;
import org.alfresco.repo.audit.model._3.Application;
import org.alfresco.repo.audit.model._3.AuditPath;
import org.alfresco.repo.audit.model._3.GenerateValue;
import org.alfresco.repo.audit.model._3.RecordValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditApplication {
    public static final String AUDIT_APPLICATION_PREFIX_FOR_PRE_DATA = "PreCallData";
    public static final String AUDIT_PATH_SEPARATOR = "/";
    public static final Pattern AUDIT_KEY_PATTERN = Pattern.compile("[a-zA-Z0-9\\-\\_\\.]+");
    public static final Pattern AUDIT_PATH_PATTERN = Pattern.compile("(/[a-zA-Z0-9:\\-\\_\\.]+)+");
    public static final Pattern AUDIT_INVALID_PATH_COMP_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9:\\-\\_\\.]");
    private static final Log logger = LogFactory.getLog(AuditApplication.class);
    private final String applicationName;
    private final String applicationKey;
    private final Map<String, DataExtractor> dataExtractorsByName;
    private final Map<String, DataGenerator> dataGeneratorsByName;
    private final Application application;
    private final Long applicationId;
    private final Long disabledPathsId;
    private List<DataExtractorDefinition> dataExtractors = new ArrayList<DataExtractorDefinition>();
    private Map<String, Map<String, DataGenerator>> dataGenerators = new HashMap<String, Map<String, DataGenerator>>(11);

    AuditApplication(Map<String, DataExtractor> dataExtractorsByName, Map<String, DataGenerator> dataGeneratorsByName, Application application, Long applicationId, Long disabledPathsId) {
        this.dataExtractorsByName = dataExtractorsByName;
        this.dataGeneratorsByName = dataGeneratorsByName;
        this.application = application;
        this.applicationName = application.getName();
        this.applicationKey = application.getKey();
        this.applicationId = applicationId;
        this.disabledPathsId = disabledPathsId;
        this.buildAuditPaths(application);
    }

    public int hashCode() {
        return this.applicationName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuditApplication) {
            AuditApplication that = (AuditApplication)obj;
            return this.applicationName.equals(that.applicationName);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(56);
        sb.append("AuditApplication").append("[ name=").append(this.applicationName).append(", id=").append(this.applicationId).append(", disabledPathsId=").append(this.disabledPathsId).append("]");
        return sb.toString();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public Long getApplicationId() {
        return this.applicationId;
    }

    public Long getDisabledPathsId() {
        return this.disabledPathsId;
    }

    public void checkPath(String path) {
        AuditApplication.checkPathFormat(path);
        if (path == null || path.length() == 0) {
            this.generateException(path, "Empty or null audit path");
        } else if (!AUDIT_PATH_PATTERN.matcher(path).matches()) {
            this.generateException(path, "An audit must match regular expression: " + AUDIT_PATH_PATTERN);
        } else if (path.indexOf(this.applicationKey, 0) != 1) {
            this.generateException(path, "An audit path's first element must be the application's key i.e. '" + this.applicationKey + "'.");
        }
    }

    public static void checkPathFormat(String path) {
        if (path == null || path.length() == 0) {
            throw new AuditModelException("Empty or null audit path: " + path);
        }
        if (!AUDIT_PATH_PATTERN.matcher(path).matches()) {
            throw new AuditModelException("Audit path '" + path + "' does not match regular expression: " + AUDIT_PATH_PATTERN);
        }
    }

    public static String buildPath(String ... pathComponents) {
        StringBuilder sb = new StringBuilder(pathComponents.length * 10);
        String[] stringArray = pathComponents;
        int n = pathComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String pathComponent = stringArray[n2];
            if (!pathComponent.startsWith(AUDIT_PATH_SEPARATOR)) {
                sb.append(AUDIT_PATH_SEPARATOR);
            }
            sb.append(pathComponent);
            ++n2;
        }
        String path = sb.toString();
        if (!AUDIT_PATH_PATTERN.matcher(path).matches()) {
            StringBuffer msg = new StringBuffer();
            msg.append("The audit path is invalid and must be matched by regular expression: ").append(AUDIT_PATH_PATTERN).append("\n").append("   Path elements: ");
            String[] stringArray2 = pathComponents;
            int n3 = pathComponents.length;
            int n4 = 0;
            while (n4 < n3) {
                String pathComponent = stringArray2[n4];
                msg.append(pathComponent).append(", ");
                ++n4;
            }
            msg.append("\n").append("   Result:        ").append(path);
            throw new AuditModelException(msg.toString());
        }
        return path;
    }

    public static String getRootKey(String path) {
        if (!path.startsWith(AUDIT_PATH_SEPARATOR)) {
            throw new AuditModelException("The path must start with the path separator '/'");
        }
        int index = path.indexOf(AUDIT_PATH_SEPARATOR, 1);
        String rootPath = index > 0 ? path.substring(1, index) : path.substring(1);
        return rootPath;
    }

    public List<DataExtractorDefinition> getDataExtractors() {
        List<DataExtractorDefinition> extractors = Collections.unmodifiableList(this.dataExtractors);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looked up data extractors: \n   Found: " + extractors));
        }
        return extractors;
    }

    public Map<String, DataGenerator> getDataGenerators(String path) {
        return this.getDataGenerators(Collections.singleton(path));
    }

    public Map<String, DataGenerator> getDataGenerators(Set<String> paths) {
        HashMap<String, DataGenerator> amalgamatedGenerators = new HashMap<String, DataGenerator>(13);
        for (String path : paths) {
            Map<String, DataGenerator> generators = this.dataGenerators.get(path);
            if (generators == null) continue;
            amalgamatedGenerators.putAll(generators);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looked up data generators: \n   Paths:  " + paths + "\n" + "   Found: " + amalgamatedGenerators));
        }
        return amalgamatedGenerators;
    }

    private void buildAuditPaths(AuditPath auditPath) {
        this.buildAuditPaths(auditPath, null, new HashSet<String>(37), new HashMap<String, DataGenerator>(13));
    }

    private void buildAuditPaths(AuditPath auditPath, String currentPath, Set<String> existingPaths, Map<String, DataGenerator> upperGeneratorsByPath) {
        String key;
        upperGeneratorsByPath = new HashMap<String, DataGenerator>(upperGeneratorsByPath);
        if (!existingPaths.add(currentPath = currentPath == null ? AuditApplication.buildPath(auditPath.getKey()) : AuditApplication.buildPath(currentPath, auditPath.getKey()))) {
            this.generateException(currentPath, "The audit path already exists.");
        }
        for (RecordValue recordValue : auditPath.getRecordValue()) {
            String dataTrigger;
            String sourcePath;
            String extractorName;
            DataExtractor extractor;
            key = recordValue.getKey();
            String extractorPath = AuditApplication.buildPath(currentPath, key);
            if (!existingPaths.add(extractorPath)) {
                this.generateException(extractorPath, "The audit path already exists.");
            }
            if ((extractor = this.dataExtractorsByName.get(extractorName = recordValue.getDataExtractor())) == null) {
                this.generateException(extractorPath, "No data extractor exists for name: " + extractorName);
            }
            if ((sourcePath = recordValue.getDataSource()) == null) {
                sourcePath = currentPath;
            }
            if ((dataTrigger = recordValue.getDataTrigger()) == null) {
                dataTrigger = currentPath;
            }
            DataExtractorDefinition extractorDef = new DataExtractorDefinition(dataTrigger, sourcePath, extractorPath, extractor);
            this.dataExtractors.add(extractorDef);
        }
        for (GenerateValue generateValue : auditPath.getGenerateValue()) {
            String generatorName;
            DataGenerator generator;
            key = generateValue.getKey();
            String generatorPath = AuditApplication.buildPath(currentPath, key);
            if (!existingPaths.add(generatorPath)) {
                this.generateException(generatorPath, "The audit path already exists.");
            }
            if ((generator = this.dataGeneratorsByName.get(generatorName = generateValue.getDataGenerator())) == null) {
                this.generateException(generatorPath, "No data generator exists for name: " + generatorName);
            }
            upperGeneratorsByPath.put(generatorPath, generator);
        }
        this.dataGenerators.put(currentPath, upperGeneratorsByPath);
        for (AuditPath auditPath2 : auditPath.getAuditPath()) {
            this.buildAuditPaths(auditPath2, currentPath, existingPaths, upperGeneratorsByPath);
        }
    }

    private void generateException(String path, String msg) throws AuditModelException {
        throw new AuditModelException(msg + "\n" + "   Application: " + this.applicationName + "\n" + "   Path:        " + path);
    }

    public boolean isApplicationJustGeneratingPreCallData() {
        return this.applicationName != null && this.applicationName.startsWith(AUDIT_APPLICATION_PREFIX_FOR_PRE_DATA);
    }

    public static class DataExtractorDefinition {
        private final String dataTrigger;
        private final String dataSource;
        private final String dataTarget;
        private final DataExtractor dataExtractor;

        public DataExtractorDefinition(String dataTrigger, String dataSource, String dataTarget, DataExtractor dataExtractor) {
            this.dataTrigger = dataTrigger;
            this.dataSource = dataSource;
            this.dataTarget = dataTarget;
            this.dataExtractor = dataExtractor;
        }

        public String getDataTrigger() {
            return this.dataTrigger;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public String getDataTarget() {
            return this.dataTarget;
        }

        public DataExtractor getDataExtractor() {
            return this.dataExtractor;
        }
    }
}

