/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.service.namespace.QName;

public interface MetadataLoader {
    public static final String METADATA_SUFFIX = ".metadata.";

    public String getMetadataFileExtension();

    public void loadMetadata(ImportableItem.ContentAndMetadata var1, Metadata var2);

    public static final class Metadata {
        private QName type = null;
        private Set<QName> aspects = new HashSet<QName>();
        private Map<QName, Serializable> properties = new HashMap<QName, Serializable>();

        public QName getType() {
            return this.type;
        }

        public void setType(QName type) {
            assert (type != null) : "type must not be null.";
            this.type = type;
        }

        public Set<QName> getAspects() {
            return Collections.unmodifiableSet(this.aspects);
        }

        public void addAspect(QName aspect) {
            assert (aspect != null) : "aspect must not be null.";
            this.aspects.add(aspect);
        }

        public Map<QName, Serializable> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public void addProperty(QName property, Serializable value) {
            assert (property != null) : "property must not be null";
            this.properties.put(property, value);
        }
    }
}

