/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.alfresco.repo.bulkimport.AnalysedDirectory;
import org.alfresco.repo.bulkimport.DirectoryAnalyser;
import org.alfresco.repo.bulkimport.FilesystemTracker;
import org.alfresco.repo.bulkimport.ImportableItem;
import org.alfresco.util.PropertyCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilesystemTracker
implements FilesystemTracker {
    protected static Logger logger = LoggerFactory.getLogger(FilesystemTracker.class);
    protected DirectoryAnalyser directoryAnalyser = null;

    public final void setDirectoryAnalyser(DirectoryAnalyser directoryAnalyser) {
        this.directoryAnalyser = directoryAnalyser;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"directoryAnalyser", (Object)this.directoryAnalyser);
    }

    protected final AnalysedDirectory getImportableItemsInDirectory(ImportableItem directory) {
        AnalysedDirectory analysedDirectory = this.directoryAnalyser.analyseDirectory(directory, null);
        return analysedDirectory;
    }

    protected final AnalysedDirectory getImportableDirectoriesInDirectory(ImportableItem directory, int count) {
        DirectoryStream.Filter<Path> filter = null;
        filter = count != -1 ? new DirectoryStream.Filter<Path>(count){
            private int i;
            {
                this.i = n;
            }

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory(entry, new LinkOption[0]) && this.i-- > 0;
            }
        } : new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory(entry, new LinkOption[0]);
            }
        };
        AnalysedDirectory analysedDirectory = this.directoryAnalyser.analyseDirectory(directory, filter);
        return analysedDirectory;
    }
}

