/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.lock.LockServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rendition.CompositeRenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionPersister;
import org.alfresco.repo.rendition.RenditionPreventionRegistry;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.rendition.CompositeRenditionDefinition;
import org.alfresco.service.cmr.rendition.RenderCallback;
import org.alfresco.service.cmr.rendition.RenderingEngineDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionPreventedException;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class RenditionServiceImpl
implements RenditionService,
RenditionDefinitionPersister,
CheckOutCheckInServicePolicies.BeforeCheckOut,
LockServicePolicies.BeforeLock {
    private static final Log log = LogFactory.getLog(RenditionServiceImpl.class);
    private ActionService actionService;
    private ActionTrackingService actionTrackingService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private PolicyComponent policyComponent;
    private RenditionService2Impl renditionService2;
    private RenditionDefinitionPersister renditionDefinitionPersister;
    private RenditionPreventionRegistry renditionPreventionRegistry;
    private List<String> knownCancellableActionTypes;

    public void setRenditionDefinitionPersister(RenditionDefinitionPersister renditionDefinitionPersister) {
        this.renditionDefinitionPersister = renditionDefinitionPersister;
    }

    public void setRenditionPreventionRegistry(RenditionPreventionRegistry registry) {
        this.renditionPreventionRegistry = registry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.contentService = serviceRegistry.getContentService();
        this.nodeService = serviceRegistry.getNodeService();
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setActionTrackingService(ActionTrackingService actionTrackingService) {
        this.actionTrackingService = actionTrackingService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setKnownCancellableActionTypes(List<String> knownCancellableActionTypes) {
        this.knownCancellableActionTypes = knownCancellableActionTypes;
    }

    public void setRenditionService2(RenditionService2Impl renditionService2) {
        this.renditionService2 = renditionService2;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(CheckOutCheckInServicePolicies.BeforeCheckOut.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "beforeCheckOut"));
        this.policyComponent.bindClassBehaviour(LockServicePolicies.BeforeLock.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "beforeLock"));
    }

    @Override
    public RenderingEngineDefinition getRenderingEngineDefinition(String name) {
        ActionDefinition actionDefinition = this.actionService.getActionDefinition(name);
        if (actionDefinition instanceof RenderingEngineDefinition) {
            return (RenderingEngineDefinition)actionDefinition;
        }
        return null;
    }

    @Override
    public List<RenderingEngineDefinition> getRenderingEngineDefinitions() {
        ArrayList<RenderingEngineDefinition> results = new ArrayList<RenderingEngineDefinition>();
        List<ActionDefinition> actionDefs = this.actionService.getActionDefinitions();
        for (ActionDefinition actionDef : actionDefs) {
            if (!(actionDef instanceof RenderingEngineDefinition)) continue;
            RenderingEngineDefinition renderingDef = (RenderingEngineDefinition)actionDef;
            results.add(renderingDef);
        }
        return results;
    }

    @Override
    public RenditionDefinition createRenditionDefinition(QName renditionDefinitionName, String renderingEngineName) {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating rendition definition ").append(renditionDefinitionName).append(" ").append(renderingEngineName);
            log.debug((Object)msg.toString());
        }
        return new RenditionDefinitionImpl(GUID.generate(), renditionDefinitionName, renderingEngineName);
    }

    @Override
    public CompositeRenditionDefinition createCompositeRenditionDefinition(QName renditionName) {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating composite rendition definition ").append(renditionName);
            log.debug((Object)msg.toString());
        }
        return new CompositeRenditionDefinitionImpl(GUID.generate(), renditionName);
    }

    @Override
    public ChildAssociationRef render(NodeRef sourceNode, RenditionDefinition definition) {
        this.checkSourceNodeForPreventionClass(sourceNode);
        log.debug((Object)"Original RenditionService render no callback START");
        ChildAssociationRef result = this.executeRenditionAction(sourceNode, definition, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Produced rendition " + result));
        }
        log.debug((Object)"Original RenditionService render no callback END");
        return result;
    }

    @Override
    public void render(NodeRef sourceNode, RenditionDefinition definition, RenderCallback callback) {
        this.checkSourceNodeForPreventionClass(sourceNode);
        log.debug((Object)"Original RenditionService render    callback START");
        definition.setCallback(callback);
        this.executeRenditionAction(sourceNode, definition, true);
        log.debug((Object)"Original RenditionService render   callback END");
    }

    @Override
    public ChildAssociationRef render(NodeRef sourceNode, final QName renditionDefinitionQName) {
        this.checkSourceNodeForPreventionClass(sourceNode);
        RenditionDefinition rendDefn = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(){

            public RenditionDefinition doWork() throws Exception {
                return RenditionServiceImpl.this.loadRenditionDefinition(renditionDefinitionQName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (rendDefn == null) {
            throw new RenditionServiceException("Rendition Definition " + renditionDefinitionQName + " was not found.");
        }
        return this.render(sourceNode, rendDefn);
    }

    @Override
    public void render(NodeRef sourceNode, final QName renditionDefinitionQName, RenderCallback callback) {
        this.checkSourceNodeForPreventionClass(sourceNode);
        RenditionDefinition rendDefn = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(){

            public RenditionDefinition doWork() throws Exception {
                return RenditionServiceImpl.this.loadRenditionDefinition(renditionDefinitionQName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (rendDefn == null) {
            throw new RenditionServiceException("Rendition Definition " + renditionDefinitionQName + " was not found.");
        }
        this.render(sourceNode, rendDefn, callback);
    }

    private void checkSourceNodeForPreventionClass(NodeRef sourceNode) {
        if (sourceNode != null && this.nodeService.exists(sourceNode)) {
            Set nodeContentClasses = this.nodeService.getAspects(sourceNode);
            nodeContentClasses.add(this.nodeService.getType(sourceNode));
            for (QName contentClass : nodeContentClasses) {
                if (!this.renditionPreventionRegistry.isContentClassRegistered(contentClass)) continue;
                StringBuilder msg = new StringBuilder();
                msg.append("Node ").append(sourceNode).append(" cannot be renditioned as it is of class ").append(contentClass);
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg.toString());
                }
                throw new RenditionPreventedException(msg.toString());
            }
        }
    }

    private ChildAssociationRef executeRenditionAction(NodeRef sourceNode, RenditionDefinition definition, boolean asynchronous) {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            if (asynchronous) {
                msg.append("Asynchronously");
            } else {
                msg.append("Synchronously");
            }
            msg.append(" rendering node ").append(sourceNode).append(" with ").append(definition.getRenditionName());
            log.debug((Object)msg.toString());
        }
        this.actionService.executeAction(definition, sourceNode, true, asynchronous);
        ChildAssociationRef result = (ChildAssociationRef)definition.getParameterValue("result");
        return result;
    }

    @Override
    public void saveRenditionDefinition(RenditionDefinition renderingAction) {
        this.renditionDefinitionPersister.saveRenditionDefinition(renderingAction);
    }

    @Override
    public RenditionDefinition loadRenditionDefinition(QName renditionDefinitionName) {
        return this.renditionDefinitionPersister.loadRenditionDefinition(renditionDefinitionName);
    }

    @Override
    public List<RenditionDefinition> loadRenditionDefinitions() {
        return this.renditionDefinitionPersister.loadRenditionDefinitions();
    }

    @Override
    public List<RenditionDefinition> loadRenditionDefinitions(String renditionEngineName) {
        return this.renditionDefinitionPersister.loadRenditionDefinitions(renditionEngineName);
    }

    @Override
    public List<ChildAssociationRef> getRenditions(NodeRef node) {
        return this.renditionService2.getRenditions(node);
    }

    @Override
    public List<ChildAssociationRef> getRenditions(NodeRef node, String mimeTypePrefix) {
        List<ChildAssociationRef> allRenditions = this.getRenditions(node);
        ArrayList<ChildAssociationRef> filteredResults = new ArrayList<ChildAssociationRef>();
        for (ChildAssociationRef chAssRef : allRenditions) {
            String readerMimeType;
            ContentReader reader;
            NodeRef renditionNode = chAssRef.getChildRef();
            QName contentProperty = ContentModel.PROP_CONTENT;
            Serializable contentPropertyName = this.nodeService.getProperty(renditionNode, ContentModel.PROP_CONTENT_PROPERTY_NAME);
            if (contentPropertyName != null) {
                contentProperty = (QName)contentPropertyName;
            }
            if ((reader = this.contentService.getReader(renditionNode, contentProperty)) == null || !reader.exists() || !(readerMimeType = reader.getMimetype()).startsWith(mimeTypePrefix)) continue;
            filteredResults.add(chAssRef);
        }
        return filteredResults;
    }

    @Override
    public ChildAssociationRef getRenditionByName(NodeRef node, QName renditionName) {
        ChildAssociationRef childAssoc;
        NodeRef renditionNode;
        List renditions = Collections.emptyList();
        if (this.nodeService.hasAspect(node, RenditionModel.ASPECT_RENDITIONED)) {
            renditions = this.nodeService.getChildAssocs(node, (QNamePattern)RenditionModel.ASSOC_RENDITION, (QNamePattern)renditionName);
        }
        if (renditions.isEmpty()) {
            return null;
        }
        if (renditions.size() > 1 && log.isDebugEnabled()) {
            log.debug((Object)("Unexpectedly found " + renditions.size() + " renditions of name " + renditionName + " on node " + node));
        }
        return !this.renditionService2.isRenditionAvailable(node, renditionNode = (childAssoc = (ChildAssociationRef)renditions.get(0)).getChildRef()) ? null : childAssoc;
    }

    @Override
    public boolean isRendition(NodeRef node) {
        QName aspectToCheckFor = RenditionModel.ASPECT_RENDITION;
        Set existingAspects = this.nodeService.getAspects(node);
        for (QName nextAspect : existingAspects) {
            if (!nextAspect.equals((Object)aspectToCheckFor) && !this.dictionaryService.isSubClass(nextAspect, aspectToCheckFor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ChildAssociationRef getSourceNode(NodeRef renditionNode) {
        List parents = this.nodeService.getParentAssocs(renditionNode, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
        if (parents.size() > 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("NodeRef ").append(renditionNode).append(" unexpectedly has ").append(parents.size()).append(" rendition parents.");
            if (log.isWarnEnabled()) {
                log.warn((Object)msg.toString());
            }
            throw new RenditionServiceException(msg.toString());
        }
        return parents.isEmpty() ? null : (ChildAssociationRef)parents.get(0);
    }

    @Override
    public void cancelRenditions(NodeRef sourceNode) {
        if (this.knownCancellableActionTypes == null) {
            return;
        }
        for (String type : this.knownCancellableActionTypes) {
            this.cancelRenditions(sourceNode, type);
        }
    }

    @Override
    public void cancelRenditions(NodeRef sourceNode, String type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cancelling renditions of type " + type + " on nodeRef: " + sourceNode.toString()));
        }
        List<ExecutionSummary> executionSummaries = this.actionTrackingService.getExecutingActions(type, sourceNode);
        for (ExecutionSummary executionSummary : executionSummaries) {
            this.actionTrackingService.requestActionCancellation(executionSummary);
        }
    }

    @Override
    public void beforeCheckOut(NodeRef nodeRef, NodeRef destinationParentNodeRef, QName destinationAssocTypeQName, QName destinationAssocQName) {
        this.cancelRenditions(nodeRef);
    }

    @Override
    public void beforeLock(NodeRef nodeRef, LockType lockType) {
        this.cancelRenditions(nodeRef);
    }

    @Override
    public boolean usingRenditionService2(NodeRef sourceNodeRef, RenditionDefinition rendDefn) {
        boolean useRenditionService2 = false;
        QName renditionQName = rendDefn.getRenditionName();
        String renditionName = renditionQName.getLocalName();
        RenditionDefinition2 renditionDefinition2 = this.getEquivalentRenditionDefinition2(rendDefn);
        boolean createdByRenditionService2 = this.renditionService2.isCreatedByRenditionService2(sourceNodeRef, renditionName);
        if (this.renditionService2.isEnabled()) {
            if (createdByRenditionService2) {
                if (renditionDefinition2 != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("OnContentUpdate ignored by original service as the rendition for \"" + sourceNodeRef + "\", \"" + renditionName + "\" new service has taken over."));
                    }
                    useRenditionService2 = true;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("OnContentUpdate remove rendition for \"" + sourceNodeRef + "\", \"" + renditionName + "\" so we switch back to the original service, as the new service does not have the definition."));
                    }
                    this.renditionService2.deleteRendition(sourceNodeRef, renditionName);
                }
            } else if (renditionDefinition2 != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OnContentUpdate calling RenditionService2.render(\"" + sourceNodeRef + "\", \"" + renditionName + "\" so we switch to the new service."));
                }
                useRenditionService2 = true;
                this.renditionService2.clearRenditionContentData(sourceNodeRef, renditionName);
                this.renditionService2.render(sourceNodeRef, renditionName);
            }
        } else if (createdByRenditionService2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("OnContentUpdate remove rendition for \"" + sourceNodeRef + "\", \"" + renditionName + "\" so we switch back to the original service, as the new service is disabled."));
            }
            this.renditionService2.deleteRendition(sourceNodeRef, renditionName);
        }
        return useRenditionService2;
    }

    private RenditionDefinition2 getEquivalentRenditionDefinition2(RenditionDefinition rendDefn) {
        QName renditionQName = rendDefn.getRenditionName();
        String renditionName = renditionQName.getLocalName();
        RenditionDefinitionRegistry2 renditionDefinitionRegistry2 = this.renditionService2.getRenditionDefinitionRegistry2();
        RenditionDefinition2 renditionDefinition2 = renditionDefinitionRegistry2.getRenditionDefinition(renditionName);
        RenditionDefinition2 equivalentRenditionDefinition2 = null;
        if (renditionDefinition2 != null) {
            String targetMimetype2;
            String targetMimetype = (String)((Object)rendDefn.getParameterValue("mime-type"));
            equivalentRenditionDefinition2 = targetMimetype.equals(targetMimetype2 = renditionDefinition2.getTargetMimetype()) ? renditionDefinition2 : null;
        }
        return equivalentRenditionDefinition2;
    }
}

