/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.index.shard.Floc;
import org.alfresco.repo.index.shard.ShardRegistry;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.SearchEngineResultMetadata;
import org.alfresco.repo.search.impl.QueryParserUtils;
import org.alfresco.repo.search.impl.solr.AbstractSolrQueryHTTPClient;
import org.alfresco.repo.search.impl.solr.ExplicitSolrStoreMappingWrapper;
import org.alfresco.repo.search.impl.solr.SolrClientUtil;
import org.alfresco.repo.search.impl.solr.SolrJSONResultSet;
import org.alfresco.repo.search.impl.solr.SolrJsonProcessor;
import org.alfresco.repo.search.impl.solr.SolrQueryClient;
import org.alfresco.repo.search.impl.solr.SolrStatsResult;
import org.alfresco.repo.search.impl.solr.SolrStoreMapping;
import org.alfresco.repo.search.impl.solr.SolrStoreMappingWrapper;
import org.alfresco.repo.search.impl.solr.SpellCheckDecisionManager;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.BasicSearchParameters;
import org.alfresco.service.cmr.search.FieldHighlightParameters;
import org.alfresco.service.cmr.search.Interval;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.RangeParameters;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.StatsParameters;
import org.alfresco.service.cmr.search.StatsRequestParameters;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.SearchDateConversion;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SolrQueryHTTPClient
extends AbstractSolrQueryHTTPClient
implements SolrQueryClient {
    static Log s_logger = LogFactory.getLog(SolrQueryHTTPClient.class);
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private NodeDAO nodeDAO;
    private TenantService tenantService;
    private ShardRegistry shardRegistry;
    private Map<String, String> languageMappings;
    private List<SolrStoreMapping> storeMappings;
    private HashMap<StoreRef, SolrStoreMappingWrapper> mappingLookup = new HashMap();
    private String alternativeDictionary = "DEFAULT_DICTIONARY";
    private RepositoryState repositoryState;
    private BeanFactory beanFactory;
    private boolean includeGroupsForRoleAdmin = false;
    private int maximumResultsFromUnlimitedQuery = Integer.MAX_VALUE;
    private boolean anyDenyDenies;
    private boolean useDynamicShardRegistration = false;
    private int defaultUnshardedFacetLimit = 100;
    private int defaultShardedFacetLimit = 20;
    private NamespaceDAO namespaceDAO;
    private PermissionService permissionService;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"NodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"PermissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"TenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"LanguageMappings", this.languageMappings);
        PropertyCheck.mandatory((Object)this, (String)"StoreMappings", this.storeMappings);
        PropertyCheck.mandatory((Object)this, (String)"RepositoryState", (Object)this.repositoryState);
        PropertyCheck.mandatory((Object)this, (String)"namespaceDAO", (Object)this.namespaceDAO);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
    }

    public void setAlternativeDictionary(String alternativeDictionary) {
        this.alternativeDictionary = alternativeDictionary;
    }

    public void setRepositoryState(RepositoryState repositoryState) {
        this.repositoryState = repositoryState;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceDAO(NamespaceDAO namespaceDAO) {
        this.namespaceDAO = namespaceDAO;
    }

    public void setShardRegistry(ShardRegistry shardRegistry) {
        this.shardRegistry = shardRegistry;
    }

    public void setUseDynamicShardRegistration(boolean useDynamicShardRegistration) {
        this.useDynamicShardRegistration = useDynamicShardRegistration;
    }

    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings = languageMappings;
    }

    public void setStoreMappings(List storeMappings) {
        this.storeMappings = storeMappings;
    }

    public void setIncludeGroupsForRoleAdmin(boolean includeGroupsForRoleAdmin) {
        this.includeGroupsForRoleAdmin = includeGroupsForRoleAdmin;
    }

    public void setMaximumResultsFromUnlimitedQuery(int maximumResultsFromUnlimitedQuery) {
        this.maximumResultsFromUnlimitedQuery = maximumResultsFromUnlimitedQuery;
    }

    public void setAnyDenyDenies(boolean anyDenyDenies) {
        this.anyDenyDenies = anyDenyDenies;
    }

    public void setDefaultUnshardedFacetLimit(int defaultUnshardedFacetLimit) {
        this.defaultUnshardedFacetLimit = defaultUnshardedFacetLimit;
    }

    public void setDefaultShardedFacetLimit(int defaultShardedFacetLimit) {
        this.defaultShardedFacetLimit = defaultShardedFacetLimit;
    }

    @Override
    public SolrStatsResult executeStatsQuery(StatsParameters searchParameters) {
        if (this.repositoryState.isBootstrapping()) {
            throw new AlfrescoRuntimeException("SOLR stats queries can not be executed while the repository is bootstrapping");
        }
        try {
            StoreRef store = SolrClientUtil.extractStoreRef((BasicSearchParameters)searchParameters);
            SolrStoreMappingWrapper mapping = SolrClientUtil.extractMapping(store, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
            Locale locale = SolrClientUtil.extractLocale((BasicSearchParameters)searchParameters);
            Pair<HttpClient, String> httpClientAndBaseUrl = mapping.getHttpClientAndBaseUrl();
            HttpClient httpClient = (HttpClient)httpClientAndBaseUrl.getFirst();
            String url = this.buildStatsUrl(searchParameters, (String)httpClientAndBaseUrl.getSecond(), locale, mapping);
            JSONObject body = this.buildStatsBody(searchParameters, this.tenantService.getCurrentUserDomain(), locale);
            if (httpClient == null) {
                throw new AlfrescoRuntimeException("No http client for store " + store.toString());
            }
            return (SolrStatsResult)this.postSolrQuery(httpClient, url, body, json -> new SolrStatsResult(json, searchParameters.isDateSearch()));
        }
        catch (UnsupportedEncodingException e) {
            throw new QueryParserException("stats", e);
        }
        catch (HttpException e) {
            throw new QueryParserException("stats", e);
        }
        catch (IOException e) {
            throw new QueryParserException("stats", e);
        }
        catch (JSONException e) {
            throw new QueryParserException("stats", e);
        }
    }

    protected String buildStatsUrl(StatsParameters searchParameters, String baseUrl, Locale locale, SolrStoreMappingWrapper mapping) throws UnsupportedEncodingException {
        URLCodec encoder = new URLCodec();
        StringBuilder url = new StringBuilder();
        String languageUrlFragment = SolrClientUtil.extractLanguageFragment(this.languageMappings, searchParameters.getLanguage());
        url.append(baseUrl);
        url.append("/").append(languageUrlFragment);
        url.append("?wt=").append(encoder.encode("json", "UTF-8"));
        url.append("&locale=").append(encoder.encode(locale.toString(), "UTF-8"));
        url.append(this.buildSortParameters((BasicSearchParameters)searchParameters, encoder));
        url.append("&stats=true");
        url.append("&rows=0");
        if (!StringUtils.isBlank((CharSequence)searchParameters.getFilterQuery())) {
            url.append("?fq=").append(encoder.encode(searchParameters.getFilterQuery(), "UTF-8"));
        }
        for (Map.Entry entry : searchParameters.getStatsParameters().entrySet()) {
            url.append("&stats.").append((String)entry.getKey()).append("=").append(encoder.encode((String)entry.getValue(), "UTF-8"));
        }
        if (mapping != null && (searchParameters.getStores().size() > 1 || mapping.isSharded())) {
            url.append("&shards=");
            this.buildShards(url, searchParameters.getStores());
        }
        return url.toString();
    }

    protected void buildShards(StringBuilder url, List<StoreRef> storeRefs) {
        boolean requiresSeparator = false;
        for (StoreRef storeRef : storeRefs) {
            SolrStoreMappingWrapper storeMapping = SolrClientUtil.extractMapping(storeRef, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
            if (requiresSeparator) {
                url.append(',');
            } else {
                requiresSeparator = true;
            }
            url.append(storeMapping.getShards());
        }
    }

    protected JSONObject buildStatsBody(StatsParameters searchParameters, String tenant, Locale locale) throws JSONException {
        JSONObject body = new JSONObject();
        body.put("query", (Object)searchParameters.getQuery());
        JSONArray tenants = new JSONArray();
        tenants.put((Object)tenant);
        body.put("tenants", (Object)tenants);
        JSONArray locales = new JSONArray();
        locales.put((Object)locale);
        body.put("locales", (Object)locales);
        return body;
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters, String language) {
        if (this.repositoryState.isBootstrapping()) {
            throw new AlfrescoRuntimeException("SOLR queries can not be executed while the repository is bootstrapping");
        }
        try {
            LimitBy limitBy;
            StoreRef store = SolrClientUtil.extractStoreRef((BasicSearchParameters)searchParameters);
            SolrStoreMappingWrapper mapping = SolrClientUtil.extractMapping(store, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
            Pair<HttpClient, String> httpClientAndBaseUrl = mapping.getHttpClientAndBaseUrl();
            HttpClient httpClient = (HttpClient)httpClientAndBaseUrl.getFirst();
            URLCodec encoder = new URLCodec();
            StringBuilder url = new StringBuilder();
            url.append((String)httpClientAndBaseUrl.getSecond());
            String languageUrlFragment = SolrClientUtil.extractLanguageFragment(this.languageMappings, language);
            if (!url.toString().endsWith("/")) {
                url.append("/");
            }
            url.append(languageUrlFragment);
            url.append("?wt=").append(encoder.encode("json", "UTF-8"));
            url.append("&fl=").append(encoder.encode("DBID,score", "UTF-8"));
            int maxResults = -1;
            if (searchParameters.getMaxItems() >= 0) {
                maxResults = searchParameters.getMaxItems();
                limitBy = LimitBy.FINAL_SIZE;
            } else if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE && searchParameters.getLimit() >= 0) {
                maxResults = searchParameters.getLimit();
                limitBy = LimitBy.FINAL_SIZE;
            } else {
                maxResults = searchParameters.getMaxPermissionChecks();
                if (maxResults < 0) {
                    maxResults = this.maximumResultsFromUnlimitedQuery;
                }
                limitBy = LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS;
            }
            url.append("&rows=").append(String.valueOf(maxResults));
            if (searchParameters.getStores().size() > 1 || mapping.isSharded()) {
                boolean requiresSeparator = false;
                url.append("&shards=");
                for (StoreRef storeRef : searchParameters.getStores()) {
                    SolrStoreMappingWrapper storeMapping = SolrClientUtil.extractMapping(storeRef, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
                    if (requiresSeparator) {
                        url.append(',');
                    } else {
                        requiresSeparator = true;
                    }
                    url.append(storeMapping.getShards());
                }
            }
            this.buildUrlParameters(searchParameters, mapping.isSharded(), encoder, url);
            String searchTerm = searchParameters.getSearchTerm();
            String spellCheckQueryStr = null;
            if (searchTerm != null && searchParameters.isSpellCheck()) {
                StringBuilder builder = new StringBuilder();
                builder.append("&spellcheck.q=").append(encoder.encode(searchTerm, "UTF-8"));
                builder.append("&spellcheck=").append(encoder.encode("true", "UTF-8"));
                spellCheckQueryStr = builder.toString();
                url.append(spellCheckQueryStr);
            }
            JSONObject body = new JSONObject();
            body.put("query", (Object)searchParameters.getQuery());
            Set allAuthorisations = this.permissionService.getAuthorisations();
            boolean includeGroups = this.includeGroupsForRoleAdmin ? true : !allAuthorisations.contains("ROLE_ADMINISTRATOR");
            JSONArray authorities = new JSONArray();
            for (String authority : allAuthorisations) {
                if (includeGroups) {
                    authorities.put((Object)authority);
                    continue;
                }
                if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.GROUP) continue;
                authorities.put((Object)authority);
            }
            body.put("authorities", (Object)authorities);
            body.put("anyDenyDenies", this.anyDenyDenies);
            JSONArray tenants = new JSONArray();
            tenants.put((Object)this.tenantService.getCurrentUserDomain());
            body.put("tenants", (Object)tenants);
            JSONArray locales = new JSONArray();
            for (Locale currentLocale : searchParameters.getLocales()) {
                locales.put(DefaultTypeConverter.INSTANCE.convert(String.class, (Object)currentLocale));
            }
            if (locales.length() == 0) {
                locales.put((Object)I18NUtil.getLocale());
            }
            body.put("locales", (Object)locales);
            JSONArray templates = new JSONArray();
            for (String templateName : searchParameters.getQueryTemplates().keySet()) {
                JSONObject template = new JSONObject();
                template.put("name", (Object)templateName);
                template.put("template", searchParameters.getQueryTemplates().get(templateName));
                templates.put((Object)template);
            }
            body.put("templates", (Object)templates);
            JSONArray allAttributes = new JSONArray();
            for (String attribute : searchParameters.getAllAttributes()) {
                allAttributes.put((Object)attribute);
            }
            body.put("allAttributes", (Object)allAttributes);
            body.put("defaultFTSOperator", (Object)searchParameters.getDefaultFTSOperator());
            body.put("defaultFTSFieldOperator", (Object)searchParameters.getDefaultFTSFieldOperator());
            body.put("queryConsistency", (Object)searchParameters.getQueryConsistency());
            if (searchParameters.getMlAnalaysisMode() != null) {
                body.put("mlAnalaysisMode", (Object)searchParameters.getMlAnalaysisMode().toString());
            }
            body.put("defaultNamespace", (Object)searchParameters.getNamespace());
            JSONArray textAttributes = new JSONArray();
            for (String attribute : searchParameters.getTextAttributes()) {
                textAttributes.put((Object)attribute);
            }
            body.put("textAttributes", (Object)textAttributes);
            int maximumResults = maxResults;
            return (ResultSet)this.postSolrQuery(httpClient, url.toString(), body, json -> new SolrJSONResultSet(json, searchParameters, this.nodeService, this.nodeDAO, limitBy, maximumResults), spellCheckQueryStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new QueryParserException("", e);
        }
        catch (HttpException e) {
            throw new QueryParserException("", e);
        }
        catch (IOException e) {
            throw new QueryParserException("", e);
        }
        catch (JSONException e) {
            throw new QueryParserException("", e);
        }
    }

    public void buildUrlParameters(SearchParameters searchParameters, boolean isSharded, URLCodec encoder, StringBuilder url) throws UnsupportedEncodingException {
        Locale locale = SolrClientUtil.extractLocale((BasicSearchParameters)searchParameters);
        url.append("&df=").append(encoder.encode(searchParameters.getDefaultFieldName(), "UTF-8"));
        url.append("&start=").append(encoder.encode("" + searchParameters.getSkipCount(), "UTF-8"));
        url.append("&locale=");
        url.append(encoder.encode(locale.toString(), "UTF-8"));
        url.append("&").append("alternativeDic").append("=").append(this.alternativeDictionary);
        for (String paramName : searchParameters.getExtraParameters().keySet()) {
            url.append("&").append(paramName).append("=").append((String)searchParameters.getExtraParameters().get(paramName));
        }
        StringBuffer sortBuffer = this.buildSortParameters((BasicSearchParameters)searchParameters, encoder);
        url.append(sortBuffer);
        if (searchParameters.getPermissionEvaluation() != PermissionEvaluationMode.NONE) {
            url.append("&fq=").append(encoder.encode("{!afts}AUTHORITY_FILTER_FROM_JSON", "UTF-8"));
        }
        if (!searchParameters.getExcludeTenantFilter()) {
            url.append("&fq=").append(encoder.encode("{!afts}TENANT_FILTER_FROM_JSON", "UTF-8"));
        }
        if (searchParameters.getTimezone() != null && !searchParameters.getTimezone().isEmpty()) {
            url.append("&TZ=").append(encoder.encode(searchParameters.getTimezone(), "UTF-8"));
        }
        for (String filterQuery : searchParameters.getFilterQueries()) {
            if (!filterQuery.startsWith("{!afts")) {
                filterQuery = "{!afts}" + filterQuery;
            }
            url.append("&fq=").append(encoder.encode(filterQuery, "UTF-8"));
        }
        this.buildFacetParameters(searchParameters, isSharded, encoder, url);
        this.buildPivotParameters(searchParameters, encoder, url);
        this.buildStatsParameters(searchParameters, encoder, url);
        this.buildFacetIntervalParameters(searchParameters, encoder, url);
        this.buildRangeParameters(searchParameters, encoder, url);
        this.buildHightlightParameters(searchParameters, encoder, url);
    }

    protected void buildFacetParameters(SearchParameters searchParameters, boolean isSharded, URLCodec encoder, StringBuilder url) throws UnsupportedEncodingException {
        if (searchParameters.getFieldFacets().size() > 0 || searchParameters.getFacetQueries().size() > 0) {
            url.append("&facet=").append(encoder.encode("true", "UTF-8"));
            for (SearchParameters.FieldFacet facet : searchParameters.getFieldFacets()) {
                int startIndex;
                url.append("&facet.field=");
                String field = facet.getField();
                StringBuilder prefix = new StringBuilder("{!afts ");
                int n = startIndex = field.startsWith("{!afts") ? 7 : 0;
                if (facet.getExcludeFilters() != null && !facet.getExcludeFilters().isEmpty()) {
                    prefix.append("ex=" + String.join((CharSequence)",", facet.getExcludeFilters()) + " ");
                }
                if (facet.getLabel() != null && !facet.getLabel().isEmpty()) {
                    prefix.append("key=" + facet.getLabel() + " ");
                }
                if (startIndex != 0) {
                    int endIndex = field.indexOf("}");
                    prefix.append(field.substring(startIndex, endIndex > startIndex ? endIndex : startIndex));
                    field = field.substring(endIndex + 1);
                }
                if (prefix.length() > 7) {
                    url.append(encoder.encode(prefix.toString().trim(), "UTF-8"));
                    url.append(encoder.encode("}", "UTF-8"));
                }
                url.append(encoder.encode(field, "UTF-8"));
                if (facet.getEnumMethodCacheMinDF() != 0) {
                    url.append("&").append(encoder.encode("f." + field + ".facet.enum.cache.minDf", "UTF-8")).append("=").append(encoder.encode("" + facet.getEnumMethodCacheMinDF(), "UTF-8"));
                }
                int facetLimit = facet.getLimitOrNull() == null ? (this.isSharded() ? this.defaultShardedFacetLimit : this.defaultUnshardedFacetLimit) : facet.getLimitOrNull();
                url.append("&").append(encoder.encode("f." + field + ".facet.limit", "UTF-8")).append("=").append(encoder.encode("" + facetLimit, "UTF-8"));
                if (facet.getMethod() != null) {
                    url.append("&").append(encoder.encode("f." + field + ".facet.method", "UTF-8")).append("=").append(encoder.encode(facet.getMethod() == SearchParameters.FieldFacetMethod.ENUM ? "enum" : "fc", "UTF-8"));
                }
                if (facet.getMinCount() != 0) {
                    url.append("&").append(encoder.encode("f." + field + ".facet.mincount", "UTF-8")).append("=").append(encoder.encode("" + facet.getMinCount(), "UTF-8"));
                }
                if (facet.getOffset() != 0) {
                    url.append("&").append(encoder.encode("f." + field + ".facet.offset", "UTF-8")).append("=").append(encoder.encode("" + facet.getOffset(), "UTF-8"));
                }
                if (facet.getPrefix() != null) {
                    url.append("&").append(encoder.encode("f." + field + ".facet.prefix", "UTF-8")).append("=").append(encoder.encode(facet.getPrefix(), "UTF-8"));
                }
                if (facet.getSort() != null) {
                    url.append("&").append(encoder.encode("f." + field + ".facet.sort", "UTF-8")).append("=").append(encoder.encode(facet.getSort() == SearchParameters.FieldFacetSort.COUNT ? "count" : "index", "UTF-8"));
                }
                if (!facet.isCountDocsMissingFacetField()) continue;
                url.append("&").append(encoder.encode("f." + field + ".facet.missing", "UTF-8")).append("=").append(encoder.encode("" + facet.isCountDocsMissingFacetField(), "UTF-8"));
            }
            for (String facetQuery : searchParameters.getFacetQueries()) {
                if (!facetQuery.startsWith("{!afts")) {
                    facetQuery = "{!afts}" + facetQuery;
                }
                url.append("&facet.query=").append(encoder.encode(facetQuery, "UTF-8"));
            }
        }
    }

    protected void buildStatsParameters(SearchParameters searchParameters, URLCodec encoder, StringBuilder url) throws UnsupportedEncodingException {
        if (searchParameters.getStats() != null && !searchParameters.getStats().isEmpty()) {
            url.append("&stats=").append(encoder.encode("true", "UTF-8"));
            for (StatsRequestParameters aStat : searchParameters.getStats()) {
                url.append("&stats.field=");
                StringBuilder prefix = new StringBuilder("{! ");
                if (aStat.getExcludeFilters() != null && !aStat.getExcludeFilters().isEmpty()) {
                    prefix.append("ex=" + String.join((CharSequence)",", aStat.getExcludeFilters()) + " ");
                }
                if (aStat.getLabel() != null && !aStat.getLabel().isEmpty()) {
                    prefix.append("tag=" + aStat.getLabel() + " ");
                    prefix.append("key=" + aStat.getLabel() + " ");
                }
                if (aStat.getPercentiles() != null && !aStat.getPercentiles().isEmpty()) {
                    StringJoiner joiner = new StringJoiner(",");
                    for (Float aFloat : aStat.getPercentiles()) {
                        joiner.add(aFloat.toString());
                    }
                    prefix.append("percentiles='" + joiner.toString() + "' ");
                }
                if (aStat.getCardinality().booleanValue()) {
                    prefix.append("cardinality=" + aStat.getCardinalityAccuracy() + " ");
                }
                prefix.append("countDistinct=" + aStat.getCountDistinct() + " ");
                prefix.append("distinctValues=" + aStat.getDistinctValues() + " ");
                prefix.append("min=" + aStat.getMin() + " ");
                prefix.append("max=" + aStat.getMax() + " ");
                prefix.append("sum=" + aStat.getSum() + " ");
                prefix.append("count=" + aStat.getCountValues() + " ");
                prefix.append("missing=" + aStat.getMissing() + " ");
                prefix.append("sumOfSquares=" + aStat.getSumOfSquares() + " ");
                prefix.append("mean=" + aStat.getMean() + " ");
                prefix.append("stddev=" + aStat.getStddev() + " ");
                url.append(encoder.encode(prefix.toString().trim(), "UTF-8"));
                url.append(encoder.encode("}", "UTF-8"));
                url.append(encoder.encode(aStat.getField(), "UTF-8"));
            }
        }
    }

    protected void buildPivotParameters(SearchParameters searchParameters, URLCodec encoder, StringBuilder url) throws UnsupportedEncodingException {
        if (searchParameters.getPivots() != null && !searchParameters.getPivots().isEmpty()) {
            url.append("&facet=").append(encoder.encode("true", "UTF-8"));
            for (List pivotKeys : searchParameters.getPivots()) {
                ArrayList pivotsList = new ArrayList();
                pivotsList.addAll(pivotKeys);
                url.append("&facet.pivot=");
                StringBuilder prefix = new StringBuilder("{! ");
                if (searchParameters.getStats() != null && !searchParameters.getStats().isEmpty()) {
                    for (StatsRequestParameters aStat : searchParameters.getStats()) {
                        if (!pivotKeys.contains(aStat.getLabel())) continue;
                        prefix.append("stats=" + aStat.getLabel() + " ");
                        pivotsList.remove(aStat.getLabel());
                        break;
                    }
                }
                if (searchParameters.getRanges() != null && !searchParameters.getRanges().isEmpty()) {
                    for (RangeParameters aRange : searchParameters.getRanges()) {
                        Optional<String> found = pivotKeys.stream().filter(aKey -> aKey.equals(aRange.getLabel())).findFirst();
                        if (!found.isPresent()) continue;
                        prefix.append("range=" + found.get() + " ");
                        pivotsList.remove(found.get());
                        break;
                    }
                }
                if (prefix.length() > 3) {
                    url.append(encoder.encode(prefix.toString().trim(), "UTF-8"));
                    url.append(encoder.encode("}", "UTF-8"));
                }
                url.append(encoder.encode(String.join((CharSequence)",", pivotsList), "UTF-8"));
            }
        }
    }

    protected void buildRangeParameters(SearchParameters searchParameters, URLCodec encoder, StringBuilder url) throws UnsupportedEncodingException {
        if (searchParameters.getRanges() != null && !searchParameters.getRanges().isEmpty()) {
            List ranges = searchParameters.getRanges();
            url.append("&facet=").append(encoder.encode("true", "UTF-8"));
            for (RangeParameters facetRange : ranges) {
                String fieldName = facetRange.getField();
                boolean isDate = false;
                PropertyDefinition propertyDef = QueryParserUtils.matchPropertyDefinition((String)searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespaceDAO, (DictionaryService)this.dictionaryService, (String)fieldName);
                if (propertyDef != null && (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATE))) {
                    isDate = true;
                }
                IntervalSet rangeSet = SearchDateConversion.parseDateInterval((IntervalSet)new IntervalSet(facetRange.getStart(), facetRange.getEnd(), facetRange.getGap(), null, null), (boolean)isDate);
                url.append("&facet.range=");
                if (facetRange.getLabel() != null && !facetRange.getLabel().isEmpty()) {
                    url.append(encoder.encode("{!", "UTF-8"));
                    url.append(encoder.encode(String.format("tag=%s ", facetRange.getLabel()), "UTF-8"));
                    url.append(encoder.encode("}", "UTF-8"));
                }
                url.append(encoder.encode(facetRange.getField(), "UTF-8"));
                url.append(String.format("&f.%s.facet.range.start=", fieldName)).append(encoder.encode(rangeSet.getStart(), "UTF-8"));
                url.append(String.format("&f.%s.facet.range.end=", fieldName)).append(encoder.encode(rangeSet.getEnd(), "UTF-8"));
                url.append(String.format("&f.%s.facet.range.gap=", fieldName)).append(encoder.encode(rangeSet.getLabel(), "UTF-8"));
                url.append(String.format("&f.%s.facet.range.hardend=", fieldName)).append(encoder.encode("" + facetRange.isHardend(), "UTF-8"));
                if (facetRange.getInclude() != null && !facetRange.getInclude().isEmpty()) {
                    for (String include : facetRange.getInclude()) {
                        url.append(String.format("&f.%s.facet.range.include=", fieldName)).append(encoder.encode(include, "UTF-8"));
                    }
                }
                if (facetRange.getOther() != null && !facetRange.getOther().isEmpty()) {
                    for (String other : facetRange.getOther()) {
                        url.append(String.format("&f.%s.facet.range.other=", fieldName)).append(encoder.encode(other, "UTF-8"));
                    }
                }
                if (facetRange.getExcludeFilters().isEmpty()) continue;
                url.append("&facet.range=");
                if (facetRange.getExcludeFilters() == null || facetRange.getExcludeFilters().isEmpty()) continue;
                StringBuilder prefix = new StringBuilder("{!ex=");
                Iterator itr = facetRange.getExcludeFilters().iterator();
                while (itr.hasNext()) {
                    String val = (String)itr.next();
                    prefix.append(val);
                    if (!itr.hasNext()) continue;
                    prefix.append(",");
                }
                prefix.append("}");
                url.append((CharSequence)prefix);
                url.append(fieldName);
            }
        }
    }

    protected void buildHightlightParameters(SearchParameters searchParameters, URLCodec encoder, StringBuilder url) throws UnsupportedEncodingException {
        if (searchParameters.getHighlight() != null) {
            url.append("&").append("hl=true");
            url.append("&hl.q=").append(encoder.encode(searchParameters.getSearchTerm(), "UTF-8"));
            if (searchParameters.getHighlight().getSnippetCount() != null) {
                url.append("&").append("hl.snippets=").append(searchParameters.getHighlight().getSnippetCount());
            }
            if (searchParameters.getHighlight().getFragmentSize() != null) {
                url.append("&").append("hl.fragsize=").append(searchParameters.getHighlight().getFragmentSize());
            }
            if (searchParameters.getHighlight().getMaxAnalyzedChars() != null) {
                url.append("&").append("hl.maxAnalyzedChars=").append(searchParameters.getHighlight().getMaxAnalyzedChars());
            }
            if (searchParameters.getHighlight().getMergeContiguous() != null) {
                url.append("&").append("hl.mergeContiguous=").append(searchParameters.getHighlight().getMergeContiguous());
            }
            if (searchParameters.getHighlight().getUsePhraseHighlighter() != null) {
                url.append("&").append("hl.usePhraseHighlighter=").append(searchParameters.getHighlight().getUsePhraseHighlighter());
            }
            if (searchParameters.getHighlight().getPrefix() != null) {
                url.append("&").append("hl.simple.pre=").append(encoder.encode(searchParameters.getHighlight().getPrefix(), "UTF-8"));
            }
            if (searchParameters.getHighlight().getPostfix() != null) {
                url.append("&").append("hl.simple.post=").append(encoder.encode(searchParameters.getHighlight().getPostfix(), "UTF-8"));
            }
            if (searchParameters.getHighlight().getFields() != null && !searchParameters.getHighlight().getFields().isEmpty()) {
                ArrayList<String> fieldNames = new ArrayList<String>(searchParameters.getHighlight().getFields().size());
                for (FieldHighlightParameters aField : searchParameters.getHighlight().getFields()) {
                    ParameterCheck.mandatoryString((String)"highlight field", (String)aField.getField());
                    fieldNames.add(aField.getField());
                    if (aField.getSnippetCount() != null) {
                        url.append("&f.").append(encoder.encode(aField.getField(), "UTF-8")).append(".hl.snippets=").append(aField.getSnippetCount());
                    }
                    if (aField.getFragmentSize() != null) {
                        url.append("&f.").append(encoder.encode(aField.getField(), "UTF-8")).append(".hl.fragsize=").append(aField.getFragmentSize());
                    }
                    if (aField.getFragmentSize() != null) {
                        url.append("&f.").append(encoder.encode(aField.getField(), "UTF-8")).append(".hl.fragsize=").append(aField.getFragmentSize());
                    }
                    if (aField.getMergeContiguous() != null) {
                        url.append("&f.").append(encoder.encode(aField.getField(), "UTF-8")).append(".hl.mergeContiguous=").append(aField.getMergeContiguous());
                    }
                    if (aField.getPrefix() != null) {
                        url.append("&f.").append(encoder.encode(aField.getField(), "UTF-8")).append(".hl.simple.pre=").append(encoder.encode(aField.getPrefix(), "UTF-8"));
                    }
                    if (aField.getPostfix() == null) continue;
                    url.append("&f.").append(encoder.encode(aField.getField(), "UTF-8")).append(".hl.simple.post=").append(encoder.encode(aField.getPostfix(), "UTF-8"));
                }
                url.append("&").append("hl.fl=").append(encoder.encode(String.join((CharSequence)",", fieldNames), "UTF-8"));
            }
        }
    }

    protected void buildFacetIntervalParameters(SearchParameters searchParameters, URLCodec encoder, StringBuilder url) throws UnsupportedEncodingException {
        if (searchParameters.getInterval() != null) {
            url.append("&facet=").append(encoder.encode("true", "UTF-8"));
            if (searchParameters.getInterval().getSets() != null) {
                for (IntervalSet aSet : searchParameters.getInterval().getSets()) {
                    url.append("&facet.interval.set=").append(encoder.encode(aSet.toParam(), "UTF-8"));
                }
            }
            if (searchParameters.getInterval().getIntervals() != null) {
                for (Interval interval : searchParameters.getInterval().getIntervals()) {
                    ParameterCheck.mandatory((String)"facetIntervals intervals field", (Object)interval.getField());
                    url.append("&facet.interval=");
                    boolean isDate = false;
                    PropertyDefinition propertyDef = QueryParserUtils.matchPropertyDefinition((String)searchParameters.getNamespace(), (NamespacePrefixResolver)this.namespaceDAO, (DictionaryService)this.dictionaryService, (String)interval.getField());
                    if (propertyDef != null && (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATE))) {
                        isDate = true;
                    }
                    if (interval.getLabel() != null && !interval.getLabel().isEmpty()) {
                        url.append(encoder.encode("{!key=" + interval.getLabel() + "}", "UTF-8"));
                    }
                    url.append(encoder.encode(interval.getField(), "UTF-8"));
                    if (interval.getSets() == null) continue;
                    for (IntervalSet aSet : interval.getSets()) {
                        IntervalSet validated = SearchDateConversion.parseDateInterval((IntervalSet)aSet, (boolean)isDate);
                        url.append("&").append(encoder.encode("f." + interval.getField() + ".facet.interval.set", "UTF-8")).append("=").append(encoder.encode(validated.toParam(), "UTF-8"));
                    }
                }
            }
        }
    }

    protected SearchEngineResultMetadata postSolrQuery(HttpClient httpClient, String url, JSONObject body, SolrJsonProcessor<?> jsonProcessor) throws UnsupportedEncodingException, IOException, HttpException, URIException, JSONException {
        return this.postSolrQuery(httpClient, url, body, jsonProcessor, null);
    }

    protected SearchEngineResultMetadata postSolrQuery(HttpClient httpClient, String url, JSONObject body, SolrJsonProcessor<?> jsonProcessor, String spellCheckParams) throws UnsupportedEncodingException, IOException, HttpException, URIException, JSONException {
        JSONObject json = this.postQuery(httpClient, url, body);
        if (spellCheckParams != null) {
            SpellCheckDecisionManager manager = new SpellCheckDecisionManager(json, url, body, spellCheckParams);
            if (manager.isCollate()) {
                json = this.postQuery(httpClient, manager.getUrl(), body);
            }
            json.put("spellcheck", (Object)manager.getSpellCheckJsonValue());
        }
        Object results = jsonProcessor.getResult(json);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Sent :" + url));
            s_logger.debug((Object)("   with: " + body.toString()));
            s_logger.debug((Object)("Got: " + results.getNumberFound() + " in " + results.getQueryTime() + " ms"));
        }
        return results;
    }

    private StringBuffer buildSortParameters(BasicSearchParameters searchParameters, URLCodec encoder) throws UnsupportedEncodingException {
        StringBuffer sortBuffer = new StringBuffer();
        for (SearchParameters.SortDefinition sortDefinition : searchParameters.getSortDefinitions()) {
            if (sortBuffer.length() == 0) {
                sortBuffer.append("&sort=");
            } else {
                sortBuffer.append(encoder.encode(", ", "UTF-8"));
            }
            switch (sortDefinition.getSortType()) {
                case DOCUMENT: {
                    sortBuffer.append(encoder.encode("_docid_", "UTF-8")).append(encoder.encode(" ", "UTF-8"));
                    break;
                }
                case SCORE: {
                    sortBuffer.append(encoder.encode("score", "UTF-8")).append(encoder.encode(" ", "UTF-8"));
                    break;
                }
                default: {
                    sortBuffer.append(encoder.encode(sortDefinition.getField().replaceAll(" ", "%20"), "UTF-8")).append(encoder.encode(" ", "UTF-8"));
                }
            }
            if (sortDefinition.isAscending()) {
                sortBuffer.append(encoder.encode("asc", "UTF-8"));
                continue;
            }
            sortBuffer.append(encoder.encode("desc", "UTF-8"));
        }
        return sortBuffer;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.mappingLookup.clear();
        for (SolrStoreMapping mapping : this.storeMappings) {
            this.mappingLookup.put(mapping.getStoreRef(), new ExplicitSolrStoreMappingWrapper(mapping, this.beanFactory));
        }
    }

    public JSONObject execute(StoreRef storeRef, String handler, HashMap<String, String> params) {
        JSONObject jSONObject;
        SolrStoreMappingWrapper mapping = SolrClientUtil.extractMapping(storeRef, this.mappingLookup, this.shardRegistry, this.useDynamicShardRegistration, this.beanFactory);
        URLCodec encoder = new URLCodec();
        StringBuilder url = new StringBuilder();
        Pair<HttpClient, String> httpClientAndBaseUrl = mapping.getHttpClientAndBaseUrl();
        HttpClient httpClient = (HttpClient)httpClientAndBaseUrl.getFirst();
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (url.length() == 0) {
                url.append((String)httpClientAndBaseUrl.getSecond());
                if (!handler.startsWith("/")) {
                    url.append("/");
                }
                url.append(handler);
                url.append("?");
                url.append(encoder.encode(key, "UTF-8"));
                url.append("=");
                url.append(encoder.encode(value, "UTF-8"));
                continue;
            }
            url.append("&");
            url.append(encoder.encode(key, "UTF-8"));
            url.append("=");
            url.append(encoder.encode(value, "UTF-8"));
        }
        if (mapping.isSharded()) {
            url.append("&shards=");
            url.append(mapping.getShards());
        }
        GetMethod get = new GetMethod(url.toString());
        try {
            JSONObject json;
            Header locationHeader;
            httpClient.executeMethod((HttpMethod)get);
            if ((get.getStatusCode() == 301 || get.getStatusCode() == 302) && (locationHeader = get.getResponseHeader("location")) != null) {
                String redirectLocation = locationHeader.getValue();
                get.setURI(new URI(redirectLocation, true));
                httpClient.executeMethod((HttpMethod)get);
            }
            if (get.getStatusCode() != 200) {
                throw new QueryParserException("Request failed " + get.getStatusCode() + " " + url.toString());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream()));
            jSONObject = json = new JSONObject(new JSONTokener((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                get.releaseConnection();
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new QueryParserException("", e);
            }
            catch (HttpException e) {
                throw new QueryParserException("", e);
            }
            catch (IOException e) {
                throw new QueryParserException("", e);
            }
            catch (JSONException e) {
                throw new QueryParserException("", e);
            }
        }
        get.releaseConnection();
        return jSONObject;
    }

    @Override
    public boolean isSharded() {
        if (this.shardRegistry != null && this.useDynamicShardRegistration) {
            for (Floc floc : this.shardRegistry.getFlocs().keySet()) {
                if (floc.getNumberOfShards() <= 1) continue;
                return true;
            }
            return false;
        }
        for (SolrStoreMappingWrapper mapping : this.mappingLookup.values()) {
            if (!mapping.isSharded()) continue;
            return true;
        }
        return false;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public ShardRegistry getShardRegistry() {
        return this.shardRegistry;
    }

    public RepositoryState getRepositoryState() {
        return this.repositoryState;
    }

    public boolean isUseDynamicShardRegistration() {
        return this.useDynamicShardRegistration;
    }

    public int getDefaultUnshardedFacetLimit() {
        return this.defaultUnshardedFacetLimit;
    }

    public int getDefaultShardedFacetLimit() {
        return this.defaultShardedFacetLimit;
    }

    public NamespaceDAO getNamespaceDAO() {
        return this.namespaceDAO;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public Map<String, String> getLanguageMappings() {
        return this.languageMappings;
    }

    public boolean isAnyDenyDenies() {
        return this.anyDenyDenies;
    }

    public String getAlternativeDictionary() {
        return this.alternativeDictionary;
    }

    public boolean isIncludeGroupsForRoleAdmin() {
        return this.includeGroupsForRoleAdmin;
    }

    public int getMaximumResultsFromUnlimitedQuery() {
        return this.maximumResultsFromUnlimitedQuery;
    }
}

