/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.user;

import java.util.Objects;
import java.util.Optional;

public final class DecodedTokenUser {
    private static final String EMPTY_STRING = "";
    private final String username;
    private final String firstName;
    private final String lastName;
    private final String email;

    public DecodedTokenUser(String username, String firstName, String lastName, String email) {
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
    }

    public static DecodedTokenUser validateAndCreate(String username, Object firstName, Object lastName, Object email) {
        return new DecodedTokenUser(username, DecodedTokenUser.getStringVal(firstName), DecodedTokenUser.getStringVal(lastName), DecodedTokenUser.getStringVal(email));
    }

    private static String getStringVal(Object firstName) {
        return Optional.ofNullable(firstName).filter(String.class::isInstance).map(String.class::cast).orElse(EMPTY_STRING);
    }

    public String username() {
        return this.username;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public String email() {
        return this.email;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DecodedTokenUser that = (DecodedTokenUser)object;
        return Objects.equals(this.username, that.username) && Objects.equals(this.firstName, that.firstName) && Objects.equals(this.lastName, that.lastName) && Objects.equals(this.email, that.email);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.firstName, this.lastName, this.email);
    }

    public String toString() {
        return "DecodedTokenUser{username='" + this.username + '\'' + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", email='" + this.email + '\'' + '}';
    }
}

