/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.Set;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ACLEntryVoterUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ACLEntryVoterUtils.class);

    private ACLEntryVoterUtils() {
    }

    static NodeRef getNodeRef(Object testObject, NodeService nodeService) {
        if (testObject == null) {
            return null;
        }
        if (StoreRef.class.isAssignableFrom(testObject.getClass())) {
            LOG.debug("Permission test against the store - using permissions on the root node");
            StoreRef storeRef = (StoreRef)testObject;
            if (nodeService.exists(storeRef)) {
                return nodeService.getRootNode(storeRef);
            }
            LOG.debug("StoreRef does not exist");
            return null;
        }
        if (NodeRef.class.isAssignableFrom(testObject.getClass())) {
            NodeRef result = (NodeRef)testObject;
            if (LOG.isDebugEnabled()) {
                if (nodeService.exists(result)) {
                    LOG.debug("Permission test on node {}", (Object)nodeService.getPath(result));
                } else {
                    LOG.debug("Permission test on non-existing node {}", (Object)result);
                }
            }
            return result;
        }
        if (ChildAssociationRef.class.isAssignableFrom(testObject.getClass())) {
            ChildAssociationRef testChildRef = (ChildAssociationRef)testObject;
            NodeRef result = testChildRef.getChildRef();
            if (LOG.isDebugEnabled()) {
                if (nodeService.exists(result)) {
                    LOG.debug("Permission test on node {}", (Object)nodeService.getPath(result));
                } else {
                    LOG.debug("Permission test on non-existing node {}", (Object)result);
                }
            }
            return result;
        }
        throw new ACLEntryVoterException("The specified parameter is not a NodeRef or ChildAssociationRef");
    }

    static Integer shouldAbstainOrDeny(SimplePermissionReference requiredPermissionReference, NodeRef testNodeRef, Set<QName> abstainForClassQNames, NodeService nodeService, PermissionService permissionService) {
        if (testNodeRef == null) {
            return null;
        }
        LOG.debug("Node ref is not null");
        if (abstainForClassQNames.size() > 0 && nodeService.exists(testNodeRef)) {
            if (abstainForClassQNames.contains(nodeService.getType(testNodeRef))) {
                return 0;
            }
            Set testNodeRefAspects = nodeService.getAspects(testNodeRef);
            for (QName abstain : abstainForClassQNames) {
                if (!testNodeRefAspects.contains(abstain)) continue;
                return 0;
            }
        }
        if (AccessStatus.DENIED == permissionService.hasPermission(testNodeRef, requiredPermissionReference.toString())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Permission is denied");
                Thread.dumpStack();
            }
            return -1;
        }
        return null;
    }
}

