/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.manifest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.TransferContext;
import org.alfresco.repo.transfer.manifest.ManifestAccessControl;
import org.alfresco.repo.transfer.manifest.ManifestCategory;
import org.alfresco.repo.transfer.manifest.ManifestPermission;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactory;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

public class TransferManifestNodeFactoryImpl
implements TransferManifestNodeFactory {
    private NodeService nodeService;
    private NodeService mlAwareNodeService;
    private PermissionService permissionService;
    private DictionaryService dictionaryService;

    public void init() {
    }

    @Override
    public TransferManifestNode createTransferManifestNode(NodeRef nodeRef, TransferDefinition definition, TransferContext transferContext) {
        return this.createTransferManifestNode(nodeRef, definition, transferContext, false);
    }

    @Override
    public TransferManifestNode createTransferManifestNode(NodeRef nodeRef, TransferDefinition definition, TransferContext transferContext, boolean forceDelete) {
        NodeRef.Status status = this.nodeService.getNodeStatus(nodeRef);
        if (status == null) {
            throw new TransferException("Unable to get node status for node : " + nodeRef);
        }
        if (status.isDeleted()) {
            TransferManifestDeletedNode deletedNode = new TransferManifestDeletedNode();
            deletedNode.setNodeRef(nodeRef);
            ChildAssociationRef dummyPrimaryParent = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, nodeRef, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"dummy"), nodeRef, true, -1);
            deletedNode.setPrimaryParentAssoc(dummyPrimaryParent);
            deletedNode.setParentPath(new Path());
            return deletedNode;
        }
        if (nodeRef.getStoreRef().equals((Object)StoreRef.STORE_REF_ARCHIVE_SPACESSTORE)) {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_ARCHIVED)) {
                ChildAssociationRef car = (ChildAssociationRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
                TransferManifestDeletedNode node = new TransferManifestDeletedNode();
                NodeRef parentNodeRef = car.getParentRef();
                node.setNodeRef(car.getChildRef());
                node.setPrimaryParentAssoc(car);
                if (this.nodeService.exists(parentNodeRef)) {
                    Path parentPath = this.nodeService.getPath(parentNodeRef);
                    node.setParentPath(parentPath);
                }
                return node;
            }
            TransferManifestDeletedNode node = new TransferManifestDeletedNode();
            node.setNodeRef(nodeRef);
            ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
            if (parentAssocRef != null && parentAssocRef.getParentRef() != null) {
                NodeRef parentNodeRef = parentAssocRef.getParentRef();
                node.setPrimaryParentAssoc(parentAssocRef);
                Path parentPath = this.nodeService.getPath(parentNodeRef);
                node.setParentPath(parentPath);
            }
            return node;
        }
        if (forceDelete) {
            ChildAssociationRef primaryParentAssoc = this.nodeService.getPrimaryParent(nodeRef);
            TransferManifestDeletedNode node = new TransferManifestDeletedNode();
            NodeRef parentNodeRef = primaryParentAssoc.getParentRef();
            node.setNodeRef(primaryParentAssoc.getChildRef());
            node.setPrimaryParentAssoc(primaryParentAssoc);
            if (this.nodeService.exists(parentNodeRef)) {
                Path parentPath = this.nodeService.getPath(parentNodeRef);
                node.setParentPath(parentPath);
            }
            return node;
        }
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        node.setNodeRef(nodeRef);
        node.setProperties(this.getNodeProperties(nodeRef, definition == null ? null : definition.getExcludedAspects()));
        node.setAspects(this.getNodeAspects(nodeRef, definition == null ? null : definition.getExcludedAspects()));
        node.setType(this.nodeService.getType(nodeRef));
        if (this.dictionaryService.isSubClass(node.getType(), ContentModel.TYPE_CONTENT)) {
            node.setAncestorType(ContentModel.TYPE_CONTENT);
        } else if (this.dictionaryService.isSubClass(node.getType(), ContentModel.TYPE_FOLDER)) {
            node.setAncestorType(ContentModel.TYPE_FOLDER);
        } else {
            node.setAncestorType(ContentModel.TYPE_BASE);
        }
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssocRef != null && parentAssocRef.getParentRef() != null) {
            NodeRef parentNodeRef = parentAssocRef.getParentRef();
            node.setPrimaryParentAssoc(parentAssocRef);
            Path parentPath = this.nodeService.getPath(parentNodeRef);
            node.setParentPath(parentPath);
        }
        node.setChildAssocs(this.nodeService.getChildAssocs(nodeRef));
        node.setParentAssocs(this.nodeService.getParentAssocs(nodeRef));
        node.setTargetAssocs(this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        node.setSourceAssocs(this.nodeService.getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL));
        boolean inherit = this.permissionService.getInheritParentPermissions(nodeRef);
        ManifestAccessControl acl = new ManifestAccessControl();
        acl.setInherited(inherit);
        node.setAccessControl(acl);
        Set permissions = this.permissionService.getAllSetPermissions(nodeRef);
        ArrayList<ManifestPermission> mps = new ArrayList<ManifestPermission>(permissions.size());
        for (AccessPermission permission : permissions) {
            if (!permission.isSetDirectly()) continue;
            ManifestPermission mp = new ManifestPermission();
            mp.setStatus(permission.getAccessStatus().toString());
            mp.setAuthority(permission.getAuthority());
            mp.setPermission(permission.getPermission());
            mps.add(mp);
        }
        acl.setPermissions(mps);
        HashMap<NodeRef, ManifestCategory> categories = new HashMap<NodeRef, ManifestCategory>();
        Map<QName, Serializable> properties = node.getProperties();
        for (Map.Entry<QName, Serializable> val : properties.entrySet()) {
            PropertyDefinition def = this.dictionaryService.getProperty(val.getKey());
            if (def == null || !def.getDataType().getName().isMatch(DataTypeDefinition.CATEGORY)) continue;
            if (def.isMultiValued()) {
                Serializable thing = val.getValue();
                if (thing instanceof Collection) {
                    Collection c = (Collection)((Object)thing);
                    for (NodeRef categoryNodeRef : c) {
                        if (categoryNodeRef == null) continue;
                        categories.put(categoryNodeRef, this.getManifestCategory(transferContext, categoryNodeRef));
                    }
                    continue;
                }
                NodeRef categoryNodeRef = (NodeRef)val.getValue();
                if (categoryNodeRef == null) continue;
                categories.put(categoryNodeRef, this.getManifestCategory(transferContext, categoryNodeRef));
                continue;
            }
            NodeRef categoryNodeRef = (NodeRef)val.getValue();
            if (categoryNodeRef == null) continue;
            categories.put(categoryNodeRef, this.getManifestCategory(transferContext, categoryNodeRef));
        }
        node.setManifestCategories(categories);
        return node;
    }

    private Set<QName> getNodeAspects(NodeRef nodeRef, Set<QName> excludedAspects) {
        Set aspects = this.nodeService.getAspects(nodeRef);
        if (excludedAspects == null || excludedAspects.size() == 0) {
            return aspects;
        }
        HashSet<QName> filteredAspects = new HashSet<QName>(aspects.size());
        for (QName aspect : aspects) {
            if (excludedAspects.contains(aspect)) continue;
            filteredAspects.add(aspect);
        }
        return filteredAspects;
    }

    private Map<QName, Serializable> getNodeProperties(NodeRef nodeRef, Set<QName> excludedAspects) {
        Map properties = this.mlAwareNodeService.getProperties(nodeRef);
        if (excludedAspects == null || excludedAspects.size() == 0) {
            return properties;
        }
        HashMap<QName, Serializable> filteredProperties = new HashMap<QName, Serializable>(properties.size());
        for (Map.Entry property : properties.entrySet()) {
            PropertyDefinition propDef = this.dictionaryService.getProperty((QName)property.getKey());
            if (propDef != null && excludedAspects.contains(propDef.getContainerClass().getName())) continue;
            filteredProperties.put((QName)property.getKey(), (Serializable)property.getValue());
        }
        return filteredProperties;
    }

    private ManifestCategory getManifestCategory(TransferContext transferContext, NodeRef categoryNodeRef) {
        ManifestCategory c = transferContext.getManifestCategoriesCache().get(categoryNodeRef);
        if (c != null) {
            return c;
        }
        c = new ManifestCategory();
        Path p = this.nodeService.getPath(categoryNodeRef);
        c.setPath(p.toString());
        transferContext.getManifestCategoriesCache().put(categoryNodeRef, c);
        return c;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setMlAwareNodeService(NodeService mlAwareNodeService) {
        this.mlAwareNodeService = mlAwareNodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }
}

