/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.rating.traitextender.RatingServiceExtension;
import org.alfresco.repo.rating.traitextender.RatingServiceTrait;
import org.alfresco.repo.virtual.store.VirtualStore;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.traitextender.SpringBeanExtension;

public class VirtualRatingServiceExtension
extends SpringBeanExtension<RatingServiceExtension, RatingServiceTrait>
implements RatingServiceExtension {
    private VirtualStore smartStore;

    public VirtualRatingServiceExtension() {
        super(RatingServiceTrait.class);
    }

    public void setSmartStore(VirtualStore smartStore) {
        this.smartStore = smartStore;
    }

    @Override
    public void applyRating(NodeRef targetNode, float rating, String ratingSchemeName) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        ((RatingServiceTrait)this.getTrait()).applyRating(materialNode, rating, ratingSchemeName);
    }

    @Override
    public int getRatingsCount(NodeRef targetNode, String ratingSchemeName) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        return ((RatingServiceTrait)this.getTrait()).getRatingsCount(materialNode, ratingSchemeName);
    }

    @Override
    public float getTotalRating(NodeRef targetNode, String ratingSchemeName) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        return ((RatingServiceTrait)this.getTrait()).getTotalRating(materialNode, ratingSchemeName);
    }

    @Override
    public float getAverageRating(NodeRef targetNode, String ratingSchemeName) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        return ((RatingServiceTrait)this.getTrait()).getAverageRating(materialNode, ratingSchemeName);
    }

    @Override
    public Rating getRatingByCurrentUser(NodeRef targetNode, String ratingSchemeName) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        return ((RatingServiceTrait)this.getTrait()).getRatingByCurrentUser(materialNode, ratingSchemeName);
    }

    @Override
    public List<Rating> getRatingsByCurrentUser(NodeRef targetNode) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        return ((RatingServiceTrait)this.getTrait()).getRatingsByCurrentUser(materialNode);
    }

    @Override
    public Rating removeRatingByCurrentUser(NodeRef targetNode, String ratingSchemeName) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        return ((RatingServiceTrait)this.getTrait()).removeRatingByCurrentUser(materialNode, ratingSchemeName);
    }

    @Override
    public Serializable getRatingRollup(NodeRef targetNode, String ratingSchemeName, String ratingRollupName) {
        NodeRef materialNode = this.smartStore.materializeIfPossible(targetNode);
        return ((RatingServiceTrait)this.getTrait()).getRatingRollup(materialNode, ratingSchemeName, ratingRollupName);
    }

    @Override
    public Map<String, RatingScheme> getRatingSchemes() {
        return ((RatingServiceTrait)this.getTrait()).getRatingSchemes();
    }

    @Override
    public RatingScheme getRatingScheme(String ratingSchemeName) {
        return ((RatingServiceTrait)this.getTrait()).getRatingScheme(ratingSchemeName);
    }
}

