/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.config;

import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.virtual.config.NodeRefResolver;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class RepositoryNodeRefResolver
implements NodeRefResolver {
    public static final String PATH_REF_EXPRESSION = "path";
    public static final String NODE_REF_EXPRESSION = "node";
    public static final String QNAME_REF_EXPRESSION = "qname";
    private Repository repository;
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;

    public RepositoryNodeRefResolver() {
    }

    public RepositoryNodeRefResolver(Repository repository) {
        this.repository = repository;
    }

    @Override
    public NodeRef resolveNodeReference(String[] reference) {
        return this.repository.findNodeRef(NODE_REF_EXPRESSION, reference);
    }

    @Override
    public NodeRef resolvePathReference(String[] reference) {
        return this.repository.findNodeRef(PATH_REF_EXPRESSION, reference);
    }

    @Override
    public NodeRef resolveQNameReference(String[] reference) {
        NodeRef theNodeRef = null;
        if (reference.length > 0) {
            theNodeRef = this.repository.getRootHome();
            List rootChildren = this.nodeService.getChildAssocs(theNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)QName.createQName((String)reference[0], (NamespacePrefixResolver)this.namespacePrefixResolver), false);
            if (rootChildren == null || rootChildren.isEmpty()) {
                rootChildren = this.nodeService.getChildAssocs(theNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)reference[0], (NamespacePrefixResolver)this.namespacePrefixResolver), false);
            }
            if (rootChildren == null || rootChildren.isEmpty()) {
                return null;
            }
            theNodeRef = ((ChildAssociationRef)rootChildren.get(0)).getChildRef();
            int i = 1;
            while (i < reference.length) {
                List children = this.nodeService.getChildAssocs(theNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)reference[i], (NamespacePrefixResolver)this.namespacePrefixResolver), false);
                if (children == null || children.isEmpty()) {
                    theNodeRef = null;
                    break;
                }
                theNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
                ++i;
            }
        }
        return theNodeRef;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public NodeRef getCompanyHome() {
        return this.repository.getCompanyHome();
    }

    @Override
    public NodeRef getRootHome() {
        return this.repository.getRootHome();
    }

    @Override
    public NodeRef getSharedHome() {
        return this.repository.getSharedHome();
    }

    @Override
    public NodeRef getUserHome(NodeRef person) {
        return this.repository.getUserHome(person);
    }

    @Override
    public NodeRef createNamePath(String[] reference) {
        NodeRef found;
        Stack<String> notFoundStack = new Stack<String>();
        if (reference == null || reference.length == 0) {
            found = this.getRootHome();
        } else {
            NodeRef parentNodeRef = null;
            int i = reference.length;
            while (i > 0) {
                String[] parent = new String[i];
                System.arraycopy(reference, 0, parent, 0, i);
                parentNodeRef = this.resolvePathReference(parent);
                if (parentNodeRef != null) break;
                notFoundStack.push(reference[i - 1]);
                --i;
            }
            while (!notFoundStack.isEmpty()) {
                String toCreate = (String)notFoundStack.pop();
                HashMap<QName, String> newProperties = new HashMap<QName, String>();
                newProperties.put(ContentModel.PROP_NAME, toCreate);
                ChildAssociationRef newAssoc = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)toCreate)), ContentModel.TYPE_FOLDER, newProperties);
                parentNodeRef = newAssoc.getChildRef();
            }
            found = parentNodeRef;
        }
        return found;
    }

    @Override
    public NodeRef createQNamePath(String[] reference, String[] names) {
        NodeRef found;
        Stack<String> notFoundStack = new Stack<String>();
        Stack<String> notFoundNameStack = new Stack<String>();
        if (reference == null || reference.length == 0) {
            found = this.getRootHome();
        } else {
            NodeRef parentNodeRef = null;
            int i = reference.length;
            while (i > 0) {
                int offset;
                String[] parent = new String[i];
                System.arraycopy(reference, 0, parent, 0, i);
                parentNodeRef = this.resolveQNameReference(parent);
                if (parentNodeRef != null) break;
                if (names != null && (offset = reference.length - i) < names.length) {
                    notFoundNameStack.push(names[names.length - 1 - offset]);
                }
                notFoundStack.push(reference[i - 1]);
                --i;
            }
            while (!notFoundStack.isEmpty()) {
                String stringQNameToCreate = (String)notFoundStack.pop();
                QName qNameToCreate = QName.createQName((String)stringQNameToCreate, (NamespacePrefixResolver)this.namespacePrefixResolver);
                String nameToCreate = !notFoundNameStack.isEmpty() ? (String)notFoundNameStack.pop() : qNameToCreate.getLocalName();
                HashMap<QName, String> newProperties = new HashMap<QName, String>();
                newProperties.put(ContentModel.PROP_NAME, nameToCreate);
                ChildAssociationRef newAssoc = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, qNameToCreate, ContentModel.TYPE_FOLDER, newProperties);
                parentNodeRef = newAssoc.getChildRef();
            }
            found = parentNodeRef;
        }
        return found;
    }
}

