/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.virtual.ref.Encoding;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.ReferenceEncodingException;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Reference {
    private static Log logger = LogFactory.getLog(Reference.class);
    private static final Character VIRTUAL_TOKEN = Character.valueOf('v');
    private static long _trace_refLength = 0L;
    private static long _trace_refCount = 0L;
    private static final long _trace_refBatchSize = 8192L;
    private Encoding encoding;
    private Protocol protocol;
    private Resource resource;
    private List<Parameter> parameters;

    public static final boolean isReference(NodeRef nodeRef) {
        if (nodeRef != null) {
            String id = nodeRef.getId();
            if (id != null && id.length() > 1 && id.startsWith("" + VIRTUAL_TOKEN)) {
                char token = id.charAt(1);
                Encoding encoding = Encodings.fromToken(Character.valueOf(token));
                if (encoding != null) {
                    return true;
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"NodeRef is not a reference.");
            }
        }
        return false;
    }

    public static final Reference fromNodeRef(NodeRef nodeRef) {
        char token;
        Encoding encoding;
        String id;
        if (nodeRef != null && (id = nodeRef.getId()).startsWith("" + VIRTUAL_TOKEN) && id.length() > 1 && (encoding = Encodings.fromToken(Character.valueOf(token = id.charAt(1)))) != null) {
            try {
                String referenceString = id.substring(2);
                if (!encoding.urlNative) {
                    referenceString = new String(Base64.decodeBase64((String)referenceString));
                }
                Reference reference = encoding.parser.parse(referenceString);
                return reference.propagateNodeRefMutations(nodeRef);
            }
            catch (ReferenceParseException rpe) {
                logger.debug((Object)"Parse exception:", (Throwable)rpe);
                return null;
            }
            catch (ReferenceEncodingException ree) {
                logger.debug((Object)"Encoding exception:", (Throwable)ree);
                return null;
            }
        }
        return null;
    }

    private static synchronized void _trace_avg_ref_length(long refLength) {
        _trace_refLength += refLength;
        if (++_trace_refCount % 8192L == 0L) {
            logger.trace((Object)("Average reference encoding size : " + _trace_refLength / _trace_refCount));
            _trace_refCount = 0L;
            _trace_refLength = 0L;
        }
    }

    public Reference(Encoding encoding, Protocol protocol, Resource resource, List<? extends Parameter> parameters) {
        this.encoding = encoding;
        this.protocol = protocol;
        this.resource = resource;
        this.parameters = new LinkedList<Parameter>(parameters);
    }

    public Reference(Encoding encoding, Protocol protocol, Resource resource) {
        this(encoding, protocol, resource, Collections.emptyList());
    }

    public String encode() throws ReferenceEncodingException {
        return this.encode(this.encoding);
    }

    public String encode(Encoding anEncoding) throws ReferenceEncodingException {
        return anEncoding.stringifier.stringify(this);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Resource getResource() {
        return this.resource;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public NodeRef toNodeRef() throws ReferenceEncodingException {
        return this.toNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
    }

    public NodeRef toNodeRef(StoreRef storeRef) throws ReferenceEncodingException {
        return this.toNodeRef(storeRef, this.encoding);
    }

    public NodeRef toNodeRef(StoreRef storeRef, Encoding encoding) throws ReferenceEncodingException {
        String id = this.encode(encoding);
        if (!encoding.urlNative) {
            id = new String(Base64.encodeBase64((byte[])id.getBytes(), (boolean)false));
        }
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(VIRTUAL_TOKEN);
        idBuilder.append(encoding.token);
        idBuilder.append(id);
        NodeRef theNode = new NodeRef(storeRef, idBuilder.toString());
        if (logger.isTraceEnabled()) {
            Reference._trace_avg_ref_length(theNode.toString().length());
        }
        return theNode;
    }

    public <R> R execute(ProtocolMethod<R> method) throws ProtocolMethodException {
        return this.protocol.dispatch(method, this);
    }

    public Reference propagateNodeRefMutations(NodeRef mutatedNodeRef) {
        return this.protocol.propagateNodeRefMutations(mutatedNodeRef, this);
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (ReferenceEncodingException e) {
            logger.error((Object)"Invalid reference", (Throwable)e);
            return super.toString();
        }
    }

    public int hashCode() {
        return this.resource != null ? this.resource.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.resource == null) {
            return other.resource == null;
        }
        if (!this.resource.equals(other.resource)) {
            return false;
        }
        if (this.parameters == null) {
            return other.parameters == null;
        }
        return this.parameters.equals(other.parameters);
    }
}

