/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.alfresco.traitextender.AJExtender;
import org.alfresco.traitextender.InvalidExtension;
import org.alfresco.traitextender.Trait;
import org.alfresco.util.ParameterCheck;

public class AJProxyTrait
implements InvocationHandler {
    private Object extensibleInterface;

    public static <M extends Trait> M create(Object extensibleInterface, Class<M> traitAPI) {
        return (M)((Trait)Proxy.newProxyInstance(AJProxyTrait.class.getClassLoader(), new Class[]{traitAPI}, (InvocationHandler)new AJProxyTrait(extensibleInterface)));
    }

    private AJProxyTrait(Object extensibleInterface) {
        ParameterCheck.mandatory((String)"extensible", (Object)extensibleInterface);
        this.extensibleInterface = extensibleInterface;
    }

    @Override
    public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
        final Method traitMethod = this.extensibleInterface.getClass().getMethod(method.getName(), method.getParameterTypes());
        if (AJExtender.isLocalProceeder(method)) {
            return AJExtender.localProceed(args);
        }
        Class<?>[] exTypes = traitMethod.getExceptionTypes();
        return AJExtender.run(new AJExtender.ExtensionBypass<Object>(){

            @Override
            public Object run() throws Throwable {
                try {
                    return traitMethod.invoke(AJProxyTrait.this.extensibleInterface, args);
                }
                catch (IllegalAccessException error) {
                    throw new InvalidExtension(error);
                }
                catch (IllegalArgumentException error) {
                    throw new InvalidExtension(error);
                }
                catch (InvocationTargetException error) {
                    Throwable targetException = error.getTargetException();
                    throw targetException;
                }
            }
        }, exTypes);
    }

    public String toString() {
        return "AJAutoTrait@" + System.identityHashCode(this) + " of " + this.extensibleInterface.getClass().getSimpleName() + "@" + System.identityHashCode(this.extensibleInterface);
    }
}

